/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.examples;

import java.util.concurrent.CountDownLatch;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.LDAPConnectionFactory;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ModificationType;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.RootDSE;
import org.forgerock.opendj.ldap.controls.PermissiveModifyRequestControl;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.Responses;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Utils;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;
import org.forgerock.util.promise.ResultHandler;

public final class UpdateGroupAsync {
    private static Connection connection;
    private static int resultCode;
    private static final CountDownLatch COMPLETION_LATCH;

    public static void main(String[] args) {
        if (args.length != 5) {
            UpdateGroupAsync.printUsage();
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        final String groupDn = args[2];
        final String memberDn = args[3];
        final ModificationType modType = UpdateGroupAsync.getModificationType(args[4]);
        new LDAPConnectionFactory(host, port).getConnectionAsync().thenAsync(new AsyncFunction<Connection, BindResult, LdapException>(){

            @Override
            public Promise<BindResult, LdapException> apply(Connection connection) throws LdapException {
                connection = connection;
                return connection.bindAsync(Requests.newSimpleBindRequest("cn=Directory Manager", "password".toCharArray()));
            }
        }).thenAsync(new AsyncFunction<BindResult, RootDSE, LdapException>(){

            @Override
            public Promise<RootDSE, LdapException> apply(BindResult bindResult) throws LdapException {
                return RootDSE.readRootDSEAsync(connection);
            }
        }).thenAsync(new AsyncFunction<RootDSE, Result, LdapException>(){

            @Override
            public Promise<Result, LdapException> apply(RootDSE rootDSE) throws LdapException {
                if (rootDSE.getSupportedControls().contains("1.2.840.113556.1.4.1413")) {
                    UpdateGroupAsync.log("Updating group membership.");
                    return connection.modifyAsync(Requests.newModifyRequest(groupDn).addControl(PermissiveModifyRequestControl.newControl(true)).addModification(modType, "member", memberDn));
                }
                return connection.compareAsync(Requests.newCompareRequest(groupDn, "member", (Object)memberDn)).thenAsync(new AsyncFunction<CompareResult, Result, LdapException>(){

                    @Override
                    public Promise<Result, LdapException> apply(CompareResult compareResult) throws LdapException {
                        ResultCode rc = compareResult.getResultCode();
                        if (modType.equals(ModificationType.ADD) && rc.equals(ResultCode.COMPARE_FALSE)) {
                            UpdateGroupAsync.log("Adding " + memberDn + " to " + groupDn + ".");
                            return connection.modifyAsync(Requests.newModifyRequest(groupDn).addModification(modType, "member", memberDn));
                        }
                        if (modType.equals(ModificationType.DELETE) && rc.equals(ResultCode.COMPARE_TRUE)) {
                            UpdateGroupAsync.log("Deleting " + memberDn + " from " + groupDn + ".");
                            return connection.modifyAsync(Requests.newModifyRequest(groupDn).addModification(modType, "member", memberDn));
                        }
                        return Promises.newResultPromise(Responses.newResult(ResultCode.SUCCESS));
                    }
                });
            }
        }).thenOnResult(new ResultHandler<Result>(){

            @Override
            public void handleResult(Result result) {
                String op = modType == ModificationType.ADD ? "added to" : "deleted from";
                UpdateGroupAsync.log(memberDn + " has been " + op + " the group " + groupDn + ".");
                resultCode = result.getResultCode().intValue();
                COMPLETION_LATCH.countDown();
            }
        }).thenOnException(new ExceptionHandler<LdapException>(){

            @Override
            public void handleException(LdapException e) {
                System.err.println(e.getMessage());
                resultCode = e.getResult().getResultCode().intValue();
                COMPLETION_LATCH.countDown();
            }
        });
        try {
            COMPLETION_LATCH.await();
        }
        catch (InterruptedException e) {
            System.err.println(e.getMessage());
            System.exit(ResultCode.CLIENT_SIDE_USER_CANCELLED.intValue());
            return;
        }
        Utils.closeSilently(connection);
        System.exit(resultCode);
    }

    private static void printUsage() {
        System.err.println("Usage: host port group-dn member-dn {add|del}");
        System.err.println("For example: localhost 1389 cn=Static,ou=Groups,dc=example,dc=com uid=user.5150,ou=People,dc=example,dc=com del");
        System.exit(1);
    }

    private static ModificationType getModificationType(String operation) {
        boolean isAdd = "add".equalsIgnoreCase(operation);
        if (!isAdd && !"del".equalsIgnoreCase(operation)) {
            UpdateGroupAsync.printUsage();
        }
        return isAdd ? ModificationType.ADD : ModificationType.DELETE;
    }

    private static void log(String message) {
        System.out.println(message);
    }

    private UpdateGroupAsync() {
    }

    static {
        COMPLETION_LATCH = new CountDownLatch(1);
    }
}

