/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.examples;

import java.io.File;
import java.security.GeneralSecurityException;
import java.util.concurrent.CountDownLatch;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.LDAPConnectionFactory;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SSLContextBuilder;
import org.forgerock.opendj.ldap.TrustManagers;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Options;
import org.forgerock.util.Utils;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.ResultHandler;

public final class SimpleAuthAsync {
    private static Connection connection;
    private static int resultCode;
    private static final CountDownLatch COMPLETION_LATCH;
    private static String host;
    private static int port;
    private static String bindDN;
    private static String bindPassword;
    private static boolean useStartTLS;
    private static boolean useSSL;
    private static String keystore;
    private static String storepass;

    public static void main(String[] args) {
        SimpleAuthAsync.parseArgs(args);
        new LDAPConnectionFactory(host, port, SimpleAuthAsync.getTrustOptions(host, keystore, storepass)).getConnectionAsync().thenAsync(new AsyncFunction<Connection, BindResult, LdapException>(){

            @Override
            public Promise<BindResult, LdapException> apply(Connection connection) throws LdapException {
                connection = connection;
                return connection.bindAsync(Requests.newSimpleBindRequest(bindDN, bindPassword.toCharArray()));
            }
        }).thenOnResult((ResultHandler<BindResult>)new ResultHandler<Result>(){

            @Override
            public void handleResult(Result result) {
                resultCode = result.getResultCode().intValue();
                System.out.println("Authenticated as " + bindDN + ".");
                COMPLETION_LATCH.countDown();
            }
        }).thenOnException(new ExceptionHandler<LdapException>(){

            @Override
            public void handleException(LdapException e) {
                System.err.println(e.getMessage());
                resultCode = e.getResult().getResultCode().intValue();
                COMPLETION_LATCH.countDown();
            }
        });
        try {
            COMPLETION_LATCH.await();
        }
        catch (InterruptedException e) {
            System.err.println(e.getMessage());
            System.exit(ResultCode.CLIENT_SIDE_USER_CANCELLED.intValue());
            return;
        }
        Utils.closeSilently(connection);
        System.exit(resultCode);
    }

    private static Options getTrustOptions(String hostname, String truststore, String storepass) {
        Options options = Options.defaultOptions();
        if (useSSL || useStartTLS) {
            try {
                X509TrustManager trustManager = TrustManagers.checkValidityDates(TrustManagers.checkHostName(hostname, TrustManagers.checkUsingTrustStore(truststore, storepass.toCharArray(), null)));
                if (trustManager != null) {
                    SSLContext sslContext = new SSLContextBuilder().setTrustManager(trustManager).getSSLContext();
                    options.set(LDAPConnectionFactory.SSL_CONTEXT, sslContext);
                }
                options.set(LDAPConnectionFactory.SSL_USE_STARTTLS, useStartTLS);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                System.exit(ResultCode.CLIENT_SIDE_CONNECT_ERROR.intValue());
                return null;
            }
        }
        return options;
    }

    private static Options getTrustAllOptions() {
        try {
            Options options = Options.defaultOptions();
            SSLContext sslContext = new SSLContextBuilder().setTrustManager(TrustManagers.trustAll()).getSSLContext();
            options.set(LDAPConnectionFactory.SSL_CONTEXT, sslContext);
            options.set(LDAPConnectionFactory.SSL_USE_STARTTLS, useStartTLS);
            return options;
        }
        catch (GeneralSecurityException e) {
            System.err.println(e.getMessage());
            System.exit(ResultCode.CLIENT_SIDE_CONNECT_ERROR.intValue());
            return null;
        }
    }

    private static void parseArgs(String[] args) {
        if (args.length < 4 || args.length > 5) {
            SimpleAuthAsync.giveUp();
        }
        host = args[0];
        port = Integer.parseInt(args[1]);
        bindDN = args[2];
        bindPassword = args[3];
        if (args.length == 5) {
            if ("use-starttls".equals(args[4].toLowerCase())) {
                useStartTLS = true;
                useSSL = false;
            } else if ("use-ssl".equals(args[4].toLowerCase())) {
                useStartTLS = false;
                useSSL = true;
            } else {
                SimpleAuthAsync.giveUp();
            }
        }
        keystore = System.getProperty("javax.net.ssl.trustStore");
        storepass = System.getProperty("javax.net.ssl.trustStorePassword");
        if (keystore == null) {
            keystore = System.getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts";
            storepass = "changeit";
        }
    }

    private static void giveUp() {
        SimpleAuthAsync.printUsage();
        System.exit(1);
    }

    private static void printUsage() {
        System.err.println("Usage: host port bind-dn bind-password [ use-starttls | use-ssl ]");
        System.err.println("\thost, port, bind-dn, and bind-password arguments are required.");
        System.err.println("\tuse-starttls and use-ssl are optional and mutually exclusive.");
        System.err.println("\tOptionally set javax.net.ssl.trustStore and javax.net.ssl.trustStorePassword.");
    }

    private SimpleAuthAsync() {
    }

    static {
        COMPLETION_LATCH = new CountDownLatch(1);
    }
}

