/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.examples;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.Entries;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.LDAPConnectionFactory;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LinkedHashMapEntry;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.TreeMapEntry;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldif.LDIFEntryWriter;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Utils;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.ResultHandler;

public final class ShortLifeAsync {
    private static Entry entry;
    private static LDIFEntryWriter writer;
    private static Connection connection;
    private static int resultCode;
    private static final CountDownLatch COMPLETION_LATCH;

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: host port");
            System.err.println("For example: localhost 1389");
            System.exit(1);
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        String adminDn = "uid=kvaughan,ou=people,dc=example,dc=com";
        final char[] adminPwd = "bribery".toCharArray();
        String entryDn = "cn=Bob,ou=People,dc=example,dc=com";
        entry = new LinkedHashMapEntry("cn=Bob,ou=People,dc=example,dc=com").addAttribute("cn", "Bob").addAttribute("objectclass", "top").addAttribute("objectclass", "person").addAttribute("objectclass", "organizationalPerson").addAttribute("objectclass", "inetOrgPerson").addAttribute("mail", "subgenius@example.com").addAttribute("sn", "Dobbs");
        new LDAPConnectionFactory(host, port).getConnectionAsync().thenAsync(new AsyncFunction<Connection, BindResult, LdapException>(){

            @Override
            public Promise<BindResult, LdapException> apply(Connection connection) throws LdapException {
                connection = connection;
                return connection.bindAsync(Requests.newSimpleBindRequest("uid=kvaughan,ou=people,dc=example,dc=com", adminPwd));
            }
        }).thenAsync(new AsyncFunction<BindResult, Result, LdapException>(){

            @Override
            public Promise<Result, LdapException> apply(BindResult bindResult) throws LdapException {
                ShortLifeAsync.log("Adding the entry...");
                ShortLifeAsync.log(entry);
                return connection.addAsync(Requests.newAddRequest(entry));
            }
        }).thenAsync(new AsyncFunction<Result, Result, LdapException>(){

            @Override
            public Promise<Result, LdapException> apply(Result result) throws LdapException {
                TreeMapEntry old = TreeMapEntry.deepCopyOfEntry(entry);
                entry = entry.replaceAttribute("mail", "spammer@example.com").addAttribute("description", "Good user gone bad");
                ShortLifeAsync.log("Updating mail address, adding description...");
                ShortLifeAsync.log(entry);
                ModifyRequest request = Entries.diffEntries(old, entry);
                return connection.modifyAsync(request);
            }
        }).thenAsync(new AsyncFunction<Result, Result, LdapException>(){

            @Override
            public Promise<Result, LdapException> apply(Result result) throws LdapException {
                entry = entry.setName("cn=Renamed,ou=People,dc=example,dc=com");
                ShortLifeAsync.log("Renaming the entry...");
                ShortLifeAsync.log(entry);
                return connection.modifyDNAsync(Requests.newModifyDNRequest("cn=Bob,ou=People,dc=example,dc=com", "cn=Renamed"));
            }
        }).thenAsync(new AsyncFunction<Result, Result, LdapException>(){

            @Override
            public Promise<Result, LdapException> apply(Result result) throws LdapException {
                String newDn = "cn=Bob,ou=People,dc=example,dc=com".replace("Bob", "Renamed");
                ShortLifeAsync.log("Deleting " + newDn + "...");
                return connection.deleteAsync(Requests.newDeleteRequest(newDn));
            }
        }).thenOnResult(new ResultHandler<Result>(){

            @Override
            public void handleResult(Result result) {
                resultCode = result.getResultCode().intValue();
                ShortLifeAsync.log("... done.");
                COMPLETION_LATCH.countDown();
            }
        }).thenOnException(new ExceptionHandler<LdapException>(){

            @Override
            public void handleException(LdapException e) {
                System.err.println(e.getMessage());
                resultCode = e.getResult().getResultCode().intValue();
                COMPLETION_LATCH.countDown();
            }
        });
        try {
            COMPLETION_LATCH.await();
        }
        catch (InterruptedException e) {
            System.err.println(e.getMessage());
            System.exit(ResultCode.CLIENT_SIDE_USER_CANCELLED.intValue());
            return;
        }
        Utils.closeSilently(connection);
        System.exit(resultCode);
    }

    private static void log(String message) {
        System.out.println(message);
    }

    private static void log(Entry entry) {
        try {
            writer.writeEntry(entry);
            writer.flush();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(ResultCode.CLIENT_SIDE_LOCAL_ERROR.intValue());
        }
    }

    private ShortLifeAsync() {
    }

    static {
        writer = new LDIFEntryWriter(System.out);
        COMPLETION_LATCH = new CountDownLatch(1);
    }
}

