/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.examples;

import java.io.IOException;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.Entries;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.LDAPConnectionFactory;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LinkedHashMapEntry;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.TreeMapEntry;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldif.LDIFEntryWriter;

public final class ShortLife {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: host port");
            System.err.println("For example: localhost 1389");
            System.exit(1);
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        String adminDN = "uid=kvaughan,ou=people,dc=example,dc=com";
        char[] adminPwd = "bribery".toCharArray();
        String entryDN = "cn=Bob,ou=People,dc=example,dc=com";
        Entry entry = new LinkedHashMapEntry(entryDN).addAttribute("cn", "Bob").addAttribute("objectclass", "top").addAttribute("objectclass", "person").addAttribute("objectclass", "organizationalPerson").addAttribute("objectclass", "inetOrgPerson").addAttribute("mail", "subgenius@example.com").addAttribute("sn", "Dobbs");
        LDIFEntryWriter writer = new LDIFEntryWriter(System.out);
        LDAPConnectionFactory factory = new LDAPConnectionFactory(host, port);
        Connection connection = null;
        try {
            connection = factory.getConnection();
            connection.bind(adminDN, adminPwd);
            System.out.println("Creating an entry...");
            ShortLife.writeToConsole(writer, entry);
            connection.add(entry);
            System.out.println("...done.");
            System.out.println("Updating mail address, adding description...");
            TreeMapEntry old = TreeMapEntry.deepCopyOfEntry(entry);
            entry = entry.replaceAttribute("mail", "spammer@example.com").addAttribute("description", "Good user gone bad");
            ShortLife.writeToConsole(writer, entry);
            ModifyRequest request = Entries.diffEntries(old, entry);
            connection.modify(request);
            System.out.println("...done.");
            System.out.println("Renaming the entry...");
            String newDN = "cn=Ted,ou=People,dc=example,dc=com";
            entry = entry.setName(newDN);
            ShortLife.writeToConsole(writer, entry);
            connection.modifyDN(entryDN, "cn=Ted");
            System.out.println("...done.");
            System.out.println("Deleting the entry...");
            ShortLife.writeToConsole(writer, entry);
            connection.delete(newDN);
            System.out.println("...done.");
        }
        catch (LdapException e) {
            System.err.println(e.getMessage());
            System.exit(e.getResult().getResultCode().intValue());
            return;
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(ResultCode.CLIENT_SIDE_LOCAL_ERROR.intValue());
            return;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static void writeToConsole(LDIFEntryWriter writer, Entry entry) throws IOException {
        writer.writeEntry(entry);
        writer.flush();
    }

    private ShortLife() {
    }
}

