/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.examples;

import java.io.Console;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.LDAPConnectionFactory;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;

public final class SearchBind {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 3) {
            System.err.println("Usage: host port base-dn");
            System.err.println("For example: localhost 1389 dc=example,dc=com");
            System.exit(1);
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        String baseDN = args[2];
        Console c = System.console();
        if (c == null) {
            System.err.println("No console.");
            System.exit(1);
        }
        String mail = c.readLine("Email address: ", new Object[0]);
        char[] password = c.readPassword("Password: ", new Object[0]);
        LDAPConnectionFactory factory = new LDAPConnectionFactory(host, port);
        try (Connection connection = null;){
            connection = factory.getConnection();
            SearchResultEntry entry = connection.searchSingleEntry(baseDN, SearchScope.WHOLE_SUBTREE, Filter.equality("mail", mail).toString(), "cn");
            DN bindDN = entry.getName();
            connection.bind(bindDN.toString(), password);
            String cn = entry.getAttribute("cn").firstValueAsString();
            System.out.println("Hello, " + cn + "!");
        }
    }

    private SearchBind() {
    }
}

