/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.examples;

import java.util.HashSet;
import java.util.List;
import org.forgerock.opendj.examples.ProxyBackend;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.Attributes;
import org.forgerock.opendj.ldap.ConnectionPool;
import org.forgerock.opendj.ldap.Connections;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LDAPClientContext;
import org.forgerock.opendj.ldap.LDAPConnectionFactory;
import org.forgerock.opendj.ldap.LDAPListener;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapResultHandler;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.ldap.RequestContext;
import org.forgerock.opendj.ldap.RequestHandler;
import org.forgerock.opendj.ldap.RequestHandlerFactory;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.ServerConnectionFactory;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.util.Options;

public final class RewriterProxy {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 6) {
            System.err.println("Usage:\tlocalAddress localPort proxyDN proxyPassword serverAddress serverPort");
            System.exit(1);
        }
        String localAddress = args[0];
        int localPort = Integer.parseInt(args[1]);
        String proxyDN = args[2];
        String proxyPassword = args[3];
        String remoteAddress = args[4];
        int remotePort = Integer.parseInt(args[5]);
        Options factoryOptions = Options.defaultOptions().set(LDAPConnectionFactory.AUTHN_BIND_REQUEST, Requests.newSimpleBindRequest(proxyDN, proxyPassword.toCharArray()));
        final ConnectionPool factory = Connections.newCachedConnectionPool(new LDAPConnectionFactory(remoteAddress, remotePort, factoryOptions));
        final ConnectionPool bindFactory = Connections.newCachedConnectionPool(new LDAPConnectionFactory(remoteAddress, remotePort));
        RequestHandlerFactory<LDAPClientContext, RequestContext> proxyFactory = new RequestHandlerFactory<LDAPClientContext, RequestContext>(){

            public Rewriter handleAccept(LDAPClientContext clientContext) throws LdapException {
                return new Rewriter(new ProxyBackend(factory, bindFactory));
            }
        };
        ServerConnectionFactory<LDAPClientContext, Integer> connectionHandler = Connections.newServerConnectionFactory(proxyFactory);
        Options listenerOptions = Options.defaultOptions().set(LDAPListener.CONNECT_MAX_BACKLOG, 4096);
        try (LDAPListener listener = null;){
            listener = new LDAPListener(localAddress, localPort, connectionHandler, listenerOptions);
            System.out.println("Press any key to stop the server...");
            System.in.read();
        }
    }

    private RewriterProxy() {
    }

    private static final class Rewriter
    implements RequestHandler<RequestContext> {
        private static final String CLIENT_ATTRIBUTE = "fullname";
        private static final String SERVER_ATTRIBUTE = "cn";
        private static final String CLIENT_SUFFIX = "o=example";
        private static final String SERVER_SUFFIX = "dc=example,dc=com";
        private final AttributeDescription clientAttributeDescription = AttributeDescription.valueOf("fullname");
        private final AttributeDescription serverAttributeDescription = AttributeDescription.valueOf("cn");
        private final RequestHandler<RequestContext> nextHandler;

        private Rewriter(RequestHandler<RequestContext> nextHandler) {
            this.nextHandler = nextHandler;
        }

        @Override
        public void handleAdd(RequestContext requestContext, AddRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<Result> resultHandler) {
            this.nextHandler.handleAdd(requestContext, this.rewrite(request), intermediateResponseHandler, resultHandler);
        }

        @Override
        public void handleBind(RequestContext requestContext, int version, BindRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<BindResult> resultHandler) {
            this.nextHandler.handleBind(requestContext, version, this.rewrite(request), intermediateResponseHandler, resultHandler);
        }

        @Override
        public void handleCompare(RequestContext requestContext, CompareRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<CompareResult> resultHandler) {
            this.nextHandler.handleCompare(requestContext, this.rewrite(request), intermediateResponseHandler, resultHandler);
        }

        @Override
        public void handleDelete(RequestContext requestContext, DeleteRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<Result> resultHandler) {
            this.nextHandler.handleDelete(requestContext, this.rewrite(request), intermediateResponseHandler, resultHandler);
        }

        @Override
        public <R extends ExtendedResult> void handleExtendedRequest(RequestContext requestContext, ExtendedRequest<R> request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<R> resultHandler) {
            this.nextHandler.handleExtendedRequest(requestContext, this.rewrite(request), intermediateResponseHandler, resultHandler);
        }

        @Override
        public void handleModify(RequestContext requestContext, ModifyRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<Result> resultHandler) {
            this.nextHandler.handleModify(requestContext, this.rewrite(request), intermediateResponseHandler, resultHandler);
        }

        @Override
        public void handleModifyDN(RequestContext requestContext, ModifyDNRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<Result> resultHandler) {
            this.nextHandler.handleModifyDN(requestContext, this.rewrite(request), intermediateResponseHandler, resultHandler);
        }

        @Override
        public void handleSearch(RequestContext requestContext, SearchRequest request, IntermediateResponseHandler intermediateResponseHandler, final SearchResultHandler entryHandler, LdapResultHandler<Result> resultHandler) {
            this.nextHandler.handleSearch(requestContext, this.rewrite(request), intermediateResponseHandler, new SearchResultHandler(){

                @Override
                public boolean handleReference(SearchResultReference reference) {
                    return entryHandler.handleReference(reference);
                }

                @Override
                public boolean handleEntry(SearchResultEntry entry) {
                    return entryHandler.handleEntry(Rewriter.this.rewrite(entry));
                }
            }, resultHandler);
        }

        private AddRequest rewrite(AddRequest request) {
            AddRequest rewrittenRequest = Requests.copyOfAddRequest(request);
            rewrittenRequest.setName(request.getName().toString().replace(CLIENT_SUFFIX, SERVER_SUFFIX));
            for (Attribute a : request.getAllAttributes(this.clientAttributeDescription)) {
                if (a == null) continue;
                String ad = a.getAttributeDescriptionAsString().replaceFirst(CLIENT_ATTRIBUTE, SERVER_ATTRIBUTE);
                Attribute serverAttr = Attributes.renameAttribute(a, AttributeDescription.valueOf(ad));
                rewrittenRequest.addAttribute(serverAttr);
                rewrittenRequest.removeAttribute(a.getAttributeDescription());
            }
            return rewrittenRequest;
        }

        private BindRequest rewrite(BindRequest request) {
            return request;
        }

        private CompareRequest rewrite(CompareRequest request) {
            String ad = request.getAttributeDescription().toString();
            if (ad.toLowerCase().startsWith(CLIENT_ATTRIBUTE.toLowerCase())) {
                String serverAttrDesc = ad.replaceFirst(CLIENT_ATTRIBUTE, SERVER_ATTRIBUTE);
                request.setAttributeDescription(AttributeDescription.valueOf(serverAttrDesc));
            }
            return request.setName(request.getName().toString().replace(CLIENT_SUFFIX, SERVER_SUFFIX));
        }

        private DeleteRequest rewrite(DeleteRequest request) {
            return request.setName(request.getName().toString().replace(CLIENT_SUFFIX, SERVER_SUFFIX));
        }

        private <S extends ExtendedResult> ExtendedRequest<S> rewrite(ExtendedRequest<S> request) {
            return request;
        }

        private ModifyDNRequest rewrite(ModifyDNRequest request) {
            if (request.getNewSuperior() != null) {
                return request.setName(request.getName().toString().replace(CLIENT_SUFFIX, SERVER_SUFFIX)).setNewSuperior(request.getNewSuperior().toString().replace(CLIENT_SUFFIX, SERVER_SUFFIX));
            }
            return request.setName(request.getName().toString().replace(CLIENT_SUFFIX, SERVER_SUFFIX));
        }

        private ModifyRequest rewrite(ModifyRequest request) {
            ModifyRequest rewrittenRequest = Requests.newModifyRequest(request.getName().toString().replace(CLIENT_SUFFIX, SERVER_SUFFIX));
            List<Modification> mods = request.getModifications();
            for (Modification mod : mods) {
                Attribute a = mod.getAttribute();
                AttributeDescription ad = a.getAttributeDescription();
                AttributeType at = ad.getAttributeType();
                if (at.equals(this.clientAttributeDescription.getAttributeType())) {
                    AttributeDescription serverAttrDesc = AttributeDescription.valueOf(ad.toString().replaceFirst(CLIENT_ATTRIBUTE, SERVER_ATTRIBUTE));
                    rewrittenRequest.addModification(new Modification(mod.getModificationType(), Attributes.renameAttribute(a, serverAttrDesc)));
                    continue;
                }
                rewrittenRequest.addModification(mod);
            }
            for (Control control : request.getControls()) {
                rewrittenRequest.addControl(control);
            }
            return rewrittenRequest;
        }

        private SearchRequest rewrite(SearchRequest request) {
            String[] a = new String[request.getAttributes().size()];
            int count = 0;
            for (String attrName : request.getAttributes()) {
                a[count] = attrName.toLowerCase().startsWith(CLIENT_ATTRIBUTE.toLowerCase()) ? attrName.replaceFirst(CLIENT_ATTRIBUTE, SERVER_ATTRIBUTE) : attrName;
                ++count;
            }
            return Requests.newSearchRequest(DN.valueOf(request.getName().toString().replace(CLIENT_SUFFIX, SERVER_SUFFIX)), request.getScope(), Filter.valueOf(request.getFilter().toString().replace(CLIENT_ATTRIBUTE, SERVER_ATTRIBUTE)), a);
        }

        private SearchResultEntry rewrite(SearchResultEntry entry) {
            HashSet<Attribute> attrsToAdd = new HashSet<Attribute>();
            HashSet<AttributeDescription> attrsToRemove = new HashSet<AttributeDescription>();
            for (Attribute a : entry.getAllAttributes(this.serverAttributeDescription)) {
                AttributeDescription ad = a.getAttributeDescription();
                AttributeType at = ad.getAttributeType();
                if (!at.equals(this.serverAttributeDescription.getAttributeType())) continue;
                AttributeDescription clientAttrDesc = AttributeDescription.valueOf(ad.toString().replaceFirst(SERVER_ATTRIBUTE, CLIENT_ATTRIBUTE));
                attrsToAdd.add(Attributes.renameAttribute(a, clientAttrDesc));
                attrsToRemove.add(ad);
            }
            if (!attrsToAdd.isEmpty() && !attrsToRemove.isEmpty()) {
                for (Attribute a : attrsToAdd) {
                    entry.addAttribute(a);
                }
                for (AttributeDescription ad : attrsToRemove) {
                    entry.removeAttribute(ad);
                }
            }
            return entry.setName(entry.getName().toString().replace(SERVER_SUFFIX, CLIENT_SUFFIX));
        }
    }
}

