/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.examples;

import java.util.Collection;
import java.util.LinkedList;
import org.forgerock.opendj.examples.ProxyBackend;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.Connections;
import org.forgerock.opendj.ldap.LDAPClientContext;
import org.forgerock.opendj.ldap.LDAPConnectionFactory;
import org.forgerock.opendj.ldap.LDAPListener;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.RequestContext;
import org.forgerock.opendj.ldap.RequestHandlerFactory;
import org.forgerock.opendj.ldap.ServerConnectionFactory;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SimpleBindRequest;
import org.forgerock.util.Options;

public final class Proxy {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        LoadBalancingAlgorithm algorithm;
        int i;
        if (args.length < 6 || args.length % 2 != 0) {
            System.err.println("Usage: [--load-balancer <mode>] listenAddress listenPort proxyDN proxyPassword remoteAddress1 remotePort1 remoteAddress2 remotePort2 ...");
            System.exit(1);
        }
        if ("--load-balancer".equals(args[i = 0])) {
            algorithm = Proxy.getLoadBalancingAlgorithm(args[i + 1]);
            i += 2;
        } else {
            algorithm = LoadBalancingAlgorithm.ROUND_ROBIN;
        }
        String localAddress = args[i++];
        int localPort = Integer.parseInt(args[i++]);
        String proxyDN = args[i++];
        String proxyPassword = args[i++];
        LinkedList<ConnectionFactory> factories = new LinkedList<ConnectionFactory>();
        SimpleBindRequest bindRequest = Requests.newSimpleBindRequest(proxyDN, proxyPassword.toCharArray());
        Options factoryOptions = Options.defaultOptions().set(LDAPConnectionFactory.HEARTBEAT_ENABLED, true).set(LDAPConnectionFactory.AUTHN_BIND_REQUEST, bindRequest);
        LinkedList<ConnectionFactory> bindFactories = new LinkedList<ConnectionFactory>();
        Options bindFactoryOptions = Options.defaultOptions().set(LDAPConnectionFactory.HEARTBEAT_ENABLED, true);
        while (i < args.length) {
            String remoteAddress = args[i];
            int remotePort = Integer.parseInt(args[i + 1]);
            factories.add(Connections.newCachedConnectionPool(new LDAPConnectionFactory(remoteAddress, remotePort, factoryOptions)));
            bindFactories.add(Connections.newCachedConnectionPool(new LDAPConnectionFactory(remoteAddress, remotePort, bindFactoryOptions)));
            i += 2;
        }
        final ConnectionFactory factory = algorithm.newLoadBalancer(factories, factoryOptions);
        final ConnectionFactory bindFactory = algorithm.newLoadBalancer(bindFactories, bindFactoryOptions);
        RequestHandlerFactory<LDAPClientContext, RequestContext> proxyFactory = new RequestHandlerFactory<LDAPClientContext, RequestContext>(){

            public ProxyBackend handleAccept(LDAPClientContext clientContext) throws LdapException {
                return new ProxyBackend(factory, bindFactory);
            }
        };
        ServerConnectionFactory<LDAPClientContext, Integer> connectionHandler = Connections.newServerConnectionFactory(proxyFactory);
        Options options = Options.defaultOptions().set(LDAPListener.CONNECT_MAX_BACKLOG, 4096);
        try (LDAPListener listener = null;){
            listener = new LDAPListener(localAddress, localPort, connectionHandler, options);
            System.out.println("Press any key to stop the server...");
            System.in.read();
        }
    }

    private static LoadBalancingAlgorithm getLoadBalancingAlgorithm(String algorithmName) {
        switch (algorithmName) {
            case "round-robin": {
                return LoadBalancingAlgorithm.ROUND_ROBIN;
            }
            case "fail-over": {
                return LoadBalancingAlgorithm.FAIL_OVER;
            }
            case "sharded": {
                return LoadBalancingAlgorithm.SHARDED;
            }
        }
        System.err.println("Unrecognized load-balancing algorithm '" + algorithmName + "'. Should be one of 'round-robin', 'fail-over', or 'sharded'.");
        System.exit(1);
        return LoadBalancingAlgorithm.ROUND_ROBIN;
    }

    private Proxy() {
    }

    private static enum LoadBalancingAlgorithm {
        ROUND_ROBIN{

            @Override
            ConnectionFactory newLoadBalancer(Collection<ConnectionFactory> factories, Options options) {
                return Connections.newRoundRobinLoadBalancer(factories, options);
            }
        }
        ,
        FAIL_OVER{

            @Override
            ConnectionFactory newLoadBalancer(Collection<ConnectionFactory> factories, Options options) {
                return Connections.newFailoverLoadBalancer(factories, options);
            }
        }
        ,
        SHARDED{

            @Override
            ConnectionFactory newLoadBalancer(Collection<ConnectionFactory> factories, Options options) {
                return Connections.newShardedRequestLoadBalancer(factories, options);
            }
        };


        abstract ConnectionFactory newLoadBalancer(Collection<ConnectionFactory> var1, Options var2);
    }
}

