/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.examples;

import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LDAPConnectionFactory;
import org.forgerock.opendj.ldap.ModificationType;
import org.forgerock.opendj.ldap.SSLContextBuilder;
import org.forgerock.opendj.ldap.TrustManagers;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.util.Options;

public final class PasswordResetForAD {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 7) {
            System.err.println("Usage: host port \"admin\"|\"self\" DN password targetDN newPassword");
            System.err.println("For example: ad.example.com 636 admin cn=administrator,cn=Users,DC=ad,DC=example,DC=com Secret123 cn=testuser,cn=Users,DC=ad,DC=example,DC=com NewP4s5w0rd");
            System.exit(1);
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        String mode = args[2];
        String bindDN = args[3];
        String bindPassword = args[4];
        String targetDN = args[5];
        String newPassword = args[6];
        try (Connection connection = null;){
            LDAPConnectionFactory factory = new LDAPConnectionFactory(host, port, PasswordResetForAD.getTrustAllOptions());
            connection = factory.getConnection();
            connection.bind(bindDN, bindPassword.toCharArray());
            ModifyRequest request = Requests.newModifyRequest(DN.valueOf(targetDN));
            String passwordAttribute = "unicodePwd";
            if ("admin".equalsIgnoreCase(mode)) {
                request.addModification(ModificationType.REPLACE, passwordAttribute, new Object[]{PasswordResetForAD.encodePassword(newPassword)});
            } else if ("self".equalsIgnoreCase(mode)) {
                request.addModification(ModificationType.DELETE, passwordAttribute, new Object[]{PasswordResetForAD.encodePassword(bindPassword)});
                request.addModification(ModificationType.ADD, passwordAttribute, new Object[]{PasswordResetForAD.encodePassword(newPassword)});
            } else {
                System.err.println("Mode must be admin or self, not " + mode);
                System.exit(1);
            }
            connection.modify(request);
            System.out.println("Successfully changed password for " + targetDN + " to " + newPassword + ".");
        }
    }

    public static byte[] encodePassword(String password) {
        return ("\"" + password + "\"").getBytes(Charset.forName("UTF-16LE"));
    }

    private static Options getTrustAllOptions() throws GeneralSecurityException {
        Options options = Options.defaultOptions();
        SSLContext sslContext = new SSLContextBuilder().setTrustManager(TrustManagers.trustAll()).getSSLContext();
        options.set(LDAPConnectionFactory.SSL_CONTEXT, sslContext);
        return options;
    }

    private PasswordResetForAD() {
    }
}

