/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.examples;

import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.LDAPConnectionFactory;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldif.LDIFEntryWriter;

public final class GetInfo {
    private static String host;
    private static int port;
    private static String infoType;

    public static void main(String[] args) {
        GetInfo.parseArgs(args);
        GetInfo.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void connect() {
        LDAPConnectionFactory factory = new LDAPConnectionFactory(host, port);
        try (Connection connection = null;){
            connection = factory.getConnection();
            connection.bind("", "".toCharArray());
            String attributeList = "controls".equals(infoType.toLowerCase()) ? "supportedControl" : ("extops".equals(infoType.toLowerCase()) ? "supportedExtension" : "+");
            SearchResultEntry entry = connection.searchSingleEntry("", SearchScope.BASE_OBJECT, "(objectclass=*)", attributeList);
            LDIFEntryWriter writer = new LDIFEntryWriter(System.out);
            writer.writeComment("Root DSE for LDAP server at " + host + ":" + port);
            if (entry != null) {
                writer.writeEntry(entry);
            }
            writer.flush();
        }
    }

    private static void giveUp() {
        GetInfo.printUsage();
        System.exit(1);
    }

    private static void parseArgs(String[] args) {
        if (args.length != 3) {
            GetInfo.giveUp();
        }
        host = args[0];
        port = Integer.parseInt(args[1]);
        infoType = args[2];
        String infoTypeLc = infoType.toLowerCase();
        if (!("all".equals(infoTypeLc) || "controls".equals(infoTypeLc) || "extops".equals(infoTypeLc))) {
            GetInfo.giveUp();
        }
    }

    private static void printUsage() {
        System.err.println("Usage: host port info-type");
        System.err.println("\tAll arguments are required.");
        System.err.println("\tinfo-type to get can be either all, controls, or extops.");
    }

    private GetInfo() {
    }
}

