/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.examples;

import java.util.Collection;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.LDAPConnectionFactory;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.RootDSE;
import org.forgerock.opendj.ldap.requests.PasswordModifyExtendedRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.WhoAmIExtendedRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.PasswordModifyExtendedResult;
import org.forgerock.opendj.ldap.responses.WhoAmIExtendedResult;

public final class ExtendedOperations {
    private static Collection<String> extendedOperations;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: host port");
            System.err.println("For example: localhost 1389");
            System.exit(1);
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        LDAPConnectionFactory factory = new LDAPConnectionFactory(host, port);
        try (Connection connection = null;){
            connection = factory.getConnection();
            ExtendedOperations.checkSupportedExtendedOperations(connection);
            String user = "cn=Directory Manager";
            char[] password = "password".toCharArray();
            connection.bind("cn=Directory Manager", password);
            ExtendedOperations.useWhoAmIExtendedRequest(connection);
        }
    }

    static void usePasswordModifyExtendedRequest(Connection connection) throws LdapException {
        if (ExtendedOperations.isSupported("1.3.6.1.4.1.4203.1.11.1")) {
            String userIdentity = "u:scarter";
            char[] oldPassword = "sprain".toCharArray();
            char[] newPassword = "secret12".toCharArray();
            PasswordModifyExtendedRequest request = Requests.newPasswordModifyExtendedRequest().setUserIdentity("u:scarter").setOldPassword(oldPassword).setNewPassword(newPassword);
            PasswordModifyExtendedResult result = connection.extendedRequest(request);
            if (result.isSuccess()) {
                System.out.println("Changed password for u:scarter");
            } else {
                System.err.println(result.getDiagnosticMessage());
            }
        } else {
            System.err.println("PasswordModifyExtendedRequest not supported");
        }
    }

    static void useWhoAmIExtendedRequest(Connection connection) throws LdapException {
        if (ExtendedOperations.isSupported("1.3.6.1.4.1.4203.1.11.3")) {
            WhoAmIExtendedRequest request;
            WhoAmIExtendedResult extResult;
            String name = "uid=bjensen,ou=People,dc=example,dc=com";
            char[] password = "hifalutin".toCharArray();
            BindResult result = connection.bind("uid=bjensen,ou=People,dc=example,dc=com", password);
            if (result.isSuccess() && (extResult = connection.extendedRequest(request = Requests.newWhoAmIExtendedRequest())).isSuccess()) {
                System.out.println("Authz ID: " + extResult.getAuthorizationID());
            }
        } else {
            System.err.println("WhoAmIExtendedRequest not supported");
        }
    }

    static void checkSupportedExtendedOperations(Connection connection) throws LdapException {
        extendedOperations = RootDSE.readRootDSE(connection).getSupportedExtendedOperations();
    }

    static boolean isSupported(String extendedOperation) {
        return extendedOperations != null && extendedOperations.contains(extendedOperation);
    }

    private ExtendedOperations() {
    }
}

