/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.forgerock.util.Pair;

public final class ManifestUtil {
    private static final String OPENDJ_CORE_VERSION;
    private static final String OPENDJ_CORE_VERSION_WITH_REVISION;

    public static String getVersionWithRevision(String moduleName) {
        if ("opendj-core".equals(moduleName)) {
            return OPENDJ_CORE_VERSION_WITH_REVISION;
        }
        return ManifestUtil.getVersions(moduleName).getSecond();
    }

    public static String getBundleVersion(String moduleName) {
        if ("opendj-core".equals(moduleName)) {
            return OPENDJ_CORE_VERSION;
        }
        return ManifestUtil.getVersions(moduleName).getFirst();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Pair<String, String> getVersions(String moduleName) {
        try {
            URL manifestUrl;
            Enumeration<URL> manifests = ManifestUtil.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            do {
                if (!manifests.hasMoreElements()) return null;
            } while (!(manifestUrl = manifests.nextElement()).toString().contains(moduleName));
            try (InputStream manifestStream = manifestUrl.openStream();){
                Attributes attrs = new Manifest(manifestStream).getMainAttributes();
                String bundleVersion = attrs.getValue("Bundle-Version");
                Pair<String, String> pair = Pair.of(bundleVersion, bundleVersion + " (revision " + attrs.getValue("SCM-Revision") + ")");
                return pair;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("IOException while determining opendj tool version", e);
        }
    }

    private ManifestUtil() {
    }

    static {
        Pair<String, String> versions = ManifestUtil.getVersions("opendj-core");
        OPENDJ_CORE_VERSION = versions.getFirst();
        OPENDJ_CORE_VERSION_WITH_REVISION = versions.getSecond();
    }
}

