/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.grizzly;

import com.forgerock.opendj.util.ReferenceCountedObject;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.grizzly.DefaultTCPNIOTransport;
import org.forgerock.opendj.grizzly.GrizzlyUtils;
import org.forgerock.opendj.grizzly.LDAPServerFilter;
import org.forgerock.opendj.ldap.Connections;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.LDAPClientContext;
import org.forgerock.opendj.ldap.LDAPListener;
import org.forgerock.opendj.ldap.ServerConnectionFactory;
import org.forgerock.opendj.ldap.spi.LDAPListenerImpl;
import org.forgerock.util.Options;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.nio.transport.TCPNIOBindingHandler;
import org.glassfish.grizzly.nio.transport.TCPNIOServerConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;

public final class GrizzlyLDAPListener
implements LDAPListenerImpl {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private final ReferenceCountedObject.Reference transport;
    private final ServerConnectionFactory<LDAPClientContext, Integer> connectionFactory;
    private final TCPNIOServerConnection serverConnection;
    private final AtomicBoolean isClosed = new AtomicBoolean();
    private final InetSocketAddress socketAddress;
    private final Options options;

    public GrizzlyLDAPListener(InetSocketAddress address, ServerConnectionFactory<LDAPClientContext, Integer> factory, Options options) throws IOException {
        this(address, factory, options, null);
    }

    public GrizzlyLDAPListener(InetSocketAddress address, ServerConnectionFactory<LDAPClientContext, Integer> factory, Options options, TCPNIOTransport transport) throws IOException {
        this.transport = DefaultTCPNIOTransport.DEFAULT_TRANSPORT.acquireIfNull(transport);
        this.connectionFactory = factory;
        this.options = Options.copyOf((Options)options);
        LDAPServerFilter serverFilter = new LDAPServerFilter(this, (DecodeOptions)options.get(LDAPListener.LDAP_DECODE_OPTIONS), (Integer)options.get(LDAPListener.REQUEST_MAX_SIZE_IN_BYTES));
        FilterChain ldapChain = GrizzlyUtils.buildFilterChain(((TCPNIOTransport)this.transport.get()).getProcessor(), (Filter)serverFilter);
        TCPNIOBindingHandler bindingHandler = ((TCPNIOBindingHandler.Builder)TCPNIOBindingHandler.builder((TCPNIOTransport)((TCPNIOTransport)this.transport.get())).processor((Processor)ldapChain)).build();
        this.serverConnection = bindingHandler.bind((SocketAddress)address, ((Integer)options.get(LDAPListener.CONNECT_MAX_BACKLOG)).intValue());
        int port = ((InetSocketAddress)this.serverConnection.getLocalAddress()).getPort();
        this.socketAddress = new InetSocketAddress(Connections.getHostString((InetSocketAddress)address), port);
    }

    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            try {
                this.serverConnection.close().get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                logger.warn(LocalizableMessage.raw((CharSequence)"Exception occurred while closing listener", (Object[])new Object[]{e}));
            }
            this.transport.release();
        }
    }

    public InetSocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LDAPListener(");
        builder.append(this.getSocketAddress());
        builder.append(')');
        return builder.toString();
    }

    ServerConnectionFactory<LDAPClientContext, Integer> getConnectionFactory() {
        return this.connectionFactory;
    }

    Options getLDAPListenerOptions() {
        return this.options;
    }
}

