/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.grizzly;

import java.io.EOFException;
import java.io.IOException;
import javax.net.ssl.SSLEngine;
import org.forgerock.opendj.grizzly.ASN1BufferReader;
import org.forgerock.opendj.grizzly.ASN1BufferWriter;
import org.forgerock.opendj.grizzly.ConnectionSecurityLayerFilter;
import org.forgerock.opendj.grizzly.GrizzlyLDAPConnection;
import org.forgerock.opendj.grizzly.GrizzlyUtils;
import org.forgerock.opendj.grizzly.LDAPBaseFilter;
import org.forgerock.opendj.io.ASN1Reader;
import org.forgerock.opendj.io.AbstractLDAPMessageHandler;
import org.forgerock.opendj.io.LDAP;
import org.forgerock.opendj.io.LDAPMessageHandler;
import org.forgerock.opendj.io.LDAPReader;
import org.forgerock.opendj.io.LDAPWriter;
import org.forgerock.opendj.ldap.ConnectionSecurityLayer;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.LDAPListener;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.BindClient;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.GenericBindRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.StartTLSExtendedRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.IntermediateResponse;
import org.forgerock.opendj.ldap.responses.Response;
import org.forgerock.opendj.ldap.responses.Responses;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.opendj.ldap.spi.BindResultLdapPromiseImpl;
import org.forgerock.opendj.ldap.spi.ExtendedResultLdapPromiseImpl;
import org.forgerock.opendj.ldap.spi.ResultLdapPromiseImpl;
import org.forgerock.opendj.ldap.spi.SearchResultLdapPromiseImpl;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;

final class LDAPClientFilter
extends LDAPBaseFilter {
    private static final Attribute<GrizzlyLDAPConnection> LDAP_CONNECTION_ATTR = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("LDAPClientConnection");
    private static final Attribute<ClientResponseHandler> RESPONSE_HANDLER_ATTR = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("ClientResponseHandler");

    LDAPClientFilter(DecodeOptions options, int maxASN1ElementSize) {
        super(options, maxASN1ElementSize);
    }

    public void exceptionOccurred(FilterChainContext ctx, Throwable error) {
        Connection connection = ctx.getConnection();
        if (!connection.isOpen()) {
            return;
        }
        GrizzlyLDAPConnection ldapConnection = (GrizzlyLDAPConnection)LDAP_CONNECTION_ATTR.get((AttributeStorage)connection);
        Result errorResult = error instanceof EOFException ? Responses.newResult((ResultCode)ResultCode.CLIENT_SIDE_SERVER_DOWN).setCause(error) : Responses.newResult((ResultCode)ResultCode.CLIENT_SIDE_LOCAL_ERROR).setCause(error);
        ldapConnection.close(null, false, errorResult);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final NextAction handleRead(FilterChainContext ctx) throws IOException {
        LDAPMessageHandler handler = this.getLDAPHandler(ctx);
        Buffer buffer = (Buffer)ctx.getMessage();
        try (ASN1BufferReader reader = new ASN1BufferReader(this.maxASN1ElementSize, buffer);){
            buffer.mark();
            if (!reader.elementAvailable()) {
                buffer.reset();
                NextAction nextAction = ctx.getStopAction((Object)buffer.duplicate());
                return nextAction;
            }
            int length = reader.peekLength();
            Buffer remainder = buffer.remaining() > length ? buffer.split(buffer.position() + length) : null;
            buffer.reset();
            try (ASN1BufferReader packetReader = new ASN1BufferReader(this.maxASN1ElementSize, buffer.asReadOnlyBuffer());){
                LDAPReader ldapReader = LDAP.getReader((ASN1Reader)packetReader, (DecodeOptions)this.decodeOptions);
                ctx.setMessage(null);
                ldapReader.readMessage(handler);
            }
            NextAction nextAction = ctx.getInvokeAction((Object)remainder);
            return nextAction;
        }
        catch (IOException e) {
            this.handleReadException(ctx, e);
            throw e;
        }
    }

    private final void handleReadException(FilterChainContext ctx, IOException e) {
        GrizzlyLDAPConnection ldapConnection = (GrizzlyLDAPConnection)LDAP_CONNECTION_ATTR.get((AttributeStorage)ctx.getConnection());
        Result errorResult = Responses.newResult((ResultCode)ResultCode.CLIENT_SIDE_DECODING_ERROR).setCause((Throwable)e).setDiagnosticMessage(e.getMessage());
        ldapConnection.close(null, false, errorResult);
    }

    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        GrizzlyLDAPConnection ldapConnection = (GrizzlyLDAPConnection)LDAP_CONNECTION_ATTR.remove((AttributeStorage)connection);
        if (ldapConnection != null) {
            Result errorResult = Responses.newResult((ResultCode)ResultCode.CLIENT_SIDE_SERVER_DOWN);
            ldapConnection.close(null, false, errorResult);
        }
        return ctx.getInvokeAction();
    }

    final LDAPMessageHandler getLDAPHandler(FilterChainContext ctx) {
        Connection connection = ctx.getConnection();
        ClientResponseHandler handler = (ClientResponseHandler)((Object)RESPONSE_HANDLER_ATTR.get((AttributeStorage)connection));
        if (handler == null) {
            handler = new ClientResponseHandler();
            RESPONSE_HANDLER_ATTR.set((AttributeStorage)connection, (Object)handler);
        }
        handler.setFilterChainContext(ctx);
        return handler;
    }

    void registerConnection(Connection<?> connection, GrizzlyLDAPConnection ldapConnection) {
        LDAP_CONNECTION_ATTR.set(connection, (Object)ldapConnection);
    }

    static final class ClientResponseHandler
    extends AbstractLDAPMessageHandler {
        private FilterChainContext context;

        ClientResponseHandler() {
        }

        void setFilterChainContext(FilterChainContext context) {
            this.context = context;
        }

        public void addResult(int messageID, Result result) throws DecodeException, IOException {
            ResultLdapPromiseImpl<?, ?> pendingRequest;
            GrizzlyLDAPConnection ldapConnection = (GrizzlyLDAPConnection)LDAP_CONNECTION_ATTR.get((AttributeStorage)this.context.getConnection());
            if (ldapConnection != null && (pendingRequest = ldapConnection.removePendingRequest(messageID)) != null) {
                if (pendingRequest.getRequest() instanceof AddRequest) {
                    pendingRequest.setResultOrError(result);
                    return;
                }
                throw this.newUnexpectedResponseException(messageID, (Response)result);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bindResult(int messageID, BindResult result) throws DecodeException, IOException {
            ResultLdapPromiseImpl<?, ?> pendingRequest;
            GrizzlyLDAPConnection ldapConnection = (GrizzlyLDAPConnection)LDAP_CONNECTION_ATTR.get((AttributeStorage)this.context.getConnection());
            if (ldapConnection != null && (pendingRequest = ldapConnection.removePendingRequest(messageID)) != null) {
                if (pendingRequest instanceof BindResultLdapPromiseImpl) {
                    ConnectionSecurityLayer l;
                    BindClient bindClient;
                    BindResultLdapPromiseImpl promise;
                    block9: {
                        promise = (BindResultLdapPromiseImpl)pendingRequest;
                        bindClient = promise.getBindClient();
                        try {
                            if (bindClient.evaluateResult(result)) break block9;
                            int msgID = ldapConnection.continuePendingBindRequest(promise);
                            LDAPWriter<ASN1BufferWriter> ldapWriter = GrizzlyUtils.getWriter(this.context.getMemoryManager(), 3);
                            try {
                                GenericBindRequest nextRequest = bindClient.nextBindRequest();
                                ldapWriter.writeBindRequest(msgID, 3, nextRequest);
                                this.context.write((Object)((ASN1BufferWriter)ldapWriter.getASN1Writer()).getBuffer(), null);
                            }
                            finally {
                                GrizzlyUtils.recycleWriter(ldapWriter);
                            }
                            return;
                        }
                        catch (LdapException e) {
                            ldapConnection.setBindOrStartTLSInProgress(false);
                            promise.adaptErrorResult(e.getResult());
                            return;
                        }
                        catch (IOException e) {
                            ldapConnection.setBindOrStartTLSInProgress(false);
                            Result errorResult = Responses.newResult((ResultCode)ResultCode.CLIENT_SIDE_LOCAL_ERROR).setDiagnosticMessage("An error occurred during multi-stage authentication").setCause((Throwable)e);
                            promise.adaptErrorResult(errorResult);
                            return;
                        }
                    }
                    if (result.getResultCode() == ResultCode.SUCCESS && (l = bindClient.getConnectionSecurityLayer()) != null) {
                        ldapConnection.installFilter((Filter)new ConnectionSecurityLayerFilter(l, this.context.getConnection().getTransport().getMemoryManager()));
                    }
                    ldapConnection.setBindOrStartTLSInProgress(false);
                    promise.setResultOrError((Result)result);
                    return;
                }
                throw this.newUnexpectedResponseException(messageID, (Response)result);
            }
        }

        public void compareResult(int messageID, CompareResult result) throws DecodeException, IOException {
            ResultLdapPromiseImpl<?, ?> pendingRequest;
            GrizzlyLDAPConnection ldapConnection = (GrizzlyLDAPConnection)LDAP_CONNECTION_ATTR.get((AttributeStorage)this.context.getConnection());
            if (ldapConnection != null && (pendingRequest = ldapConnection.removePendingRequest(messageID)) != null) {
                if (pendingRequest.getRequest() instanceof CompareRequest) {
                    pendingRequest.setResultOrError((Result)result);
                    return;
                }
                throw this.newUnexpectedResponseException(messageID, (Response)result);
            }
        }

        public void deleteResult(int messageID, Result result) throws DecodeException, IOException {
            ResultLdapPromiseImpl<?, ?> pendingRequest;
            GrizzlyLDAPConnection ldapConnection = (GrizzlyLDAPConnection)LDAP_CONNECTION_ATTR.get((AttributeStorage)this.context.getConnection());
            if (ldapConnection != null && (pendingRequest = ldapConnection.removePendingRequest(messageID)) != null) {
                if (pendingRequest.getRequest() instanceof DeleteRequest) {
                    pendingRequest.setResultOrError(result);
                    return;
                }
                throw this.newUnexpectedResponseException(messageID, (Response)result);
            }
        }

        public void extendedResult(int messageID, ExtendedResult result) throws DecodeException, IOException {
            GrizzlyLDAPConnection ldapConnection = (GrizzlyLDAPConnection)LDAP_CONNECTION_ATTR.get((AttributeStorage)this.context.getConnection());
            if (ldapConnection != null) {
                if (messageID == 0) {
                    if ("1.3.6.1.4.1.1466.20036".equals(result.getOID())) {
                        Result errorResult = Responses.newResult((ResultCode)result.getResultCode()).setDiagnosticMessage(result.getDiagnosticMessage());
                        ldapConnection.close(null, true, errorResult);
                    } else {
                        ldapConnection.handleUnsolicitedNotification(result);
                    }
                } else {
                    ResultLdapPromiseImpl<?, ?> pendingRequest = ldapConnection.removePendingRequest(messageID);
                    if (pendingRequest != null) {
                        if (pendingRequest.getRequest() instanceof ExtendedRequest) {
                            ExtendedResultLdapPromiseImpl extendedPromise = (ExtendedResultLdapPromiseImpl)pendingRequest;
                            try {
                                this.handleExtendedResult0(ldapConnection, extendedPromise, result);
                            }
                            catch (DecodeException de) {
                                Result errorResult = Responses.newResult((ResultCode)ResultCode.CLIENT_SIDE_DECODING_ERROR).setDiagnosticMessage(de.getLocalizedMessage()).setCause((Throwable)de);
                                extendedPromise.adaptErrorResult(errorResult);
                            }
                        } else {
                            throw this.newUnexpectedResponseException(messageID, (Response)result);
                        }
                    }
                }
            }
        }

        public void intermediateResponse(int messageID, IntermediateResponse response) throws DecodeException, IOException {
            ResultLdapPromiseImpl<?, ?> pendingRequest;
            GrizzlyLDAPConnection ldapConnection = (GrizzlyLDAPConnection)LDAP_CONNECTION_ATTR.get((AttributeStorage)this.context.getConnection());
            if (ldapConnection != null && (pendingRequest = ldapConnection.getPendingRequest(messageID)) != null) {
                pendingRequest.handleIntermediateResponse(response);
            }
        }

        public void modifyDNResult(int messageID, Result result) throws DecodeException, IOException {
            ResultLdapPromiseImpl<?, ?> pendingRequest;
            GrizzlyLDAPConnection ldapConnection = (GrizzlyLDAPConnection)LDAP_CONNECTION_ATTR.get((AttributeStorage)this.context.getConnection());
            if (ldapConnection != null && (pendingRequest = ldapConnection.removePendingRequest(messageID)) != null) {
                if (pendingRequest.getRequest() instanceof ModifyDNRequest) {
                    pendingRequest.setResultOrError(result);
                    return;
                }
                throw this.newUnexpectedResponseException(messageID, (Response)result);
            }
        }

        public void modifyResult(int messageID, Result result) throws DecodeException, IOException {
            ResultLdapPromiseImpl<?, ?> pendingRequest;
            GrizzlyLDAPConnection ldapConnection = (GrizzlyLDAPConnection)LDAP_CONNECTION_ATTR.get((AttributeStorage)this.context.getConnection());
            if (ldapConnection != null && (pendingRequest = ldapConnection.removePendingRequest(messageID)) != null) {
                if (pendingRequest.getRequest() instanceof ModifyRequest) {
                    pendingRequest.setResultOrError(result);
                    return;
                }
                throw this.newUnexpectedResponseException(messageID, (Response)result);
            }
        }

        public void searchResult(int messageID, Result result) throws DecodeException, IOException {
            ResultLdapPromiseImpl<?, ?> pendingRequest;
            GrizzlyLDAPConnection ldapConnection = (GrizzlyLDAPConnection)LDAP_CONNECTION_ATTR.get((AttributeStorage)this.context.getConnection());
            if (ldapConnection != null && (pendingRequest = ldapConnection.removePendingRequest(messageID)) != null) {
                if (pendingRequest.getRequest() instanceof SearchRequest) {
                    pendingRequest.setResultOrError(result);
                } else {
                    throw this.newUnexpectedResponseException(messageID, (Response)result);
                }
            }
        }

        public void searchResultEntry(int messageID, SearchResultEntry entry) throws DecodeException, IOException {
            ResultLdapPromiseImpl<?, ?> pendingRequest;
            GrizzlyLDAPConnection ldapConnection = (GrizzlyLDAPConnection)LDAP_CONNECTION_ATTR.get((AttributeStorage)this.context.getConnection());
            if (ldapConnection != null && (pendingRequest = ldapConnection.getPendingRequest(messageID)) != null) {
                if (pendingRequest instanceof SearchResultLdapPromiseImpl) {
                    ((SearchResultLdapPromiseImpl)pendingRequest).handleEntry(entry);
                } else {
                    throw this.newUnexpectedResponseException(messageID, (Response)entry);
                }
            }
        }

        public void searchResultReference(int messageID, SearchResultReference reference) throws DecodeException, IOException {
            ResultLdapPromiseImpl<?, ?> pendingRequest;
            GrizzlyLDAPConnection ldapConnection = (GrizzlyLDAPConnection)LDAP_CONNECTION_ATTR.get((AttributeStorage)this.context.getConnection());
            if (ldapConnection != null && (pendingRequest = ldapConnection.getPendingRequest(messageID)) != null) {
                if (pendingRequest instanceof SearchResultLdapPromiseImpl) {
                    ((SearchResultLdapPromiseImpl)pendingRequest).handleReference(reference);
                } else {
                    throw this.newUnexpectedResponseException(messageID, (Response)reference);
                }
            }
        }

        private <R extends ExtendedResult> void handleExtendedResult0(final GrizzlyLDAPConnection conn, final ExtendedResultLdapPromiseImpl<R> promise, ExtendedResult result) throws DecodeException {
            final ExtendedResult decodedResponse = promise.decodeResult(result, (DecodeOptions)conn.getLDAPOptions().get(LDAPListener.LDAP_DECODE_OPTIONS));
            if (result.getResultCode() == ResultCode.SUCCESS && promise.getRequest() instanceof StartTLSExtendedRequest) {
                try {
                    StartTLSExtendedRequest request = (StartTLSExtendedRequest)promise.getRequest();
                    conn.startTLS(request.getSSLContext(), request.getEnabledProtocols(), request.getEnabledCipherSuites(), (CompletionHandler<SSLEngine>)new EmptyCompletionHandler<SSLEngine>(){

                        public void completed(SSLEngine result) {
                            conn.setBindOrStartTLSInProgress(false);
                            promise.setResultOrError((Result)decodedResponse);
                        }

                        public void failed(Throwable throwable) {
                            Result errorResult = Responses.newResult((ResultCode)ResultCode.CLIENT_SIDE_LOCAL_ERROR).setCause(throwable).setDiagnosticMessage("SSL handshake failed");
                            conn.setBindOrStartTLSInProgress(false);
                            conn.close(null, false, errorResult);
                            promise.adaptErrorResult(errorResult);
                        }
                    });
                    return;
                }
                catch (IOException e) {
                    Result errorResult = Responses.newResult((ResultCode)ResultCode.CLIENT_SIDE_LOCAL_ERROR).setCause((Throwable)e).setDiagnosticMessage(e.getMessage());
                    promise.adaptErrorResult(errorResult);
                    conn.close(null, false, errorResult);
                    return;
                }
            }
            promise.setResultOrError((Result)decodedResponse);
        }
    }
}

