/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.maven.doc;

import freemarker.template.Configuration;
import freemarker.template.TemplateExceptionHandler;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public final class Utils {
    static final String EOL = System.getProperty("line.separator");
    static Configuration configuration;

    static void createDirectory(String directory) throws IOException {
        File dir = new File(directory);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Failed to create directory: " + directory);
        }
    }

    static String getJavaCommand() {
        return System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
    }

    static void copyFile(File original, File copy) throws IOException {
        Utils.copyInputStreamToFile(new FileInputStream(original), copy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copyInputStreamToFile(InputStream original, File copy) throws IOException {
        if (original == null) {
            throw new IOException("Could not read input to copy.");
        }
        Utils.createFile(copy);
        try (FileOutputStream outputStream = new FileOutputStream(copy);){
            int bytesRead;
            byte[] buffer = new byte[4096];
            while ((bytesRead = original.read(buffer)) > 0) {
                ((OutputStream)outputStream).write(buffer, 0, bytesRead);
            }
        }
        catch (Throwable throwable) {
            org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{original});
            throw throwable;
        }
        org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{original});
    }

    static void writeStringToFile(String string, File file) throws IOException {
        Utils.createFile(file);
        PrintWriter printWriter = new PrintWriter(file);
        printWriter.print(string);
        printWriter.close();
    }

    private static void createFile(File file) throws IOException {
        if (!file.exists()) {
            Utils.createDirectory(file.getParent());
            if (!file.createNewFile()) {
                throw new IOException("Failed to create " + file.getPath());
            }
        }
    }

    static String getClassPath(URLClassLoader classLoader) throws URISyntaxException {
        LinkedHashSet urls = new LinkedHashSet();
        Collections.addAll(urls, classLoader.getURLs());
        Collections.addAll(urls, ((URLClassLoader)classLoader.getParent()).getURLs());
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        for (URL url : urls) {
            paths.add(new File(url.toURI()).getPath());
        }
        return org.forgerock.util.Utils.joinAsString((String)File.pathSeparator, paths);
    }

    static URLClassLoader getRuntimeClassLoader(MavenProject project, Log log) throws DependencyResolutionRequiredException, MalformedURLException {
        List runtimeClasspathElements = project.getRuntimeClasspathElements();
        LinkedHashSet<URL> runtimeUrls = new LinkedHashSet<URL>();
        for (String element : runtimeClasspathElements) {
            runtimeUrls.add(new File(element).toURI().toURL());
        }
        URLClassLoader urlClassLoader = new URLClassLoader(runtimeUrls.toArray(new URL[runtimeClasspathElements.size()]), Thread.currentThread().getContextClassLoader());
        Utils.debugClassPathElements(urlClassLoader, log);
        return urlClassLoader;
    }

    static void debugClassPathElements(ClassLoader classLoader, Log log) {
        if (null == classLoader) {
            return;
        }
        log.debug((CharSequence)"--------------------");
        log.debug((CharSequence)classLoader.toString());
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader ucl = (URLClassLoader)classLoader;
            int i = 0;
            for (URL url : ucl.getURLs()) {
                log.debug((CharSequence)("url[" + i++ + "]=" + url));
            }
        }
        Utils.debugClassPathElements(classLoader.getParent(), log);
    }

    static Configuration getConfiguration() {
        if (configuration == null) {
            configuration = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
            configuration.setClassForTemplateLoading(Utils.class, "/templates");
            configuration.setDefaultEncoding("UTF-8");
            configuration.setTemplateExceptionHandler(TemplateExceptionHandler.DEBUG_HANDLER);
        }
        return configuration;
    }

    /*
     * Exception decompiling
     */
    static String applyTemplate(String template, Map<String, Object> map) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Utils() {
    }
}

