/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.maven.doc;

import com.forgerock.opendj.ldap.CoreMessages;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.forgerock.opendj.ldap.schema.CoreSchemaSupportedLocales;
import org.forgerock.opendj.maven.doc.Utils;

@Mojo(name="generate-schema-ref")
public class GenerateSchemaDocMojo
extends AbstractMojo {
    @Parameter(defaultValue="en")
    private String locale;
    @Parameter(defaultValue="${project.build.directory}/docbkx-sources/shared")
    private File outputDirectory;
    private final Map<String, String> localeTagsToOids = CoreSchemaSupportedLocales.getJvmSupportedLocaleNamesToOids();

    public void execute() throws MojoExecutionException, MojoFailureException {
        Locale currentLocale = this.getLocaleFromTag(this.locale);
        String localeReference = this.getLocalesAndSubTypesDocumentation(currentLocale);
        File localeReferenceFile = new File(this.outputDirectory, "sec-locales-subtypes.xml");
        try {
            Utils.writeStringToFile(localeReference, localeReferenceFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write " + localeReferenceFile.getPath());
        }
    }

    private String getLocalesAndSubTypesDocumentation(Locale currentLocale) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("year", new SimpleDateFormat("yyyy").format(new Date()));
        map.put("lang", this.getTagFromLocale(currentLocale));
        map.put("title", CoreMessages.DOC_LOCALE_SECTION_TITLE.get());
        map.put("info", CoreMessages.DOC_LOCALE_SECTION_INFO.get());
        map.put("locales", this.getLocalesDocMap(currentLocale));
        map.put("subtypes", this.getSubTypesDocMap(currentLocale));
        return Utils.applyTemplate("sec-locales-subtypes.ftl", map);
    }

    private Map<String, LocaleDoc> getLanguagesToLocalesMap(Locale currentLocale) {
        TreeMap<String, LocaleDoc> locales = new TreeMap<String, LocaleDoc>();
        for (String tag : this.localeTagsToOids.keySet()) {
            Locale locale = this.getLocaleFromTag(tag);
            if (locale == null) continue;
            LocaleDoc localeDoc = new LocaleDoc();
            localeDoc.tag = tag;
            localeDoc.language = locale.getDisplayName(currentLocale);
            localeDoc.oid = this.localeTagsToOids.get(tag);
            if (!localeDoc.language.equals(localeDoc.tag)) {
                locales.put(localeDoc.language, localeDoc);
                continue;
            }
            if (!localeDoc.tag.equals("sh")) continue;
            localeDoc.language = CoreMessages.DOC_LANGUAGE_SH.get().toString(currentLocale);
            locales.put(localeDoc.language, localeDoc);
        }
        return locales;
    }

    private Map<String, Object> getLocalesDocMap(Locale currentLocale) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("title", CoreMessages.DOC_SUPPORTED_LOCALES_TITLE.get());
        result.put("indexTerm", CoreMessages.DOC_SUPPORTED_LOCALES_INDEXTERM.get());
        Map<String, LocaleDoc> localesMap = this.getLanguagesToLocalesMap(currentLocale);
        Set<String> sortedLanguages = localesMap.keySet();
        LinkedList locales = new LinkedList();
        for (String language : sortedLanguages) {
            LocaleDoc locale = localesMap.get(language);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("language", locale.language);
            map.put("tag", (String)CoreMessages.DOC_LOCALE_TAG.get((Object)locale.tag));
            map.put("oid", (String)CoreMessages.DOC_LOCALE_OID.get((Object)locale.oid));
            locales.add(map);
        }
        result.put("locales", locales);
        return result;
    }

    private Map<String, Object> getSubTypesDocMap(Locale currentLocale) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("title", CoreMessages.DOC_SUPPORTED_SUBTYPES_TITLE.get());
        result.put("indexTerm", CoreMessages.DOC_SUPPORTED_SUBTYPES_INDEXTERM.get());
        LinkedList locales = new LinkedList();
        for (String tag : this.localeTagsToOids.keySet()) {
            Locale locale;
            HashMap<String, String> map = new HashMap<String, String>();
            int idx = tag.indexOf(45);
            if (idx != -1 || (locale = this.getLocaleFromTag(tag)) == null) continue;
            String language = locale.getDisplayName(currentLocale);
            if (!language.equals(tag)) {
                map.put("language", language);
                map.put("tag", tag);
            } else if (tag.equals("sh")) {
                map.put("language", CoreMessages.DOC_LANGUAGE_SH.get().toString(currentLocale));
                map.put("tag", tag);
            }
            if (map.isEmpty()) continue;
            locales.add(map);
        }
        result.put("locales", locales);
        return result;
    }

    private Locale getLocaleFromTag(String tag) {
        if (tag == null) {
            return null;
        }
        int sep = 45;
        int langIdx = tag.indexOf(45);
        if (langIdx == -1) {
            return new Locale(tag);
        }
        String lang = tag.substring(0, langIdx);
        int countryIdx = tag.indexOf(45, langIdx + 1);
        if (countryIdx == -1) {
            String country = tag.substring(langIdx + 1);
            return new Locale(lang, country);
        }
        String country = tag.substring(langIdx + 1, countryIdx);
        String variant = tag.substring(countryIdx + 1);
        return new Locale(lang, country, variant);
    }

    private String getTagFromLocale(Locale locale) {
        if (locale == null) {
            return null;
        }
        String lang = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        int sep = 45;
        StringBuilder tag = new StringBuilder();
        if (lang != null) {
            tag.append(lang);
        }
        if (country != null && !country.isEmpty()) {
            tag.append('-').append(country);
        }
        if (variant != null && !variant.isEmpty()) {
            tag.append('-').append(variant);
        }
        return tag.toString();
    }

    private class LocaleDoc {
        String tag;
        String language;
        String oid;

        private LocaleDoc() {
        }
    }
}

