/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.maven.doc;

import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.maven.doc.Utils;

@Mojo(name="generate-result-code-doc", defaultPhase=LifecyclePhase.COMPILE)
public class GenerateResultCodeDocMojo
extends AbstractMojo {
    @Parameter(required=true)
    private File resultCodeSource;
    @Parameter(required=true)
    private File xmlFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        JavaClass resultCodeClass;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("year", new SimpleDateFormat("yyyy").format(new Date()));
        try {
            resultCodeClass = this.getJavaClass();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not read " + this.resultCodeSource.getPath(), (Exception)e);
        }
        map.put("classComment", this.cleanComment(resultCodeClass.getComment()));
        HashMap<String, Object> comments = new HashMap<String, Object>();
        for (JavaField field : resultCodeClass.getFields()) {
            JavaClass type = field.getType();
            if (!type.getValue().equals("ResultCode")) continue;
            comments.put(field.getName(), this.cleanComment(field.getComment()));
        }
        map.put("resultCodes", this.getResultCodesDoc(comments));
        String template = "appendix-ldap-result-codes.ftl";
        try {
            Utils.writeStringToFile(Utils.applyTemplate("appendix-ldap-result-codes.ftl", map), this.xmlFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not write to " + this.xmlFile.getPath(), (Exception)e);
        }
        this.getLog().info((CharSequence)("Wrote " + this.xmlFile.getPath()));
    }

    private JavaClass getJavaClass() throws IOException {
        JavaProjectBuilder builder = new JavaProjectBuilder();
        builder.addSource(this.resultCodeSource);
        return builder.getClassByName("org.forgerock.opendj.ldap.ResultCode");
    }

    private String cleanComment(String comment) {
        return this.stripCodeValueSentences(this.stripTags(this.convertLineSeparators(comment))).trim();
    }

    private String convertLineSeparators(String string) {
        return string.replaceAll(System.lineSeparator(), " ");
    }

    private String stripTags(String string) {
        return string.replaceAll("<[^>]*>", "");
    }

    private String stripCodeValueSentences(String string) {
        return string.replaceAll("This result code corresponds to the LDAP result code value of \\{@code \\d+\\}.", "");
    }

    private List<Map<String, Object>> getResultCodesDoc(Map<String, Object> comments) {
        LinkedList<Map<String, Object>> list = new LinkedList<Map<String, Object>>();
        if (comments == null || comments.isEmpty()) {
            return list;
        }
        for (ResultCode resultCode : ResultCode.values()) {
            HashMap<String, Object> doc = new HashMap<String, Object>();
            doc.put("intValue", resultCode.intValue());
            doc.put("name", resultCode.getName());
            Object comment = comments.get(resultCode.asEnum().toString());
            doc.put("comment", comment);
            list.add(doc);
        }
        return list;
    }
}

