/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.maven.doc;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.forgerock.opendj.maven.doc.CommandLineTool;
import org.forgerock.opendj.maven.doc.Utils;

@Mojo(name="generate-refentry", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public final class GenerateRefEntriesMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter
    private List<CommandLineTool> tools;
    @Parameter(required=true)
    private File outputDir;
    private static final String EOL = System.getProperty("line.separator");

    public void execute() throws MojoExecutionException, MojoFailureException {
        URLClassLoader toolsClassLoader;
        if (!this.isOutputDirAvailable()) {
            throw new MojoFailureException("Output directory " + this.outputDir.getPath() + " not available");
        }
        try {
            toolsClassLoader = Utils.getRuntimeClassLoader(this.project, this.getLog());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to get class loader.", e);
        }
        for (CommandLineTool tool : this.tools) {
            if (!tool.isEnabled()) continue;
            this.generateManPageForTool(toolsClassLoader, tool);
        }
    }

    private void generateManPageForTool(URLClassLoader toolsClassLoader, CommandLineTool tool) throws MojoExecutionException, MojoFailureException {
        File manPage = new File(this.outputDir, "man-" + tool.getName() + ".xml");
        String toolScript = tool.getName();
        String toolSects = this.pathsToXIncludes(tool.getTrailingSectionPaths());
        String toolClass = tool.getApplication();
        LinkedList<String> commands = new LinkedList<String>();
        commands.add(Utils.getJavaCommand());
        commands.addAll(this.getJavaArgs(toolScript, toolSects));
        commands.add("-classpath");
        try {
            commands.add(Utils.getClassPath(toolsClassLoader));
        }
        catch (URISyntaxException e) {
            throw new MojoExecutionException("Failed to set the classpath.", (Exception)e);
        }
        commands.add(toolClass);
        commands.add(this.getUsageArgument(toolScript));
        this.getLog().info((CharSequence)("Writing man page: " + manPage.getPath()));
        try {
            ProcessBuilder builder = new ProcessBuilder(commands);
            Process process = builder.start();
            this.writeToFile(process.getInputStream(), manPage);
            process.waitFor();
            int result = process.exitValue();
            if (result != 0) {
                StringBuilder message = new StringBuilder();
                message.append("Failed to write page. Tool exit code: ").append(result).append(EOL).append("To debug the problem, run the following command and connect your IDE:").append(EOL);
                commands.add(1, "-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=8000");
                for (String arg : commands) {
                    message.append("\"").append(arg).append("\"").append(' ');
                }
                message.append(EOL);
                throw new MojoFailureException(message.toString());
            }
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException(toolClass + " interrupted", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException(toolClass + " not found", (Exception)e);
        }
        if (tool.getName().equals("dsconfig")) {
            try {
                this.splitPage(manPage);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to split " + manPage.getName(), (Exception)e);
            }
        }
    }

    private boolean isOutputDirAvailable() {
        return this.outputDir != null && (this.outputDir.exists() && this.outputDir.isDirectory() || this.outputDir.mkdirs());
    }

    private List<String> getJavaArgs(String scriptName, String trailingSections) {
        LinkedList<String> args = new LinkedList<String>();
        args.add("-Dorg.forgerock.opendj.gendoc=true");
        args.add("-Dorg.opends.server.ServerRoot=" + System.getProperty("java.io.tmpdir"));
        args.add("-Dcom.forgerock.opendj.ldap.tools.scriptName=" + scriptName);
        args.add("-Dorg.forgerock.opendj.gendoc.trailing=" + trailingSections + "");
        return args;
    }

    private String pathsToXIncludes(List<String> paths) {
        if (paths == null) {
            return "";
        }
        String nameSpace = "xinclude";
        StringBuilder result = new StringBuilder();
        for (String path : paths) {
            result.append("<").append("xinclude").append(":include href='").append(path).append("' />");
        }
        return result.toString();
    }

    private String getUsageArgument(String scriptName) {
        return scriptName.equals("dsjavaproperties") ? "-H" : "-?";
    }

    private void writeToFile(InputStream input, File output) throws IOException {
        try (FileWriter writer = new FileWriter(output);){
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            while ((line = reader.readLine()) != null) {
                writer.write(line);
                writer.write(EOL);
            }
        }
    }

    private void splitPage(File page) throws IOException {
        File pageCopy = new File(page.getPath() + ".tmp");
        Utils.copyFile(page, pageCopy);
        try (BufferedReader reader = new BufferedReader(new FileReader(pageCopy));){
            String line;
            File output = page;
            this.getLog().info((CharSequence)("Rewriting man page: " + page.getPath()));
            Pattern marker = Pattern.compile("@@@(.+?)@@@");
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                Matcher matcher = marker.matcher(line);
                if (matcher.find()) {
                    this.writeToFile(builder.toString(), output);
                    builder.setLength(0);
                    output = new File(page.getParentFile(), "man-" + matcher.group(1) + ".xml");
                    this.getLog().info((CharSequence)("Writing man page: " + output.getPath()));
                    continue;
                }
                builder.append(line).append(System.getProperty("line.separator"));
            }
            this.writeToFile(builder.toString(), output);
            if (!pageCopy.delete()) {
                throw new IOException("Failed to delete " + pageCopy.getName());
            }
        }
    }

    private void writeToFile(String input, File output) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(input.getBytes(Charset.forName("UTF-8")));
        this.writeToFile(is, output);
    }
}

