/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.maven.doc;

import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.maven.doc.DocsMessages;
import org.forgerock.opendj.maven.doc.GenerateSchemaDocMojo;
import org.forgerock.util.Utils;

@Mojo(name="generate-xml-messages-doc", defaultPhase=LifecyclePhase.PRE_SITE)
public class GenerateMessageFileMojo
extends AbstractMojo {
    @Parameter(property="project", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="en")
    private String locale;
    @Parameter(required=true)
    private String messagesDirectory;
    @Parameter(required=true)
    private String outputDirectory;
    @Parameter(required=true)
    private List<String> messageFileNames;
    private static final HashMap<String, LocalizableMessage> CATEGORY_DESCRIPTIONS = new HashMap();
    public static final String KEY_FORM_MSG = ".\n\nOpenDJ message property keys must be of the form\n\n\t'[CATEGORY]_[SEVERITY]_[DESCRIPTION]_[ORDINAL]'\n\n";
    private static final String ERROR_SEVERITY_IDENTIFIER_STRING = "ERR_";
    private Configuration configuration;

    private Configuration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
            this.configuration.setClassForTemplateLoading(GenerateSchemaDocMojo.class, "/templates");
            this.configuration.setDefaultEncoding("UTF-8");
            this.configuration.setTemplateExceptionHandler(TemplateExceptionHandler.DEBUG_HANDLER);
        }
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLogRef(File file, String template, Map<String, Object> map) throws IOException, TemplateException {
        this.configuration = this.getConfiguration();
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(file);
            this.configuration.getTemplate(template).process(map, (Writer)writer);
        }
        catch (Throwable throwable) {
            Utils.closeSilently((Closeable[])new Closeable[]{writer});
            throw throwable;
        }
        Utils.closeSilently((Closeable[])new Closeable[]{writer});
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        String projectBuildDir = this.project.getBuild().getDirectory();
        if (!this.outputDirectory.contains(projectBuildDir)) {
            String errorMsg = String.format("outputDirectory parameter (%s) must be included in ${project.build.directory} (%s)", this.outputDirectory, projectBuildDir);
            this.getLog().error((CharSequence)errorMsg);
            throw new MojoExecutionException(errorMsg);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("year", new SimpleDateFormat("yyyy").format(new Date()));
        map.put("lang", this.locale);
        map.put("title", DocsMessages.LOG_REF_TITLE.get());
        map.put("indexterm", DocsMessages.LOG_REF_INDEXTERM.get());
        map.put("intro", DocsMessages.LOG_REF_INTRO.get());
        LinkedList<Map<String, Object>> categories = new LinkedList<Map<String, Object>>();
        for (String category : this.messageFileNames) {
            File source = new File(this.messagesDirectory, category + ".properties");
            categories.add(this.getCategoryMap(source, category.toUpperCase()));
        }
        map.put("categories", categories);
        File file = new File(this.outputDirectory, "log-message-reference.xml");
        try {
            this.createOutputDirectory();
            this.writeLogRef(file, "log-message-reference.ftl", map);
        }
        catch (Exception e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private void createOutputDirectory() throws IOException {
        File outputDir = new File(this.outputDirectory);
        if (outputDir != null && !outputDir.exists() && !outputDir.mkdirs()) {
            throw new IOException("Failed to create output directory.");
        }
    }

    private Map<String, Object> getCategoryMap(File source, String globalCategory) throws MojoExecutionException {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(source));
            Map<MessagePropertyKey, String> errorMessages = this.loadErrorProperties(properties);
            TreeSet<MessageRefEntry> messageRefEntries = new TreeSet<MessageRefEntry>();
            HashSet<Integer> usedOrdinals = new HashSet<Integer>();
            for (MessagePropertyKey msgKey : errorMessages.keySet()) {
                String formatString = errorMessages.get(msgKey).replaceAll("<", "&lt;");
                Integer ordinal = msgKey.getOrdinal();
                if (ordinal != null && usedOrdinals.contains(ordinal)) {
                    throw new Exception("The ordinal value '" + ordinal + "' in key " + msgKey + " has been previously defined in " + source + KEY_FORM_MSG);
                }
                usedOrdinals.add(ordinal);
                messageRefEntries.add(new MessageRefEntry(msgKey.toString(), ordinal, formatString));
            }
            return messageRefEntries.isEmpty() ? new HashMap<String, Object>() : new MessageRefCategory(globalCategory, messageRefEntries).toMap();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private Map<MessagePropertyKey, String> loadErrorProperties(Properties properties) throws Exception {
        TreeMap<MessagePropertyKey, String> errorMessage = new TreeMap<MessagePropertyKey, String>();
        for (Object propO : properties.keySet()) {
            String propKey = propO.toString();
            try {
                if (!propKey.startsWith(ERROR_SEVERITY_IDENTIFIER_STRING)) continue;
                MessagePropertyKey key = MessagePropertyKey.parseString(propKey);
                String formatString = properties.getProperty(propKey);
                errorMessage.put(key, formatString);
            }
            catch (IllegalArgumentException iae) {
                throw new Exception("invalid property key " + propKey + ": " + iae.getMessage() + KEY_FORM_MSG, iae);
            }
        }
        return errorMessage;
    }

    static {
        CATEGORY_DESCRIPTIONS.put("ACCESS_CONTROL", DocsMessages.CATEGORY_ACCESS_CONTROL.get());
        CATEGORY_DESCRIPTIONS.put("ADMIN", DocsMessages.CATEGORY_ADMIN.get());
        CATEGORY_DESCRIPTIONS.put("ADMIN_TOOL", DocsMessages.CATEGORY_ADMIN_TOOL.get());
        CATEGORY_DESCRIPTIONS.put("BACKEND", DocsMessages.CATEGORY_BACKEND.get());
        CATEGORY_DESCRIPTIONS.put("CONFIG", DocsMessages.CATEGORY_CONFIG.get());
        CATEGORY_DESCRIPTIONS.put("CORE", DocsMessages.CATEGORY_CORE.get());
        CATEGORY_DESCRIPTIONS.put("DSCONFIG", DocsMessages.CATEGORY_DSCONFIG.get());
        CATEGORY_DESCRIPTIONS.put("EXTENSIONS", DocsMessages.CATEGORY_EXTENSIONS.get());
        CATEGORY_DESCRIPTIONS.put("JEB", DocsMessages.CATEGORY_JEB.get());
        CATEGORY_DESCRIPTIONS.put("LOG", DocsMessages.CATEGORY_LOG.get());
        CATEGORY_DESCRIPTIONS.put("PLUGIN", DocsMessages.CATEGORY_PLUGIN.get());
        CATEGORY_DESCRIPTIONS.put("PROTOCOL", DocsMessages.CATEGORY_PROTOCOL.get());
        CATEGORY_DESCRIPTIONS.put("QUICKSETUP", DocsMessages.CATEGORY_QUICKSETUP.get());
        CATEGORY_DESCRIPTIONS.put("RUNTIME_INFORMATION", DocsMessages.CATEGORY_RUNTIME_INFORMATION.get());
        CATEGORY_DESCRIPTIONS.put("SCHEMA", DocsMessages.CATEGORY_SCHEMA.get());
        CATEGORY_DESCRIPTIONS.put("SYNC", DocsMessages.CATEGORY_SYNC.get());
        CATEGORY_DESCRIPTIONS.put("TASK", DocsMessages.CATEGORY_TASK.get());
        CATEGORY_DESCRIPTIONS.put("THIRD_PARTY", DocsMessages.CATEGORY_THIRD_PARTY.get());
        CATEGORY_DESCRIPTIONS.put("TOOLS", DocsMessages.CATEGORY_TOOLS.get());
        CATEGORY_DESCRIPTIONS.put("USER_DEFINED", DocsMessages.CATEGORY_USER_DEFINED.get());
        CATEGORY_DESCRIPTIONS.put("UTIL", DocsMessages.CATEGORY_UTIL.get());
        CATEGORY_DESCRIPTIONS.put("VERSION", DocsMessages.CATEGORY_VERSION.get());
    }

    private static class MessagePropertyKey
    implements Comparable<MessagePropertyKey> {
        private String description;
        private Integer ordinal;

        public static MessagePropertyKey parseString(String key) {
            int li = key.lastIndexOf("_");
            if (li == -1) {
                throw new IllegalArgumentException("Incorrectly formatted key " + key);
            }
            String description = key.substring(0, li).toUpperCase();
            Integer ordinal = null;
            try {
                String ordString = key.substring(li + 1);
                ordinal = Integer.parseInt(ordString);
            }
            catch (Exception nfe) {
                // empty catch block
            }
            return new MessagePropertyKey(description, ordinal);
        }

        public MessagePropertyKey(String description, Integer ordinal) {
            this.description = description;
            this.ordinal = ordinal;
        }

        public Integer getOrdinal() {
            return this.ordinal;
        }

        public String toString() {
            if (this.ordinal != null) {
                return this.description + "_" + this.ordinal;
            }
            return this.description;
        }

        @Override
        public int compareTo(MessagePropertyKey k) {
            if (this.ordinal == k.ordinal) {
                return this.description.compareTo(k.description);
            }
            return this.ordinal.compareTo(k.ordinal);
        }
    }

    private static class MessageRefCategory {
        private String category;
        private TreeSet<MessageRefEntry> messages;

        MessageRefCategory(String category, TreeSet<MessageRefEntry> messages) {
            this.category = category;
            this.messages = messages;
        }

        public Map<String, Object> toMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", this.category);
            map.put("category", DocsMessages.MESSAGE_CATEGORY.get((Object)this.category));
            LinkedList<Map<String, Object>> messageEntries = new LinkedList<Map<String, Object>>();
            for (MessageRefEntry entry : this.messages) {
                messageEntries.add(entry.toMap());
            }
            map.put("entries", messageEntries);
            return map;
        }
    }

    private static class MessageRefEntry
    implements Comparable<MessageRefEntry> {
        private Integer ordinal;
        private String xmlId;
        private String formatString;

        public MessageRefEntry(String msgPropKey, Integer ordinal, String formatString) {
            this.formatString = formatString;
            this.ordinal = ordinal;
            this.xmlId = this.getXmlId(msgPropKey);
        }

        private String getXmlId(String messagePropertyKey) {
            String invalidChars = "[^A-Za-z0-9\\-_:\\.]";
            return messagePropertyKey.replaceAll("[^A-Za-z0-9\\-_:\\.]", "-");
        }

        public Map<String, Object> toMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            String id = this.ordinal != null ? this.ordinal.toString() : DocsMessages.MESSAGE_NO_ORDINAL.get().toString();
            map.put("xmlId", "log-ref-" + this.xmlId);
            map.put("id", DocsMessages.MESSAGE_ORDINAL_ID.get((Object)id));
            map.put("severity", DocsMessages.MESSAGE_SEVERITY.get((Object)DocsMessages.ERROR_SEVERITY_PRINTABLE.get()));
            map.put("message", DocsMessages.MESSAGE_MESSAGE.get((Object)this.formatString));
            return map;
        }

        @Override
        public int compareTo(MessageRefEntry mre) {
            if (this.ordinal != null && mre.ordinal != null) {
                return this.ordinal.compareTo(mre.ordinal);
            }
            return 0;
        }
    }
}

