/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.maven.doc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldif.LDIFEntryReader;
import org.forgerock.opendj.maven.doc.DocsMessages;
import org.forgerock.opendj.maven.doc.Utils;

@Mojo(name="generate-global-acis-table")
public class GenerateGlobalAcisTableMojo
extends AbstractMojo {
    @Parameter(defaultValue="en")
    private String locale;
    @Parameter(defaultValue="${basedir}/resource/config/config.ldif")
    private File configDotLdif;
    @Parameter(defaultValue="${project.build.directory}/docbkx-sources/shared")
    private File outputDirectory;
    private Map<String, String> descriptions;
    private static List<Aci> allGlobalAcis = new LinkedList<Aci>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.readAcis(this.getAciDescriptions());
        }
        catch (IOException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        File table = new File(this.outputDirectory, "table-global-acis.xml");
        try {
            Utils.writeStringToFile(this.getGlobalAcisTable(), table);
        }
        catch (IOException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private Map<String, String> getAciDescriptions() throws IOException {
        String line;
        HashMap<String, String> descriptions = new HashMap<String, String>();
        BufferedReader reader = new BufferedReader(new FileReader(this.configDotLdif));
        while ((line = reader.readLine()) != null) {
            if (!line.startsWith("# @aci ")) continue;
            String[] split = line.replace("# @aci ", "").split(":", 2);
            descriptions.put(split[0], split[1]);
        }
        return descriptions;
    }

    private void readAcis(Map<String, String> descriptions) throws IOException {
        LDIFEntryReader reader = new LDIFEntryReader((InputStream)new FileInputStream(this.configDotLdif));
        reader.setIncludeBranch(DN.valueOf((String)"cn=Access Control Handler,cn=config"));
        while (reader.hasNext()) {
            Entry entry = reader.readEntry();
            for (String attribute : entry.parseAttribute("ds-cfg-global-aci").asSetOfString(new String[0])) {
                Aci aci = new Aci();
                aci.name = this.getName(attribute);
                if (descriptions != null) {
                    aci.description = descriptions.get(aci.name);
                }
                aci.definition = attribute;
                allGlobalAcis.add(aci);
            }
        }
    }

    private String getName(String aci) {
        Pattern pattern = Pattern.compile(".+version 3.0; ?acl \"([^\"]+)\".+");
        Matcher matcher = pattern.matcher(aci);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    private String getGlobalAcisTable() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("year", new SimpleDateFormat("yyyy").format(new Date()));
        map.put("lang", this.locale);
        map.put("title", DocsMessages.DOC_GLOBAL_ACIS_TABLE_TITLE.get());
        map.put("summary", DocsMessages.DOC_GLOBAL_ACIS_TABLE_SUMMARY.get());
        map.put("nameTitle", DocsMessages.DOC_GLOBAL_ACIS_NAME_COLUMN_TITLE.get());
        map.put("descTitle", DocsMessages.DOC_GLOBAL_ACIS_DESCRIPTION_COLUMN_TITLE.get());
        map.put("defTitle", DocsMessages.DOC_GLOBAL_ACIS_DEFINITION_COLUMN_TITLE.get());
        map.put("acis", this.getDefaultGlobalAciList());
        return Utils.applyTemplate("table-global-acis.ftl", map);
    }

    private List<Map<String, Object>> getDefaultGlobalAciList() {
        LinkedList<Map<String, Object>> globalAciList = new LinkedList<Map<String, Object>>();
        for (Aci aci : allGlobalAcis) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", aci.name);
            map.put("description", aci.description);
            map.put("definition", aci.definition);
            globalAciList.add(map);
        }
        return globalAciList;
    }

    private class Aci {
        String name;
        String description;
        String definition;

        private Aci() {
        }
    }
}

