/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.maven.doc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.forgerock.opendj.maven.doc.Utils;

@Mojo(name="generate-config-ref", defaultPhase=LifecyclePhase.PRE_SITE)
public class GenerateConfigurationReferenceMojo
extends AbstractMojo {
    @Parameter(property="project", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/site/configref")
    private String outputDirectory;
    private static String[] resourceFiles = new String[]{"duration-syntax.html", "opendj-config.css", "opendj_logo_sm.png", "pageaction.gif", "tab_deselected.jpg", "tab_selected.gif"};

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.createOutputDirectory();
        this.generateConfigRef();
        try {
            this.copyResources();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to copy resource files.", (Exception)e);
        }
    }

    private void createOutputDirectory() throws MojoExecutionException {
        String projectBuildDir = this.project.getBuild().getDirectory();
        if (!this.outputDirectory.contains(projectBuildDir)) {
            String errorMsg = String.format("The outputDirectory (%s) must be under the ${project.build.directory} (%s).", this.outputDirectory, projectBuildDir);
            this.getLog().error((CharSequence)errorMsg);
            throw new MojoExecutionException(errorMsg);
        }
        try {
            Utils.createDirectory(this.outputDirectory);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)e.getMessage());
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void generateConfigRef() throws MojoExecutionException {
        String generatorClass = "org.opends.server.admin.doc.ConfigGuideGeneration";
        LinkedList<String> commands = new LinkedList<String>();
        try {
            commands.add(Utils.getJavaCommand());
            commands.add("-classpath");
            commands.add(Utils.getClassPath(Utils.getRuntimeClassLoader(this.project, this.getLog())));
            commands.add("-DGenerationDir=" + this.outputDirectory);
            commands.add(generatorClass);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to set the classpath.", e);
        }
        try {
            ProcessBuilder builder = new ProcessBuilder(commands);
            Process process = builder.start();
            process.waitFor();
            int result = process.exitValue();
            if (result != 0) {
                StringBuilder message = new StringBuilder();
                message.append("Failed to generate the config ref. Exit code: ").append(result).append(Utils.EOL).append("To debug the problem, run the following command and connect your IDE:").append(Utils.EOL);
                commands.add(1, "-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=8000");
                for (String arg : commands) {
                    message.append(arg).append(' ');
                }
                message.append(Utils.EOL);
                throw new MojoExecutionException(message.toString());
            }
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException(generatorClass + " interrupted", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException(generatorClass + " not found", (Exception)e);
        }
    }

    private void copyResources() throws IOException {
        for (String file : resourceFiles) {
            InputStream original = ((Object)((Object)this)).getClass().getResourceAsStream("/config-ref/" + file);
            File copy = new File(this.outputDirectory, file);
            Utils.copyInputStreamToFile(original, copy);
        }
    }
}

