/*
 * The contents of this file are subject to the terms of the Common Development and
 * Distribution License (the License). You may not use this file except in compliance with the
 * License.
 *
 * You can obtain a copy of the License at legal/CDDLv1.0.txt. See the License for the
 * specific language governing permission and limitations under the License.
 *
 * When distributing Covered Software, include this CDDL Header Notice in each file and include
 * the License file at legal/CDDLv1.0.txt. If applicable, add the following below the CDDL
 * Header, with the fields enclosed by brackets [] replaced by your own identifying
 * information: "Portions Copyright [year] [name of copyright owner]".
 *
 * Copyright 2010 Sun Microsystems, Inc.
 * Portions copyright 2011-2012 ForgeRock AS.
 */

package org.forgerock.opendj.ldap.requests;

import com.forgerock.opendj.util.StaticUtils;

/**
 * Unmodifiable generic bind request implementation.
 */
final class UnmodifiableGenericBindRequestImpl extends
        AbstractUnmodifiableBindRequest<GenericBindRequest> implements GenericBindRequest {
    UnmodifiableGenericBindRequestImpl(final GenericBindRequest impl) {
        super(impl);
    }

    @Override
    public byte[] getAuthenticationValue() {
        // Defensive copy.
        return StaticUtils.copyOfBytes(impl.getAuthenticationValue());
    }

    @Override
    public GenericBindRequest setAuthenticationType(final byte type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public GenericBindRequest setAuthenticationValue(final byte[] bytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public GenericBindRequest setName(final String name) {
        throw new UnsupportedOperationException();
    }
}
