/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.spi;

import java.util.LinkedList;
import java.util.List;
import org.forgerock.opendj.ldap.ConnectionEventListener;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.responses.ExtendedResult;

public final class ConnectionState {
    private volatile LdapException connectionError;
    private boolean failedDueToDisconnect;
    private final List<ConnectionEventListener> listeners = new LinkedList<ConnectionEventListener>();
    private volatile State state = State.VALID;

    public synchronized void addConnectionEventListener(ConnectionEventListener listener) {
        this.state.addConnectionEventListener(this, listener);
    }

    public LdapException getConnectionError() {
        return this.connectionError;
    }

    public boolean isClosed() {
        return this.state.isClosed();
    }

    public boolean isValid() {
        return this.state.isValid();
    }

    public synchronized boolean notifyConnectionClosed() {
        return this.state.notifyConnectionClosed(this);
    }

    public synchronized boolean notifyConnectionError(boolean isDisconnectNotification, LdapException error) {
        return this.state.notifyConnectionError(this, isDisconnectNotification, error);
    }

    public synchronized void notifyUnsolicitedNotification(ExtendedResult notification) {
        this.state.notifyUnsolicitedNotification(this, notification);
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.remove(listener);
    }

    private static enum State {
        VALID{

            @Override
            void addConnectionEventListener(ConnectionState cs, ConnectionEventListener listener) {
                cs.listeners.add(listener);
            }

            @Override
            boolean isClosed() {
                return false;
            }

            @Override
            boolean isFailed() {
                return false;
            }

            @Override
            boolean isValid() {
                return true;
            }

            @Override
            boolean notifyConnectionClosed(ConnectionState cs) {
                cs.state = 1.CLOSED;
                for (ConnectionEventListener listener : cs.listeners) {
                    listener.handleConnectionClosed();
                }
                return true;
            }

            @Override
            boolean notifyConnectionError(ConnectionState cs, boolean isDisconnectNotification, LdapException error) {
                cs.failedDueToDisconnect = isDisconnectNotification;
                cs.connectionError = error;
                cs.state = 1.ERROR;
                for (ConnectionEventListener listener : cs.listeners) {
                    listener.handleConnectionError(isDisconnectNotification, error);
                }
                return true;
            }

            @Override
            void notifyUnsolicitedNotification(ConnectionState cs, ExtendedResult notification) {
                for (ConnectionEventListener listener : cs.listeners) {
                    listener.handleUnsolicitedNotification(notification);
                }
            }
        }
        ,
        ERROR{

            @Override
            void addConnectionEventListener(ConnectionState cs, ConnectionEventListener listener) {
                listener.handleConnectionError(cs.failedDueToDisconnect, cs.connectionError);
                cs.listeners.add(listener);
            }

            @Override
            boolean isClosed() {
                return false;
            }

            @Override
            boolean isFailed() {
                return true;
            }

            @Override
            boolean isValid() {
                return false;
            }

            @Override
            boolean notifyConnectionClosed(ConnectionState cs) {
                cs.state = 2.ERROR_CLOSED;
                for (ConnectionEventListener listener : cs.listeners) {
                    listener.handleConnectionClosed();
                }
                return true;
            }
        }
        ,
        CLOSED{

            @Override
            void addConnectionEventListener(ConnectionState cs, ConnectionEventListener listener) {
                listener.handleConnectionClosed();
            }

            @Override
            boolean isClosed() {
                return true;
            }

            @Override
            boolean isFailed() {
                return false;
            }

            @Override
            boolean isValid() {
                return false;
            }
        }
        ,
        ERROR_CLOSED{

            @Override
            void addConnectionEventListener(ConnectionState cs, ConnectionEventListener listener) {
                listener.handleConnectionError(cs.failedDueToDisconnect, cs.connectionError);
                listener.handleConnectionClosed();
            }

            @Override
            boolean isClosed() {
                return true;
            }

            @Override
            boolean isFailed() {
                return true;
            }

            @Override
            boolean isValid() {
                return false;
            }
        };


        abstract void addConnectionEventListener(ConnectionState var1, ConnectionEventListener var2);

        abstract boolean isClosed();

        abstract boolean isFailed();

        abstract boolean isValid();

        boolean notifyConnectionClosed(ConnectionState cs) {
            return false;
        }

        boolean notifyConnectionError(ConnectionState cs, boolean isDisconnectNotification, LdapException error) {
            return false;
        }

        void notifyUnsolicitedNotification(ConnectionState cs, ExtendedResult notification) {
        }
    }
}

