/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import com.forgerock.opendj.ldap.CoreMessages;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.LanguageCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.io.ASN1;
import org.forgerock.opendj.io.ASN1Writer;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.requests.BindClient;
import org.forgerock.opendj.ldap.requests.BindClientImpl;
import org.forgerock.opendj.ldap.requests.SASLBindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;

class SASLBindClientImpl
extends BindClientImpl
implements CallbackHandler {
    static final String SASL_DEFAULT_PROTOCOL = "ldap";
    private final String saslMechanism;

    SASLBindClientImpl(SASLBindRequest initialBindRequest) {
        super(initialBindRequest);
        this.saslMechanism = initialBindRequest.getSASLMechanism();
    }

    @Override
    public final void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                this.handle((NameCallback)callback);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                this.handle((PasswordCallback)callback);
                continue;
            }
            if (callback instanceof AuthorizeCallback) {
                this.handle((AuthorizeCallback)callback);
                continue;
            }
            if (callback instanceof RealmCallback) {
                this.handle((RealmCallback)callback);
                continue;
            }
            if (callback instanceof RealmChoiceCallback) {
                this.handle((RealmChoiceCallback)callback);
                continue;
            }
            if (callback instanceof ChoiceCallback) {
                this.handle((ChoiceCallback)callback);
                continue;
            }
            if (callback instanceof ConfirmationCallback) {
                this.handle((ConfirmationCallback)callback);
                continue;
            }
            if (callback instanceof LanguageCallback) {
                this.handle((LanguageCallback)callback);
                continue;
            }
            if (callback instanceof TextInputCallback) {
                this.handle((TextInputCallback)callback);
                continue;
            }
            if (callback instanceof TextOutputCallback) {
                this.handle((TextOutputCallback)callback);
                continue;
            }
            LocalizableMessage message = CoreMessages.INFO_SASL_UNSUPPORTED_CALLBACK.get((Object)this.saslMechanism, (Object)String.valueOf(callback));
            throw new UnsupportedCallbackException(callback, message.toString());
        }
    }

    void handle(AuthorizeCallback callback) throws UnsupportedCallbackException {
        LocalizableMessage message = CoreMessages.INFO_SASL_UNSUPPORTED_CALLBACK.get((Object)this.saslMechanism, (Object)String.valueOf(callback));
        throw new UnsupportedCallbackException(callback, message.toString());
    }

    void handle(ChoiceCallback callback) throws UnsupportedCallbackException {
        LocalizableMessage message = CoreMessages.INFO_SASL_UNSUPPORTED_CALLBACK.get((Object)this.saslMechanism, (Object)String.valueOf(callback));
        throw new UnsupportedCallbackException(callback, message.toString());
    }

    void handle(ConfirmationCallback callback) throws UnsupportedCallbackException {
        LocalizableMessage message = CoreMessages.INFO_SASL_UNSUPPORTED_CALLBACK.get((Object)this.saslMechanism, (Object)String.valueOf(callback));
        throw new UnsupportedCallbackException(callback, message.toString());
    }

    void handle(LanguageCallback callback) throws UnsupportedCallbackException {
        LocalizableMessage message = CoreMessages.INFO_SASL_UNSUPPORTED_CALLBACK.get((Object)this.saslMechanism, (Object)String.valueOf(callback));
        throw new UnsupportedCallbackException(callback, message.toString());
    }

    void handle(NameCallback callback) throws UnsupportedCallbackException {
        LocalizableMessage message = CoreMessages.INFO_SASL_UNSUPPORTED_CALLBACK.get((Object)this.saslMechanism, (Object)String.valueOf(callback));
        throw new UnsupportedCallbackException(callback, message.toString());
    }

    void handle(PasswordCallback callback) throws UnsupportedCallbackException {
        LocalizableMessage message = CoreMessages.INFO_SASL_UNSUPPORTED_CALLBACK.get((Object)this.saslMechanism, (Object)String.valueOf(callback));
        throw new UnsupportedCallbackException(callback, message.toString());
    }

    void handle(RealmCallback callback) throws UnsupportedCallbackException {
        LocalizableMessage message = CoreMessages.INFO_SASL_UNSUPPORTED_CALLBACK.get((Object)this.saslMechanism, (Object)String.valueOf(callback));
        throw new UnsupportedCallbackException(callback, message.toString());
    }

    void handle(RealmChoiceCallback callback) throws UnsupportedCallbackException {
        LocalizableMessage message = CoreMessages.INFO_SASL_UNSUPPORTED_CALLBACK.get((Object)this.saslMechanism, (Object)String.valueOf(callback));
        throw new UnsupportedCallbackException(callback, message.toString());
    }

    void handle(TextInputCallback callback) throws UnsupportedCallbackException {
        LocalizableMessage message = CoreMessages.INFO_SASL_UNSUPPORTED_CALLBACK.get((Object)this.saslMechanism, (Object)String.valueOf(callback));
        throw new UnsupportedCallbackException(callback, message.toString());
    }

    void handle(TextOutputCallback callback) throws UnsupportedCallbackException {
        LocalizableMessage message = CoreMessages.INFO_SASL_UNSUPPORTED_CALLBACK.get((Object)this.saslMechanism, (Object)String.valueOf(callback));
        throw new UnsupportedCallbackException(callback, message.toString());
    }

    final BindClient setNextSASLCredentials(byte[] saslCredentials) {
        ByteString value = saslCredentials != null ? ByteString.wrap(saslCredentials) : null;
        return this.setNextSASLCredentials(value);
    }

    final BindClient setNextSASLCredentials(ByteString saslCredentials) {
        ByteStringBuilder builder = new ByteStringBuilder();
        ASN1Writer writer = ASN1.getWriter(builder);
        try {
            writer.writeOctetString(this.saslMechanism);
            if (saslCredentials != null) {
                writer.writeOctetString(saslCredentials);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error encoding SaslCredentials");
        }
        return this.setNextAuthenticationValue(builder.toByteString().toByteArray());
    }

    boolean evaluateSaslBindResult(SaslClient saslClient, BindResult result) throws LdapException {
        if (saslClient.isComplete()) {
            return true;
        }
        try {
            ByteString serverSASLCredentials = result.getServerSASLCredentials();
            byte[] nextResponse = saslClient.evaluateChallenge(serverSASLCredentials == null ? new byte[]{} : serverSASLCredentials.toByteArray());
            if (nextResponse == null) {
                return true;
            }
            this.setNextSASLCredentials(nextResponse);
            return false;
        }
        catch (SaslException e) {
            throw LdapException.newLdapException(ResultCode.CLIENT_SIDE_LOCAL_ERROR, (CharSequence)CoreMessages.ERR_SASL_BIND_MULTI_STAGE.get((Object)e.getLocalizedMessage()), e);
        }
    }
}

