/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ConnectionSecurityLayer;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.requests.AbstractSASLBindRequest;
import org.forgerock.opendj.ldap.requests.BindClient;
import org.forgerock.opendj.ldap.requests.DigestMD5SASLBindRequest;
import org.forgerock.opendj.ldap.requests.SASLBindClientImpl;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.util.Reject;
import org.forgerock.util.Utils;

final class DigestMD5SASLBindRequestImpl
extends AbstractSASLBindRequest<DigestMD5SASLBindRequest>
implements DigestMD5SASLBindRequest {
    private final Map<String, String> additionalAuthParams = new LinkedHashMap<String, String>();
    private String authenticationID;
    private String authorizationID;
    private String cipher;
    private Integer maxReceiveBufferSize;
    private Integer maxSendBufferSize;
    private byte[] password;
    private final List<String> qopValues = new LinkedList<String>();
    private String realm;
    private Boolean serverAuth;

    DigestMD5SASLBindRequestImpl(DigestMD5SASLBindRequest digestMD5SASLBindRequest) {
        super(digestMD5SASLBindRequest);
        this.additionalAuthParams.putAll(digestMD5SASLBindRequest.getAdditionalAuthParams());
        this.qopValues.addAll(digestMD5SASLBindRequest.getQOPs());
        this.cipher = digestMD5SASLBindRequest.getCipher();
        this.serverAuth = digestMD5SASLBindRequest.isServerAuth();
        this.maxReceiveBufferSize = digestMD5SASLBindRequest.getMaxReceiveBufferSize();
        this.maxSendBufferSize = digestMD5SASLBindRequest.getMaxSendBufferSize();
        this.authenticationID = digestMD5SASLBindRequest.getAuthenticationID();
        this.authorizationID = digestMD5SASLBindRequest.getAuthorizationID();
        this.password = StaticUtils.copyOfBytes(digestMD5SASLBindRequest.getPassword());
        this.realm = digestMD5SASLBindRequest.getRealm();
    }

    DigestMD5SASLBindRequestImpl(String authenticationID, byte[] password) {
        Reject.ifNull((Object[])new Serializable[]{authenticationID, password});
        this.authenticationID = authenticationID;
        this.password = password;
    }

    @Override
    public DigestMD5SASLBindRequest addAdditionalAuthParam(String name, String value) {
        Reject.ifNull((Object)name, (String)value);
        this.additionalAuthParams.put(name, value);
        return this;
    }

    @Override
    public DigestMD5SASLBindRequest addQOP(String ... qopValues) {
        for (String qopValue : qopValues) {
            this.qopValues.add((String)Reject.checkNotNull((Object)qopValue));
        }
        return this;
    }

    @Override
    public BindClient createBindClient(String serverName) throws LdapException {
        return new Client(this, serverName);
    }

    @Override
    public Map<String, String> getAdditionalAuthParams() {
        return this.additionalAuthParams;
    }

    @Override
    public String getAuthenticationID() {
        return this.authenticationID;
    }

    @Override
    public String getAuthorizationID() {
        return this.authorizationID;
    }

    @Override
    public String getCipher() {
        return this.cipher;
    }

    @Override
    public int getMaxReceiveBufferSize() {
        return this.maxReceiveBufferSize == null ? 65536 : this.maxReceiveBufferSize;
    }

    @Override
    public int getMaxSendBufferSize() {
        return this.maxSendBufferSize == null ? 65536 : this.maxSendBufferSize;
    }

    @Override
    public byte[] getPassword() {
        return this.password;
    }

    @Override
    public List<String> getQOPs() {
        return this.qopValues;
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    @Override
    public String getSASLMechanism() {
        return "DIGEST-MD5";
    }

    @Override
    public boolean isServerAuth() {
        return this.serverAuth == null ? false : this.serverAuth;
    }

    @Override
    public DigestMD5SASLBindRequest setAuthenticationID(String authenticationID) {
        Reject.ifNull((Object)authenticationID);
        this.authenticationID = authenticationID;
        return this;
    }

    @Override
    public DigestMD5SASLBindRequest setAuthorizationID(String authorizationID) {
        this.authorizationID = authorizationID;
        return this;
    }

    @Override
    public DigestMD5SASLBindRequest setCipher(String cipher) {
        this.cipher = cipher;
        return this;
    }

    @Override
    public DigestMD5SASLBindRequest setMaxReceiveBufferSize(int size) {
        this.maxReceiveBufferSize = size;
        return this;
    }

    @Override
    public DigestMD5SASLBindRequest setMaxSendBufferSize(int size) {
        this.maxSendBufferSize = size;
        return this;
    }

    @Override
    public DigestMD5SASLBindRequest setPassword(byte[] password) {
        Reject.ifNull((Object)password);
        this.password = password;
        return this;
    }

    @Override
    public DigestMD5SASLBindRequest setPassword(char[] password) {
        Reject.ifNull((Object)password);
        this.password = StaticUtils.getBytes(password);
        return this;
    }

    @Override
    public DigestMD5SASLBindRequest setRealm(String realm) {
        this.realm = realm;
        return this;
    }

    @Override
    public DigestMD5SASLBindRequest setServerAuth(boolean serverAuth) {
        this.serverAuth = serverAuth;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DigestMD5SASLBindRequest(bindDN=");
        builder.append(this.getName());
        builder.append(", authentication=SASL");
        builder.append(", saslMechanism=");
        builder.append(this.getSASLMechanism());
        builder.append(", authenticationID=");
        builder.append(this.authenticationID);
        builder.append(", authorizationID=");
        builder.append(this.authorizationID);
        builder.append(", realm=");
        builder.append(this.realm);
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }

    private static final class Client
    extends SASLBindClientImpl {
        private final String authenticationID;
        private final ByteString password;
        private final String realm;
        private final SaslClient saslClient;

        private Client(DigestMD5SASLBindRequestImpl initialBindRequest, String serverName) throws LdapException {
            super(initialBindRequest);
            Integer size;
            Boolean serverAuth;
            String cipher;
            this.authenticationID = initialBindRequest.getAuthenticationID();
            this.password = ByteString.wrap(initialBindRequest.getPassword());
            this.realm = initialBindRequest.getRealm();
            HashMap<String, String> props = new HashMap<String, String>();
            List<String> qopValues = initialBindRequest.getQOPs();
            if (!qopValues.isEmpty()) {
                props.put("javax.security.sasl.qop", Utils.joinAsString((String)",", qopValues));
            }
            if ((cipher = initialBindRequest.getCipher()) != null) {
                if (cipher.equalsIgnoreCase("low")) {
                    props.put("javax.security.sasl.strength", "high,medium,low");
                } else if (cipher.equalsIgnoreCase("medium")) {
                    props.put("javax.security.sasl.strength", "high,medium");
                } else if (cipher.equalsIgnoreCase("high")) {
                    props.put("javax.security.sasl.strength", "high");
                } else {
                    props.put("com.sun.security.sasl.digest.cipher", cipher);
                }
            }
            if ((serverAuth = Boolean.valueOf(initialBindRequest.isServerAuth())) != null) {
                props.put("javax.security.sasl.server.authentication", String.valueOf(serverAuth));
            }
            if ((size = Integer.valueOf(initialBindRequest.getMaxReceiveBufferSize())) != null) {
                props.put("javax.security.sasl.maxbuffer", String.valueOf(size));
            }
            if ((size = Integer.valueOf(initialBindRequest.getMaxSendBufferSize())) != null) {
                props.put("javax.security.sasl.sendmaxbuffer", String.valueOf(size));
            }
            for (Map.Entry<String, String> e : initialBindRequest.getAdditionalAuthParams().entrySet()) {
                props.put(e.getKey(), e.getValue());
            }
            try {
                this.saslClient = Sasl.createSaslClient(new String[]{"DIGEST-MD5"}, initialBindRequest.getAuthorizationID(), "ldap", serverName, props, this);
                if (this.saslClient.hasInitialResponse()) {
                    this.setNextSASLCredentials(this.saslClient.evaluateChallenge(new byte[0]));
                } else {
                    this.setNextSASLCredentials((ByteString)null);
                }
            }
            catch (SaslException e) {
                throw LdapException.newLdapException(ResultCode.CLIENT_SIDE_LOCAL_ERROR, e);
            }
        }

        @Override
        public void dispose() {
            try {
                this.saslClient.dispose();
            }
            catch (SaslException saslException) {
                // empty catch block
            }
        }

        @Override
        public boolean evaluateResult(BindResult result) throws LdapException {
            return this.evaluateSaslBindResult(this.saslClient, result);
        }

        @Override
        public ConnectionSecurityLayer getConnectionSecurityLayer() {
            String qop = (String)this.saslClient.getNegotiatedProperty("javax.security.sasl.qop");
            if (qop.equalsIgnoreCase("auth-int") || qop.equalsIgnoreCase("auth-conf")) {
                return this;
            }
            return null;
        }

        @Override
        public byte[] unwrap(byte[] incoming, int offset, int len) throws LdapException {
            try {
                return this.saslClient.unwrap(incoming, offset, len);
            }
            catch (SaslException e) {
                LocalizableMessage msg = CoreMessages.ERR_SASL_PROTOCOL_ERROR.get((Object)"DIGEST-MD5", (Object)StaticUtils.getExceptionMessage(e));
                throw LdapException.newLdapException(ResultCode.CLIENT_SIDE_DECODING_ERROR, msg.toString(), e);
            }
        }

        @Override
        public byte[] wrap(byte[] outgoing, int offset, int len) throws LdapException {
            try {
                return this.saslClient.wrap(outgoing, offset, len);
            }
            catch (SaslException e) {
                LocalizableMessage msg = CoreMessages.ERR_SASL_PROTOCOL_ERROR.get((Object)"DIGEST-MD5", (Object)StaticUtils.getExceptionMessage(e));
                throw LdapException.newLdapException(ResultCode.CLIENT_SIDE_ENCODING_ERROR, msg.toString(), e);
            }
        }

        @Override
        void handle(NameCallback callback) throws UnsupportedCallbackException {
            callback.setName(this.authenticationID);
        }

        @Override
        void handle(PasswordCallback callback) throws UnsupportedCallbackException {
            callback.setPassword(this.password.toString().toCharArray());
        }

        @Override
        void handle(RealmCallback callback) throws UnsupportedCallbackException {
            callback.setText(this.realm != null ? this.realm : callback.getDefaultText());
        }
    }
}

