/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.CoreMessages;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.ldap.AVA;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.InetAddressValidator;
import org.forgerock.opendj.ldap.RDN;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.util.Reject;

public final class TrustManagers {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();

    public static X509TrustManager checkHostName(String hostName, X509TrustManager trustManager) {
        Reject.ifNull((Object)trustManager, (String)hostName);
        return new CheckHostName(trustManager, hostName);
    }

    public static X509TrustManager checkUsingTrustStore(String file) throws GeneralSecurityException, IOException {
        return TrustManagers.checkUsingTrustStore(file, null, null);
    }

    public static X509TrustManager checkUsingTrustStore(String file, char[] password, String format) throws GeneralSecurityException, IOException {
        Reject.ifNull((Object)file);
        File trustStoreFile = new File(file);
        String trustStoreFormat = format != null ? format : KeyStore.getDefaultType();
        KeyStore keyStore = KeyStore.getInstance(trustStoreFormat);
        TrustManager[] trustManagerArray = null;
        try (FileInputStream fos = new FileInputStream(trustStoreFile);){
            keyStore.load(fos, password);
        }
        catch (Throwable object) {
            trustManagerArray = object;
            throw object;
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(keyStore);
        for (TrustManager tm : tmf.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            return (X509TrustManager)tm;
        }
        throw new NoSuchAlgorithmException();
    }

    public static X509TrustManager checkValidityDates(X509TrustManager trustManager) {
        Reject.ifNull((Object)trustManager);
        return new CheckValidityDates(trustManager);
    }

    public static X509TrustManager distrustAll() {
        return DistrustAll.INSTANCE;
    }

    public static X509TrustManager trustAll() {
        return TrustAll.INSTANCE;
    }

    private TrustManagers() {
    }

    private static final class TrustAll
    implements X509TrustManager {
        private static final TrustAll INSTANCE = new TrustAll();

        private TrustAll() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    private static final class DistrustAll
    implements X509TrustManager {
        private static final DistrustAll INSTANCE = new DistrustAll();

        private DistrustAll() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new CertificateException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new CertificateException();
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    private static final class CheckValidityDates
    implements X509TrustManager {
        private final X509TrustManager trustManager;

        private CheckValidityDates(X509TrustManager trustManager) {
            this.trustManager = trustManager;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.verifyExpiration(chain);
            this.trustManager.checkClientTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.verifyExpiration(chain);
            this.trustManager.checkServerTrusted(chain, authType);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.trustManager.getAcceptedIssuers();
        }

        private void verifyExpiration(X509Certificate[] chain) throws CertificateException {
            Date currentDate = new Date();
            for (X509Certificate c : chain) {
                try {
                    c.checkValidity(currentDate);
                }
                catch (CertificateExpiredException e) {
                    logger.warn(LocalizableMessage.raw((CharSequence)"Refusing to trust security certificate '%s' because it expired on %s", (Object[])new Object[]{c.getSubjectDN().getName(), c.getNotAfter()}));
                    throw e;
                }
                catch (CertificateNotYetValidException e) {
                    logger.warn(LocalizableMessage.raw((CharSequence)"Refusing to trust security  certificate '%s' because it is not valid until %s", (Object[])new Object[]{c.getSubjectDN().getName(), c.getNotBefore()}));
                    throw e;
                }
            }
        }
    }

    private static final class CheckHostName
    implements X509TrustManager {
        private final X509TrustManager trustManager;
        private final String hostName;

        private CheckHostName(X509TrustManager trustManager, String hostName) {
            this.trustManager = trustManager;
            this.hostName = hostName;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.verifyHostName(chain);
            this.trustManager.checkClientTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.verifyHostName(chain);
            this.trustManager.checkServerTrusted(chain, authType);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.trustManager.getAcceptedIssuers();
        }

        private void verifyHostName(X509Certificate[] chain) throws CertificateException {
            X500Principal principal = chain[0].getSubjectX500Principal();
            try {
                ArrayList<String> dnsNamePatterns = new ArrayList<String>(0);
                ArrayList<String> ipAddresses = new ArrayList<String>(0);
                ArrayList<Object> allOthers = new ArrayList<Object>(0);
                this.getSanGeneralNames(chain[0], dnsNamePatterns, ipAddresses, allOthers);
                boolean sanIsCritical = this.getSanCriticality(chain[0]);
                InetAddress hostAddress = CheckHostName.toIpAddress(this.hostName);
                if (hostAddress != null ? this.verifyIpAddresses(hostAddress, ipAddresses, principal, sanIsCritical) : this.verifyDnsNamePatterns(this.hostName, dnsNamePatterns, principal, sanIsCritical)) {
                    return;
                }
                if (!allOthers.isEmpty() && sanIsCritical) {
                    throw new CertificateException(CoreMessages.ERR_CERT_NO_MATCH_ALLOTHERS.get((Object)principal, (Object)this.hostName).toString());
                }
                DN dn = DN.valueOf(principal.getName(), Schema.getCoreSchema());
                String certSubjectHostName = this.getLowestCommonName(dn);
                if (this.hostNameMatchesPattern(this.hostName, certSubjectHostName)) {
                    return;
                }
                throw new CertificateException(CoreMessages.ERR_CERT_NO_MATCH_SUBJECT.get((Object)principal, (Object)this.hostName).toString());
            }
            catch (CertificateException e) {
                logger.warn(LocalizableMessage.raw((CharSequence)"Certificate verification problem for: %s", (Object[])new Object[]{principal}), (Throwable)e);
                throw e;
            }
        }

        private void getSanGeneralNames(X509Certificate subject, List<String> dnsNames, List<String> ipAddresses, List<Object> allOthers) {
            try {
                Collection<List<?>> sans = subject.getSubjectAlternativeNames();
                if (sans == null) {
                    return;
                }
                block6: for (List<?> san : sans) {
                    switch ((Integer)san.get(0)) {
                        case 2: {
                            dnsNames.add((String)san.get(1));
                            continue block6;
                        }
                        case 7: {
                            ipAddresses.add((String)san.get(1));
                            continue block6;
                        }
                    }
                    allOthers.add(san.get(1));
                }
            }
            catch (CertificateParsingException certificateParsingException) {
                // empty catch block
            }
        }

        private boolean getSanCriticality(X509Certificate subject) {
            Set<String> critSet = subject.getCriticalExtensionOIDs();
            return critSet != null && critSet.contains("2.5.29.17");
        }

        private static InetAddress toIpAddress(String hostName) {
            try {
                if (InetAddressValidator.isValid(hostName)) {
                    return InetAddress.getByName(hostName);
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            return null;
        }

        private boolean verifyIpAddresses(InetAddress hostAddress, List<String> ipAddresses, X500Principal principal, boolean failureIsCritical) throws CertificateException {
            if (!ipAddresses.isEmpty()) {
                for (String address : ipAddresses) {
                    try {
                        if (!InetAddress.getByName(address).equals(hostAddress)) continue;
                        return true;
                    }
                    catch (UnknownHostException unknownHostException) {
                    }
                }
                if (failureIsCritical) {
                    throw new CertificateException(CoreMessages.ERR_CERT_NO_MATCH_IP.get((Object)principal, (Object)this.hostName).toString());
                }
            }
            return false;
        }

        private boolean verifyDnsNamePatterns(String hostName, List<String> dnsNamePatterns, X500Principal principal, boolean failureIsCritical) throws CertificateException {
            for (String namePattern : dnsNamePatterns) {
                if (!this.hostNameMatchesPattern(hostName, namePattern)) continue;
                return true;
            }
            if (failureIsCritical) {
                throw new CertificateException(CoreMessages.ERR_CERT_NO_MATCH_DNS.get((Object)principal, (Object)hostName).toString());
            }
            return false;
        }

        private boolean hostNameMatchesPattern(String hostName, String pattern) {
            String[] patternElements;
            String[] nameElements = hostName.split("\\.");
            boolean hostMatch = nameElements.length == (patternElements = pattern.split("\\.")).length;
            for (int i = 0; i < nameElements.length && hostMatch; ++i) {
                String ne = nameElements[i];
                String pe = patternElements[i];
                if (pe.equals("*")) continue;
                hostMatch = ne.equalsIgnoreCase(pe);
            }
            return hostMatch;
        }

        private String getLowestCommonName(DN subject) {
            AttributeType cn = Schema.getDefaultSchema().getAttributeType("cn");
            for (RDN rdn : subject) {
                for (AVA ava : rdn) {
                    if (!ava.getAttributeType().equals(cn)) continue;
                    return ava.getAttributeValue().toString();
                }
            }
            return null;
        }
    }
}

