/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import org.forgerock.opendj.ldap.AbstractConnection;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.Result;

public abstract class AbstractAsynchronousConnection
extends AbstractConnection {
    protected AbstractAsynchronousConnection() {
    }

    @Override
    public Result add(AddRequest request) throws LdapException {
        return this.blockingGetOrThrow(this.addAsync(request));
    }

    @Override
    public BindResult bind(BindRequest request) throws LdapException {
        return this.blockingGetOrThrow(this.bindAsync(request));
    }

    @Override
    public CompareResult compare(CompareRequest request) throws LdapException {
        return this.blockingGetOrThrow(this.compareAsync(request));
    }

    @Override
    public Result delete(DeleteRequest request) throws LdapException {
        return this.blockingGetOrThrow(this.deleteAsync(request));
    }

    @Override
    public <R extends ExtendedResult> R extendedRequest(ExtendedRequest<R> request, IntermediateResponseHandler handler) throws LdapException {
        return (R)((ExtendedResult)this.blockingGetOrThrow(this.extendedRequestAsync(request, handler)));
    }

    @Override
    public Result modify(ModifyRequest request) throws LdapException {
        return this.blockingGetOrThrow(this.modifyAsync(request));
    }

    @Override
    public Result modifyDN(ModifyDNRequest request) throws LdapException {
        return this.blockingGetOrThrow(this.modifyDNAsync(request));
    }

    @Override
    public Result search(SearchRequest request, SearchResultHandler handler) throws LdapException {
        return this.blockingGetOrThrow(this.searchAsync(request, handler));
    }

    private <T extends Result> T blockingGetOrThrow(LdapPromise<T> promise) throws LdapException {
        try {
            return (T)((Result)promise.getOrThrow());
        }
        catch (InterruptedException e) {
            throw this.interrupted(e);
        }
    }

    private LdapException interrupted(InterruptedException e) {
        return LdapException.newLdapException(ResultCode.CLIENT_SIDE_USER_CANCELLED, e);
    }
}

