/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.io;

import java.io.IOException;
import java.util.List;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.io.ASN1Writer;
import org.forgerock.opendj.io.LDAP;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.LinkedAttribute;
import org.forgerock.opendj.ldap.LinkedHashMapEntry;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.requests.AbandonRequest;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.GenericBindRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.UnbindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.IntermediateResponse;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;

public final class LDAPWriter<W extends ASN1Writer> {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private final W writer;
    private final int protocolVersion;

    LDAPWriter(W asn1Writer, int ldapVersion) {
        this.writer = asn1Writer;
        this.protocolVersion = ldapVersion;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public W getASN1Writer() {
        return this.writer;
    }

    public void writeAbandonRequest(int messageID, AbandonRequest request) throws IOException {
        logger.trace("ENCODE LDAP ABANDON REQUEST(messageID=%d, request=%s)", (Object)messageID, (Object)request);
        this.writeMessageHeader(messageID);
        this.writer.writeInteger((byte)80, request.getRequestID());
        this.writeMessageFooter(request.getControls());
    }

    public void writeAddRequest(int messageID, AddRequest request) throws IOException {
        logger.trace("ENCODE LDAP ADD REQUEST(messageID=%d, request=%s)", (Object)messageID, (Object)request);
        this.writeMessageHeader(messageID);
        LDAP.writeEntry(this.writer, (byte)104, this.adaptEntry(request));
        this.writeMessageFooter(request.getControls());
    }

    private Entry adaptEntry(Entry entry) {
        if (this.protocolVersion >= 3) {
            return entry;
        }
        LinkedHashMapEntry v2entry = new LinkedHashMapEntry(entry.getName());
        for (Attribute attribute : entry.getAllAttributes()) {
            v2entry.addAttribute(new LinkedAttribute(attribute.getAttributeDescription().withoutAnyOptions(), attribute));
        }
        return v2entry;
    }

    public void writeAddResult(int messageID, Result result) throws IOException {
        logger.trace("ENCODE LDAP ADD RESULT(messageID=%d, result=%s)", (Object)messageID, (Object)result);
        this.writeMessageHeader(messageID);
        this.writeResultHeader((byte)105, result);
        this.writeResultFooter((ASN1Writer)this.writer);
        this.writeMessageFooter(result.getControls());
    }

    public void writeBindRequest(int messageID, int version, GenericBindRequest request) throws IOException {
        logger.trace("ENCODE LDAP BIND REQUEST(messageID=%d, auth=0x%x, request=%s)", (Object)messageID, (Object)request.getAuthenticationType(), (Object)request);
        this.writeMessageHeader(messageID);
        this.writer.writeStartSequence((byte)96);
        this.writer.writeInteger(version);
        this.writer.writeOctetString(request.getName());
        this.writer.writeOctetString(request.getAuthenticationType(), request.getAuthenticationValue());
        this.writer.writeEndSequence();
        this.writeMessageFooter(request.getControls());
    }

    public void writeBindResult(int messageID, BindResult result) throws IOException {
        logger.trace("ENCODE LDAP BIND RESULT(messageID=%d, result=%s)", (Object)messageID, (Object)result);
        this.writeMessageHeader(messageID);
        this.writeResultHeader((byte)97, result);
        ByteString saslCredentials = result.getServerSASLCredentials();
        if (saslCredentials != null && saslCredentials.length() > 0) {
            this.writer.writeOctetString((byte)-121, result.getServerSASLCredentials());
        }
        this.writeResultFooter((ASN1Writer)this.writer);
        this.writeMessageFooter(result.getControls());
    }

    public void writeCompareRequest(int messageID, CompareRequest request) throws IOException {
        logger.trace("ENCODE LDAP COMPARE REQUEST(messageID=%d, request=%s)", (Object)messageID, (Object)request);
        this.writeMessageHeader(messageID);
        this.writer.writeStartSequence((byte)110);
        this.writer.writeOctetString(request.getName().toString());
        this.writer.writeStartSequence();
        this.writer.writeOctetString(request.getAttributeDescription().toString());
        this.writer.writeOctetString(request.getAssertionValue());
        this.writer.writeEndSequence();
        this.writer.writeEndSequence();
        this.writeMessageFooter(request.getControls());
    }

    public void writeCompareResult(int messageID, CompareResult result) throws IOException {
        logger.trace("ENCODE LDAP COMPARE RESULT(messageID=%d, result=%s)", (Object)messageID, (Object)result);
        this.writeMessageHeader(messageID);
        this.writeResultHeader((byte)111, result);
        this.writeResultFooter((ASN1Writer)this.writer);
        this.writeMessageFooter(result.getControls());
    }

    public void writeControl(Control control) throws IOException {
        this.writer.writeStartSequence();
        this.writer.writeOctetString(control.getOID());
        if (control.isCritical()) {
            this.writer.writeBoolean(control.isCritical());
        }
        if (control.getValue() != null) {
            this.writer.writeOctetString(control.getValue());
        }
        this.writer.writeEndSequence();
    }

    public void writeDeleteRequest(int messageID, DeleteRequest request) throws IOException {
        logger.trace("ENCODE LDAP DELETE REQUEST(messageID=%d, request=%s)", (Object)messageID, (Object)request);
        this.writeMessageHeader(messageID);
        this.writer.writeOctetString((byte)74, request.getName().toString());
        this.writeMessageFooter(request.getControls());
    }

    public void writeDeleteResult(int messageID, Result result) throws IOException {
        logger.trace("ENCODE LDAP DELETE RESULT(messageID=%d, result=%s)", (Object)messageID, (Object)result);
        this.writeMessageHeader(messageID);
        this.writeResultHeader((byte)107, result);
        this.writeResultFooter((ASN1Writer)this.writer);
        this.writeMessageFooter(result.getControls());
    }

    public void writeExtendedRequest(int messageID, ExtendedRequest<?> request) throws IOException {
        logger.trace("ENCODE LDAP EXTENDED REQUEST(messageID=%d, request=%s)", (Object)messageID, request);
        this.writeMessageHeader(messageID);
        this.writer.writeStartSequence((byte)119);
        this.writer.writeOctetString((byte)-128, request.getOID());
        ByteString requestValue = request.getValue();
        if (requestValue != null) {
            this.writer.writeOctetString((byte)-127, requestValue);
        }
        this.writer.writeEndSequence();
        this.writeMessageFooter(request.getControls());
    }

    public void writeExtendedResult(int messageID, ExtendedResult result) throws IOException {
        ByteString responseValue;
        logger.trace("ENCODE LDAP EXTENDED RESULT(messageID=%d, result=%s)", (Object)messageID, (Object)result);
        this.writeMessageHeader(messageID);
        this.writeResultHeader((byte)120, result);
        String responseName = result.getOID();
        if (responseName != null) {
            this.writer.writeOctetString((byte)-118, responseName);
        }
        if ((responseValue = result.getValue()) != null) {
            this.writer.writeOctetString((byte)-117, responseValue);
        }
        this.writeResultFooter((ASN1Writer)this.writer);
        this.writeMessageFooter(result.getControls());
    }

    public void writeIntermediateResponse(int messageID, IntermediateResponse response) throws IOException {
        ByteString responseValue;
        logger.trace("ENCODE LDAP INTERMEDIATE RESPONSE(messageID=%d, response=%s)", (Object)messageID, (Object)response);
        this.writeMessageHeader(messageID);
        this.writer.writeStartSequence((byte)121);
        String responseName = response.getOID();
        if (responseName != null) {
            this.writer.writeOctetString((byte)-128, response.getOID());
        }
        if ((responseValue = response.getValue()) != null) {
            this.writer.writeOctetString((byte)-127, response.getValue());
        }
        this.writer.writeEndSequence();
        this.writeMessageFooter(response.getControls());
    }

    public void writeModifyDNRequest(int messageID, ModifyDNRequest request) throws IOException {
        logger.trace("ENCODE LDAP MODIFY DN REQUEST(messageID=%d, request=%s)", (Object)messageID, (Object)request);
        this.writeMessageHeader(messageID);
        this.writer.writeStartSequence((byte)108);
        this.writer.writeOctetString(request.getName().toString());
        this.writer.writeOctetString(request.getNewRDN().toString());
        this.writer.writeBoolean(request.isDeleteOldRDN());
        DN newSuperior = request.getNewSuperior();
        if (newSuperior != null) {
            this.writer.writeOctetString((byte)-128, newSuperior.toString());
        }
        this.writer.writeEndSequence();
        this.writeMessageFooter(request.getControls());
    }

    public void writeModifyDNResult(int messageID, Result result) throws IOException {
        logger.trace("ENCODE LDAP MODIFY DN RESULT(messageID=%d, result=%s)", (Object)messageID, (Object)result);
        this.writeMessageHeader(messageID);
        this.writeResultHeader((byte)109, result);
        this.writeResultFooter((ASN1Writer)this.writer);
        this.writeMessageFooter(result.getControls());
    }

    public void writeModifyRequest(int messageID, ModifyRequest request) throws IOException {
        logger.trace("ENCODE LDAP MODIFY REQUEST(messageID=%d, request=%s)", (Object)messageID, (Object)request);
        this.writeMessageHeader(messageID);
        this.writer.writeStartSequence((byte)102);
        this.writer.writeOctetString(request.getName().toString());
        this.writer.writeStartSequence();
        for (Modification change : request.getModifications()) {
            this.writeChange(change);
        }
        this.writer.writeEndSequence();
        this.writer.writeEndSequence();
        this.writeMessageFooter(request.getControls());
    }

    public void writeModifyResult(int messageID, Result result) throws IOException {
        logger.trace("ENCODE LDAP MODIFY RESULT(messageID=%d, result=%s)", (Object)messageID, (Object)result);
        this.writeMessageHeader(messageID);
        this.writeResultHeader((byte)103, result);
        this.writeResultFooter((ASN1Writer)this.writer);
        this.writeMessageFooter(result.getControls());
    }

    public void writeSearchRequest(int messageID, SearchRequest request) throws IOException {
        logger.trace("ENCODE LDAP SEARCH REQUEST(messageID=%d, request=%s)", (Object)messageID, (Object)request);
        this.writeMessageHeader(messageID);
        this.writer.writeStartSequence((byte)99);
        this.writer.writeOctetString(request.getName().toString());
        this.writer.writeEnumerated(request.getScope().intValue());
        this.writer.writeEnumerated(request.getDereferenceAliasesPolicy().intValue());
        this.writer.writeInteger(request.getSizeLimit());
        this.writer.writeInteger(request.getTimeLimit());
        this.writer.writeBoolean(request.isTypesOnly());
        LDAP.writeFilter(this.writer, request.getFilter());
        this.writer.writeStartSequence();
        for (String attribute : request.getAttributes()) {
            this.writer.writeOctetString(attribute);
        }
        this.writer.writeEndSequence();
        this.writer.writeEndSequence();
        this.writeMessageFooter(request.getControls());
    }

    public void writeSearchResult(int messageID, Result result) throws IOException {
        logger.trace("ENCODE LDAP SEARCH RESULT(messageID=%d, result=%s)", (Object)messageID, (Object)result);
        this.writeMessageHeader(messageID);
        this.writeResultHeader((byte)101, result);
        this.writeResultFooter((ASN1Writer)this.writer);
        this.writeMessageFooter(result.getControls());
    }

    public void writeSearchResultEntry(int messageID, SearchResultEntry entry) throws IOException {
        logger.trace("ENCODE LDAP SEARCH RESULT ENTRY(messageID=%d, entry=%s)", (Object)messageID, (Object)entry);
        this.writeMessageHeader(messageID);
        LDAP.writeEntry(this.writer, (byte)100, this.adaptEntry(entry));
        this.writeMessageFooter(entry.getControls());
    }

    public void writeSearchResultReference(int messageID, SearchResultReference reference) throws IOException {
        if (this.protocolVersion <= 2) {
            return;
        }
        logger.trace("ENCODE LDAP SEARCH RESULT REFERENCE(messageID=%d, reference=%s)", (Object)messageID, (Object)reference);
        this.writeMessageHeader(messageID);
        this.writer.writeStartSequence((byte)115);
        for (String url : reference.getURIs()) {
            this.writer.writeOctetString(url);
        }
        this.writer.writeEndSequence();
        this.writeMessageFooter(reference.getControls());
    }

    public void writeUnbindRequest(int messageID, UnbindRequest request) throws IOException {
        logger.trace("ENCODE LDAP UNBIND REQUEST(messageID=%d, request=%s)", (Object)messageID, (Object)request);
        this.writeMessageHeader(messageID);
        this.writer.writeNull((byte)66);
        this.writeMessageFooter(request.getControls());
    }

    public void writeUnrecognizedMessage(int messageID, byte messageTag, ByteString messageBytes) throws IOException {
        logger.trace("ENCODE LDAP UNKNOWN MESSAGE(messageID=%d, messageTag=%x, messageBytes=%s)", (Object)messageID, (Object)messageTag, (Object)messageBytes);
        this.writeMessageHeader(messageID);
        this.writer.writeOctetString(messageTag, messageBytes);
        this.writer.writeEndSequence();
    }

    private void writeChange(Modification change) throws IOException {
        this.writer.writeStartSequence();
        this.writer.writeEnumerated(change.getModificationType().intValue());
        LDAP.writeAttribute(this.writer, change.getAttribute());
        this.writer.writeEndSequence();
    }

    private void writeMessageFooter(List<Control> controls) throws IOException {
        if (!controls.isEmpty() && this.protocolVersion >= 3) {
            this.writer.writeStartSequence((byte)-96);
            for (Control control : controls) {
                this.writeControl(control);
            }
            this.writer.writeEndSequence();
        }
        this.writer.writeEndSequence();
    }

    private void writeMessageHeader(int messageID) throws IOException {
        this.writer.writeStartSequence();
        this.writer.writeInteger(messageID);
    }

    private void writeResultFooter(ASN1Writer writer) throws IOException {
        writer.writeEndSequence();
    }

    private void writeResultHeader(byte typeTag, Result rawMessage) throws IOException {
        List<String> referralURIs;
        this.writer.writeStartSequence(typeTag);
        this.writer.writeEnumerated(rawMessage.getResultCode().intValue());
        this.writer.writeOctetString(rawMessage.getMatchedDN());
        this.writer.writeOctetString(rawMessage.getDiagnosticMessage());
        if (this.protocolVersion >= 3 && !(referralURIs = rawMessage.getReferralURIs()).isEmpty()) {
            this.writer.writeStartSequence((byte)-93);
            for (String s : referralURIs) {
                this.writer.writeOctetString(s);
            }
            this.writer.writeEndSequence();
        }
    }
}

