/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.io;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.io.ASN1Reader;
import org.forgerock.opendj.io.ASN1Writer;
import org.forgerock.opendj.io.LDAPReader;
import org.forgerock.opendj.io.LDAPWriter;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.FilterVisitor;
import org.forgerock.opendj.ldap.schema.Schema;

public final class LDAP {
    public static final String OID_GSSAPI_KERBEROS_V = "1.2.840.113554.1.2.2";
    public static final String OID_NOTICE_OF_DISCONNECTION = "1.3.6.1.4.1.1466.20036";
    public static final byte OP_TYPE_ABANDON_REQUEST = 80;
    public static final byte OP_TYPE_ADD_REQUEST = 104;
    public static final byte OP_TYPE_ADD_RESPONSE = 105;
    public static final byte OP_TYPE_BIND_REQUEST = 96;
    public static final byte OP_TYPE_BIND_RESPONSE = 97;
    public static final byte OP_TYPE_COMPARE_REQUEST = 110;
    public static final byte OP_TYPE_COMPARE_RESPONSE = 111;
    public static final byte OP_TYPE_DELETE_REQUEST = 74;
    public static final byte OP_TYPE_DELETE_RESPONSE = 107;
    public static final byte OP_TYPE_EXTENDED_REQUEST = 119;
    public static final byte OP_TYPE_EXTENDED_RESPONSE = 120;
    public static final byte OP_TYPE_INTERMEDIATE_RESPONSE = 121;
    public static final byte OP_TYPE_MODIFY_DN_REQUEST = 108;
    public static final byte OP_TYPE_MODIFY_DN_RESPONSE = 109;
    public static final byte OP_TYPE_MODIFY_REQUEST = 102;
    public static final byte OP_TYPE_MODIFY_RESPONSE = 103;
    public static final byte OP_TYPE_SEARCH_REQUEST = 99;
    public static final byte OP_TYPE_SEARCH_RESULT_DONE = 101;
    public static final byte OP_TYPE_SEARCH_RESULT_ENTRY = 100;
    public static final byte OP_TYPE_SEARCH_RESULT_REFERENCE = 115;
    public static final byte OP_TYPE_UNBIND_REQUEST = 66;
    public static final byte[] OP_TO_RESULT_TYPE = new byte[255];
    public static final byte TYPE_AUTHENTICATION_SASL = -93;
    public static final byte TYPE_AUTHENTICATION_SIMPLE = -128;
    public static final byte TYPE_CONTROL_SEQUENCE = -96;
    public static final byte TYPE_EXTENDED_REQUEST_OID = -128;
    public static final byte TYPE_EXTENDED_REQUEST_VALUE = -127;
    public static final byte TYPE_EXTENDED_RESPONSE_OID = -118;
    public static final byte TYPE_EXTENDED_RESPONSE_VALUE = -117;
    public static final byte TYPE_FILTER_AND = -96;
    public static final byte TYPE_FILTER_APPROXIMATE = -88;
    public static final byte TYPE_FILTER_EQUALITY = -93;
    public static final byte TYPE_FILTER_EXTENSIBLE_MATCH = -87;
    public static final byte TYPE_FILTER_GREATER_OR_EQUAL = -91;
    public static final byte TYPE_FILTER_LESS_OR_EQUAL = -90;
    public static final byte TYPE_FILTER_NOT = -94;
    public static final byte TYPE_FILTER_OR = -95;
    public static final byte TYPE_FILTER_PRESENCE = -121;
    public static final byte TYPE_FILTER_SUBSTRING = -92;
    public static final byte TYPE_INTERMEDIATE_RESPONSE_OID = -128;
    public static final byte TYPE_INTERMEDIATE_RESPONSE_VALUE = -127;
    public static final byte TYPE_MATCHING_RULE_DN_ATTRIBUTES = -124;
    public static final byte TYPE_MATCHING_RULE_ID = -127;
    public static final byte TYPE_MATCHING_RULE_TYPE = -126;
    public static final byte TYPE_MATCHING_RULE_VALUE = -125;
    public static final byte TYPE_MODIFY_DN_NEW_SUPERIOR = -128;
    public static final byte TYPE_REFERRAL_SEQUENCE = -93;
    public static final byte TYPE_SERVER_SASL_CREDENTIALS = -121;
    public static final byte TYPE_SUBANY = -127;
    public static final byte TYPE_SUBFINAL = -126;
    public static final byte TYPE_SUBINITIAL = -128;
    private static final FilterVisitor<IOException, ASN1Writer> ASN1_ENCODER;

    public static <R extends ASN1Reader> LDAPReader<R> getReader(R asn1Reader, DecodeOptions options) {
        return new LDAPReader<R>(asn1Reader, options);
    }

    public static <W extends ASN1Writer> LDAPWriter<W> getWriter(W asn1Writer, int ldapVersion) {
        return new LDAPWriter<W>(asn1Writer, ldapVersion);
    }

    public static Filter readFilter(ASN1Reader reader) throws IOException {
        byte type = reader.peekType();
        switch (type) {
            case -96: {
                return LDAP.readAndFilter(reader);
            }
            case -95: {
                return LDAP.readOrFilter(reader);
            }
            case -94: {
                return LDAP.readNotFilter(reader);
            }
            case -93: {
                return LDAP.readEqualityMatchFilter(reader);
            }
            case -91: {
                return LDAP.readGreaterOrEqualMatchFilter(reader);
            }
            case -90: {
                return LDAP.readLessOrEqualMatchFilter(reader);
            }
            case -88: {
                return LDAP.readApproxMatchFilter(reader);
            }
            case -92: {
                return LDAP.readSubstringsFilter(reader);
            }
            case -121: {
                return Filter.present(reader.readOctetStringAsString(type));
            }
            case -87: {
                return LDAP.readExtensibleMatchFilter(reader);
            }
        }
        return Filter.unrecognized(type, reader.readOctetString(type));
    }

    public static Entry readEntry(ASN1Reader reader, DecodeOptions options) throws IOException {
        return LDAP.readEntry(reader, (byte)100, options);
    }

    public static void writeFilter(ASN1Writer writer, Filter filter) throws IOException {
        IOException e = filter.accept(ASN1_ENCODER, writer);
        if (e != null) {
            throw e;
        }
    }

    public static void writeEntry(ASN1Writer writer, Entry entry) throws IOException {
        LDAP.writeEntry(writer, (byte)100, entry);
    }

    static AttributeDescription readAttributeDescription(String attributeDescription, Schema schema) throws DecodeException {
        try {
            return AttributeDescription.valueOf(attributeDescription, schema);
        }
        catch (LocalizedIllegalArgumentException e) {
            throw DecodeException.error(e.getMessageObject());
        }
    }

    static DN readDN(String dn, Schema schema) throws DecodeException {
        try {
            return DN.valueOf(dn, schema);
        }
        catch (LocalizedIllegalArgumentException e) {
            throw DecodeException.error(e.getMessageObject());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Entry readEntry(ASN1Reader reader, byte tagType, DecodeOptions options) throws DecodeException, IOException {
        Entry entry;
        reader.readStartSequence(tagType);
        try {
            String dnString = reader.readOctetStringAsString();
            Schema schema = options.getSchemaResolver().resolveSchema(dnString);
            DN dn = LDAP.readDN(dnString, schema);
            entry = options.getEntryFactory().newEntry(dn);
            reader.readStartSequence();
            try {
                while (reader.hasNextElement()) {
                    reader.readStartSequence();
                    try {
                        String ads = reader.readOctetStringAsString();
                        AttributeDescription ad = LDAP.readAttributeDescription(ads, schema);
                        Attribute attribute = options.getAttributeFactory().newAttribute(ad);
                        reader.readStartSet();
                        try {
                            while (reader.hasNextElement()) {
                                attribute.add(reader.readOctetString());
                            }
                            entry.addAttribute(attribute);
                        }
                        finally {
                            reader.readEndSet();
                        }
                    }
                    finally {
                        reader.readEndSequence();
                    }
                }
            }
            finally {
                reader.readEndSequence();
            }
        }
        finally {
            reader.readEndSequence();
        }
        return entry;
    }

    static void writeAttribute(ASN1Writer writer, Attribute attribute) throws IOException {
        writer.writeStartSequence();
        writer.writeOctetString(attribute.getAttributeDescriptionAsString());
        writer.writeStartSet();
        for (ByteString value : attribute) {
            writer.writeOctetString(value);
        }
        writer.writeEndSet();
        writer.writeEndSequence();
    }

    static void writeEntry(ASN1Writer writer, byte typeTag, Entry entry) throws IOException {
        writer.writeStartSequence(typeTag);
        writer.writeOctetString(entry.getName().toString());
        writer.writeStartSequence();
        for (Attribute attr : entry.getAllAttributes()) {
            LDAP.writeAttribute(writer, attr);
        }
        writer.writeEndSequence();
        writer.writeEndSequence();
    }

    private static Filter readAndFilter(ASN1Reader reader) throws IOException {
        reader.readStartSequence((byte)-96);
        try {
            if (reader.hasNextElement()) {
                LinkedList<Filter> subFilters = new LinkedList<Filter>();
                do {
                    subFilters.add(LDAP.readFilter(reader));
                } while (reader.hasNextElement());
                Filter filter = Filter.and(subFilters);
                return filter;
            }
            Filter filter = Filter.alwaysTrue();
            return filter;
        }
        finally {
            reader.readEndSequence();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Filter readApproxMatchFilter(ASN1Reader reader) throws IOException {
        reader.readStartSequence((byte)-88);
        try {
            String attributeDescription = reader.readOctetStringAsString();
            ByteString assertionValue = reader.readOctetString();
            Filter filter = Filter.approx(attributeDescription, assertionValue);
            return filter;
        }
        finally {
            reader.readEndSequence();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Filter readEqualityMatchFilter(ASN1Reader reader) throws IOException {
        reader.readStartSequence((byte)-93);
        try {
            String attributeDescription = reader.readOctetStringAsString();
            ByteString assertionValue = reader.readOctetString();
            Filter filter = Filter.equality(attributeDescription, assertionValue);
            return filter;
        }
        finally {
            reader.readEndSequence();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Filter readExtensibleMatchFilter(ASN1Reader reader) throws IOException {
        reader.readStartSequence((byte)-87);
        try {
            String matchingRule = null;
            if (reader.peekType() == -127) {
                matchingRule = reader.readOctetStringAsString((byte)-127);
            }
            String attributeDescription = null;
            if (reader.peekType() == -126) {
                attributeDescription = reader.readOctetStringAsString((byte)-126);
            }
            boolean dnAttributes = false;
            if (reader.hasNextElement() && reader.peekType() == -124) {
                dnAttributes = reader.readBoolean();
            }
            ByteString assertionValue = reader.readOctetString((byte)-125);
            Filter filter = Filter.extensible(matchingRule, attributeDescription, assertionValue, dnAttributes);
            return filter;
        }
        finally {
            reader.readEndSequence();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Filter readGreaterOrEqualMatchFilter(ASN1Reader reader) throws IOException {
        reader.readStartSequence((byte)-91);
        try {
            String attributeDescription = reader.readOctetStringAsString();
            ByteString assertionValue = reader.readOctetString();
            Filter filter = Filter.greaterOrEqual(attributeDescription, assertionValue);
            return filter;
        }
        finally {
            reader.readEndSequence();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Filter readLessOrEqualMatchFilter(ASN1Reader reader) throws IOException {
        reader.readStartSequence((byte)-90);
        try {
            String attributeDescription = reader.readOctetStringAsString();
            ByteString assertionValue = reader.readOctetString();
            Filter filter = Filter.lessOrEqual(attributeDescription, assertionValue);
            return filter;
        }
        finally {
            reader.readEndSequence();
        }
    }

    private static Filter readNotFilter(ASN1Reader reader) throws IOException {
        reader.readStartSequence((byte)-94);
        try {
            Filter filter = Filter.not(LDAP.readFilter(reader));
            return filter;
        }
        finally {
            reader.readEndSequence();
        }
    }

    private static Filter readOrFilter(ASN1Reader reader) throws IOException {
        reader.readStartSequence((byte)-95);
        try {
            if (reader.hasNextElement()) {
                LinkedList<Filter> subFilters = new LinkedList<Filter>();
                do {
                    subFilters.add(LDAP.readFilter(reader));
                } while (reader.hasNextElement());
                Filter filter = Filter.or(subFilters);
                return filter;
            }
            Filter filter = Filter.alwaysFalse();
            return filter;
        }
        finally {
            reader.readEndSequence();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Filter readSubstringsFilter(ASN1Reader reader) throws IOException {
        reader.readStartSequence((byte)-92);
        try {
            Filter filter;
            String attributeDescription = reader.readOctetStringAsString();
            reader.readStartSequence();
            try {
                List anySubstrings;
                ByteString initialSubstring = null;
                if (reader.peekType() == -128) {
                    initialSubstring = reader.readOctetString((byte)-128);
                }
                if (reader.hasNextElement() && reader.peekType() == -127) {
                    anySubstrings = new LinkedList();
                    do {
                        anySubstrings.add(reader.readOctetString((byte)-127));
                    } while (reader.hasNextElement() && reader.peekType() == -127);
                } else {
                    anySubstrings = Collections.emptyList();
                }
                ByteString finalSubstring = null;
                if (reader.hasNextElement() && reader.peekType() == -126) {
                    finalSubstring = reader.readOctetString((byte)-126);
                }
                filter = Filter.substrings(attributeDescription, initialSubstring, anySubstrings, finalSubstring);
            }
            catch (Throwable throwable) {
                reader.readEndSequence();
                throw throwable;
            }
            reader.readEndSequence();
            return filter;
        }
        finally {
            reader.readEndSequence();
        }
    }

    private LDAP() {
    }

    static {
        Arrays.fill(OP_TO_RESULT_TYPE, (byte)0);
        LDAP.OP_TO_RESULT_TYPE[104] = 105;
        LDAP.OP_TO_RESULT_TYPE[96] = 97;
        LDAP.OP_TO_RESULT_TYPE[110] = 111;
        LDAP.OP_TO_RESULT_TYPE[74] = 107;
        LDAP.OP_TO_RESULT_TYPE[119] = 120;
        LDAP.OP_TO_RESULT_TYPE[108] = 109;
        LDAP.OP_TO_RESULT_TYPE[102] = 103;
        LDAP.OP_TO_RESULT_TYPE[99] = 101;
        ASN1_ENCODER = new FilterVisitor<IOException, ASN1Writer>(){

            @Override
            public IOException visitAndFilter(ASN1Writer writer, List<Filter> subFilters) {
                try {
                    writer.writeStartSequence((byte)-96);
                    for (Filter subFilter : subFilters) {
                        IOException e = subFilter.accept(this, writer);
                        if (e == null) continue;
                        return e;
                    }
                    writer.writeEndSequence();
                    return null;
                }
                catch (IOException e) {
                    return e;
                }
            }

            @Override
            public IOException visitApproxMatchFilter(ASN1Writer writer, String attributeDescription, ByteString assertionValue) {
                return this.writeFilter(writer, (byte)-88, attributeDescription, assertionValue);
            }

            @Override
            public IOException visitEqualityMatchFilter(ASN1Writer writer, String attributeDescription, ByteString assertionValue) {
                return this.writeFilter(writer, (byte)-93, attributeDescription, assertionValue);
            }

            @Override
            public IOException visitExtensibleMatchFilter(ASN1Writer writer, String matchingRule, String attributeDescription, ByteString assertionValue, boolean dnAttributes) {
                try {
                    writer.writeStartSequence((byte)-87);
                    if (matchingRule != null) {
                        writer.writeOctetString((byte)-127, matchingRule);
                    }
                    if (attributeDescription != null) {
                        writer.writeOctetString((byte)-126, attributeDescription);
                    }
                    writer.writeOctetString((byte)-125, assertionValue);
                    if (dnAttributes) {
                        writer.writeBoolean((byte)-124, true);
                    }
                    writer.writeEndSequence();
                    return null;
                }
                catch (IOException e) {
                    return e;
                }
            }

            @Override
            public IOException visitGreaterOrEqualFilter(ASN1Writer writer, String attributeDescription, ByteString assertionValue) {
                return this.writeFilter(writer, (byte)-91, attributeDescription, assertionValue);
            }

            @Override
            public IOException visitLessOrEqualFilter(ASN1Writer writer, String attributeDescription, ByteString assertionValue) {
                return this.writeFilter(writer, (byte)-90, attributeDescription, assertionValue);
            }

            public IOException writeFilter(ASN1Writer writer, byte filterType, String attributeDescription, ByteString assertionValue) {
                try {
                    writer.writeStartSequence(filterType);
                    writer.writeOctetString(attributeDescription);
                    writer.writeOctetString(assertionValue);
                    writer.writeEndSequence();
                    return null;
                }
                catch (IOException e) {
                    return e;
                }
            }

            @Override
            public IOException visitNotFilter(ASN1Writer writer, Filter subFilter) {
                try {
                    writer.writeStartSequence((byte)-94);
                    IOException e = subFilter.accept(this, writer);
                    if (e != null) {
                        return e;
                    }
                    writer.writeEndSequence();
                    return null;
                }
                catch (IOException e) {
                    return e;
                }
            }

            @Override
            public IOException visitOrFilter(ASN1Writer writer, List<Filter> subFilters) {
                try {
                    writer.writeStartSequence((byte)-95);
                    for (Filter subFilter : subFilters) {
                        IOException e = subFilter.accept(this, writer);
                        if (e == null) continue;
                        return e;
                    }
                    writer.writeEndSequence();
                    return null;
                }
                catch (IOException e) {
                    return e;
                }
            }

            @Override
            public IOException visitPresentFilter(ASN1Writer writer, String attributeDescription) {
                try {
                    writer.writeOctetString((byte)-121, attributeDescription);
                    return null;
                }
                catch (IOException e) {
                    return e;
                }
            }

            @Override
            public IOException visitSubstringsFilter(ASN1Writer writer, String attributeDescription, ByteString initialSubstring, List<ByteString> anySubstrings, ByteString finalSubstring) {
                try {
                    writer.writeStartSequence((byte)-92);
                    writer.writeOctetString(attributeDescription);
                    writer.writeStartSequence();
                    if (initialSubstring != null) {
                        writer.writeOctetString((byte)-128, initialSubstring);
                    }
                    for (ByteSequence byteSequence : anySubstrings) {
                        writer.writeOctetString((byte)-127, byteSequence);
                    }
                    if (finalSubstring != null) {
                        writer.writeOctetString((byte)-126, finalSubstring);
                    }
                    writer.writeEndSequence();
                    writer.writeEndSequence();
                    return null;
                }
                catch (IOException e) {
                    return e;
                }
            }

            @Override
            public IOException visitUnrecognizedFilter(ASN1Writer writer, byte filterTag, ByteString filterBytes) {
                try {
                    writer.writeOctetString(filterTag, filterBytes);
                    return null;
                }
                catch (IOException e) {
                    return e;
                }
            }
        };
    }
}

