/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.NoSuchElementException;
import org.forgerock.util.Reject;

public final class SmallSet<E>
extends AbstractSet<E> {
    private LinkedHashMap<E, E> elements;
    private E firstElement;

    public SmallSet() {
    }

    public SmallSet(Collection<? extends E> c) {
        this.addAll(c);
    }

    public SmallSet(int initialCapacity) {
        Reject.ifFalse((initialCapacity >= 0 ? 1 : 0) != 0);
        if (initialCapacity > 1) {
            this.elements = new LinkedHashMap(initialCapacity);
        }
    }

    @Override
    public boolean add(E e) {
        if (this.firstElement == null && this.elements == null) {
            this.firstElement = e;
            return true;
        }
        if (this.elements == null) {
            if (this.firstElement.equals(e)) {
                return false;
            }
            this.elements = new LinkedHashMap(2);
            this.addForbidsReplace(this.elements, this.firstElement);
            this.firstElement = null;
        }
        return this.addForbidsReplace(this.elements, e);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (this.elements != null) {
            return this.addAllForbidsReplace(this.elements, c);
        }
        if (this.firstElement != null && !c.isEmpty()) {
            this.elements = new LinkedHashMap(1 + c.size());
            this.addForbidsReplace(this.elements, this.firstElement);
            this.firstElement = null;
            return this.addAllForbidsReplace(this.elements, c);
        }
        switch (c.size()) {
            case 0: {
                return false;
            }
            case 1: {
                this.firstElement = c.iterator().next();
                return true;
            }
        }
        this.elements = new LinkedHashMap(c.size());
        this.addAllForbidsReplace(this.elements, c);
        return true;
    }

    private boolean addForbidsReplace(LinkedHashMap<E, E> map, E e) {
        if (map.containsKey(e)) {
            return false;
        }
        return map.put(e, e) == null;
    }

    private boolean addAllForbidsReplace(LinkedHashMap<E, E> map, Collection<? extends E> c) {
        boolean modified = false;
        for (E e : c) {
            modified |= this.addForbidsReplace(map, e);
        }
        return modified;
    }

    public void addOrReplace(E element) {
        this.remove(element);
        this.add(element);
    }

    @Override
    public void clear() {
        this.firstElement = null;
        this.elements = null;
    }

    @Override
    public Iterator<E> iterator() {
        if (this.elements != null) {
            return this.elements.keySet().iterator();
        }
        if (this.firstElement != null) {
            return new Iterator<E>(){
                private boolean hasNext = true;

                @Override
                public boolean hasNext() {
                    return this.hasNext;
                }

                @Override
                public E next() {
                    if (!this.hasNext) {
                        throw new NoSuchElementException();
                    }
                    this.hasNext = false;
                    return SmallSet.this.firstElement;
                }

                @Override
                public void remove() {
                    SmallSet.this.firstElement = null;
                }
            };
        }
        return Collections.emptySet().iterator();
    }

    @Override
    public boolean remove(Object o) {
        if (this.elements != null) {
            return this.elements.keySet().remove(o);
        }
        if (this.firstElement != null && this.firstElement.equals(o)) {
            this.firstElement = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        if (this.elements != null) {
            return this.elements.containsKey(o);
        }
        return this.firstElement != null && this.firstElement.equals(o);
    }

    public E get(Object o) {
        if (this.elements != null) {
            return this.elements.get(o);
        }
        return this.firstElement != null && this.firstElement.equals(o) ? (E)this.firstElement : null;
    }

    @Override
    public int size() {
        if (this.elements != null) {
            return this.elements.size();
        }
        if (this.firstElement != null) {
            return 1;
        }
        return 0;
    }
}

