/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.security;

import java.net.URL;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.forgerock.opendj.ldap.MemoryBackend;
import org.forgerock.opendj.ldap.SdkTestCase;
import org.forgerock.opendj.security.KeyStoreObject;
import org.forgerock.opendj.security.KeyStoreObjectCache;
import org.forgerock.opendj.security.KeyStoreTestUtils;
import org.forgerock.opendj.security.OpenDJProvider;
import org.forgerock.util.Factory;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class OpenDJProviderTest
extends SdkTestCase {
    @Test
    public void testNewProviderWithoutConfigFile() throws Exception {
        OpenDJProvider provider = new OpenDJProvider();
        Assertions.assertThat((Object)provider.getDefaultConfig()).isNull();
    }

    @Test
    public void testNewProviderFromConfigFile() throws Exception {
        URL configUrl = ((Object)((Object)this)).getClass().getResource("opendj-provider.conf");
        OpenDJProvider provider = new OpenDJProvider(configUrl.toURI());
        Assertions.assertThat((Object)provider.getDefaultConfig().getBaseDN()).isEqualTo((Object)KeyStoreTestUtils.KEYSTORE_DN);
        Assertions.assertThat((Object)provider.getDefaultConfig().getConnectionFactory()).isNotNull();
        Assertions.assertThat((Object)provider.getDefaultConfig().getOptions()).isNotNull();
    }

    @Test
    public void testNewLDAPKeyStore() throws Exception {
        MemoryBackend backend = KeyStoreTestUtils.createKeyStoreMemoryBackend();
        KeyStore keystore = KeyStoreTestUtils.createKeyStore(backend);
        Assertions.assertThat((Map)keystore.getProvider()).isInstanceOf(OpenDJProvider.class);
        Assertions.assertThat((String)keystore.getType()).isEqualTo((Object)"LDAP");
        Assertions.assertThat((int)keystore.size()).isZero();
        Assertions.assertThat(Collections.list(keystore.aliases())).isEmpty();
    }

    @Test
    public void testNewKeyStoreObjectCacheFromMap() throws Exception {
        HashMap map = new HashMap();
        KeyStoreObjectCache cache = OpenDJProvider.newKeyStoreObjectCacheFromMap(map);
        KeyStoreObject keyStoreObject = KeyStoreObject.newTrustedCertificateObject((String)"test", (Certificate)KeyStoreTestUtils.PUBLIC_KEY_CERTIFICATE);
        cache.put(keyStoreObject);
        Assertions.assertThat(map).containsEntry((Object)"test", (Object)keyStoreObject);
        Assertions.assertThat((Object)cache.get("test")).isSameAs((Object)keyStoreObject);
    }

    @Test
    public void testNewCapacityBasedKeyStoreObjectCache() throws Exception {
        KeyStoreObject keyStoreObject1 = KeyStoreObject.newTrustedCertificateObject((String)"test1", (Certificate)KeyStoreTestUtils.PUBLIC_KEY_CERTIFICATE);
        KeyStoreObject keyStoreObject2 = KeyStoreObject.newTrustedCertificateObject((String)"test2", (Certificate)KeyStoreTestUtils.PUBLIC_KEY_CERTIFICATE);
        KeyStoreObject keyStoreObject3 = KeyStoreObject.newTrustedCertificateObject((String)"test3", (Certificate)KeyStoreTestUtils.PUBLIC_KEY_CERTIFICATE);
        KeyStoreObject keyStoreObject4 = KeyStoreObject.newTrustedCertificateObject((String)"test4", (Certificate)KeyStoreTestUtils.PUBLIC_KEY_CERTIFICATE);
        KeyStoreObjectCache cache = OpenDJProvider.newCapacityBasedKeyStoreObjectCache((int)3);
        cache.put(keyStoreObject1);
        cache.put(keyStoreObject2);
        cache.put(keyStoreObject3);
        Assertions.assertThat((Object)cache.get("test1")).isSameAs((Object)keyStoreObject1);
        Assertions.assertThat((Object)cache.get("test2")).isSameAs((Object)keyStoreObject2);
        Assertions.assertThat((Object)cache.get("test3")).isSameAs((Object)keyStoreObject3);
        cache.put(keyStoreObject4);
        Assertions.assertThat((Object)cache.get("test1")).isNull();
        Assertions.assertThat((Object)cache.get("test2")).isSameAs((Object)keyStoreObject2);
        Assertions.assertThat((Object)cache.get("test3")).isSameAs((Object)keyStoreObject3);
        Assertions.assertThat((Object)cache.get("test4")).isSameAs((Object)keyStoreObject4);
    }

    @DataProvider
    public static Object[][] obfuscatedPasswords() {
        return new Object[][]{{null}, {"".toCharArray()}, {"password".toCharArray()}, {"\u0000\u007f\u0080\u00ff\uffff".toCharArray()}};
    }

    @Test(dataProvider="obfuscatedPasswords")
    public void testNewObfuscatedPasswordFactory(char[] password) {
        Factory factory = OpenDJProvider.newClearTextPasswordFactory((char[])password);
        Assertions.assertThat((char[])((char[])factory.newInstance())).isEqualTo((Object)password);
        if (password != null) {
            Assertions.assertThat((char[])((char[])factory.newInstance())).isNotSameAs((Object)password);
        }
    }
}

