/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.security;

import org.assertj.core.api.Assertions;
import org.forgerock.opendj.ldap.SdkTestCase;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.ObjectClass;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.forgerock.opendj.security.OpenDJProviderSchema;
import org.testng.annotations.Test;

public class OpenDJProviderSchemaTest
extends SdkTestCase {
    @Test
    public void testGetObjectClasses() throws Exception {
        Assertions.assertThat((Iterable)OpenDJProviderSchema.getObjectClasses()).isNotEmpty();
    }

    @Test
    public void testGetAttributeTypes() throws Exception {
        Assertions.assertThat((Iterable)OpenDJProviderSchema.getAttributeTypes()).isNotEmpty();
    }

    @Test
    public void testAddOpenDJProviderSchema() throws Exception {
        SchemaBuilder schemaBuilder = new SchemaBuilder(Schema.getCoreSchema());
        Schema schema = OpenDJProviderSchema.addOpenDJProviderSchema((SchemaBuilder)schemaBuilder).toSchema();
        Assertions.assertThat((Iterable)schema.getWarnings()).isEmpty();
        for (ObjectClass objectClass : OpenDJProviderSchema.getObjectClasses()) {
            Assertions.assertThat((boolean)schema.hasObjectClass(objectClass.getNameOrOID())).isTrue();
        }
        for (AttributeType attributeType : OpenDJProviderSchema.getAttributeTypes()) {
            Assertions.assertThat((boolean)schema.hasAttributeType(attributeType.getNameOrOID())).isTrue();
        }
    }
}

