/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.security;

import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Date;
import javax.crypto.SecretKey;
import org.assertj.core.api.Assertions;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.SdkTestCase;
import org.forgerock.opendj.security.KeyProtector;
import org.forgerock.opendj.security.KeyStoreObject;
import org.forgerock.opendj.security.KeyStoreParameters;
import org.forgerock.opendj.security.KeyStoreTestUtils;
import org.forgerock.opendj.security.OpenDJProvider;
import org.forgerock.util.Options;
import org.testng.annotations.Test;

public class KeyStoreObjectTest
extends SdkTestCase {
    private static final KeyProtector KEY_PROTECTOR = new KeyProtector(Options.defaultOptions().set(KeyStoreParameters.GLOBAL_PASSWORD, (Object)OpenDJProvider.newClearTextPasswordFactory((char[])KeyStoreTestUtils.KEYSTORE_PASSWORD)));

    @Test
    public void testNewTrustedCertificateEntry() throws Exception {
        KeyStoreObject keyStoreObject = KeyStoreObject.newTrustedCertificateObject((String)"test", (Certificate)KeyStoreTestUtils.PUBLIC_KEY_CERTIFICATE);
        this.validateTrustedCertificateKeyStoreEntry(keyStoreObject);
        Entry ldapEntry = keyStoreObject.toLDAPEntry(KeyStoreTestUtils.KEYSTORE_DN);
        Assertions.assertThat((Object)ldapEntry.getName()).isEqualTo((Object)KeyStoreTestUtils.TEST_DN);
        Assertions.assertThat((Iterable)ldapEntry.parseAttribute("objectClass").asSetOfString(new String[0])).containsOnly((Object[])new String[]{"top", "ds-keystore-object", "ds-keystore-trusted-certificate"});
        Assertions.assertThat((String)ldapEntry.parseAttribute("ds-keystore-alias").asString()).isEqualTo((Object)"test");
        Assertions.assertThat((Object)ldapEntry.parseAttribute("ds-keystore-certificate;binary").asCertificate()).isEqualTo((Object)KeyStoreTestUtils.PUBLIC_KEY_CERTIFICATE);
        this.validateTrustedCertificateKeyStoreEntry(KeyStoreObject.valueOf((Entry)ldapEntry));
    }

    private void validateTrustedCertificateKeyStoreEntry(KeyStoreObject keyStoreObject) throws Exception {
        Assertions.assertThat((String)keyStoreObject.getAlias()).isEqualTo((Object)"test");
        Assertions.assertThat((boolean)keyStoreObject.isTrustedCertificate()).isTrue();
        Assertions.assertThat((Date)keyStoreObject.getCreationDate()).isNotNull();
        Assertions.assertThat((Object)keyStoreObject.getCertificate()).isSameAs((Object)KeyStoreTestUtils.PUBLIC_KEY_CERTIFICATE);
        Assertions.assertThat((Object[])keyStoreObject.getCertificateChain()).isNull();
        Assertions.assertThat((Object)keyStoreObject.getKey(new KeyProtector(Options.defaultOptions()), KeyStoreTestUtils.KEY_PASSWORD)).isNull();
    }

    @Test
    public void testNewPrivateKeyEntry() throws Exception {
        KeyStoreObject keyStoreObject = KeyStoreObject.newKeyObject((String)"test", (Key)KeyStoreTestUtils.PRIVATE_KEY, (Certificate[])KeyStoreTestUtils.CERTIFICATE_CHAIN, (KeyProtector)KEY_PROTECTOR, (char[])KeyStoreTestUtils.KEY_PASSWORD);
        this.validatePrivateKeyStoreEntry(keyStoreObject);
        Entry ldapEntry = keyStoreObject.toLDAPEntry(KeyStoreTestUtils.KEYSTORE_DN);
        Assertions.assertThat((Object)ldapEntry.getName()).isEqualTo((Object)KeyStoreTestUtils.TEST_DN);
        Assertions.assertThat((Iterable)ldapEntry.parseAttribute("objectClass").asSetOfString(new String[0])).containsOnly((Object[])new String[]{"top", "ds-keystore-object", "ds-keystore-private-key"});
        Assertions.assertThat((String)ldapEntry.parseAttribute("ds-keystore-alias").asString()).isEqualTo((Object)"test");
        Assertions.assertThat((String)ldapEntry.parseAttribute("ds-keystore-key-algorithm").asString()).isEqualTo((Object)"RSA");
        Assertions.assertThat((boolean)ldapEntry.containsAttribute("ds-keystore-certificate;binary", new Object[0])).isTrue();
        Assertions.assertThat((boolean)ldapEntry.containsAttribute("ds-keystore-certificate-chain", new Object[0])).isFalse();
        Assertions.assertThat((boolean)ldapEntry.containsAttribute("ds-keystore-key", new Object[0])).isTrue();
        this.validatePrivateKeyStoreEntry(KeyStoreObject.valueOf((Entry)ldapEntry));
    }

    private void validatePrivateKeyStoreEntry(KeyStoreObject keyStoreObject) throws Exception {
        Assertions.assertThat((String)keyStoreObject.getAlias()).isEqualTo((Object)"test");
        Assertions.assertThat((boolean)keyStoreObject.isTrustedCertificate()).isFalse();
        Assertions.assertThat((Date)keyStoreObject.getCreationDate()).isNotNull();
        Assertions.assertThat((Object)keyStoreObject.getCertificate()).isEqualTo((Object)KeyStoreTestUtils.PUBLIC_KEY_CERTIFICATE);
        Assertions.assertThat((Object[])keyStoreObject.getCertificateChain()).containsExactly((Object[])KeyStoreTestUtils.CERTIFICATE_CHAIN);
        Key privateKey = keyStoreObject.getKey(KEY_PROTECTOR, KeyStoreTestUtils.KEY_PASSWORD);
        Assertions.assertThat((Object)privateKey).isInstanceOf(PrivateKey.class);
        Assertions.assertThat((String)privateKey.getAlgorithm()).isEqualTo((Object)"RSA");
        Assertions.assertThat((String)privateKey.getFormat()).isEqualTo((Object)"PKCS#8");
        Assertions.assertThat((byte[])privateKey.getEncoded()).isEqualTo((Object)ByteString.valueOfBase64((String)"MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDh4tTZu1vNvAgDEXpGEvzkl3r4ayGfX7jSqWpjDtSyfbfIW71MiIQ90O64g5hzArHWhOWrgbCABXHIk9Ad7wn87bWLIoagHQCUQ89QrDKMntvAea66B4RLKJRilNIm07b+mGjEx3FJb2NfoCA2UmLVBKEvYpNHrxv5c//tet+MVbs7AL74t5ALCTeK99h2m2dmYvraAc7zbneKBdBK+7eIhdjZzrT1ElN8HfCQ4PzZD0cglue8M6V0R993BC8L0h00IHaHKzTMIKEMWUI9ailHON4fYI61BuNcRYyyKUQ1pojadEQ5bqEJ1zf51D6D6dusVKA52EAC+KPa0oHvdxlnAgMBAAECggEBALEYOpJdvtLkiU+Gg1uvBVBeps1eiKS/0lJu+nahKQarY8wUiKwZF7yzMoW8vmflA/JQjRPSgMNOAXAk2vSs9SK0ZzGnJu8e7dZP95ii+Jqg7V7Qx7kXrZOTRAqp7Lz+HakranBkgR/20W0mSDruiofBsnFJEnkQA5mmZU8Vl3AYSYwKP785N/nO7vZMMOkSrs5BYwDeYHIwncxXlaUBBCHf1I0tAHMe3SlqpPHpjrFiv2IofjGTGWEe6KDiUMWGNOkTLHgxb9rZTRh2p3vuMfOfkzd0Tgj6DOUVb1SOI8g4nFwfphwU008eV86OV7nxIbc+DXfQYpZ/850Rra/lCmECgYEA+AiIsw8QkkJuws+GoYWuVMH+m/qbWami+g1CDaR8zPTSAMdqNLamrnXkN3HtiMn+qjxBh5f7zw4eu5TA/jyFBTcOvh1gsYJNTGKPrzxyHF3k3BV/SGplIdzos+f7JSLNLZmSFSpikoAhy46sZKw30XjG74BHmeQmcAmLsx6a8lECgYEA6SQwv+i196e3DlfPBuUHuB9Z91FFUZi7A3Q3ziB56xXxOZO+F1L565Ve0z2j1jeVnmrBANkXnJUVWK2g+dCi8/gvocQ3hGr/WbJVXD6T57GkcwtApR1qkQxRVycxqYR0mYjb6jGOMJZ8OeC0UWYDWBlgjmv65C01IdItTJz/6jcCgYEAkk5mZEjkm4G4WA2V+r0iIjj0eQmQjYk0647agbWfMD7RiUgX69Q56fr8jYAUf3W3VK+Kb/NEw9QuaLPMS6tjQ7pAZgBqQwr7ka0p2FItdXIlR3UeyZaI5TqrwUN7r2Ih6V4G/5kq4APY63vTUOcNXfCCWFAw7CPaUIgw8Y2CFKECgYAEEOyEvFNIIXWw21kx/paW4H0aMiGqXaaNVd6PSsO1lOljHq+HCpxvPmir+Hw+BTQn0ibRk/e0dGkt5cFT+g6NgLub76ckORWBA/o3JKRBuzhqBT04Y/3yz6svgPB9y2CZOOjU+c5IDKfX/pJGhSfzxmWHtlxm1F8D2v2NQ4O3GwKBgASHtjgsEed1s+K6EU2S2dRqzrAyrokUZp5dKoYPPE2l4AIb0IGODD3GO3uZ6xAYg7RZkemtm2tLH4sTF6QUtRGputLLoAPp3qTWVCKW668hdNApC/WtqRwY68KOQlhoMgWQWLgX3Lu1gGqJHu89B3UmswvgNCZ7hA49P33jR2wh").toByteArray());
    }

    @Test
    public void testNewSecretKeyEntry() throws Exception {
        SecretKey secretKey = KeyStoreTestUtils.createSecretKey();
        KeyStoreObject keyStoreObject = KeyStoreObject.newKeyObject((String)"test", (Key)secretKey, (Certificate[])KeyStoreTestUtils.CERTIFICATE_CHAIN, (KeyProtector)KEY_PROTECTOR, (char[])KeyStoreTestUtils.KEY_PASSWORD);
        this.validateSecretKeyStoreEntry(keyStoreObject, secretKey.getEncoded());
        Entry ldapEntry = keyStoreObject.toLDAPEntry(KeyStoreTestUtils.KEYSTORE_DN);
        Assertions.assertThat((Object)ldapEntry.getName()).isEqualTo((Object)KeyStoreTestUtils.TEST_DN);
        Assertions.assertThat((Iterable)ldapEntry.parseAttribute("objectClass").asSetOfString(new String[0])).containsOnly((Object[])new String[]{"top", "ds-keystore-object", "ds-keystore-secret-key"});
        Assertions.assertThat((String)ldapEntry.parseAttribute("ds-keystore-alias").asString()).isEqualTo((Object)"test");
        Assertions.assertThat((String)ldapEntry.parseAttribute("ds-keystore-key-algorithm").asString()).isEqualTo((Object)"PBKDF2WithHmacSHA1");
        Assertions.assertThat((boolean)ldapEntry.containsAttribute("ds-keystore-key", new Object[0])).isTrue();
        this.validateSecretKeyStoreEntry(KeyStoreObject.valueOf((Entry)ldapEntry), secretKey.getEncoded());
    }

    private void validateSecretKeyStoreEntry(KeyStoreObject keyStoreObject, byte[] encodedKey) throws Exception {
        Assertions.assertThat((String)keyStoreObject.getAlias()).isEqualTo((Object)"test");
        Assertions.assertThat((boolean)keyStoreObject.isTrustedCertificate()).isFalse();
        Assertions.assertThat((Date)keyStoreObject.getCreationDate()).isNotNull();
        Assertions.assertThat((Object)keyStoreObject.getCertificate()).isNull();
        Assertions.assertThat((Object[])keyStoreObject.getCertificateChain()).isNull();
        Key secretKey = keyStoreObject.getKey(KEY_PROTECTOR, KeyStoreTestUtils.KEY_PASSWORD);
        Assertions.assertThat((Object)secretKey).isInstanceOf(SecretKey.class);
        Assertions.assertThat((String)secretKey.getAlgorithm()).isEqualTo((Object)"PBKDF2WithHmacSHA1");
        Assertions.assertThat((String)secretKey.getFormat()).isEqualTo((Object)"RAW");
        Assertions.assertThat((byte[])secretKey.getEncoded()).isEqualTo((Object)encodedKey);
    }

    @Test
    public void testDnOf() throws Exception {
        Assertions.assertThat((Object)KeyStoreObject.dnOf((DN)KeyStoreTestUtils.KEYSTORE_DN, (String)"test")).isEqualTo((Object)KeyStoreTestUtils.TEST_DN);
    }
}

