/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.security;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import javax.crypto.SecretKey;
import org.assertj.core.api.Assertions;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.Connections;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.MemoryBackend;
import org.forgerock.opendj.ldap.RequestHandler;
import org.forgerock.opendj.ldap.SdkTestCase;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.security.KeyStoreParameters;
import org.forgerock.opendj.security.KeyStoreTestUtils;
import org.forgerock.opendj.security.OpenDJProvider;
import org.forgerock.opendj.security.OpenDJProviderSchema;
import org.forgerock.util.Options;
import org.mockito.Mockito;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class KeyStoreImplTest
extends SdkTestCase {
    private MemoryBackend backend;
    private KeyStore keyStore;

    @BeforeClass
    public void beforeClass() {
        Schema.setDefaultSchema((Schema)OpenDJProviderSchema.SCHEMA);
    }

    @BeforeMethod
    public void beforeMethod() throws Exception {
        this.backend = KeyStoreTestUtils.createKeyStoreMemoryBackend();
        this.keyStore = KeyStoreTestUtils.createKeyStore(this.backend);
    }

    @Test
    public void getProviderShouldReturnOpenDJProvider() {
        Assertions.assertThat((Map)this.keyStore.getProvider()).isInstanceOf(OpenDJProvider.class);
    }

    @Test
    public void getTypeShouldReturnLDAP() {
        Assertions.assertThat((String)this.keyStore.getType()).isEqualTo((Object)"LDAP");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void storeShouldThrowWhenOutputStreamIsNotNull() throws Exception {
        this.keyStore.store((OutputStream)Mockito.mock(OutputStream.class), null);
    }

    @Test
    public void storeShouldBeNoOpWhenOutputStreamIsNull() throws Exception {
        this.keyStore.store(null, null);
    }

    @Test
    public void storeShouldBeNoOp() throws Exception {
        this.keyStore.store(null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void loadWithNonNullInputStreamShouldThrow() throws Exception {
        KeyStore keyStore = KeyStore.getInstance("LDAP", (Provider)new OpenDJProvider());
        keyStore.load((InputStream)Mockito.mock(InputStream.class), null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void loadWithNullInputStreamShouldThrowWhenNoProviderConfig() throws Exception {
        KeyStore keyStore = KeyStore.getInstance("LDAP", (Provider)new OpenDJProvider());
        keyStore.load(null, null);
    }

    @Test
    public void loadWithNullInputStreamShouldUseProviderConfig() throws Exception {
        ConnectionFactory factory = Connections.newInternalConnectionFactory((RequestHandler)this.backend);
        Options options = Options.defaultOptions().set(KeyStoreParameters.GLOBAL_PASSWORD, (Object)OpenDJProvider.newClearTextPasswordFactory((char[])KeyStoreTestUtils.KEYSTORE_PASSWORD));
        KeyStoreParameters config = KeyStoreParameters.newKeyStoreParameters((ConnectionFactory)factory, (DN)KeyStoreTestUtils.KEYSTORE_DN, (Options)options);
        OpenDJProvider provider = new OpenDJProvider(config);
        KeyStore keyStore = KeyStore.getInstance("LDAP", (Provider)provider);
        keyStore.load(null, null);
        Assertions.assertThat((int)keyStore.size()).isEqualTo(0);
        Assertions.assertThat((int)this.backend.size()).isEqualTo(1);
        keyStore.setKeyEntry("test", KeyStoreTestUtils.createSecretKey(), KeyStoreTestUtils.KEY_PASSWORD, null);
        Assertions.assertThat((int)keyStore.size()).isEqualTo(1);
        Assertions.assertThat((int)this.backend.size()).isEqualTo(2);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void loadWithNullLoadStoreParameterShouldThrowWhenNoProviderConfig() throws Exception {
        KeyStore keyStore = KeyStore.getInstance("LDAP", (Provider)new OpenDJProvider());
        keyStore.load(null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void loadWithNullLoadStoreParameterShouldThrowWhenParametersHaveWrongType() throws Exception {
        KeyStore keyStore = KeyStore.getInstance("LDAP", (Provider)new OpenDJProvider());
        keyStore.load((KeyStore.LoadStoreParameter)Mockito.mock(KeyStore.LoadStoreParameter.class));
    }

    @Test
    public void loadWithNullLoadStoreParameterShouldUseProviderConfig() throws Exception {
        ConnectionFactory factory = Connections.newInternalConnectionFactory((RequestHandler)this.backend);
        Options options = Options.defaultOptions().set(KeyStoreParameters.GLOBAL_PASSWORD, (Object)OpenDJProvider.newClearTextPasswordFactory((char[])KeyStoreTestUtils.KEYSTORE_PASSWORD));
        KeyStoreParameters config = KeyStoreParameters.newKeyStoreParameters((ConnectionFactory)factory, (DN)KeyStoreTestUtils.KEYSTORE_DN, (Options)options);
        OpenDJProvider provider = new OpenDJProvider(config);
        KeyStore keyStore = KeyStore.getInstance("LDAP", (Provider)provider);
        keyStore.load(null);
        Assertions.assertThat((int)keyStore.size()).isEqualTo(0);
        Assertions.assertThat((int)this.backend.size()).isEqualTo(1);
        keyStore.setKeyEntry("test", KeyStoreTestUtils.createSecretKey(), KeyStoreTestUtils.KEY_PASSWORD, null);
        Assertions.assertThat((int)keyStore.size()).isEqualTo(1);
        Assertions.assertThat((int)this.backend.size()).isEqualTo(2);
    }

    @Test
    public void loadWithNonNullLoadStoreParameterShouldNotUseProviderConfig() throws Exception {
        ConnectionFactory factory = Connections.newInternalConnectionFactory((RequestHandler)this.backend);
        Options options = Options.defaultOptions().set(KeyStoreParameters.GLOBAL_PASSWORD, (Object)OpenDJProvider.newClearTextPasswordFactory((char[])KeyStoreTestUtils.KEYSTORE_PASSWORD));
        KeyStoreParameters config = KeyStoreParameters.newKeyStoreParameters((ConnectionFactory)factory, (DN)KeyStoreTestUtils.KEYSTORE_DN, (Options)options);
        KeyStore keyStore = KeyStore.getInstance("LDAP", (Provider)new OpenDJProvider());
        keyStore.load((KeyStore.LoadStoreParameter)config);
        Assertions.assertThat((int)keyStore.size()).isEqualTo(0);
        Assertions.assertThat((int)this.backend.size()).isEqualTo(1);
        keyStore.setKeyEntry("test", KeyStoreTestUtils.createSecretKey(), KeyStoreTestUtils.KEY_PASSWORD, null);
        Assertions.assertThat((int)keyStore.size()).isEqualTo(1);
        Assertions.assertThat((int)this.backend.size()).isEqualTo(2);
    }

    @Test
    public void secretKeysCanBeStoredAndRetrieved() throws Exception {
        SecretKey key = KeyStoreTestUtils.createSecretKey();
        this.keyStore.setKeyEntry("test", key, KeyStoreTestUtils.KEY_PASSWORD, null);
        Key retrievedKey = this.keyStore.getKey("test", KeyStoreTestUtils.KEY_PASSWORD);
        Assertions.assertThat((Object)retrievedKey).isNotNull();
        Assertions.assertThat((Object)retrievedKey).isInstanceOf(SecretKey.class);
        Assertions.assertThat((String)retrievedKey.getAlgorithm()).isEqualTo((Object)key.getAlgorithm());
        Assertions.assertThat((String)retrievedKey.getFormat()).isEqualTo((Object)key.getFormat());
        Assertions.assertThat((byte[])retrievedKey.getEncoded()).isEqualTo((Object)key.getEncoded());
        Assertions.assertThat((int)this.keyStore.size()).isEqualTo(1);
        Assertions.assertThat(Collections.list(this.keyStore.aliases())).containsExactly((Object[])new String[]{"test"});
        Assertions.assertThat((boolean)this.keyStore.containsAlias("test"));
        Assertions.assertThat((Object)this.keyStore.getCertificate("test")).isNull();
        Assertions.assertThat((Object[])this.keyStore.getCertificateChain("test")).isNull();
        Assertions.assertThat((boolean)this.keyStore.entryInstanceOf("test", KeyStore.SecretKeyEntry.class));
        Assertions.assertThat((Date)this.keyStore.getCreationDate("test")).isNotNull();
        Assertions.assertThat((Object)this.keyStore.getEntry("test", KeyStoreImplTest.newPasswordProtection())).isInstanceOf(KeyStore.SecretKeyEntry.class);
        Assertions.assertThat((boolean)this.keyStore.isCertificateEntry("test")).isFalse();
        Assertions.assertThat((boolean)this.keyStore.isKeyEntry("test")).isTrue();
    }

    private static KeyStore.PasswordProtection newPasswordProtection() {
        return new KeyStore.PasswordProtection((char[])KeyStoreTestUtils.KEY_PASSWORD.clone());
    }

    @Test
    public void privateKeysCanBeStoredAndRetrieved() throws Exception {
        this.keyStore.setKeyEntry("test", KeyStoreTestUtils.PRIVATE_KEY, KeyStoreTestUtils.KEY_PASSWORD, KeyStoreTestUtils.CERTIFICATE_CHAIN);
        Key retrievedKey = this.keyStore.getKey("test", KeyStoreTestUtils.KEY_PASSWORD);
        Assertions.assertThat((Object)retrievedKey).isNotNull();
        Assertions.assertThat((Object)retrievedKey).isInstanceOf(PrivateKey.class);
        Assertions.assertThat((String)retrievedKey.getAlgorithm()).isEqualTo((Object)KeyStoreTestUtils.PRIVATE_KEY.getAlgorithm());
        Assertions.assertThat((String)retrievedKey.getFormat()).isEqualTo((Object)KeyStoreTestUtils.PRIVATE_KEY.getFormat());
        Assertions.assertThat((byte[])retrievedKey.getEncoded()).isEqualTo((Object)KeyStoreTestUtils.PRIVATE_KEY.getEncoded());
        Assertions.assertThat((int)this.keyStore.size()).isEqualTo(1);
        Assertions.assertThat(Collections.list(this.keyStore.aliases())).containsExactly((Object[])new String[]{"test"});
        Assertions.assertThat((boolean)this.keyStore.containsAlias("test"));
        Assertions.assertThat((Object)this.keyStore.getCertificate("test")).isSameAs((Object)KeyStoreTestUtils.PUBLIC_KEY_CERTIFICATE);
        Assertions.assertThat((Object[])this.keyStore.getCertificateChain("test")).isNotSameAs((Object)KeyStoreTestUtils.CERTIFICATE_CHAIN);
        Assertions.assertThat((Object[])this.keyStore.getCertificateChain("test")).containsExactly((Object[])new Certificate[]{KeyStoreTestUtils.PUBLIC_KEY_CERTIFICATE});
        Assertions.assertThat((boolean)this.keyStore.entryInstanceOf("test", KeyStore.PrivateKeyEntry.class));
        Assertions.assertThat((Date)this.keyStore.getCreationDate("test")).isNotNull();
        Assertions.assertThat((Object)this.keyStore.getEntry("test", KeyStoreImplTest.newPasswordProtection())).isInstanceOf(KeyStore.PrivateKeyEntry.class);
        Assertions.assertThat((boolean)this.keyStore.isCertificateEntry("test")).isFalse();
        Assertions.assertThat((boolean)this.keyStore.isKeyEntry("test")).isTrue();
    }

    @Test
    public void trustedCertificatesCanBeStoredAndRetrieved() throws Exception {
        this.keyStore.setCertificateEntry("test", KeyStoreTestUtils.PUBLIC_KEY_CERTIFICATE);
        Certificate retrievedCertificate = this.keyStore.getCertificate("test");
        Assertions.assertThat((Object)retrievedCertificate).isNotNull();
        Assertions.assertThat((Object)retrievedCertificate).isInstanceOf(X509Certificate.class);
        Assertions.assertThat((Object)retrievedCertificate).isEqualTo((Object)KeyStoreTestUtils.PUBLIC_KEY_CERTIFICATE);
        Assertions.assertThat((int)this.keyStore.size()).isEqualTo(1);
        Assertions.assertThat(Collections.list(this.keyStore.aliases())).containsExactly((Object[])new String[]{"test"});
        Assertions.assertThat((boolean)this.keyStore.containsAlias("test"));
        Assertions.assertThat((Object[])this.keyStore.getCertificateChain("test")).isNull();
        Assertions.assertThat((boolean)this.keyStore.entryInstanceOf("test", KeyStore.TrustedCertificateEntry.class));
        Assertions.assertThat((Date)this.keyStore.getCreationDate("test")).isNotNull();
        Assertions.assertThat((Object)this.keyStore.getEntry("test", null)).isInstanceOf(KeyStore.TrustedCertificateEntry.class);
        Assertions.assertThat((boolean)this.keyStore.isCertificateEntry("test")).isTrue();
        Assertions.assertThat((boolean)this.keyStore.isKeyEntry("test")).isFalse();
    }

    @Test
    public void getKeyShouldReturnNullWhenAliasUnknown() throws Exception {
        Key retrievedKey = this.keyStore.getKey("test", KeyStoreTestUtils.KEY_PASSWORD);
        Assertions.assertThat((Object)retrievedKey).isNull();
    }

    @Test(expectedExceptions={UnrecoverableKeyException.class})
    public void getKeyShouldThrowWhenPasswordIsMissing() throws Exception {
        this.keyStore.setKeyEntry("test", KeyStoreTestUtils.createSecretKey(), KeyStoreTestUtils.KEY_PASSWORD, null);
        this.keyStore.getKey("test", null);
    }

    @Test(expectedExceptions={UnrecoverableKeyException.class})
    public void getKeyShouldThrowWhenPasswordIsBad() throws Exception {
        this.keyStore.setKeyEntry("test", KeyStoreTestUtils.createSecretKey(), KeyStoreTestUtils.KEY_PASSWORD, null);
        this.keyStore.getKey("test", "bad".toCharArray());
    }

    @Test
    public void setKeyEntryWithSecretKeyWithCertChainIsAllowed() throws Exception {
        this.keyStore.setKeyEntry("test", KeyStoreTestUtils.createSecretKey(), KeyStoreTestUtils.KEY_PASSWORD, KeyStoreTestUtils.CERTIFICATE_CHAIN);
        Assertions.assertThat((boolean)this.keyStore.isKeyEntry("test")).isTrue();
        Assertions.assertThat((Object)this.keyStore.getCertificate("test")).isNull();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void setKeyEntryShouldThrowWhenPrivateKeyWithoutCertChain() throws Exception {
        this.keyStore.setKeyEntry("test", KeyStoreTestUtils.PRIVATE_KEY, KeyStoreTestUtils.KEY_PASSWORD, null);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void setKeyEntryWithPreEncodedKeyIsNotSupported() throws Exception {
        this.keyStore.setKeyEntry("test", KeyStoreTestUtils.createSecretKey().getEncoded(), null);
    }

    @Test
    public void keyStoreCanManageMultipleObjects() throws Exception {
        Object[] aliases = new String[]{"cert1", "cert2", "pkey", "skey1", "skey2"};
        this.keyStore.setCertificateEntry("cert1", KeyStoreTestUtils.PUBLIC_KEY_CERTIFICATE);
        this.keyStore.setCertificateEntry("cert2", KeyStoreTestUtils.TRUSTED_CERTIFICATE);
        this.keyStore.setKeyEntry("pkey", KeyStoreTestUtils.PRIVATE_KEY, KeyStoreTestUtils.KEY_PASSWORD, KeyStoreTestUtils.CERTIFICATE_CHAIN);
        this.keyStore.setKeyEntry("skey1", KeyStoreTestUtils.createSecretKey(), KeyStoreTestUtils.KEY_PASSWORD, null);
        this.keyStore.setKeyEntry("skey2", KeyStoreTestUtils.createSecretKey(), KeyStoreTestUtils.KEY_PASSWORD, null);
        Assertions.assertThat(Collections.list(this.keyStore.aliases())).containsOnly(aliases);
        for (int i = 0; i < aliases.length; ++i) {
            Object alias = aliases[i];
            Assertions.assertThat((int)this.keyStore.size()).isEqualTo(5 - i);
            Assertions.assertThat((boolean)this.keyStore.containsAlias((String)alias)).isTrue();
            this.keyStore.deleteEntry((String)alias);
            Assertions.assertThat((boolean)this.keyStore.containsAlias((String)alias)).isFalse();
        }
        Assertions.assertThat((int)this.keyStore.size()).isEqualTo(0);
        Assertions.assertThat(Collections.list(this.keyStore.aliases())).isEmpty();
    }

    @Test
    public void deleteEntryShouldIgnoreMissingAliases() throws Exception {
        this.keyStore.deleteEntry("unknown");
    }

    @Test
    public void getCertificateAliasShouldPerformCertificateMatchSearches() throws Exception {
        this.keyStore.setKeyEntry("privateKey", KeyStoreTestUtils.PRIVATE_KEY, KeyStoreTestUtils.KEY_PASSWORD, KeyStoreTestUtils.CERTIFICATE_CHAIN);
        this.keyStore.setCertificateEntry("trustedCertificate", KeyStoreTestUtils.TRUSTED_CERTIFICATE);
        Assertions.assertThat((String)this.keyStore.getCertificateAlias(KeyStoreTestUtils.PUBLIC_KEY_CERTIFICATE)).isEqualTo((Object)"privateKey");
        Assertions.assertThat((String)this.keyStore.getCertificateAlias(KeyStoreTestUtils.TRUSTED_CERTIFICATE)).isEqualTo((Object)"trustedCertificate");
        this.keyStore.deleteEntry("privateKey");
        Assertions.assertThat((String)this.keyStore.getCertificateAlias(KeyStoreTestUtils.PUBLIC_KEY_CERTIFICATE)).isNull();
        this.keyStore.deleteEntry("trustedCertificate");
        Assertions.assertThat((String)this.keyStore.getCertificateAlias(KeyStoreTestUtils.TRUSTED_CERTIFICATE)).isNull();
    }

    @Test
    public void setKeyShouldReplaceExistingObjects() throws Exception {
        this.keyStore.setKeyEntry("test", KeyStoreTestUtils.PRIVATE_KEY, KeyStoreTestUtils.KEY_PASSWORD, KeyStoreTestUtils.CERTIFICATE_CHAIN);
        Assertions.assertThat((Object)this.keyStore.getKey("test", KeyStoreTestUtils.KEY_PASSWORD)).isInstanceOf(PrivateKey.class);
        this.keyStore.setKeyEntry("test", KeyStoreTestUtils.createSecretKey(), KeyStoreTestUtils.KEY_PASSWORD, null);
        Assertions.assertThat((Object)this.keyStore.getKey("test", KeyStoreTestUtils.KEY_PASSWORD)).isInstanceOf(SecretKey.class);
    }

    @Test
    public void setCertificateShouldReplaceExistingCertificates() throws Exception {
        this.keyStore.setCertificateEntry("test", KeyStoreTestUtils.PUBLIC_KEY_CERTIFICATE);
        Assertions.assertThat((Object)this.keyStore.getCertificate("test")).isEqualTo((Object)KeyStoreTestUtils.PUBLIC_KEY_CERTIFICATE);
        this.keyStore.setCertificateEntry("test", KeyStoreTestUtils.TRUSTED_CERTIFICATE);
        Assertions.assertThat((Object)this.keyStore.getCertificate("test")).isEqualTo((Object)KeyStoreTestUtils.TRUSTED_CERTIFICATE);
    }
}

