/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldif;

import java.util.ArrayList;
import java.util.List;
import org.fest.assertions.Assertions;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.SdkTestCase;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldif.TemplateFile;
import org.forgerock.opendj.ldif.TemplateTag;
import org.mockito.Mockito;
import org.testng.annotations.Test;

public class TemplateTagTestcase
extends SdkTestCase {
    private static final int LINE_NUMBER = 10;
    private static final TemplateFile NULL_TEMPLATE_FILE = null;
    private static final List<LocalizableMessage> NULL_WARNINGS = null;
    private static final TemplateFile.TemplateValue NULL_VALUE = null;
    private static final TemplateFile.TemplateLine NULL_LINE = null;

    @Test
    public void testIfAbsentTag() throws Exception {
        TemplateTag.IfAbsentTag tag = new TemplateTag.IfAbsentTag();
        String org = "org";
        this.tagWithArguments((TemplateTag)tag, "dc", org);
        Assertions.assertThat((Object)tag.generateValue(this.templateEntry("v1", "v2"), NULL_VALUE)).isEqualTo((Object)TemplateTag.TagResult.SUCCESS);
        Assertions.assertThat((Object)tag.generateValue(this.templateEntry(org, "v"), NULL_VALUE)).isEqualTo((Object)TemplateTag.TagResult.FAILURE);
        Assertions.assertThat((Object)tag.generateValue(this.templateEntry("v", org), NULL_VALUE)).isEqualTo((Object)TemplateTag.TagResult.FAILURE);
        Assertions.assertThat((Object)tag.generateValue(this.templateEntry(org), NULL_VALUE)).isEqualTo((Object)TemplateTag.TagResult.FAILURE);
    }

    @Test
    public void testIfAbsentTagWithNoValue() throws Exception {
        TemplateTag.IfAbsentTag tag = new TemplateTag.IfAbsentTag();
        this.tagWithArguments((TemplateTag)tag, "dc");
        Assertions.assertThat((Object)tag.generateValue(this.templateEntry("v"), NULL_VALUE)).isEqualTo((Object)TemplateTag.TagResult.FAILURE);
    }

    @Test(expectedExceptions={DecodeException.class}, expectedExceptionsMessageRegExp=".*Invalid number of arguments.*")
    public void testIfAbsentTagTooManyArguments() throws Exception {
        this.tagWithArguments((TemplateTag)new TemplateTag.IfAbsentTag(), "dc", "org1", "org2");
    }

    @Test(expectedExceptions={DecodeException.class}, expectedExceptionsMessageRegExp=".*Invalid number of arguments.*")
    public void testIfAbsentTagNotEnoughArguments() throws Exception {
        this.tagWithArguments((TemplateTag)new TemplateTag.IfAbsentTag(), new String[0]);
    }

    @Test(expectedExceptions={DecodeException.class}, expectedExceptionsMessageRegExp=".*Undefined attribute.*")
    public void testIfAbsentTagNoAttribute() throws Exception {
        this.tagWithArguments((TemplateTag)new TemplateTag.IfAbsentTag(), this.templateWithNoAttribute(), "dc");
    }

    @Test
    public void testDNTagRootDN() throws Exception {
        TemplateTag.DNTag tag = new TemplateTag.DNTag();
        this.tagWithArguments((TemplateTag)tag, new String[0]);
        TemplateFile.TemplateValue value = new TemplateFile.TemplateValue(NULL_LINE);
        tag.generateValue(this.templateEntry(DN.rootDN()), value);
        Assertions.assertThat((String)value.getValueAsString()).isEqualTo((Object)"");
    }

    @Test
    public void testDNTagZeroComponent() throws Exception {
        TemplateTag.DNTag tag = new TemplateTag.DNTag();
        this.tagWithArguments((TemplateTag)tag, new String[0]);
        TemplateFile.TemplateValue value = new TemplateFile.TemplateValue(NULL_LINE);
        tag.generateValue(this.templateEntry(DN.valueOf((String)"ou=users,dc=example,dc=test")), value);
        Assertions.assertThat((String)value.getValueAsString()).isEqualTo((Object)"ou=users,dc=example,dc=test");
    }

    @Test
    public void testUnderscoreDNTagZeroComponent() throws Exception {
        TemplateTag.UnderscoreDNTag tag = new TemplateTag.UnderscoreDNTag();
        this.tagWithArguments((TemplateTag)tag, new String[0]);
        TemplateFile.TemplateValue value = new TemplateFile.TemplateValue(NULL_LINE);
        tag.generateValue(this.templateEntry(DN.valueOf((String)"ou=users,dc=example,dc=test")), value);
        Assertions.assertThat((String)value.getValueAsString()).isEqualTo((Object)"ou=users_dc=example_dc=test");
    }

    @Test
    public void testDNTagOneComponent() throws Exception {
        TemplateTag.DNTag tag = new TemplateTag.DNTag();
        this.tagWithArguments((TemplateTag)tag, "1");
        TemplateFile.TemplateValue value = new TemplateFile.TemplateValue(NULL_LINE);
        tag.generateValue(this.templateEntry(DN.valueOf((String)"ou=users,dc=example,dc=test")), value);
        Assertions.assertThat((String)value.getValueAsString()).isEqualTo((Object)"ou=users");
    }

    @Test
    public void testDNTagTwoComponent() throws Exception {
        TemplateTag.DNTag tag = new TemplateTag.DNTag();
        this.tagWithArguments((TemplateTag)tag, "2");
        TemplateFile.TemplateValue value = new TemplateFile.TemplateValue(NULL_LINE);
        tag.generateValue(this.templateEntry(DN.valueOf((String)"ou=users,dc=example,dc=test")), value);
        Assertions.assertThat((String)value.getValueAsString()).isEqualTo((Object)"ou=users,dc=example");
    }

    @Test
    public void testDNTagMinusOneComponent() throws Exception {
        TemplateTag.DNTag tag = new TemplateTag.DNTag();
        this.tagWithArguments((TemplateTag)tag, "-1");
        TemplateFile.TemplateValue value = new TemplateFile.TemplateValue(NULL_LINE);
        tag.generateValue(this.templateEntry(DN.valueOf((String)"ou=users,dc=example,dc=test")), value);
        Assertions.assertThat((String)value.getValueAsString()).isEqualTo((Object)"dc=test");
    }

    @Test
    public void testDNTagMinusTwoComponents() throws Exception {
        TemplateTag.DNTag tag = new TemplateTag.DNTag();
        this.tagWithArguments((TemplateTag)tag, "-2");
        TemplateFile.TemplateValue value = new TemplateFile.TemplateValue(NULL_LINE);
        tag.generateValue(this.templateEntry(DN.valueOf((String)"ou=users,dc=example,dc=test")), value);
        Assertions.assertThat((String)value.getValueAsString()).isEqualTo((Object)"dc=example,dc=test");
    }

    @Test
    public void testIfPresentTag() throws Exception {
        TemplateTag.IfPresentTag tag = new TemplateTag.IfPresentTag();
        String org = "org";
        this.tagWithArguments((TemplateTag)tag, "dc", org);
        Assertions.assertThat((Object)tag.generateValue(this.templateEntry("v1", "v2"), NULL_VALUE)).isEqualTo((Object)TemplateTag.TagResult.FAILURE);
        Assertions.assertThat((Object)tag.generateValue(this.templateEntry(org, "v"), NULL_VALUE)).isEqualTo((Object)TemplateTag.TagResult.SUCCESS);
        Assertions.assertThat((Object)tag.generateValue(this.templateEntry("v", org), NULL_VALUE)).isEqualTo((Object)TemplateTag.TagResult.SUCCESS);
        Assertions.assertThat((Object)tag.generateValue(this.templateEntry(org), NULL_VALUE)).isEqualTo((Object)TemplateTag.TagResult.SUCCESS);
    }

    @Test
    public void testIfPresentTagWithNoValue() throws Exception {
        TemplateTag.IfPresentTag tag = new TemplateTag.IfPresentTag();
        this.tagWithArguments((TemplateTag)tag, "dc");
        Assertions.assertThat((Object)tag.generateValue(this.templateEntry("org"), NULL_VALUE)).isEqualTo((Object)TemplateTag.TagResult.SUCCESS);
    }

    @Test(expectedExceptions={DecodeException.class}, expectedExceptionsMessageRegExp=".*Invalid number of arguments.*")
    public void testIfPresentTagTooManyArguments() throws Exception {
        this.tagWithArguments((TemplateTag)new TemplateTag.IfPresentTag(), "1", "2", "3");
    }

    @Test(expectedExceptions={DecodeException.class}, expectedExceptionsMessageRegExp=".*Invalid number of arguments.*")
    public void testIfPresentTagNotEnoughArguments() throws Exception {
        this.tagWithArguments((TemplateTag)new TemplateTag.IfPresentTag(), new String[0]);
    }

    @Test(expectedExceptions={DecodeException.class}, expectedExceptionsMessageRegExp=".*Undefined attribute.*")
    public void testIfPresentTagNoAttribute() throws Exception {
        this.tagWithArguments((TemplateTag)new TemplateTag.IfPresentTag(), this.templateWithNoAttribute(), "dc");
    }

    @Test(expectedExceptions={DecodeException.class}, expectedExceptionsMessageRegExp=".*Invalid number of arguments.*")
    public void testAttributeValueTagTooManyArguments() throws Exception {
        this.tagWithArguments((TemplateTag)new TemplateTag.AttributeValueTag(), "dc", "2", "3");
    }

    @Test(expectedExceptions={DecodeException.class}, expectedExceptionsMessageRegExp=".*below the lowest allowed value.*")
    public void testAttributeValueTagBelowLowerBound() throws Exception {
        this.tagWithArguments((TemplateTag)new TemplateTag.AttributeValueTag(), "dc", "-1");
    }

    @Test(expectedExceptions={DecodeException.class}, expectedExceptionsMessageRegExp=".*Cannot parse value.*")
    public void testAttributeValueTagNotANumber() throws Exception {
        this.tagWithArguments((TemplateTag)new TemplateTag.AttributeValueTag(), "dc", "notanumber");
    }

    @Test(expectedExceptions={DecodeException.class}, expectedExceptionsMessageRegExp=".*Undefined attribute.*")
    public void testAttributeValueTagNoAttribute() throws Exception {
        this.tagWithArguments((TemplateTag)new TemplateTag.AttributeValueTag(), this.templateWithNoAttribute(), "dc");
    }

    private void tagWithArguments(TemplateTag tag, String ... arguments) throws DecodeException {
        this.tagWithArguments(tag, this.templateWithAnyAttribute(), arguments);
    }

    private void tagWithArguments(TemplateTag tag, TemplateFile.Template template, String ... arguments) throws DecodeException {
        tag.initializeForTemplate(Schema.getDefaultSchema(), NULL_TEMPLATE_FILE, template, arguments, 10, NULL_WARNINGS);
    }

    private TemplateFile.TemplateEntry templateEntry(String ... values) {
        TemplateFile.TemplateEntry templateEntry = (TemplateFile.TemplateEntry)Mockito.mock(TemplateFile.TemplateEntry.class);
        ArrayList<TemplateFile.TemplateValue> templateValues = new ArrayList<TemplateFile.TemplateValue>();
        for (String value : values) {
            templateValues.add(this.templateValue(value));
        }
        Mockito.when((Object)templateEntry.getValues((AttributeType)Mockito.any(AttributeType.class))).thenReturn(templateValues);
        return templateEntry;
    }

    private TemplateFile.TemplateEntry templateEntry(DN dn) {
        TemplateFile.TemplateEntry templateEntry = (TemplateFile.TemplateEntry)Mockito.mock(TemplateFile.TemplateEntry.class);
        Mockito.when((Object)templateEntry.getDN()).thenReturn((Object)dn);
        return templateEntry;
    }

    private TemplateFile.TemplateValue templateValue(String value) {
        TemplateFile.TemplateValue templateVal = new TemplateFile.TemplateValue(null);
        templateVal.append(value);
        return templateVal;
    }

    private TemplateFile.Template templateWithAnyAttribute() {
        TemplateFile.Template template = (TemplateFile.Template)Mockito.mock(TemplateFile.Template.class);
        Mockito.when((Object)template.hasAttribute((AttributeType)Mockito.any(AttributeType.class))).thenReturn((Object)true);
        return template;
    }

    private TemplateFile.Template templateWithNoAttribute() {
        TemplateFile.Template template = (TemplateFile.Template)Mockito.mock(TemplateFile.Template.class);
        Mockito.when((Object)template.hasAttribute((AttributeType)Mockito.any(AttributeType.class))).thenReturn((Object)false);
        return template;
    }
}

