/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldif;

import com.forgerock.opendj.ldap.CoreMessages;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.fest.assertions.Assertions;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.LinkedHashMapEntry;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.ldap.ModificationType;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.TestCaseUtils;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.schema.CoreSchema;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.forgerock.opendj.ldap.schema.SchemaOptions;
import org.forgerock.opendj.ldap.schema.Syntax;
import org.forgerock.opendj.ldif.AbstractLDIFTestCase;
import org.forgerock.opendj.ldif.ChangeRecord;
import org.forgerock.opendj.ldif.ChangeRecordReader;
import org.forgerock.opendj.ldif.ChangeRecordWriter;
import org.forgerock.opendj.ldif.EntryReader;
import org.forgerock.opendj.ldif.EntryWriter;
import org.forgerock.opendj.ldif.LDIF;
import org.forgerock.opendj.ldif.LDIFChangeRecordReader;
import org.forgerock.opendj.ldif.LDIFChangeRecordWriter;
import org.forgerock.opendj.ldif.LDIFEntryReader;
import org.forgerock.opendj.ldif.LDIFEntryWriter;
import org.forgerock.opendj.ldif.RejectedChangeRecordListener;
import org.testng.annotations.Test;

public class LDIFTestCase
extends AbstractLDIFTestCase {
    public final int nbStandardEntryAttributes = new LinkedHashMapEntry(this.getStandardEntry()).getAttributeCount();
    private static final List<String> LDIF_ONE_ENTRY = Arrays.asList("dn: uid=user.1,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "objectClass: organizationalperson", "objectClass: inetorgperson", "givenName: Eniko", "sn: Atpco", "cn: Eniko Atpco", "uid: user.1");
    private static final List<String> LDIF_TWO_ENTRIES = Arrays.asList("dn: uid=user.1,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "objectClass: organizationalperson", "objectClass: inetorgperson", "givenName: Eniko", "sn: Atpco", "uid: user.1", "", "dn: uid=user.2,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "objectClass: organizationalperson", "objectClass: inetorgperson", "givenName: Aaaron", "sn: Atp", "uid: user.2");

    public final String[] getStandardEntry() {
        return new String[]{"dn: uid=user.0,ou=People,dc=example,dc=com", "objectClass: person", "objectClass: inetorgperson", "objectClass: organizationalperson", "objectClass: top", "postalAddress: Aaccf Amar$01251 Chestnut Street$Panama City, DE  50369", "postalCode: 50369", "uid: user.0", "description: This is the description for Aaccf Amar.", "userPassword: {SSHA}hpbT8dLi8xgYy2kl4aP6QKGzsFdhESWpPmDTEw==", "employeeNumber: 0", "initials: ASA", "givenName: Aaccf", "pager: +1 779 041 6341", "mobile: +1 010 154 3228", "cn: Aaccf Amar", "telephoneNumber: +1 685 622 6202", "sn: Amar", "street: 01251 Chestnut Street", "homePhone: +1 225 216 5900", "mail: user.0@maildomain.net", "l: Panama City", "st: DE", "pwdChangedTime: 20120903142126.219Z", "entryDN: uid=user.0,ou=people,dc=example,dc=org", "entryUUID: ad55a34a-763f-358f-93f9-da86f9ecd9e4", "modifyTimestamp: 20120903142126Z", "modifiersName: cn=Internal Client,cn=Root DNs,cn=config"};
    }

    @Test
    public final void testLdifSearchWithMatch() throws Exception {
        LDIFEntryReader reader = new LDIFEntryReader(this.getStandardEntry());
        SearchRequest sr = Requests.newSearchRequest((String)"dc=example,dc=com", (SearchScope)SearchScope.WHOLE_SUBTREE, (String)"(uid=user.0)", (String[])new String[0]);
        EntryReader resultReader = LDIF.search((EntryReader)reader, (SearchRequest)sr);
        Entry entry = resultReader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=user.0,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(this.nbStandardEntryAttributes);
        reader.close();
        resultReader.close();
    }

    @Test
    public final void testLdifSearchWithNoMatch() throws Exception {
        LDIFEntryReader reader = new LDIFEntryReader(this.getStandardEntry());
        SearchRequest sr = Requests.newSearchRequest((String)"dc=example,dc=org", (SearchScope)SearchScope.WHOLE_SUBTREE, (String)"(uid=user.0)", (String[])new String[0]);
        EntryReader resultReader = LDIF.search((EntryReader)reader, (SearchRequest)sr);
        Assertions.assertThat((boolean)resultReader.hasNext()).isFalse();
        resultReader.close();
    }

    @Test(expectedExceptions={NullPointerException.class})
    public final void testLdifSearchDoesntAllowNull() throws Exception {
        LDIF.search(null, null);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public final void testLdifSearchDoesntAllowNullSearchRequest() throws Exception {
        try (LDIFEntryReader reader = new LDIFEntryReader(this.getStandardEntry());){
            LDIF.search((EntryReader)reader, null);
        }
    }

    @Test(expectedExceptions={NullPointerException.class})
    public final void testLdifSearchAllowsNullReader() throws Exception {
        SearchRequest sr = Requests.newSearchRequest((String)"dc=example,dc=com", (SearchScope)SearchScope.WHOLE_SUBTREE, (String)"(uid=user.0)", (String[])new String[0]);
        EntryReader resultReader = LDIF.search(null, (SearchRequest)sr);
        resultReader.readEntry();
        resultReader.close();
    }

    @Test
    public final void testLdifSearchWithSchemaMatchNoAttributeDescription() throws Exception {
        LDIFEntryReader reader = new LDIFEntryReader(new String[]{"dn: uid=user.0,ou=People,dc=example,dc=com", "objectClass: person", "objectClass: inetorgperson", "objectClass: organizationalperson", "objectClass: top", "uid: user.0"});
        SearchRequest sr = Requests.newSearchRequest((String)"dc=example,dc=com", (SearchScope)SearchScope.WHOLE_SUBTREE, (String)"uid=*", (String[])new String[0]);
        EntryReader resultReader = LDIF.search((EntryReader)reader, (SearchRequest)sr, (Schema)Schema.getEmptySchema());
        Entry entry = resultReader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=user.0,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(2);
        Assertions.assertThat((Collection)entry.getAttribute("uid")).isNotNull();
        Assertions.assertThat((Object)entry.getAttribute("uid").getAttributeDescription()).isNotNull();
        Assertions.assertThat((String)entry.getAttribute("uid").firstValueAsString()).isNotNull();
        resultReader.close();
    }

    @Test
    public final void testLdifSearchWithSchemaMatchNoAttributeDescriptionTypeOnly() throws Exception {
        LDIFEntryReader reader = new LDIFEntryReader(new String[]{"dn: uid=user.0,ou=People,dc=example,dc=com", "objectClass: person", "objectClass: inetorgperson", "objectClass: organizationalperson", "objectClass: top", "uid: user.0"});
        SearchRequest sr = Requests.newSearchRequest((String)"dc=example,dc=com", (SearchScope)SearchScope.WHOLE_SUBTREE, (String)"uid=*", (String[])new String[0]).setTypesOnly(true);
        EntryReader resultReader = LDIF.search((EntryReader)reader, (SearchRequest)sr, (Schema)Schema.getEmptySchema());
        Entry entry = resultReader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=user.0,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(2);
        Assertions.assertThat((Collection)entry.getAttribute("uid")).isNotNull();
        Assertions.assertThat((Object)entry.getAttribute("uid").getAttributeDescription()).isNotNull();
        Assertions.assertThat((Collection)entry.getAttribute("uid")).isEmpty();
        resultReader.close();
    }

    @Test
    public final void testLdifSearchWithSchemaMatchFullAttributes() throws Exception {
        LDIFEntryReader reader = new LDIFEntryReader(new String[]{"dn: uid=user.0,ou=People,dc=example,dc=com", "objectClass: person", "objectClass: inetorgperson", "objectClass: organizationalperson", "objectClass: top", "uid: user.0"});
        SearchRequest sr = Requests.newSearchRequest((String)"dc=example,dc=com", (SearchScope)SearchScope.WHOLE_SUBTREE, (String)"(uid=user.0)", (String[])new String[]{"*"});
        EntryReader resultReader = LDIF.search((EntryReader)reader, (SearchRequest)sr, (Schema)Schema.getEmptySchema());
        Entry entry = resultReader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=user.0,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(2);
        Assertions.assertThat((Collection)entry.getAttribute("uid")).isNotNull();
        Assertions.assertThat((Object)entry.getAttribute("uid").getAttributeDescription()).isNotNull();
        Assertions.assertThat((String)entry.getAttribute("uid").firstValueAsString()).isEqualTo((Object)"user.0");
        resultReader.close();
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public final void testLdifSearchWithSchemaMatchFullAttributesTypeOnly() throws Exception {
        LDIFEntryReader reader = new LDIFEntryReader(new String[]{"dn: uid=user.0,ou=People,dc=example,dc=com", "objectClass: person", "objectClass: inetorgperson", "objectClass: organizationalperson", "objectClass: top", "uid: user.0"});
        SearchRequest sr = Requests.newSearchRequest((String)"dc=example,dc=com", (SearchScope)SearchScope.WHOLE_SUBTREE, (String)"(uid=user.0)", (String[])new String[]{"*"}).setTypesOnly(true);
        EntryReader resultReader = LDIF.search((EntryReader)reader, (SearchRequest)sr, (Schema)Schema.getEmptySchema());
        Entry entry = resultReader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=user.0,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(2);
        Assertions.assertThat((Collection)entry.getAttribute("objectClass")).isNotNull();
        Assertions.assertThat((Collection)entry.getAttribute("uid")).isNotNull();
        Assertions.assertThat((Object)entry.getAttribute("uid").getAttributeDescription()).isNotNull();
        Assertions.assertThat((Collection)entry.getAttribute("uid")).isEmpty();
        Assertions.assertThat((String)entry.getAttribute("uid").firstValueAsString()).isNull();
        resultReader.close();
    }

    @Test
    public final void testLdifSearchWithSchemaMatchOnlyOperationalAttributes() throws Exception {
        LDIFEntryReader reader = new LDIFEntryReader(new String[]{"dn: uid=user.0,ou=People,dc=example,dc=com", "objectClass: person", "objectClass: inetorgperson", "objectClass: organizationalperson", "objectClass: top", "uid: user.0", "entryDN: uid=user.0,ou=People,dc=example,dc=com", "entryUUID: ad55a34a-763f-358f-93f9-da86f9ecd9e4", "modifyTimestamp: 20120903142126Z", "modifiersName: cn=Internal Client,cn=Root DNs,cn=config"});
        SearchRequest sr = Requests.newSearchRequest((String)"dc=example,dc=com", (SearchScope)SearchScope.WHOLE_SUBTREE, (String)"(uid=user.0)", (String[])new String[]{"+"});
        EntryReader resultReader = LDIF.search((EntryReader)reader, (SearchRequest)sr, (Schema)Schema.getCoreSchema());
        Entry entry = resultReader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=user.0,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(4);
        Assertions.assertThat((String)entry.getAttribute("entryDN").firstValueAsString()).isEqualTo((Object)"uid=user.0,ou=People,dc=example,dc=com");
        Assertions.assertThat((Collection)entry.getAttribute("entryUUID")).isNotEmpty();
        Assertions.assertThat((Collection)entry.getAttribute("modifyTimestamp")).isNotEmpty();
        Assertions.assertThat((Collection)entry.getAttribute("modifiersName")).isNotEmpty();
        resultReader.close();
    }

    @Test
    public final void testLdifSearchWithSchemaMatchOnlyOperationalAttributesTypeOnly() throws Exception {
        LDIFEntryReader reader = new LDIFEntryReader(new String[]{"dn: uid=user.0,ou=People,dc=example,dc=com", "objectClass: person", "objectClass: inetorgperson", "objectClass: organizationalperson", "objectClass: top", "uid: user.0", "entryDN: uid=user.0,ou=People,dc=example,dc=com", "entryUUID: ad55a34a-763f-358f-93f9-da86f9ecd9e4", "modifyTimestamp: 20120903142126Z", "modifiersName: cn=Internal Client,cn=Root DNs,cn=config"});
        SearchRequest sr = Requests.newSearchRequest((String)"dc=example,dc=com", (SearchScope)SearchScope.WHOLE_SUBTREE, (String)"(uid=user.0)", (String[])new String[]{"+"}).setTypesOnly(true);
        EntryReader resultReader = LDIF.search((EntryReader)reader, (SearchRequest)sr, (Schema)Schema.getCoreSchema());
        Entry entry = resultReader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=user.0,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(4);
        Assertions.assertThat((Collection)entry.getAttribute("entryDN")).isEmpty();
        Assertions.assertThat((Collection)entry.getAttribute("entryUUID")).isEmpty();
        Assertions.assertThat((Collection)entry.getAttribute("modifyTimestamp")).isEmpty();
        Assertions.assertThat((Collection)entry.getAttribute("modifiersName")).isEmpty();
        resultReader.close();
    }

    @Test
    public final void testLdifSearchWithSchemaMatchSpecifiedAttribute() throws Exception {
        LDIFEntryReader reader = new LDIFEntryReader(new String[]{"dn: uid=user.0,ou=People,dc=example,dc=com", "objectClass: person", "objectClass: inetorgperson", "objectClass: organizationalperson", "objectClass: top", "uid: user.0"});
        SearchRequest sr = Requests.newSearchRequest((String)"dc=example,dc=com", (SearchScope)SearchScope.WHOLE_SUBTREE, (String)"(uid=user.0)", (String[])new String[]{"uid"});
        EntryReader resultReader = LDIF.search((EntryReader)reader, (SearchRequest)sr, (Schema)Schema.getEmptySchema());
        Entry entry = resultReader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=user.0,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(1);
        resultReader.close();
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public final void testLdifSearchWithSchemaMatchSpecifiedAttributeTypeOnly() throws Exception {
        LDIFEntryReader reader = new LDIFEntryReader(new String[]{"dn: uid=user.0,ou=People,dc=example,dc=com", "objectClass: person", "objectClass: inetorgperson", "objectClass: organizationalperson", "objectClass: top", "uid: user.0"});
        SearchRequest sr = Requests.newSearchRequest((String)"dc=example,dc=com", (SearchScope)SearchScope.WHOLE_SUBTREE, (String)"(uid=user.0)", (String[])new String[]{"uid"}).setTypesOnly(true);
        EntryReader resultReader = LDIF.search((EntryReader)reader, (SearchRequest)sr, (Schema)Schema.getEmptySchema());
        Entry entry = resultReader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=user.0,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(1);
        Assertions.assertThat((Object)entry.getAttribute("uid").getAttributeDescription()).isNotNull();
        Assertions.assertThat((Collection)entry.getAttribute("uid")).isEmpty();
        Assertions.assertThat((String)entry.getAttribute("uid").firstValueAsString()).isNull();
        resultReader.close();
    }

    @Test
    public final void testLdifSearchWithSchemaNoMatchSpecifiedAttribute() throws Exception {
        LDIFEntryReader reader = new LDIFEntryReader(new String[]{"dn: uid=user.0,ou=People,dc=example,dc=com", "objectClass: person", "objectClass: inetorgperson", "objectClass: organizationalperson", "objectClass: top", "uid: user.0"});
        SearchRequest sr = Requests.newSearchRequest((String)"dc=example,dc=com", (SearchScope)SearchScope.WHOLE_SUBTREE, (String)"(uid=user.0)", (String[])new String[]{"email"});
        EntryReader resultReader = LDIF.search((EntryReader)reader, (SearchRequest)sr, (Schema)Schema.getEmptySchema());
        Entry entry = resultReader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=user.0,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(0);
        resultReader.close();
    }

    @Test(expectedExceptions={LocalizedIllegalArgumentException.class})
    public final void testLdifSearchWithSchemaThrowsException() throws Exception {
        LDIFEntryReader reader = new LDIFEntryReader(new String[]{"dn: uid=user.0,ou=People,dc=example,dc=com", "objectClass: person", "objectClass: inetorgperson", "objectClass: organizationalperson", "objectClass: top", "uid: user.0"});
        SearchRequest sr = Requests.newSearchRequest((String)"dc=example,dc=com", (SearchScope)SearchScope.WHOLE_SUBTREE, (String)"(uid=user.0)", (String[])new String[]{"wro ng"});
        EntryReader resultReader = LDIF.search((EntryReader)reader, (SearchRequest)sr, (Schema)Schema.getEmptySchema());
        resultReader.readEntry();
        resultReader.close();
    }

    @Test
    public final void testSearchForEntryInLDIFUsingIgnoreMatchingRuleSucceedWithLowerCaseFilter() throws IOException {
        Schema schema = this.newSchemaBuilder(CoreSchema.getCaseIgnoreMatchingRule(), CoreSchema.getDirectoryStringSyntax());
        LDIFEntryReader input = new LDIFEntryReader(new String[]{"dn: cn=JPEG,cn=Syntaxes,cn=config", "objectClass: top", "objectClass: ds-cfg-attribute-syntax", "cn: JPEG", "ds-cfg-java-class: org.opends.server.schema.JPEGSyntax", "ds-cfg-enabled: true"}).setSchema(schema);
        SearchRequest sr = Requests.newSearchRequest((String)"cn=config", (SearchScope)SearchScope.WHOLE_SUBTREE, (String)"(ds-cfg-java-class=org.opends.server.schema.jpegsyntax)", (String[])new String[]{"*"});
        EntryReader resultReader = LDIF.search((EntryReader)input, (SearchRequest)sr, (Schema)schema);
        Entry entry = resultReader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"cn=JPEG,cn=Syntaxes,cn=config");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(4);
        Assertions.assertThat((String)entry.getAttribute("ds-cfg-java-class").firstValueAsString()).isEqualTo((Object)"org.opends.server.schema.JPEGSyntax");
        input.close();
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public final void testSearchForEntryInLDIFUsingExactMatchingRuleFailsWithLowerCaseFilter() throws IOException {
        Schema schema = this.newSchemaBuilder(CoreSchema.getCaseExactMatchingRule(), CoreSchema.getDirectoryStringSyntax());
        LDIFEntryReader input = new LDIFEntryReader(new String[]{"dn: cn=JPEG,cn=Syntaxes,cn=config", "objectClass: top", "objectClass: ds-cfg-attribute-syntax", "cn: JPEG", "ds-cfg-java-class: org.opends.server.schema.JPEGSyntax", "ds-cfg-enabled: true"}).setSchema(schema);
        SearchRequest sr = Requests.newSearchRequest((String)"cn=config", (SearchScope)SearchScope.WHOLE_SUBTREE, (String)"(ds-cfg-java-class=org.opends.server.schema.jpegsyntax)", (String[])new String[]{"*"});
        EntryReader resultReader = LDIF.search((EntryReader)input, (SearchRequest)sr, (Schema)schema);
        resultReader.readEntry();
    }

    @Test
    public final void testSearchForEntryInLDIFUsingExactMatchingRuleSucceedWithRightFilter() throws IOException {
        Schema schema = this.newSchemaBuilder(CoreSchema.getCaseExactMatchingRule(), CoreSchema.getDirectoryStringSyntax());
        LDIFEntryReader input = new LDIFEntryReader(new String[]{"dn: cn=JPEG,cn=Syntaxes,cn=config", "objectClass: top", "objectClass: ds-cfg-attribute-syntax", "cn: JPEG", "ds-cfg-java-class: org.opends.server.schema.JPEGSyntax", "ds-cfg-enabled: true"}).setSchema(schema);
        SearchRequest sr = Requests.newSearchRequest((String)"cn=config", (SearchScope)SearchScope.WHOLE_SUBTREE, (String)"(ds-cfg-java-class=org.opends.server.schema.JPEGSyntax)", (String[])new String[]{"*"});
        EntryReader resultReader = LDIF.search((EntryReader)input, (SearchRequest)sr, (Schema)schema);
        Entry entry = resultReader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"cn=JPEG,cn=Syntaxes,cn=config");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(4);
        Assertions.assertThat((String)entry.getAttribute("ds-cfg-java-class").firstValueAsString()).isEqualTo((Object)"org.opends.server.schema.JPEGSyntax");
        input.close();
    }

    private Schema newSchemaBuilder(MatchingRule defaultMatchingRule, Syntax defaultSyntax) {
        return new SchemaBuilder(Schema.getCoreSchema()).setOption(SchemaOptions.DEFAULT_MATCHING_RULE_OID, (Object)defaultMatchingRule.getOID()).setOption(SchemaOptions.DEFAULT_SYNTAX_OID, (Object)defaultSyntax.getOID()).toSchema().asNonStrictSchema();
    }

    @Test
    public final void testLdifNewEntryCollectionReader() throws Exception {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: uid=user.0,ou=People,dc=example,dc=com", "objectClass: person", "objectClass: inetorgperson"});
        LinkedHashMapEntry e1 = new LinkedHashMapEntry(new String[]{"dn: uid=user.1,ou=People,dc=example,dc=com", "objectClass: person"});
        LinkedHashMapEntry e2 = new LinkedHashMapEntry(new String[]{"dn: uid=user.2,ou=People,dc=example,dc=com", "objectClass: person"});
        ArrayList<LinkedHashMapEntry> collection = new ArrayList<LinkedHashMapEntry>();
        collection.add(e);
        collection.add(e1);
        collection.add(e2);
        EntryReader resultReader = LDIF.newEntryCollectionReader(collection);
        Entry entry = null;
        int cCount = 0;
        while (resultReader.hasNext()) {
            entry = resultReader.readEntry();
            Assertions.assertThat((String)entry.getName().toString()).isNotNull();
            Assertions.assertThat((int)entry.getAttributeCount()).isGreaterThanOrEqualTo(1);
            ++cCount;
        }
        Assertions.assertThat((int)cCount).isEqualTo(3);
        resultReader.close();
    }

    @Test(expectedExceptions={NullPointerException.class})
    public final void testLdifNewEntryCollectionDoesntAllowNull() throws Exception {
        try (EntryReader resultReader = LDIF.newEntryCollectionReader(null);){
            resultReader.readEntry();
        }
    }

    @Test
    public final void testLdifNewEntryIteratorReader() throws Exception {
        LinkedHashMapEntry e = new LinkedHashMapEntry(new String[]{"dn: uid=user.0,ou=People,dc=example,dc=com", "objectClass: person", "objectClass: inetorgperson"});
        LinkedHashMapEntry e1 = new LinkedHashMapEntry(new String[]{"dn: uid=user.1,ou=People,dc=example,dc=com", "objectClass: person"});
        TreeMap<DN, LinkedHashMapEntry> sourceEntries = new TreeMap<DN, LinkedHashMapEntry>();
        sourceEntries.put(DN.valueOf((String)"uid=user.0,ou=People,dc=example,dc=com"), e);
        sourceEntries.put(DN.valueOf((String)"uid=user.1,ou=People,dc=example,dc=com"), e1);
        Iterator sourceIterator = sourceEntries.values().iterator();
        EntryReader resultReader = LDIF.newEntryIteratorReader(sourceIterator);
        int cCount = 0;
        while (resultReader.hasNext()) {
            Entry entry = resultReader.readEntry();
            Assertions.assertThat((String)entry.getName().toString()).isNotNull();
            Assertions.assertThat((String)entry.getName().toString()).contains("ou=People,dc=example,dc=com");
            Assertions.assertThat((int)entry.getAttributeCount()).isGreaterThanOrEqualTo(1);
            ++cCount;
        }
        Assertions.assertThat((int)cCount).isEqualTo(2);
        resultReader.close();
    }

    @Test(expectedExceptions={NullPointerException.class})
    public final void testLdifNewEntryIteratorReaderDoesntAllowsNull() throws Exception {
        try (EntryReader resultReader = LDIF.newEntryIteratorReader(null);){
            resultReader.readEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void testLdifCopyToChangeRecord() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"# Entry to delete", "dn: uid=scarter,ou=People,dc=example,dc=com", "changetype: delete"});
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        try {
            LDIF.copyTo((ChangeRecordReader)reader, (ChangeRecordWriter)writer);
            Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)"dn: uid=scarter,ou=People,dc=example,dc=com");
            Assertions.assertThat((String)((String)actual.get(1))).isEqualTo((Object)"changetype: delete");
            Assertions.assertThat((String)((String)actual.get(2))).isEqualTo((Object)"");
            Assertions.assertThat((int)actual.size()).isEqualTo(3);
        }
        finally {
            reader.close();
            writer.close();
        }
    }

    @Test(expectedExceptions={NullPointerException.class})
    public final void testLdifCopyToChangeRecordDoesntAllowNull() throws Exception {
        LDIF.copyTo((ChangeRecordReader)null, (ChangeRecordWriter)null);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public final void testLdifCopyToChangeRecordDoesntAllowNullWriter() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"# Entry to delete", "dn: uid=scarter,ou=People,dc=example,dc=com", "changetype: delete"});
        LDIF.copyTo((ChangeRecordReader)reader, null);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public final void testLdifCopyToChangeRecordDoesntAllowNullReader() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        LDIF.copyTo(null, (ChangeRecordWriter)writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void testLdifCopyToEntryWriter() throws Exception {
        LDIFEntryReader reader = new LDIFEntryReader(new String[]{"# Entry to delete", "dn: uid=scarter,ou=People,dc=example,dc=com", "changetype: delete"});
        ArrayList actual = new ArrayList();
        LDIFEntryWriter writer = new LDIFEntryWriter(actual);
        try {
            LDIF.copyTo((EntryReader)reader, (EntryWriter)writer);
            Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)"dn: uid=scarter,ou=People,dc=example,dc=com");
            Assertions.assertThat((String)((String)actual.get(1))).isEqualTo((Object)"changetype: delete");
            Assertions.assertThat((String)((String)actual.get(2))).isEqualTo((Object)"");
            Assertions.assertThat((int)actual.size()).isEqualTo(3);
        }
        finally {
            reader.close();
            writer.close();
        }
    }

    @Test(expectedExceptions={NullPointerException.class})
    public final void testLdifCopyToEntryWriterDoesntAllowNullWriter() throws Exception {
        LDIFEntryReader reader = new LDIFEntryReader(new String[]{"# Entry to delete", "dn: uid=scarter,ou=People,dc=example,dc=com", "changetype: delete"});
        LDIF.copyTo((EntryReader)reader, null);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public final void testLdifCopyToEntryWriterDoesntAllowNullReader() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFEntryWriter writer = new LDIFEntryWriter(actual);
        LDIF.copyTo(null, (EntryWriter)writer);
    }

    @Test
    public final void testLdifDiffEntriesModsOnSameDN() throws Exception {
        LDIFEntryReader source = new LDIFEntryReader(new String[]{"dn: uid=newuser,ou=People,dc=example,dc=com", "uid: newuser", "objectClass: person", "objectClass: organizationalPerson", "objectClass: inetOrgPerson", "objectClass: top", "cn: New User", "sn: User", "ou: People", "mail: newuser@example.com", "userPassword: changeme"});
        LDIFEntryReader target = new LDIFEntryReader(new String[]{"dn: uid=newuser,ou=People,dc=example,dc=com", "uid: newuser", "objectClass: person", "objectClass: organizationalPerson", "objectClass: inetOrgPerson", "objectClass: top", "cn: New User", "sn: User", "ou: People", "mail: newuser@example.com", "userPassword: secret12", "description: A new description."});
        ChangeRecordReader reader = LDIF.diff((EntryReader)source, (EntryReader)target);
        ChangeRecord cr = reader.readChangeRecord();
        Assertions.assertThat((String)cr.getName().toString()).isEqualTo((Object)"uid=newuser,ou=People,dc=example,dc=com");
        Assertions.assertThat((Object)cr).isInstanceOf(ModifyRequest.class);
        Assertions.assertThat((int)((ModifyRequest)cr).getModifications().size()).isEqualTo(3);
        for (Modification mod : ((ModifyRequest)cr).getModifications()) {
            String attrDescription = mod.getAttribute().getAttributeDescription().toString();
            String firstValueAsString = mod.getAttribute().firstValueAsString();
            if (mod.getModificationType() == ModificationType.ADD) {
                Assertions.assertThat((String)attrDescription).isIn(new Object[]{"description", "userPassword"});
                Assertions.assertThat((String)firstValueAsString).isIn(new Object[]{"A new description.", "secret12"});
                continue;
            }
            if (mod.getModificationType() != ModificationType.DELETE) continue;
            Assertions.assertThat((String)attrDescription).isEqualTo((Object)"userPassword");
            Assertions.assertThat((String)firstValueAsString).isEqualTo((Object)"changeme");
        }
        reader.close();
        target.close();
    }

    @Test
    public final void testLdifDiffEntriesEntryInSourceNotInTarget() throws Exception {
        LDIFEntryReader source = new LDIFEntryReader(new String[]{"dn: uid=newuser,ou=People,dc=example,dc=com", "cn: New User"});
        LDIFEntryReader target = new LDIFEntryReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "cn: Samantha Carter"});
        ChangeRecordReader reader = LDIF.diff((EntryReader)source, (EntryReader)target);
        ChangeRecord cr = reader.readChangeRecord();
        Assertions.assertThat((String)cr.getName().toString()).isEqualTo((Object)"uid=newuser,ou=People,dc=example,dc=com");
        Assertions.assertThat((Object)cr).isInstanceOf(DeleteRequest.class);
        cr = reader.readChangeRecord();
        Assertions.assertThat((String)cr.getName().toString()).isEqualTo((Object)"uid=scarter,ou=People,dc=example,dc=com");
        Assertions.assertThat((Object)cr).isInstanceOf(AddRequest.class);
        Assertions.assertThat((int)((AddRequest)cr).getAttributeCount()).isEqualTo(1);
        Assertions.assertThat((String)((AddRequest)cr).getAttribute("cn").firstValueAsString()).isEqualTo((Object)"Samantha Carter");
        reader.close();
        target.close();
    }

    @Test
    public final void testLdifDiffEntriesEntryInTargetNotInSource() throws Exception {
        LDIFEntryReader source = new LDIFEntryReader(new String[]{"dn: uid=scarter,dc=example,dc=com", "cn: Samantha Carter"});
        LDIFEntryReader target = new LDIFEntryReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "cn: Samantha Carter"});
        ChangeRecordReader reader = LDIF.diff((EntryReader)source, (EntryReader)target);
        ChangeRecord cr = reader.readChangeRecord();
        Assertions.assertThat((String)cr.getName().toString()).isEqualTo((Object)"uid=scarter,ou=People,dc=example,dc=com");
        Assertions.assertThat((Object)cr).isInstanceOf(AddRequest.class);
        Assertions.assertThat((int)((AddRequest)cr).getAttributeCount()).isEqualTo(1);
        Assertions.assertThat((String)((AddRequest)cr).getAttribute("cn").firstValueAsString()).isEqualTo((Object)"Samantha Carter");
        cr = reader.readChangeRecord();
        Assertions.assertThat((String)cr.getName().toString()).isEqualTo((Object)"uid=scarter,dc=example,dc=com");
        Assertions.assertThat((Object)cr).isInstanceOf(DeleteRequest.class);
        reader.close();
        source.close();
        target.close();
    }

    @Test
    public final void testLdifDiffEntriesNoDiff() throws Exception {
        LDIFEntryReader source = new LDIFEntryReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "cn: Samantha Carter"});
        LDIFEntryReader target = new LDIFEntryReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "cn: Samantha Carter"});
        ChangeRecordReader reader = LDIF.diff((EntryReader)source, (EntryReader)target);
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        ChangeRecord cr = reader.readChangeRecord();
        Assertions.assertThat((String)cr.getName().toString()).isEqualTo((Object)"uid=scarter,ou=People,dc=example,dc=com");
        Assertions.assertThat((boolean)(cr instanceof ModifyRequest));
        Assertions.assertThat((List)((ModifyRequest)cr).getModifications()).isEmpty();
        reader.close();
        target.close();
    }

    @Test
    public final void testLdifDiffEntriesShortExamples() throws Exception {
        LDIFEntryReader source = new LDIFEntryReader(new String[]{"dn: uid=user.0,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "objectClass: organizationalperson", "objectClass: inetorgperson", "givenName: Aaccf", "sn: Amar", "cn: Aaccf Amar", "initials: APA", "employeeNumber: 0", "uid: user.0", "mail: user.0@example.com", "description: This is the description for Aaccf Amar.", "", "dn: uid=user.1,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "objectClass: organizationalperson", "objectClass: inetorgperson", "givenName: Aaren", "sn: Atp", "cn: Aaren Atp", "initials: AFA", "employeeNumber: 1", "uid: user.1", "mail: user.1@example.com", "description: This is the description for Aaren Atp.", "", "dn: uid=user.2,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "objectClass: organizationalperson", "objectClass: inetorgperson", "givenName: Aarika", "sn: Atpco", "cn: Aarika Atpco", "initials: AVA", "employeeNumber: 2", "uid: user.2", "mail: user.2@example.com", "description: This is the description for Aarika Atpco.", "", "dn: uid=user.3,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "objectClass: organizationalperson", "objectClass: inetorgperson", "givenName: Aaron", "sn: Atrc", "cn: Aaron Atrc", "initials: ATA", "employeeNumber: 3", "uid: user.3", "mail: user.3@example.com", "description: This is the description for Aaron Atrc.", "", "dn: uid=user.4,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "objectClass: organizationalperson", "objectClass: inetorgperson", "givenName: Aartjan", "sn: Aalders", "cn: Aartjan Aalders", "initials: AAA", "employeeNumber: 4", "uid: user.4", "mail: user.4@example.com", "description: This is the description for Aartjan Aalders."});
        LDIFEntryReader target = new LDIFEntryReader(new String[]{"dn: uid=user.0,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "objectClass: organizationalperson", "objectClass: inetorgperson", "givenName: Amar", "sn: Amar", "cn: Aaccf Amar", "initials: APA", "employeeNumber: 55", "uid: user.0", "mail: user.0@example.com", "description: This is the description for Aaccf Amar.", "work-phone: 650/506-0666", "", "dn: uid=user.1,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "objectClass: organizationalperson", "objectClass: inetorgperson", "givenName: Aaren", "sn: Atp", "cn: Aaren Atp", "initials: AFA", "employeeNumber: 1", "uid: user.1", "mail: aaren@example.com", "description: This is the description for Aaren Atp.", "", "dn: uid=user.2,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "objectClass: organizationalperson", "objectClass: inetorgperson", "givenName: Aarika", "sn: Atpco", "cn: Aarika Atpco", "initials: AVA", "employeeNumber: 2", "uid: user.2", "mail: user.2@example.com", "", "dn: uid=user.3,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "objectClass: organizationalperson", "objectClass: inetorgperson", "givenName: Aaron", "sn: Atrc", "cn: Aaron Atrc", "initials: ATA", "employeeNumber: 3", "uid: user.999", "mail: user.999@example.com", "description: This is the description for Aaron Atrc.", "", "dn: uid=user.4,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "objectClass: organizationalperson", "objectClass: inetorgperson", "givenName: Aartjan", "sn: Aalders", "cn: Aartjan Aalders", "initials: AAA", "employeeNumber: 4", "uid: user.4", "mail: user.4@example.com", "description: This is the description for Aartjan Aalders."});
        ChangeRecordReader reader = LDIF.diff((EntryReader)source, (EntryReader)target);
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        ChangeRecord cr = reader.readChangeRecord();
        Assertions.assertThat((String)cr.getName().toString()).isEqualTo((Object)"uid=user.0,ou=People,dc=example,dc=com");
        Assertions.assertThat((boolean)(cr instanceof ModifyRequest));
        Assertions.assertThat((List)((ModifyRequest)cr).getModifications()).isNotEmpty();
        Assertions.assertThat((int)((ModifyRequest)cr).getModifications().size()).isEqualTo(5);
        cr = reader.readChangeRecord();
        Assertions.assertThat((String)cr.getName().toString()).isEqualTo((Object)"uid=user.1,ou=People,dc=example,dc=com");
        Assertions.assertThat((boolean)(cr instanceof ModifyRequest));
        Assertions.assertThat((int)((ModifyRequest)cr).getModifications().size()).isEqualTo(2);
        cr = reader.readChangeRecord();
        Assertions.assertThat((String)cr.getName().toString()).isEqualTo((Object)"uid=user.2,ou=People,dc=example,dc=com");
        Assertions.assertThat((boolean)(cr instanceof ModifyRequest));
        Assertions.assertThat((int)((ModifyRequest)cr).getModifications().size()).isEqualTo(1);
        Assertions.assertThat((String)((Modification)((ModifyRequest)cr).getModifications().get(0)).getModificationType().toString()).isEqualTo((Object)"delete");
        Assertions.assertThat((String)((Modification)((ModifyRequest)cr).getModifications().get(0)).getAttribute().getAttributeDescriptionAsString()).isEqualTo((Object)"description");
        cr = reader.readChangeRecord();
        Assertions.assertThat((String)cr.getName().toString()).isEqualTo((Object)"uid=user.3,ou=People,dc=example,dc=com");
        Assertions.assertThat((boolean)(cr instanceof ModifyRequest));
        Assertions.assertThat((int)((ModifyRequest)cr).getModifications().size()).isEqualTo(4);
        cr = reader.readChangeRecord();
        Assertions.assertThat((String)cr.getName().toString()).isEqualTo((Object)"uid=user.4,ou=People,dc=example,dc=com");
        Assertions.assertThat((boolean)(cr instanceof ModifyRequest));
        Assertions.assertThat((int)((ModifyRequest)cr).getModifications().size()).isEqualTo(0);
        Assertions.assertThat((boolean)reader.hasNext()).isFalse();
        reader.close();
        target.close();
    }

    @Test
    public final void testLdifDiffEntriesNoDiffBase64() throws Exception {
        LDIFEntryReader source = new LDIFEntryReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "cn: Samantha Carter"});
        LDIFEntryReader target = new LDIFEntryReader(new String[]{"dn:: dWlkPXNjYXJ0ZXIsb3U9UGVvcGxlLGRjPWV4YW1wbGUsZGM9Y29t", "cn: Samantha Carter"});
        ChangeRecordReader reader = LDIF.diff((EntryReader)source, (EntryReader)target);
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        ChangeRecord cr = reader.readChangeRecord();
        Assertions.assertThat((String)cr.getName().toString()).isEqualTo((Object)"uid=scarter,ou=People,dc=example,dc=com");
        Assertions.assertThat((boolean)(cr instanceof ModifyRequest));
        Assertions.assertThat((List)((ModifyRequest)cr).getModifications()).isEmpty();
        reader.close();
        target.close();
    }

    @Test(expectedExceptions={DecodeException.class})
    public final void testLdifDiffEntriesNoDiffMalformedTarget() throws Exception {
        LDIFEntryReader source = new LDIFEntryReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com"});
        LDIFEntryReader target = new LDIFEntryReader(new String[]{"dn: wrongRDN"});
        LDIF.diff((EntryReader)source, (EntryReader)target);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public final void testLdifDiffEntriesDoesntAllowNull() throws Exception {
        LDIF.diff(null, null);
    }

    @Test
    public final void testLdifPatchAddNoDiff() throws Exception {
        LDIFEntryReader input = new LDIFEntryReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "objectClass: person", "sn: new user", "mail: mail@mailme.org"});
        LDIFChangeRecordReader patch = new LDIFChangeRecordReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "changetype: add", "objectClass: person", "sn: new user", "mail: mail@mailme.org"});
        EntryReader reader = LDIF.patch((EntryReader)input, (ChangeRecordReader)patch);
        Entry entry = reader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=scarter,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(3);
        Assertions.assertThat((boolean)reader.hasNext()).isFalse();
        reader.close();
    }

    @Test
    public final void testLdifPatchAddDiff() throws Exception {
        LDIFEntryReader input = new LDIFEntryReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "objectClass: person", "sn: new user", "mail: mail@mailme.org"});
        LDIFChangeRecordReader patch = new LDIFChangeRecordReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "changetype: add", "add: manager", "manager: uid=joneill,ou=People,dc=example,dc=com", "objectClass: person", "sn: new user", "mail: mail@mailme.org"});
        EntryReader reader = LDIF.patch((EntryReader)input, (ChangeRecordReader)patch);
        Entry entry = reader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=scarter,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(5);
        Assertions.assertThat((boolean)reader.hasNext()).isFalse();
        reader.close();
    }

    @Test
    public final void testLdifPatchAddDiffNewEntry() throws Exception {
        LDIFEntryReader input = new LDIFEntryReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "objectClass: person", "sn: new user", "mail: mail@mailme.org"});
        LDIFChangeRecordReader patch = new LDIFChangeRecordReader(new String[]{"dn: uid=joneill,ou=People,dc=example,dc=com", "changetype: add", "add: manager", "manager: uid=hamond,ou=People,dc=example,dc=com", "objectClass: person", "sn: new user", "mail: mail@mailme.org", "", "dn: uid=djackson,ou=People,dc=example,dc=com", "changetype: add", "add: manager", "manager: uid=joneill,ou=People,dc=example,dc=com", "objectClass: person", "sn: new user", "mail: mail@mailme.org"});
        EntryReader reader = LDIF.patch((EntryReader)input, (ChangeRecordReader)patch);
        Entry entry = reader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=djackson,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(5);
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        entry = reader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=joneill,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(5);
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        entry = reader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=scarter,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(3);
        reader.close();
    }

    @Test
    public final void testLdifPatchAddModifyNonExistantEntryDoNothing() throws Exception {
        LDIFEntryReader input = new LDIFEntryReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "objectClass: person", "sn: new user", "mail: mail@mailme.org"});
        LDIFChangeRecordReader patch = new LDIFChangeRecordReader(new String[]{"dn: cn=Lisa Jangles,ou=People,dc=example,dc=com", "changetype: modify", "add: telephonenumber", "telephonenumber: (408) 555-2468"});
        EntryReader reader = LDIF.patch((EntryReader)input, (ChangeRecordReader)patch);
        Entry entry = reader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=scarter,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(3);
        Assertions.assertThat((boolean)reader.hasNext()).isFalse();
        reader.close();
    }

    @Test
    public final void testLdifPatchDeleteEntry() throws Exception {
        LDIFEntryReader input = new LDIFEntryReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "objectClass: person", "sn: new user", "mail: mail@mailme.org"});
        LDIFChangeRecordReader patch = new LDIFChangeRecordReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "changetype: delete"});
        EntryReader reader = LDIF.patch((EntryReader)input, (ChangeRecordReader)patch);
        Assertions.assertThat((boolean)reader.hasNext()).isFalse();
        reader.close();
    }

    @Test
    public final void testLdifPatchDeleteEntryAmongSeveral() throws Exception {
        LDIFEntryReader input = new LDIFEntryReader(new String[]{"dn: uid=user.1,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "objectClass: organizationalperson", "objectClass: inetorgperson", "givenName: Aarika", "sn: Atpco", "cn: Aarika Atpco", "uid: user.1", "", "dn: uid=user.2,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "objectClass: organizationalperson", "objectClass: inetorgperson", "givenName: Eniko", "sn: Eniko", "cn: Eniko Atpco", "uid: user.2", "", "dn: uid=user.3,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "objectClass: organizationalperson", "objectClass: inetorgperson", "givenName: Aaron", "sn: Atrc", "cn: Aaron Atrc", "uid: user.3"});
        LDIFChangeRecordReader patch = new LDIFChangeRecordReader(new String[]{"dn: uid=user.2,ou=People,dc=example,dc=com", "changetype: delete"});
        EntryReader reader = LDIF.patch((EntryReader)input, (ChangeRecordReader)patch);
        Entry entry = reader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=user.1,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(5);
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        entry = reader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=user.3,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(5);
        Assertions.assertThat((boolean)reader.hasNext()).isFalse();
        reader.close();
    }

    @Test
    public final void testLdifPatchDeleteAttributesEntry() throws Exception {
        LDIFEntryReader input = new LDIFEntryReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "objectClass: organizationalperson", "objectClass: inetorgperson", "givenName: Carter", "sn: Sam", "cn: Sam Carter", "uid: scarter", "mail: user.1@mail.com", "postalAdress: 42 Shepherd Street", "work-phone: 650/506-7000", "work-phone: 650/506-0666", "home-fax: 650-7001"});
        LDIFChangeRecordReader patch = new LDIFChangeRecordReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "changetype: modify", "delete: work-phone", "work-phone: 650/506-0666", "-", "delete: home-fax"});
        EntryReader reader = LDIF.patch((EntryReader)input, (ChangeRecordReader)patch);
        Entry entry = reader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=scarter,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(8);
        Assertions.assertThat((String)entry.getAttribute("work-phone").firstValueAsString()).isEqualTo((Object)"650/506-7000");
        Assertions.assertThat((boolean)reader.hasNext()).isFalse();
        reader.close();
    }

    @Test
    public final void testLdifPatchModifyEntry() throws Exception {
        LDIFEntryReader input = new LDIFEntryReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "objectClass: person", "sn: new user", "mail: mail@mailme.org"});
        LDIFChangeRecordReader patch = new LDIFChangeRecordReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "changetype: modify", "add: work-phone", "work-phone: 650/506-7000"});
        EntryReader reader = LDIF.patch((EntryReader)input, (ChangeRecordReader)patch);
        Entry entry = reader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=scarter,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(4);
        Assertions.assertThat((boolean)reader.hasNext()).isFalse();
        reader.close();
    }

    @Test
    public final void testLdifPatchModifyDNEntryUppercaseUid() throws Exception {
        LDIFEntryReader input = new LDIFEntryReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "objectClass: person", "sn: new user", "mail: mail@mailme.org", "uid: scarter", "", "dn: uid=djackson,ou=People,dc=example,dc=com", "objectClass: person", "sn: new user", "mail: mail@mailme.org", "uid: djackson"});
        LDIFChangeRecordReader patch = new LDIFChangeRecordReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "changetype: modrdn", "newrdn: uid=Scarter", "deleteoldrdn: 1"});
        EntryReader reader = LDIF.patch((EntryReader)input, (ChangeRecordReader)patch);
        Entry entry = reader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=djackson,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(4);
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        entry = reader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=Scarter,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(4);
        Assertions.assertThat((boolean)reader.hasNext()).isFalse();
        reader.close();
    }

    @Test
    public final void testLdifPatchModifyDNEntryUpperCaseDnNameSurname() throws Exception {
        LDIFEntryReader input = new LDIFEntryReader(new String[]{"dn: cn=sam carter,ou=People,dc=example,dc=com", "objectClass: person", "sn: new user", "mail: mail@mailme.org", "uid: scarter", "", "dn: uid=djackson,ou=People,dc=example,dc=com", "objectClass: person", "sn: new user", "mail: mail@mailme.org", "uid: djackson"});
        LDIFChangeRecordReader patch = new LDIFChangeRecordReader(new String[]{"dn: cn=sam carter,ou=People,dc=example,dc=com", "changetype: modrdn", "newrdn: cn=Sam Carter", "deleteoldrdn: 1"});
        EntryReader reader = LDIF.patch((EntryReader)input, (ChangeRecordReader)patch);
        Entry entry = reader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"cn=Sam Carter,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(5);
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        entry = reader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=djackson,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(4);
        Assertions.assertThat((boolean)reader.hasNext()).isFalse();
        reader.close();
    }

    @Test
    public final void testLdifPatchModifyDNEntry() throws Exception {
        LDIFEntryReader input = new LDIFEntryReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "objectClass: person", "sn: new user", "mail: mail@mailme.org", "uid: scarter", "", "dn: uid=djackson,ou=People,dc=example,dc=com", "objectClass: person", "sn: new user", "mail: mail@mailme.org", "uid: djackson"});
        LDIFChangeRecordReader patch = new LDIFChangeRecordReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "changetype: modrdn", "newrdn: uid=Susan Jacobs", "deleteoldrdn: 1"});
        EntryReader reader = LDIF.patch((EntryReader)input, (ChangeRecordReader)patch);
        Entry entry = reader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=djackson,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(4);
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        entry = reader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=Susan Jacobs,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(4);
        Assertions.assertThat((boolean)reader.hasNext()).isFalse();
        reader.close();
    }

    @Test
    public final void testLdifPatchModifyDnEntry2() throws Exception {
        LDIFEntryReader input = new LDIFEntryReader(new String[]{"dn: uid=user.1,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "objectClass: organizationalperson", "objectClass: inetorgperson", "givenName: Aarika", "sn: Atpco", "cn: Aarika Atpco", "uid: user.1", "", "dn: uid=user.2,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "objectClass: organizationalperson", "objectClass: inetorgperson", "givenName: Eniko", "sn: Eniko", "cn: Eniko Atpco", "uid: user.2", "", "dn: uid=user.3,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "objectClass: organizationalperson", "objectClass: inetorgperson", "givenName: Aaron", "sn: Atrc", "cn: Aaron Atrc", "uid: user.3"});
        LDIFChangeRecordReader patch = new LDIFChangeRecordReader(new String[]{"dn: uid=user.2,ou=People,dc=example,dc=com", "changetype: modrdn", "newrdn: uid=user.22", "deleteoldrdn: 1"});
        EntryReader reader = LDIF.patch((EntryReader)input, (ChangeRecordReader)patch);
        Entry entry = reader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=user.1,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(5);
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        entry = reader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=user.22,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(5);
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        entry = reader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=user.3,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(5);
        Assertions.assertThat((boolean)reader.hasNext()).isFalse();
        reader.close();
    }

    @Test
    public final void testLdifPatchModifyDnEntryBranch() throws Exception {
        LDIFEntryReader input = new LDIFEntryReader(new String[]{"dn: ou=People,dc=example,dc=com", "objectClass: top", "objectClass: organizationalunit", "ou: People", "", "dn: uid=user.1,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "objectClass: organizationalperson", "objectClass: inetorgperson", "givenName: Aarika", "sn: Atpco", "cn: Aarika Atpco", "uid: user.1", "", "dn: uid=user.2,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "objectClass: organizationalperson", "objectClass: inetorgperson", "givenName: Eniko", "sn: Eniko", "cn: Eniko Atpco", "uid: user.2", "", "dn: uid=user.3,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "objectClass: organizationalperson", "objectClass: inetorgperson", "givenName: Aaron", "sn: Atrc", "cn: Aaron Atrc", "uid: user.3", "", "dn: uid=user.4,ou=People,dc=example,dc=org", "objectClass: top", "objectClass: person", "objectClass: organizationalperson", "objectClass: inetorgperson", "givenName: Allan", "sn: Zorg", "cn: Allan Zorg", "uid: user.4"});
        LDIFChangeRecordReader patch = new LDIFChangeRecordReader(new String[]{"dn: ou=People,dc=example,dc=com", "changetype: modrdn", "newrdn: ou=Human Resources", "deleteoldrdn: 1"});
        EntryReader reader = LDIF.patch((EntryReader)input, (ChangeRecordReader)patch);
        Entry entry = reader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"ou=Human Resources,dc=example,dc=com");
        Assertions.assertThat((String)((Attribute)entry.getAllAttributes("ou").iterator().next()).firstValueAsString()).isEqualTo((Object)"Human Resources");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(2);
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        entry = reader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=user.1,ou=Human Resources,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(5);
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        entry = reader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=user.2,ou=Human Resources,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(5);
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        entry = reader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=user.3,ou=Human Resources,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(5);
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        entry = reader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=user.4,ou=People,dc=example,dc=org");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(5);
        Assertions.assertThat((boolean)reader.hasNext()).isFalse();
        reader.close();
    }

    @Test
    public final void testLdifPatchModifyDnEntryBranchKeepsOldRdn() throws Exception {
        LDIFEntryReader input = new LDIFEntryReader(new String[]{"dn: ou=People,dc=example,dc=com", "objectClass: top", "objectClass: organizationalunit", "ou: People", "", "dn: uid=user.1,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "objectClass: organizationalperson", "objectClass: inetorgperson", "givenName: Aarika", "sn: Atpco", "cn: Aarika Atpco", "uid: user.1", "", "dn: uid=user.2,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "objectClass: organizationalperson", "objectClass: inetorgperson", "givenName: Eniko", "sn: Eniko", "cn: Eniko Atpco", "uid: user.2", "", "dn: uid=user.3,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "objectClass: organizationalperson", "objectClass: inetorgperson", "givenName: Aaron", "sn: Atrc", "cn: Aaron Atrc", "uid: user.3", "", "dn: uid=user.4,ou=People,dc=example,dc=org", "objectClass: top", "objectClass: person", "objectClass: organizationalperson", "objectClass: inetorgperson", "givenName: Allan", "sn: Zorg", "cn: Allan Zorg", "uid: user.4"});
        LDIFChangeRecordReader patch = new LDIFChangeRecordReader(new String[]{"dn: ou=People,dc=example,dc=com", "changetype: modrdn", "newrdn: ou=Human Resources", "deleteoldrdn: 0"});
        EntryReader reader = LDIF.patch((EntryReader)input, (ChangeRecordReader)patch);
        Entry entry = reader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"ou=Human Resources,dc=example,dc=com");
        Assertions.assertThat((String)((Attribute)entry.getAllAttributes("ou").iterator().next()).firstValueAsString()).isEqualTo((Object)"People");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(2);
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        entry = reader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=user.1,ou=Human Resources,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(5);
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        entry = reader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=user.2,ou=Human Resources,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(5);
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        entry = reader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=user.3,ou=Human Resources,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(5);
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        entry = reader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=user.4,ou=People,dc=example,dc=org");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(5);
        Assertions.assertThat((boolean)reader.hasNext()).isFalse();
        reader.close();
    }

    @Test
    public final void testLdifPatchModifyDnEntryNewSuperior() throws Exception {
        LDIFEntryReader input = new LDIFEntryReader(new String[]{"dn: uid=user.1,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "objectClass: organizationalperson", "objectClass: inetorgperson", "givenName: Aarika", "sn: Atpco", "cn: Aarika Atpco", "uid: user.1", "mail: user.1@mail.com", "", "dn: uid=user.2,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "objectClass: organizationalperson", "objectClass: inetorgperson", "givenName: Eniko", "sn: Eniko", "cn: Eniko Atpco", "uid: user.2"});
        LDIFChangeRecordReader patch = new LDIFChangeRecordReader(new String[]{"# moves the entry from ou=People, dc=example,dc=com to Marketing", "dn: uid=user.1,ou=People,dc=example,dc=com", "changetype: modrdn", "newrdn: uid=user.1", "deleteoldrdn: 1", "newsuperior: ou=Marketing,dc=example,dc=com"});
        EntryReader reader = LDIF.patch((EntryReader)input, (ChangeRecordReader)patch);
        Entry entry = reader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=user.1,ou=Marketing,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(6);
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        entry = reader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=user.2,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(5);
        Assertions.assertThat((boolean)reader.hasNext()).isFalse();
        reader.close();
    }

    @Test
    public final void testLdifPatchAddReplace() throws Exception {
        LDIFEntryReader input = new LDIFEntryReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "objectClass: person", "sn: new user", "mail: mail@mailme.org"});
        LDIFChangeRecordReader patch = new LDIFChangeRecordReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "changetype: modify", "replace:sn", "sn: scarter", "-", "add: manager", "manager: uid=joneill,ou=People,dc=example,dc=com"});
        EntryReader reader = LDIF.patch((EntryReader)input, (ChangeRecordReader)patch);
        Entry entry = reader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=scarter,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(4);
        Assertions.assertThat((String)entry.getAttribute("manager").firstValueAsString()).isEqualTo((Object)"uid=joneill,ou=People,dc=example,dc=com");
        Assertions.assertThat((boolean)reader.hasNext()).isFalse();
        reader.close();
    }

    @Test
    public final void testLdifPatchAddReplaceLanguageTagExample() throws Exception {
        LDIFEntryReader input = new LDIFEntryReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "objectClass: person", "sn: new user", "mail: mail@mailme.org", "postalAdress;lang-en: Shepherd Street"});
        LDIFChangeRecordReader patch = new LDIFChangeRecordReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "changetype: modify", "replace: postalAdress;lang-fr", "postalAdress;lang-fr: 355 avenue Leon Blum", "-", "replace: postalAdress;lang-en", "postalAdress;lang-en: 42 Shepherd Street"});
        EntryReader reader = LDIF.patch((EntryReader)input, (ChangeRecordReader)patch);
        Entry entry = reader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=scarter,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(5);
        Assertions.assertThat((String)entry.getAttribute("postalAdress;lang-fr").firstValueAsString()).isEqualTo((Object)"355 avenue Leon Blum");
        Assertions.assertThat((String)entry.getAttribute("postalAdress;lang-en").firstValueAsString()).isEqualTo((Object)"42 Shepherd Street");
        Assertions.assertThat((boolean)reader.hasNext()).isFalse();
        reader.close();
    }

    @Test
    public final void testLdifPatchVariousChanges() throws Exception {
        LDIFEntryReader input = new LDIFEntryReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "objectClass: person", "sn: new user", "mail: mail@mailme.org", "", "dn: uid=user.0,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "objectClass: organizationalperson", "objectClass: inetorgperson", "givenName: Aaccf", "sn: Amar", "cn: Aaccf Amar", "", "dn: uid=user.1,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "objectClass: organizationalperson", "objectClass: inetorgperson", "givenName: Aaren", "sn: Atp", "cn: Aaren Atp", "mail: AarenAtp@mail.org", "", "dn: uid=user.2,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "objectClass: organizationalperson", "objectClass: inetorgperson", "givenName: Aarika", "sn: Atpco", "cn: Aarika Atpco", "description:: ZnVubnkgZGVzY3JpcHRpb24gISA6RA==", "mail:: QWFyaWthQXRwY29AbWFpbC5vcmc=", "", "dn: uid=user.3,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "objectClass: organizationalperson", "objectClass: inetorgperson", "givenName: Kadja", "sn: Atpcol", "cn: Kadja Atpcol"});
        File file = File.createTempFile("sdk", ".png");
        String url = file.toURI().toURL().toString();
        LDIFChangeRecordReader patch = new LDIFChangeRecordReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "changetype: modify", "replace:sn", "sn: scarter", "-", "add: manager", "manager: uid=joneill,ou=People,dc=example,dc=com", "", "dn: uid=user.2,ou=People,dc=example,dc=com", "changetype: modify", "replace:description", "description:: QWFyaWthIEF0cGNvIGRlc2NyaXB0aW9uIDogbG9yZW0gaXBzdW0uLi4=", "-", "add: jpegphoto", "jpegphoto:< " + url, "", "dn: uid=user.3,ou=People,dc=example,dc=com", "changetype: delete"});
        EntryReader reader = LDIF.patch((EntryReader)input, (ChangeRecordReader)patch);
        Entry entry = reader.readEntry();
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(4);
        Assertions.assertThat((String)entry.getAttribute("manager").firstValueAsString()).isEqualTo((Object)"uid=joneill,ou=People,dc=example,dc=com");
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        entry = reader.readEntry();
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(4);
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=user.0,ou=People,dc=example,dc=com");
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        entry = reader.readEntry();
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(5);
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=user.1,ou=People,dc=example,dc=com");
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        entry = reader.readEntry();
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(7);
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=user.2,ou=People,dc=example,dc=com");
        Assertions.assertThat((String)entry.getAttribute("mail").firstValueAsString()).isEqualTo((Object)"AarikaAtpco@mail.org");
        Assertions.assertThat((String)entry.getAttribute("description").firstValueAsString()).isEqualTo((Object)"Aarika Atpco description : lorem ipsum...");
        Assertions.assertThat((Collection)entry.getAttribute("jpegphoto")).isNotEmpty();
        Assertions.assertThat((boolean)reader.hasNext()).isFalse();
        file.delete();
        reader.close();
    }

    @Test
    public final void testLdifPatchContainingChanges() throws Exception {
        LDIFEntryReader input = new LDIFEntryReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "objectClass: person", "sn: new user", "mail: mail@mailme.org", "", "dn: uid=user.0,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "objectClass: organizationalperson", "objectClass: inetorgperson", "givenName: Aaccf", "sn: Amar", "cn: Aaccf Amar", "", "dn: uid=user.1,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "objectClass: organizationalperson", "objectClass: inetorgperson", "givenName: Aaren", "sn: Atp", "cn: Aaren Atp", "", "dn: uid=user.2,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "objectClass: organizationalperson", "objectClass: inetorgperson", "givenName: Aarika", "sn: Atpco", "cn: Aarika Atpco"});
        LDIFChangeRecordReader patch = new LDIFChangeRecordReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "changetype: modify", "replace:sn", "sn: scarter", "-", "add: manager", "manager: uid=joneill,ou=People,dc=example,dc=com", "", "dn: uid=user.0,ou=People,dc=example,dc=com", "changetype: modify", "replace:sn", "sn: Amarr", "-", "delete: givenName", "", "dn: uid=user.1,ou=People,dc=example,dc=com", "changetype: modify", "replace:givenName", "givenName: Aarwen", "-", "add: manager", "manager: uid=joneill,ou=People,dc=example,dc=com", "-", "add: mail", "mail: Aarwen@mail.com", "-", "add: fax", "fax: 555 555-5555", "-", "add: description", "description:: QWFyd2VuIGRlc2NyaXB0aW9uLg=="});
        EntryReader reader = LDIF.patch((EntryReader)input, (ChangeRecordReader)patch);
        Entry entry = reader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=scarter,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(4);
        Assertions.assertThat((String)entry.getAttribute("manager").firstValueAsString()).isEqualTo((Object)"uid=joneill,ou=People,dc=example,dc=com");
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        entry = reader.readEntry();
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(3);
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        entry = reader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=user.1,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(8);
        Assertions.assertThat((String)entry.getAttribute("description").firstValueAsString()).isEqualTo((Object)"Aarwen description.");
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        entry = reader.readEntry();
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=user.2,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(4);
        Assertions.assertThat((boolean)reader.hasNext()).isFalse();
        reader.close();
    }

    @Test(expectedExceptions={DecodeException.class})
    public final void testLdifPatchInvalidChangeRecord() throws Exception {
        LDIFEntryReader input = new LDIFEntryReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "objectClass: person", "sn: new user", "mail: mail@mailme.org"});
        LDIFChangeRecordReader patch = new LDIFChangeRecordReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "changetype: modif\u0000", "replace:sn", "sn: scarter", "-", "add: manager\u0000", "manager: uid=joneill,ou=People,dc=example,dc=com"});
        try (EntryReader reader = LDIF.patch((EntryReader)input, (ChangeRecordReader)patch);){
            reader.readEntry();
        }
    }

    @Test(expectedExceptions={DecodeException.class})
    public final void testFailFastPatchOnModifyRequestFailsDueToWrongDN() throws Exception {
        RejectedChangeRecordListener listener = RejectedChangeRecordListener.FAIL_FAST;
        LDIFEntryReader input = new LDIFEntryReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "objectClass: person", "sn: new user", "mail: mail@mailme.org"});
        LDIFChangeRecordReader patch = new LDIFChangeRecordReader(new String[]{"dn: uid=WRONGUID,ou=People,dc=example,dc=com", "changetype: modify", "add: work-phone", "work-phone: 650/506-7000"});
        EntryReader reader = LDIF.patch((EntryReader)input, (ChangeRecordReader)patch, (RejectedChangeRecordListener)listener);
        Throwable throwable = null;
        if (reader != null) {
            if (throwable != null) {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                reader.close();
            }
        }
    }

    @Test
    public final void testOverwritePatchOnModifyRequestSucceedsEvenIfWrongDN() throws Exception {
        RejectedChangeRecordListener listener = RejectedChangeRecordListener.OVERWRITE;
        LDIFEntryReader input = new LDIFEntryReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "objectClass: person", "sn: new user", "mail: mail@mailme.org"});
        LDIFChangeRecordReader patch = new LDIFChangeRecordReader(new String[]{"dn: uid=WRONGUID,ou=People,dc=example,dc=com", "changetype: modify", "add: work-phone", "work-phone: 650/506-7000"});
        try (EntryReader reader = LDIF.patch((EntryReader)input, (ChangeRecordReader)patch, (RejectedChangeRecordListener)listener);){
            Entry entry = reader.readEntry();
            Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=scarter,ou=People,dc=example,dc=com");
            Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(3);
            Assertions.assertThat((String)entry.getAttribute("objectClass").firstValueAsString()).isEqualTo((Object)"person");
            Assertions.assertThat((String)entry.getAttribute("sn").firstValueAsString()).isEqualTo((Object)"new user");
            Assertions.assertThat((String)entry.getAttribute("mail").firstValueAsString()).isEqualTo((Object)"mail@mailme.org");
            Assertions.assertThat((boolean)reader.hasNext()).isFalse();
            Assertions.assertThat((Collection)entry.getAttribute("work-phone")).isNull();
        }
    }

    @Test(expectedExceptions={DecodeException.class})
    public final void testFailFastPatchOnModifyDNRequestFailsDueToWrongDN() throws Exception {
        RejectedChangeRecordListener listener = RejectedChangeRecordListener.FAIL_FAST;
        LDIFEntryReader input = new LDIFEntryReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "objectClass: person", "sn: new user", "mail: mail@mailme.org"});
        LDIFChangeRecordReader patch = new LDIFChangeRecordReader(new String[]{"dn: ou=WRONGscarter, dc=example,dc=com", "changetype: modrdn", "newrdn: ou=Human Resources,dc=example,dc=com", "deleteoldrdn: 1"});
        EntryReader reader = LDIF.patch((EntryReader)input, (ChangeRecordReader)patch, (RejectedChangeRecordListener)listener);
        Throwable throwable = null;
        if (reader != null) {
            if (throwable != null) {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                reader.close();
            }
        }
    }

    @Test
    public final void testOverwritePatchOnModifyDNRequestSucceedsEvenWithWrongDN() throws Exception {
        RejectedChangeRecordListener listener = RejectedChangeRecordListener.OVERWRITE;
        LDIFEntryReader input = new LDIFEntryReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "objectClass: person", "sn: new user", "mail: mail@mailme.org"});
        LDIFChangeRecordReader patch = new LDIFChangeRecordReader(new String[]{"dn: ou=WRONGscarter, dc=example,dc=com", "changetype: modrdn", "newrdn: ou=Human Resources", "deleteoldrdn: 1"});
        try (EntryReader reader = LDIF.patch((EntryReader)input, (ChangeRecordReader)patch, (RejectedChangeRecordListener)listener);){
            Entry entry = reader.readEntry();
            Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=scarter,ou=People,dc=example,dc=com");
            Assertions.assertThat((String)entry.getName().toString()).isNotEqualTo((Object)"uid=scarter,ou=Human Resources,dc=example,dc=com");
            Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(3);
            Assertions.assertThat((String)entry.getAttribute("objectClass").firstValueAsString()).isEqualTo((Object)"person");
            Assertions.assertThat((String)entry.getAttribute("sn").firstValueAsString()).isEqualTo((Object)"new user");
            Assertions.assertThat((String)entry.getAttribute("mail").firstValueAsString()).isEqualTo((Object)"mail@mailme.org");
            Assertions.assertThat((boolean)reader.hasNext()).isFalse();
        }
    }

    @Test(expectedExceptions={DecodeException.class})
    public final void testFailFastPatchOnModifyDNRequestFailsDueToDuplicateEntry() throws Exception {
        RejectedChangeRecordListener listener = RejectedChangeRecordListener.FAIL_FAST;
        LDIFEntryReader input = new LDIFEntryReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "objectClass: person", "sn: new user", "mail: mail@mailme.org", "", "dn: uid=user.2,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "objectClass: organizationalperson", "objectClass: inetorgperson", "givenName: Eniko", "sn: Eniko", "cn: Eniko Atpco", "uid: user.2"});
        LDIFChangeRecordReader patch = new LDIFChangeRecordReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "changetype: moddn", "newrdn: uid=user.2,ou=People,dc=example,dc=com", "deleteoldrdn: 0"});
        EntryReader reader = LDIF.patch((EntryReader)input, (ChangeRecordReader)patch, (RejectedChangeRecordListener)listener);
        Throwable throwable = null;
        if (reader != null) {
            if (throwable != null) {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                reader.close();
            }
        }
    }

    @Test
    public final void testOverwritePatchOnModifyDNRequestSucceedsEvenWithDuplicateEntry() throws Exception {
        RejectedChangeRecordListener listener = RejectedChangeRecordListener.OVERWRITE;
        LDIFEntryReader input = new LDIFEntryReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "objectClass: person", "sn: new user", "mail: mail@mailme.org", "", "dn: uid=user.2,ou=People,dc=example,dc=com", "objectClass: top", "objectClass: person", "objectClass: organizationalperson", "objectClass: inetorgperson", "givenName: Eniko", "sn: Eniko", "cn: Eniko Atpco", "uid: user.2"});
        LDIFChangeRecordReader patch = new LDIFChangeRecordReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "changetype: moddn", "newrdn: uid=user.2", "deleteoldrdn: 0"});
        try (EntryReader reader = LDIF.patch((EntryReader)input, (ChangeRecordReader)patch, (RejectedChangeRecordListener)listener);){
            Entry entry = reader.readEntry();
            Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=user.2,ou=People,dc=example,dc=com");
            Assertions.assertThat((int)entry.getAttributeCount()).isEqualTo(4);
            Assertions.assertThat((String)entry.getAttribute("objectClass").firstValueAsString()).isEqualTo((Object)"person");
            Assertions.assertThat((String)entry.getAttribute("sn").firstValueAsString()).isEqualTo((Object)"new user");
            Assertions.assertThat((String)entry.getAttribute("mail").firstValueAsString()).isEqualTo((Object)"mail@mailme.org");
            Assertions.assertThat((boolean)reader.hasNext()).isFalse();
        }
    }

    @Test(expectedExceptions={NullPointerException.class})
    public final void testLdifPatchDoesntAllowNull() throws Exception {
        LDIF.patch(null, null);
    }

    @Test
    public void testMakeEntry() throws Exception {
        Entry entry = LDIF.makeEntry(LDIF_ONE_ENTRY);
        Entry entry2 = LDIF.makeEntry((String[])LDIF_ONE_ENTRY.toArray(new String[0]));
        Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=user.1,ou=People,dc=example,dc=com");
        Assertions.assertThat((String)entry.getAttribute("objectClass").firstValueAsString()).isEqualTo((Object)"top");
        Assertions.assertThat((String)entry.getAttribute("uid").firstValueAsString()).isEqualTo((Object)"user.1");
        Assertions.assertThat((String)entry.getAttribute("givenName").firstValueAsString()).isEqualTo((Object)"Eniko");
        Assertions.assertThat((String)entry.getAttribute("sn").firstValueAsString()).isEqualTo((Object)"Atpco");
        Assertions.assertThat((Object)entry2).isEqualTo((Object)entry);
    }

    @Test
    public void testMakeEntries() throws Exception {
        List entries = LDIF.makeEntries(LDIF_TWO_ENTRIES);
        List entries2 = LDIF.makeEntries((String[])LDIF_TWO_ENTRIES.toArray(new String[0]));
        Assertions.assertThat((List)entries).hasSize(2);
        Assertions.assertThat((String)((Entry)entries.get(0)).getName().toString()).isEqualTo((Object)"uid=user.1,ou=People,dc=example,dc=com");
        Assertions.assertThat((String)((Entry)entries.get(1)).getName().toString()).isEqualTo((Object)"uid=user.2,ou=People,dc=example,dc=com");
        Assertions.assertThat((List)entries2).isEqualTo((Object)entries);
    }

    @Test
    public void testMakeEntryEmpty() throws Exception {
        try {
            LDIF.makeEntry((String[])new String[0]);
            TestCaseUtils.failWasExpected(LocalizedIllegalArgumentException.class);
        }
        catch (LocalizedIllegalArgumentException e) {
            Assertions.assertThat((Object)e.getMessageObject()).isEqualTo((Object)CoreMessages.WARN_READ_LDIF_ENTRY_NO_ENTRY_FOUND.get());
        }
    }

    @Test
    public void testMakeEntryWithMultipleEntries() throws Exception {
        try {
            LDIF.makeEntry(LDIF_TWO_ENTRIES);
            TestCaseUtils.failWasExpected(LocalizedIllegalArgumentException.class);
        }
        catch (LocalizedIllegalArgumentException e) {
            Assertions.assertThat((Object)e.getMessageObject()).isEqualTo((Object)CoreMessages.WARN_READ_LDIF_ENTRY_MULTIPLE_ENTRIES_FOUND.get((Object)2));
        }
    }

    @Test(expectedExceptions={LocalizedIllegalArgumentException.class})
    public void testMakeEntryBadLDif() throws Exception {
        LDIF.makeEntry((String[])new String[]{"dummy: uid=user.1,ou=People,dc=example,dc=com"});
    }

    @Test
    public void testMakeEntriesEmpty() throws Exception {
        try {
            LDIF.makeEntries((String[])new String[0]);
            TestCaseUtils.failWasExpected(LocalizedIllegalArgumentException.class);
        }
        catch (LocalizedIllegalArgumentException e) {
            Assertions.assertThat((Object)e.getMessageObject()).isEqualTo((Object)CoreMessages.WARN_READ_LDIF_ENTRY_NO_ENTRY_FOUND.get());
        }
    }

    @Test(expectedExceptions={LocalizedIllegalArgumentException.class})
    public void testMakeEntriesBadLDif() throws Exception {
        LDIF.makeEntries((String[])new String[]{"dummy: uid=user.1,ou=People,dc=example,dc=com"});
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testMakeEntriesNull() throws Exception {
        LDIF.makeEntries((String[])null);
    }
}

