/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldif;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.LinkedHashMapEntry;
import org.forgerock.opendj.ldap.Matcher;
import org.forgerock.opendj.ldif.AbstractLDIFTestCase;
import org.forgerock.opendj.ldif.LDIFEntryWriter;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;
import org.testng.annotations.Test;

public final class LDIFEntryWriterTestCase
extends AbstractLDIFTestCase {
    private static Entry getStandardEntry() {
        LinkedHashMapEntry entry = new LinkedHashMapEntry("cn=John Doe,ou=people,dc=example,dc=com");
        entry.addAttribute("objectClass", new Object[]{"top", "person", "inetOrgPerson"});
        entry.addAttribute("cn", new Object[]{"John Doe"});
        entry.addAttribute("sn", new Object[]{"Doe"});
        entry.addAttribute("age", new Object[]{"29"});
        entry.addAttribute("givenName", new Object[]{"John"});
        entry.addAttribute("description", new Object[]{"one two", "three four", "This is a very very long description, Neque porro quisquam est qui dolorem ipsumquia dolor sit amet, consectetur, adipisci velit..."});
        entry.addAttribute("typeOnly", new Object[0]);
        entry.addAttribute("mail", new Object[]{"email@example.com"});
        entry.addAttribute("localized;lang-fr", new Object[]{"\u00e7edilla"});
        entry.addAttribute("entryUUID", new Object[]{"ad55a34a-763f-358f-93f9-da86f9ecd9e4"});
        entry.addAttribute("entryDN", new Object[]{"uid=bjensen,ou=people,dc=example,dc=com"});
        return entry;
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testSetExcludeAttributeDoesntAllowNull() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFEntryWriter writer = new LDIFEntryWriter(actual);
        writer.setExcludeAttribute(null);
        writer.close();
    }

    @Test
    public void testSetExcludeAttributeWithMatch() throws Exception {
        AttributeDescription attribute = AttributeDescription.valueOf((String)"cn");
        ArrayList actual = new ArrayList();
        LDIFEntryWriter writer = new LDIFEntryWriter(actual);
        writer.setExcludeAttribute(attribute);
        writer.writeEntry(LDIFEntryWriterTestCase.getStandardEntry());
        writer.close();
        Assertions.assertThat((int)actual.size()).isGreaterThan(0);
        for (String line : actual) {
            Assertions.assertThat((String)line).doesNotContain("cn: John Doe");
        }
    }

    @Test
    public void testSetExcludeAttributeWithNoMatch() throws Exception {
        AttributeDescription attribute = AttributeDescription.valueOf((String)"vip");
        ArrayList actual = new ArrayList();
        LDIFEntryWriter writer = new LDIFEntryWriter(actual);
        writer.setExcludeAttribute(attribute);
        writer.writeEntry(LDIFEntryWriterTestCase.getStandardEntry());
        writer.close();
        Assertions.assertThat((int)actual.size()).isGreaterThan(0);
        for (String line : actual) {
            Assertions.assertThat((String)line).doesNotContain("vip");
        }
        Assertions.assertThat((int)actual.size()).isGreaterThan(LDIFEntryWriterTestCase.getStandardEntry().getAttributeCount());
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testSetExcludeBranchDoesntAllowNull() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFEntryWriter writer = new LDIFEntryWriter(actual);
        writer.setExcludeBranch(null);
        writer.close();
    }

    @Test
    public void testSetExcludeBranchWrongDN() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFEntryWriter writer = new LDIFEntryWriter(actual);
        DN dn = DN.valueOf((String)"dc=example.com");
        writer.setExcludeBranch(dn);
        writer.writeEntry(LDIFEntryWriterTestCase.getStandardEntry());
        writer.flush();
        writer.close();
        Assertions.assertThat((int)actual.size()).isGreaterThan(LDIFEntryWriterTestCase.getStandardEntry().getAttributeCount());
    }

    @Test
    public void testSetExcludeBranchWithNoMatch() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFEntryWriter writer = new LDIFEntryWriter(actual);
        DN dn = DN.valueOf((String)"dc=example,dc=com");
        writer.setExcludeBranch(dn);
        writer.writeEntry(LDIFEntryWriterTestCase.getStandardEntry());
        writer.flush();
        writer.close();
        Assert.assertFalse((actual.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSetExcludeBranchWithMatch() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFEntryWriter writer = new LDIFEntryWriter(actual);
        DN dn = DN.valueOf((String)"dc=example,dc=org");
        writer.setExcludeBranch(dn);
        writer.writeEntry(LDIFEntryWriterTestCase.getStandardEntry());
        writer.flush();
        writer.close();
        Assertions.assertThat((int)actual.size()).isGreaterThan(LDIFEntryWriterTestCase.getStandardEntry().getAttributeCount());
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testsetExcludeFilterDoesntAllowNull() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFEntryWriter writer = new LDIFEntryWriter(actual);
        writer.setExcludeFilter(null);
        writer.close();
    }

    @Test
    public void testSetExcludeFilterWithMatch() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFEntryWriter writer = new LDIFEntryWriter(actual);
        Filter filter = Filter.equality((String)"objectclass", (Object)"vip");
        Matcher excludeFilter = filter.matcher();
        writer.setExcludeFilter(excludeFilter);
        writer.writeEntry(LDIFEntryWriterTestCase.getStandardEntry());
        writer.close();
        Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)("dn: " + LDIFEntryWriterTestCase.getStandardEntry().getName()));
        Assertions.assertThat((int)actual.size()).isGreaterThan(LDIFEntryWriterTestCase.getStandardEntry().getAttributeCount());
    }

    @Test
    public void testSetExcludeFilterWithNoMatch() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFEntryWriter writer = new LDIFEntryWriter(actual);
        Filter filter = Filter.equality((String)"objectclass", (Object)"person");
        Matcher excludeFilter = filter.matcher();
        writer.setExcludeFilter(excludeFilter);
        writer.writeEntry(LDIFEntryWriterTestCase.getStandardEntry());
        writer.close();
        Assertions.assertThat(actual).isEmpty();
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testSetIncludeAttributeDoesntAllowNull() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFEntryWriter writer = new LDIFEntryWriter(actual);
        writer.setIncludeAttribute(null);
        writer.close();
    }

    @Test
    public void testSetIncludeAttributeWithMatch() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFEntryWriter writer = new LDIFEntryWriter(actual);
        writer.setIncludeAttribute(AttributeDescription.valueOf((String)"cn"));
        writer.setIncludeAttribute(AttributeDescription.valueOf((String)"sn"));
        writer.writeEntry(LDIFEntryWriterTestCase.getStandardEntry());
        writer.close();
        Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)("dn: " + LDIFEntryWriterTestCase.getStandardEntry().getName()));
        Assertions.assertThat((String)((String)actual.get(1))).contains("cn: ");
        Assertions.assertThat((String)((String)actual.get(2))).contains("sn: ");
    }

    @Test
    public void testSetIncludeAttributeWithNoMatch() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFEntryWriter writer = new LDIFEntryWriter(actual);
        writer.setIncludeAttribute(AttributeDescription.valueOf((String)"manager"));
        writer.writeEntry(LDIFEntryWriterTestCase.getStandardEntry());
        writer.close();
        Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)("dn: " + LDIFEntryWriterTestCase.getStandardEntry().getName()));
        Assertions.assertThat((String)((String)actual.get(1))).isEmpty();
        Assertions.assertThat((int)actual.size()).isLessThanOrEqualTo(2);
    }

    @Test
    public void testSetIncludeAttributeWithRepeatedAttributes() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFEntryWriter writer = new LDIFEntryWriter(actual);
        writer.setIncludeAttribute(AttributeDescription.valueOf((String)"cn"));
        writer.setIncludeAttribute(AttributeDescription.valueOf((String)"sn"));
        writer.setIncludeAttribute(AttributeDescription.valueOf((String)"cn"));
        writer.setIncludeAttribute(AttributeDescription.valueOf((String)"cn"));
        writer.writeEntry(LDIFEntryWriterTestCase.getStandardEntry());
        writer.close();
        Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)("dn: " + LDIFEntryWriterTestCase.getStandardEntry().getName()));
        Assertions.assertThat((String)((String)actual.get(1))).contains("cn: ");
        Assertions.assertThat((String)((String)actual.get(2))).contains("sn: ");
        Assertions.assertThat((int)actual.size()).isLessThanOrEqualTo(4);
    }

    @Test
    public void testSetExcludeAllOperationalAttributesFalse() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFEntryWriter writer = new LDIFEntryWriter(actual);
        int opAttributes = 0;
        writer.setExcludeAllOperationalAttributes(false);
        writer.writeEntry(LDIFEntryWriterTestCase.getStandardEntry());
        writer.close();
        for (String line : actual) {
            if (!line.contains("entryUUID") && !line.contains("entryDN")) continue;
            ++opAttributes;
        }
        Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)("dn: " + LDIFEntryWriterTestCase.getStandardEntry().getName()));
        Assertions.assertThat((int)actual.size()).isGreaterThan(LDIFEntryWriterTestCase.getStandardEntry().getAttributeCount());
        Assertions.assertThat((int)opAttributes).isEqualTo(2);
    }

    @Test
    public void testSetExcludeAllOperationalAttributesTrue() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFEntryWriter writer = new LDIFEntryWriter(actual);
        writer.setExcludeAllOperationalAttributes(true);
        writer.writeEntry(LDIFEntryWriterTestCase.getStandardEntry());
        writer.close();
        for (String line : actual) {
            Assertions.assertThat((String)line).doesNotContain("entryUUID");
            Assertions.assertThat((String)line).doesNotContain("entryDN");
        }
        Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)("dn: " + LDIFEntryWriterTestCase.getStandardEntry().getName()));
        Assertions.assertThat((int)actual.size()).isGreaterThan(LDIFEntryWriterTestCase.getStandardEntry().getAttributeCount());
    }

    @Test
    public void testSetExcludeAllUserAttributesFalse() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFEntryWriter writer = new LDIFEntryWriter(actual);
        writer.setExcludeAllUserAttributes(false);
        writer.writeEntry(LDIFEntryWriterTestCase.getStandardEntry());
        writer.flush();
        writer.close();
        Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)("dn: " + LDIFEntryWriterTestCase.getStandardEntry().getName()));
        Assertions.assertThat((int)actual.size()).isGreaterThan(LDIFEntryWriterTestCase.getStandardEntry().getAttributeCount());
    }

    @Test
    public void testSetExcludeAllUserAttributesTrue() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFEntryWriter writer = new LDIFEntryWriter(actual);
        writer.setExcludeAllUserAttributes(true);
        writer.writeEntry(LDIFEntryWriterTestCase.getStandardEntry());
        writer.flush();
        writer.close();
        for (String line : actual) {
            Assertions.assertThat((String)line).doesNotContain("sn");
            Assertions.assertThat((String)line).doesNotContain("mail");
        }
        Assertions.assertThat((boolean)((String)actual.get(0)).contains("dn: cn=John Doe,ou=people,dc=example,dc=com"));
        Assertions.assertThat((int)actual.size()).isLessThan(LDIFEntryWriterTestCase.getStandardEntry().getAttributeCount());
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testSetIncludeBranchDoesntAllowNull() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFEntryWriter writer = new LDIFEntryWriter(actual);
        writer.setIncludeBranch(null);
        writer.close();
    }

    @Test
    public void testSetIncludeBranchWithMatch() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFEntryWriter writer = new LDIFEntryWriter(actual);
        DN dn = DN.valueOf((String)"dc=example,dc=com");
        writer.setIncludeBranch(dn);
        writer.writeEntry(LDIFEntryWriterTestCase.getStandardEntry());
        writer.close();
        Assertions.assertThat((String)((String)actual.get(0))).contains(LDIFEntryWriterTestCase.getStandardEntry().getName().toString());
        Assertions.assertThat((int)actual.size()).isGreaterThan(LDIFEntryWriterTestCase.getStandardEntry().getAttributeCount());
    }

    @Test
    public void testSetIncludeBranchWithNoMatch() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFEntryWriter writer = new LDIFEntryWriter(actual);
        DN dn = DN.valueOf((String)"dc=opendj,dc=org");
        writer.setIncludeBranch(dn);
        writer.writeEntry(LDIFEntryWriterTestCase.getStandardEntry());
        writer.close();
        Assertions.assertThat((int)actual.size()).isEqualTo(0);
    }

    @Test
    public void testSetIncludeFilterWithNoMatch() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFEntryWriter writer = new LDIFEntryWriter(actual);
        Filter filter = Filter.equality((String)"objectclass", (Object)"vip");
        Matcher includeFilter = filter.matcher();
        writer.setIncludeFilter(includeFilter);
        writer.writeEntry(LDIFEntryWriterTestCase.getStandardEntry());
        writer.close();
        Assertions.assertThat((int)actual.size()).isEqualTo(0);
    }

    @Test
    public void testSetIncludeFilterWithMatch() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFEntryWriter writer = new LDIFEntryWriter(actual);
        Filter filter = Filter.equality((String)"objectclass", (Object)"person");
        Matcher includeFilter = filter.matcher();
        writer.setIncludeFilter(includeFilter);
        writer.writeEntry(LDIFEntryWriterTestCase.getStandardEntry());
        writer.close();
        Assertions.assertThat(actual).isNotNull();
        Assertions.assertThat((int)actual.size()).isGreaterThanOrEqualTo(LDIFEntryWriterTestCase.getStandardEntry().getAttributeCount());
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testSetIncludeFilterDoesntAllowNull() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFEntryWriter writer = new LDIFEntryWriter(actual);
        writer.setIncludeFilter(null);
        writer.writeEntry(LDIFEntryWriterTestCase.getStandardEntry());
        writer.close();
    }

    @Test
    public void testWriteCommentUsingTheWrapFunction() throws Exception {
        String comment = "Lorem ipsum dolor sit amet, consectetur adipisicing elit";
        ArrayList actual = new ArrayList();
        LDIFEntryWriter writer = new LDIFEntryWriter(actual);
        int wrapColumn = 15;
        writer.setWrapColumn(wrapColumn);
        writer.writeComment((CharSequence)comment);
        writer.close();
        for (String line : actual) {
            Assertions.assertThat((int)line.length()).isLessThanOrEqualTo(wrapColumn);
            Assertions.assertThat((boolean)line.startsWith("#")).isTrue();
        }
    }

    @Test
    public void testWriteCommentUsingTheWrapFunctionShortComment() throws Exception {
        String comment = "Lorem ipsum dolor";
        ArrayList actual = new ArrayList();
        LDIFEntryWriter writer = new LDIFEntryWriter(actual);
        int wrapColumn = 30;
        writer.setWrapColumn(wrapColumn);
        writer.writeComment((CharSequence)comment);
        writer.close();
        for (String line : actual) {
            Assertions.assertThat((boolean)line.startsWith("#")).isTrue();
            Assertions.assertThat((int)line.length()).isLessThanOrEqualTo(wrapColumn);
        }
    }

    @Test
    public void testWriteCommentUsingTheWrapFunctionNoEmptySpace() throws Exception {
        String comment = "Lorem ipsumdolorsitamet,consecteturadipisicingelit";
        ArrayList actual = new ArrayList();
        LDIFEntryWriter writer = new LDIFEntryWriter(actual);
        int wrapColumn = 15;
        writer.setWrapColumn(wrapColumn);
        writer.writeComment((CharSequence)comment);
        writer.close();
        for (String line : actual) {
            Assertions.assertThat((int)line.length()).isLessThanOrEqualTo(wrapColumn);
            Assertions.assertThat((boolean)line.startsWith("#")).isTrue();
        }
    }

    @Test
    public void testWriteComment() throws Exception {
        String comment1 = "This is a new comment";
        String comment2 = "Another one";
        ArrayList actual = new ArrayList();
        LDIFEntryWriter writer = new LDIFEntryWriter(actual);
        writer.writeComment((CharSequence)comment1);
        writer.writeComment((CharSequence)comment2);
        writer.close();
        Assert.assertEquals((int)actual.size(), (int)2);
        Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)("# " + comment1));
        Assertions.assertThat((String)((String)actual.get(1))).isEqualTo((Object)("# " + comment2));
    }

    @Test(enabled=false)
    public void testSetAddUserFriendlyComments() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFEntryWriter writer = new LDIFEntryWriter(actual);
        String comment = "A simple comment";
        writer.setAddUserFriendlyComments(true);
        writer.writeComment0((CharSequence)comment);
        writer.close();
    }

    @Test
    public void testWriteEntryUsingStandardEntry() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFEntryWriter writer = new LDIFEntryWriter(actual);
        int wrapColumn = 15;
        writer.setWrapColumn(15);
        writer.writeEntry(LDIFEntryWriterTestCase.getStandardEntry());
        writer.close();
        int countDesc = 0;
        Assertions.assertThat(actual).isNotNull();
        for (String line : actual) {
            if (line.contains("description")) {
                ++countDesc;
            }
            Assertions.assertThat((int)line.length()).isLessThanOrEqualTo(15);
        }
        Assertions.assertThat((int)countDesc).isEqualTo(LDIFEntryWriterTestCase.getStandardEntry().getAttribute("description").size());
        Assertions.assertThat((int)actual.size()).isGreaterThanOrEqualTo(LDIFEntryWriterTestCase.getStandardEntry().getAttributeCount());
    }

    @Test
    public void testWriteEntry() throws Exception {
        LinkedHashMapEntry entry = new LinkedHashMapEntry("cn=John Doe,ou=people,dc=example,dc=com");
        entry.addAttribute("objectClass", new Object[]{"top", "person", "inetOrgPerson"});
        entry.addAttribute("cn", new Object[]{"John Doe"});
        entry.addAttribute("sn", new Object[]{"Doe"});
        entry.addAttribute("givenName", new Object[]{"John"});
        entry.addAttribute("description", new Object[]{"one two", "three four", "five six"});
        entry.addAttribute("typeOnly", new Object[0]);
        entry.addAttribute("localized;lang-fr", new Object[]{"\u00e7edilla"});
        ArrayList actual = new ArrayList();
        LDIFEntryWriter writer = new LDIFEntryWriter(actual);
        writer.writeEntry((Entry)entry);
        writer.close();
        String[] expected = new String[]{"dn: cn=John Doe,ou=people,dc=example,dc=com", "objectClass: top", "objectClass: person", "objectClass: inetOrgPerson", "cn: John Doe", "sn: Doe", "givenName: John", "description: one two", "description: three four", "description: five six", "typeOnly: ", "localized;lang-fr:: w6dlZGlsbGE=", ""};
        Assert.assertEquals((int)actual.size(), (int)expected.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)((String)actual.get(i)), (String)expected[i], (String)("LDIF output was " + actual));
        }
    }

    @Test(expectedExceptions={IOException.class})
    public void testWriteEntryUsingMockOutputThrowsIOException() throws Exception {
        OutputStream mockOutput = (OutputStream)Mockito.mock(OutputStream.class);
        ((OutputStream)Mockito.doThrow((Throwable)new IOException()).when((Object)mockOutput)).write((byte[])Mockito.any(byte[].class));
        ((OutputStream)Mockito.doThrow((Throwable)new IOException()).when((Object)mockOutput)).write((byte[])Mockito.any(byte[].class), Mockito.anyInt(), Mockito.anyInt());
        try (LDIFEntryWriter writer = new LDIFEntryWriter(mockOutput);){
            String comment = "This is a new comment";
            writer.writeComment((CharSequence)comment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteEntryUsingMockOutputForFlushAndClose() throws Exception {
        OutputStream mockOutput = (OutputStream)Mockito.mock(OutputStream.class);
        try (LDIFEntryWriter writer = new LDIFEntryWriter(mockOutput);){
            writer.flush();
            writer.flush();
            ((OutputStream)Mockito.verify((Object)mockOutput, (VerificationMode)Mockito.times((int)2))).flush();
        }
        finally {
            ((OutputStream)Mockito.verify((Object)mockOutput, (VerificationMode)Mockito.times((int)1))).close();
        }
    }

    @Test
    public void testWriteEntryOutputStreamUsingMock() throws Exception {
        OutputStream out = (OutputStream)Mockito.mock(OutputStream.class);
        LDIFEntryWriter writer = new LDIFEntryWriter(out);
        writer.writeEntry(LDIFEntryWriterTestCase.getStandardEntry());
        writer.close();
        ((OutputStream)Mockito.verify((Object)out, (VerificationMode)Mockito.times((int)1))).write((byte[])Mockito.any(byte[].class), Mockito.anyInt(), Mockito.anyInt());
    }
}

