/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldif;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import org.fest.assertions.Assertions;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.ModificationType;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.PersistentSearchChangeType;
import org.forgerock.opendj.ldap.controls.PersistentSearchRequestControl;
import org.forgerock.opendj.ldap.controls.PreReadRequestControl;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldif.AbstractLDIFTestCase;
import org.forgerock.opendj.ldif.ChangeRecord;
import org.forgerock.opendj.ldif.LDIFChangeRecordWriter;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;
import org.testng.annotations.Test;

public class LDIFChangeRecordWriterTestCase
extends AbstractLDIFTestCase {
    public final String[] getAddLDIFChangeRecord() {
        return new String[]{"version: 1", "dn: uid=scarter,ou=People,dc=example,dc=com", "changetype: add", "sn: Carter", "cn: Samantha Carter", "givenName: Sam", "objectClass: inetOrgPerson", "telephoneNumber: 555 555-5555", "mail: scarter@mail.org", "entryDN: uid=scarter,ou=people,dc=example,dc=org", "entryUUID: ad55a34a-763f-358f-93f9-da86f9ecd9e4", "modifyTimestamp: 20120903142126Z", "modifiersName: cn=Internal Client,cn=Root DNs,cn=config", "description::V2hhdCBhIGNhcmVmdWwgcmVhZGVyIHlvdSBhcmUgIQ=="};
    }

    @Test
    public void testSetExcludeAllOperationalAttributesTrue() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        AddRequest changeRequest = Requests.newAddRequest((String[])this.getAddLDIFChangeRecord());
        writer.setExcludeAllOperationalAttributes(true);
        writer.writeChangeRecord(changeRequest);
        writer.close();
        Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)"dn: uid=scarter,ou=People,dc=example,dc=com");
        for (String line : actual) {
            Assertions.assertThat((String)line).doesNotContain("entryUUID");
            Assertions.assertThat((String)line).doesNotContain("entryDN");
        }
        Assertions.assertThat((int)actual.size()).isEqualTo(10);
    }

    @Test
    public void testSetExcludeAllOperationalAttributesFalse() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        AddRequest changeRequest = Requests.newAddRequest((String[])this.getAddLDIFChangeRecord());
        writer.setExcludeAllOperationalAttributes(false);
        writer.writeChangeRecord(changeRequest);
        writer.close();
        Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)"dn: uid=scarter,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)actual.size()).isEqualTo(14);
        Assertions.assertThat((String)((String)actual.get(13))).isEqualTo((Object)"");
    }

    @Test
    public void testSetExcludeAllUserAttributesTrue() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        AddRequest changeRequest = Requests.newAddRequest((String[])this.getAddLDIFChangeRecord());
        writer.setExcludeAllUserAttributes(true);
        writer.writeChangeRecord(changeRequest);
        writer.close();
        Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)"dn: uid=scarter,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)actual.size()).isEqualTo(7);
        Assertions.assertThat((String)((String)actual.get(6))).isEqualTo((Object)"");
    }

    @Test
    public void testSetExcludeAllUserAttributesFalse() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        AddRequest changeRequest = Requests.newAddRequest((String[])this.getAddLDIFChangeRecord());
        writer.setExcludeAllUserAttributes(false);
        writer.writeChangeRecord(changeRequest);
        writer.close();
        Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)"dn: uid=scarter,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)actual.size()).isEqualTo(14);
        Assertions.assertThat((String)((String)actual.get(13))).isEqualTo((Object)"");
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testSetExcludeAttributeDoesntAllowNull() throws Exception {
        ArrayList actual = new ArrayList();
        try (LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);){
            writer.setExcludeAttribute(null);
        }
    }

    @Test
    public void testSetExcludeBranchWrongDN() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        DN dn = DN.valueOf((String)"dc=example.com");
        AddRequest changeRequest = Requests.newAddRequest((String[])this.getAddLDIFChangeRecord());
        writer.setExcludeBranch(dn);
        writer.writeChangeRecord(changeRequest);
        writer.close();
        Assertions.assertThat((int)actual.size()).isEqualTo(14);
        Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)"dn: uid=scarter,ou=People,dc=example,dc=com");
    }

    @Test
    public void testSetExcludeBranchWithNoMatch() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        DN dn = DN.valueOf((String)"dc=example,dc=com");
        AddRequest changeRequest = Requests.newAddRequest((String[])this.getAddLDIFChangeRecord());
        writer.setExcludeBranch(dn);
        writer.writeChangeRecord(changeRequest);
        writer.close();
        Assert.assertFalse((actual.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSetExcludeBranchWithMatch() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        DN dn = DN.valueOf((String)"dc=example,dc=org");
        AddRequest changeRequest = Requests.newAddRequest((String[])this.getAddLDIFChangeRecord());
        writer.setExcludeBranch(dn);
        writer.writeChangeRecord(changeRequest);
        writer.close();
        Assertions.assertThat((int)actual.size()).isEqualTo(14);
        Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)"dn: uid=scarter,ou=People,dc=example,dc=com");
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testSetExcludeBranchDoesntAllowNull() throws Exception {
        ArrayList actual = new ArrayList();
        try (LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);){
            writer.setExcludeBranch(null);
        }
    }

    @Test
    public void testSetExcludeAttributeWithMatch() throws Exception {
        AttributeDescription attribute = AttributeDescription.valueOf((String)"cn");
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        AddRequest changeRequest = Requests.newAddRequest((String[])this.getAddLDIFChangeRecord());
        writer.setExcludeAttribute(attribute);
        writer.writeChangeRecord(changeRequest);
        writer.close();
        Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)"dn: uid=scarter,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)actual.size()).isEqualTo(13);
        for (String line : actual) {
            Assertions.assertThat((String)line).doesNotContain("cn: Samantha Carter");
        }
    }

    @Test
    public void testSetExcludeAttributeWithNoMatch() throws Exception {
        AttributeDescription attribute = AttributeDescription.valueOf((String)"vip");
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        AddRequest changeRequest = Requests.newAddRequest((String[])this.getAddLDIFChangeRecord());
        writer.setExcludeAttribute(attribute);
        writer.writeChangeRecord(changeRequest);
        writer.close();
        Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)"dn: uid=scarter,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)actual.size()).isEqualTo(14);
        for (String line : actual) {
            Assertions.assertThat((String)line).doesNotContain("vip");
        }
    }

    @Test
    public void testSetIncludeAttributeWithMatch() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        AddRequest changeRequest = Requests.newAddRequest((String[])this.getAddLDIFChangeRecord());
        writer.setIncludeAttribute(AttributeDescription.valueOf((String)"cn"));
        writer.setIncludeAttribute(AttributeDescription.valueOf((String)"sn"));
        writer.writeChangeRecord(changeRequest);
        writer.close();
        Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)"dn: uid=scarter,ou=People,dc=example,dc=com");
        Assertions.assertThat((String)((String)actual.get(1))).isEqualTo((Object)"changetype: add");
        Assertions.assertThat((String)((String)actual.get(2))).contains("sn: Carter");
        Assertions.assertThat((String)((String)actual.get(3))).contains("cn: ");
        Assertions.assertThat((String)((String)actual.get(4))).contains("");
    }

    @Test
    public void testSetIncludeAttributeWithNoMatch() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        AddRequest changeRequest = Requests.newAddRequest((String[])this.getAddLDIFChangeRecord());
        writer.setIncludeAttribute(AttributeDescription.valueOf((String)"vip"));
        writer.writeChangeRecord(changeRequest);
        writer.close();
        Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)"dn: uid=scarter,ou=People,dc=example,dc=com");
        Assertions.assertThat((String)((String)actual.get(1))).isEqualTo((Object)"changetype: add");
        Assertions.assertThat((String)((String)actual.get(2))).contains("");
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testSetIncludeAttributeDoesntAllowNull() throws Exception {
        ArrayList actual = new ArrayList();
        try (LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);){
            writer.setIncludeAttribute(null);
        }
    }

    @Test
    public void testSetIncludeBranchWithNoMatch() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        DN dn = DN.valueOf((String)"dc=example,dc=org");
        AddRequest changeRequest = Requests.newAddRequest((String[])this.getAddLDIFChangeRecord());
        writer.setIncludeBranch(dn);
        writer.writeChangeRecord(changeRequest);
        writer.close();
        Assertions.assertThat((int)actual.size()).isEqualTo(0);
    }

    @Test
    public void testSetIncludeBranchWithMatch() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        DN dn = DN.valueOf((String)"dc=example,dc=com");
        AddRequest changeRequest = Requests.newAddRequest((String[])this.getAddLDIFChangeRecord());
        writer.setIncludeBranch(dn);
        writer.writeChangeRecord(changeRequest);
        writer.close();
        Assertions.assertThat((String)((String)actual.get(0))).contains("dn: uid=scarter,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)actual.size()).isEqualTo(14);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testSetIncludeBranchDoesntAllowNull() throws Exception {
        ArrayList actual = new ArrayList();
        try (LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);){
            writer.setIncludeBranch(null);
        }
    }

    @Test(enabled=false)
    public void testSetAddUserFriendlyComments() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        String comment = "A simple comment";
        writer.setAddUserFriendlyComments(true);
        writer.writeComment0((CharSequence)comment);
        writer.close();
    }

    @Test
    public void testWriteCommentUsingTheWrapFunction() throws Exception {
        String comment = "Lorem ipsum dolor sit amet, consectetur adipisicing elit";
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        int wrapColumn = 15;
        writer.setWrapColumn(wrapColumn);
        writer.writeComment((CharSequence)comment);
        writer.close();
        for (String line : actual) {
            Assertions.assertThat((int)line.length()).isLessThanOrEqualTo(wrapColumn);
            Assertions.assertThat((boolean)line.startsWith("#")).isTrue();
        }
    }

    @Test
    public void testWriteCommentUsingTheWrapFunctionShortComment() throws Exception {
        String comment = "Lorem ipsum dolor";
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        int wrapColumn = 30;
        writer.setWrapColumn(wrapColumn);
        writer.writeComment((CharSequence)comment);
        writer.close();
        for (String line : actual) {
            Assertions.assertThat((boolean)line.startsWith("#")).isTrue();
            Assertions.assertThat((int)line.length()).isLessThanOrEqualTo(wrapColumn);
        }
    }

    @Test
    public void testWriteCommentUsingTheWrapFunctionNoEmptySpace() throws Exception {
        String comment = "Lorem ipsumdolorsitamet,consecteturadipisicingelit";
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        int wrapColumn = 15;
        writer.setWrapColumn(wrapColumn);
        writer.writeComment((CharSequence)comment);
        writer.close();
        for (String line : actual) {
            Assertions.assertThat((int)line.length()).isLessThanOrEqualTo(wrapColumn);
            Assertions.assertThat((boolean)line.startsWith("#")).isTrue();
        }
    }

    @Test
    public void testWriteChangeRecord() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        ChangeRecord changeRequest = Requests.newChangeRecord((String[])new String[]{"version: 1", "dn: uid=scarter,ou=People,dc=example,dc=com", "changetype: add", "sn: Carter"});
        writer.writeChangeRecord(changeRequest);
        writer.close();
        Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)"dn: uid=scarter,ou=People,dc=example,dc=com");
        Assertions.assertThat((String)((String)actual.get(1))).isEqualTo((Object)"changetype: add");
        Assertions.assertThat((String)((String)actual.get(2))).isEqualTo((Object)"sn: Carter");
        Assertions.assertThat((String)((String)actual.get(3))).isEqualTo((Object)"");
    }

    @Test
    public void testWriteAddRequest() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        AddRequest changeRequest = Requests.newAddRequest((String[])this.getAddLDIFChangeRecord());
        writer.writeChangeRecord(changeRequest);
        writer.close();
        Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)"dn: uid=scarter,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)actual.size()).isEqualTo(14);
    }

    @Test
    public void testWriteAddRequestNoBranchExcluded() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        DN dnAdd = DN.valueOf((String)"uid=scarter,ou=People,dc=example,dc=com");
        AddRequest changeRequest = Requests.newAddRequest((DN)dnAdd).addAttribute("sn", new Object[]{"Carter"});
        DN dn = DN.valueOf((String)"dc=example,dc=org");
        writer.setExcludeBranch(dn);
        writer.writeChangeRecord((ChangeRecord)changeRequest);
        writer.close();
        Assertions.assertThat((int)actual.size()).isEqualTo(4);
        Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)"dn: uid=scarter,ou=People,dc=example,dc=com");
        Assertions.assertThat((String)((String)actual.get(1))).isEqualTo((Object)"changetype: add");
        Assertions.assertThat((String)((String)actual.get(2))).isEqualTo((Object)"sn: Carter");
    }

    @Test
    public void testWriteAddRequestBranchExcluded() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        DN dnAdd = DN.valueOf((String)"uid=scarter,ou=People,dc=example,dc=com");
        AddRequest changeRequest = Requests.newAddRequest((DN)dnAdd).addAttribute("sn", new Object[]{"Carter"});
        DN dn = DN.valueOf((String)"dc=example,dc=com");
        writer.setExcludeBranch(dn);
        writer.writeChangeRecord((ChangeRecord)changeRequest);
        writer.close();
        Assertions.assertThat((int)actual.size()).isEqualTo(0);
    }

    @Test
    public void testWriteAddRequestJpegAttributeOk() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        File file = File.createTempFile("sdk", ".jpeg");
        String url = file.toURI().toURL().toString();
        DN dnAdd = DN.valueOf((String)"uid=scarter,ou=People,dc=example,dc=com");
        AddRequest changeRequest = Requests.newAddRequest((DN)dnAdd).addAttribute("sn", new Object[]{"Carter"}).addAttribute("jpegphoto", new Object[]{url});
        writer.writeChangeRecord((ChangeRecord)changeRequest);
        file.delete();
        writer.close();
        Assertions.assertThat((int)actual.size()).isEqualTo(5);
        Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)"dn: uid=scarter,ou=People,dc=example,dc=com");
        Assertions.assertThat((String)((String)actual.get(1))).isEqualTo((Object)"changetype: add");
        Assertions.assertThat((String)((String)actual.get(2))).isEqualTo((Object)"sn: Carter");
        Assertions.assertThat((String)((String)actual.get(3))).contains("jpegphoto: file:/");
    }

    @Test
    public void testWriteAddBinaryRequest() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        AddRequest changeRequest = Requests.newAddRequest((String[])new String[]{"dn:: dWlkPXJvZ2FzYXdhcmE=", "changetype: add", "sn::cm9nYXNhd2FyYQ=="});
        writer.writeChangeRecord(changeRequest);
        writer.close();
        Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)"dn: uid=rogasawara");
        Assertions.assertThat((String)((String)actual.get(2))).isEqualTo((Object)"sn: rogasawara");
        Assertions.assertThat((String)((String)actual.get(3))).isEqualTo((Object)"");
        Assertions.assertThat((int)actual.size()).isEqualTo(4);
    }

    @Test
    public void testWriteAddBinaryNonAsciiRequest() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        AddRequest changeRequest = Requests.newAddRequest((String[])new String[]{"dn:: dWlkPXJvZ2FzYXdhcmEsb3U95Za25qWt6YOoLG89QWlyaXVz", "changetype: add", "sn::cm9nYXNhd2FyYQ=="});
        writer.writeChangeRecord(changeRequest);
        writer.close();
        Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)"dn:: dWlkPXJvZ2FzYXdhcmEsb3U95Za25qWt6YOoLG89QWlyaXVz");
        Assertions.assertThat((String)((String)actual.get(2))).isEqualTo((Object)"sn: rogasawara");
        Assertions.assertThat((String)((String)actual.get(3))).isEqualTo((Object)"");
        Assertions.assertThat((int)actual.size()).isEqualTo(4);
    }

    @Test
    public void testWriteDeleteRequestBranchExcluded() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        DeleteRequest changeRequest = (DeleteRequest)Requests.newChangeRecord((String[])new String[]{"version: 1", "dn: uid=scarter,ou=People,dc=example,dc=com", "changetype: delete"});
        DN dn = DN.valueOf((String)"dc=example,dc=com");
        writer.setExcludeBranch(dn);
        writer.writeChangeRecord(changeRequest);
        writer.close();
        Assertions.assertThat((int)actual.size()).isEqualTo(0);
    }

    @Test
    public void testWriteDeleteRequestBranchNotExcluded() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        DeleteRequest changeRequest = (DeleteRequest)Requests.newChangeRecord((String[])new String[]{"version: 1", "dn: uid=scarter,ou=People,dc=example,dc=com", "changetype: delete"});
        DN dn = DN.valueOf((String)"dc=example,dc=org");
        writer.setExcludeBranch(dn);
        writer.writeChangeRecord(changeRequest);
        writer.close();
        Assertions.assertThat((int)actual.size()).isEqualTo(3);
        Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)"dn: uid=scarter,ou=People,dc=example,dc=com");
        Assertions.assertThat((String)((String)actual.get(1))).isEqualTo((Object)"changetype: delete");
        Assertions.assertThat((String)((String)actual.get(2))).isEqualTo((Object)"");
    }

    @Test
    public void testWriteDeleteRequest() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        DeleteRequest changeRequest = (DeleteRequest)Requests.newChangeRecord((String[])new String[]{"# Delete an existing entry", "dn: cn=Robert Jensen, ou=Marketing, dc=airius, dc=com", "changetype: delete"});
        writer.writeChangeRecord(changeRequest);
        writer.close();
        Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)"dn: cn=Robert Jensen,ou=Marketing,dc=airius,dc=com");
        Assertions.assertThat((String)((String)actual.get(1))).isEqualTo((Object)"changetype: delete");
    }

    @Test
    public void testWriteDeleteRequestContainingControl() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        DN dn = DN.valueOf((String)"uid=scarter,ou=People,dc=example,dc=com");
        DeleteRequest changeRequest = Requests.newDeleteRequest((DN)dn).addControl((Control)PersistentSearchRequestControl.newControl((boolean)true, (boolean)true, (boolean)true, (PersistentSearchChangeType[])new PersistentSearchChangeType[]{PersistentSearchChangeType.ADD, PersistentSearchChangeType.DELETE, PersistentSearchChangeType.MODIFY, PersistentSearchChangeType.MODIFY_DN}));
        writer.writeComment((CharSequence)"This record contains a control");
        writer.writeChangeRecord(changeRequest);
        writer.close();
        Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)"# This record contains a control");
        Assertions.assertThat((String)((String)actual.get(1))).isEqualTo((Object)"dn: uid=scarter,ou=People,dc=example,dc=com");
        Assertions.assertThat((String)((String)actual.get(2))).contains("control: 2.16.840.1.113730.3.4.3 true");
        Assertions.assertThat((String)((String)actual.get(3))).isEqualTo((Object)"changetype: delete");
        Assertions.assertThat((String)((String)actual.get(4))).isEqualTo((Object)"");
    }

    @Test(expectedExceptions={LocalizedIllegalArgumentException.class})
    public void testWriteDeleteRequestIllegalArguments() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        DeleteRequest changeRequest = (DeleteRequest)Requests.newChangeRecord((String[])new String[]{"# Delete an existing entry", "dn: cn=Robert Jensen, ou=Marketing, dc=airius, dc=com", "changetype: delete", "dn: cn=Robert , ou=Marketing, dc=airius, dc=com", "changetype: delete"});
        writer.writeChangeRecord(changeRequest);
        writer.close();
        Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)"dn: cn=Robert Jensen, ou=Marketing, dc=airius, dc=com");
        Assertions.assertThat((String)((String)actual.get(1))).isEqualTo((Object)"changetype: delete");
    }

    @Test
    public void testWriteModdnRequest() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        ModifyDNRequest changeRequest = Requests.newModifyDNRequest((String)"uid=scarter,ou=People,dc=example,dc=com", (String)"cn=carter");
        writer.writeChangeRecord(changeRequest);
        writer.close();
        Assertions.assertThat((int)actual.size()).isEqualTo(5);
        Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)"dn: uid=scarter,ou=People,dc=example,dc=com");
        Assertions.assertThat((String)((String)actual.get(1))).isEqualTo((Object)"changetype: modrdn");
        Assertions.assertThat((String)((String)actual.get(2))).isEqualTo((Object)"newrdn: cn=carter");
        Assertions.assertThat((String)((String)actual.get(3))).isEqualTo((Object)"deleteoldrdn: 0");
    }

    @Test
    public void testWriteModdnRequestNewSuperior() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        ModifyDNRequest changeRequest = (ModifyDNRequest)Requests.newChangeRecord((String[])new String[]{"version: 1", "dn: uid=scarter,ou=People,dc=example,dc=com", "changetype: moddn", "newrdn: cn=carter", "deleteoldrdn: true", "newsuperior:   ou=People,dc=example,dc=org"});
        writer.writeChangeRecord(changeRequest);
        writer.close();
        Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)"dn: uid=scarter,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)actual.size()).isEqualTo(6);
        Assertions.assertThat((String)((String)actual.get(3))).isEqualTo((Object)"deleteoldrdn: 1");
        Assertions.assertThat((String)((String)actual.get(4))).isEqualTo((Object)"newsuperior: ou=People,dc=example,dc=org");
    }

    @Test
    public void testWriteModdnRequestDeleterdnFalse() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        ModifyDNRequest changeRequest = (ModifyDNRequest)Requests.newChangeRecord((String[])new String[]{"version: 1", "", "dn: uid=scarter,ou=People,dc=example,dc=com", "changetype: moddn", "newrdn: cn=carter", "deleteoldrdn: false"});
        writer.writeChangeRecord(changeRequest);
        writer.close();
        Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)"dn: uid=scarter,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)actual.size()).isEqualTo(5);
        Assertions.assertThat((String)((String)actual.get(3))).isEqualTo((Object)"deleteoldrdn: 0");
    }

    @Test
    public void testWriteModifyRequest() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        ModifyRequest changeRequest = Requests.newModifyRequest((String[])new String[]{"version: 1", "dn: cn=scarter,dc=example,dc=com", "changetype: modify", "add: work-phone", "work-phone: 650/506-7000"});
        writer.writeChangeRecord(changeRequest);
        writer.close();
        Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)"dn: cn=scarter,dc=example,dc=com");
        Assertions.assertThat((String)((String)actual.get(1))).isEqualTo((Object)"changetype: modify");
        Assertions.assertThat((String)((String)actual.get(2))).isEqualTo((Object)"add: work-phone");
        Assertions.assertThat((String)((String)actual.get(3))).isEqualTo((Object)"work-phone: 650/506-7000");
        Assertions.assertThat((String)((String)actual.get(4))).isEqualTo((Object)"-");
    }

    @Test
    public void testWriteModifyRequestUsingControl() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        ModifyRequest changeRequest = Requests.newModifyRequest((String)"cn=scarter,dc=example,dc=com").addControl((Control)PreReadRequestControl.newControl((boolean)true, (String[])new String[]{"mail"})).addModification(ModificationType.REPLACE, "mail", new Object[]{"modified@example.com"});
        writer.writeChangeRecord(changeRequest);
        writer.close();
        Assertions.assertThat((int)actual.size()).isEqualTo(7);
        Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)"dn: cn=scarter,dc=example,dc=com");
        Assertions.assertThat((String)((String)actual.get(1))).contains("control: 1.3.6.1.1.13.1 true:");
        Assertions.assertThat((String)((String)actual.get(2))).isEqualTo((Object)"changetype: modify");
        Assertions.assertThat((String)((String)actual.get(3))).isEqualTo((Object)"replace: mail");
        Assertions.assertThat((String)((String)actual.get(4))).isEqualTo((Object)"mail: modified@example.com");
        Assertions.assertThat((String)((String)actual.get(5))).isEqualTo((Object)"-");
    }

    @Test
    public void testWriteModifyRequestNoModifications() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        ModifyRequest changeRequest = Requests.newModifyRequest((String[])new String[]{"version: 1", "", "dn: cn=scarter,dc=example,dc=com", "changetype: modify"});
        writer.writeChangeRecord(changeRequest);
        writer.close();
        Assertions.assertThat((int)actual.size()).isEqualTo(0);
    }

    @Test
    public void testWriteModifyRequestFilterAttributesExcluded() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        ModifyRequest changeRequest = (ModifyRequest)Requests.newChangeRecord((String[])new String[]{"version: 1", "", "dn: cn=scarter,dc=example,dc=com", "changetype: modify", "replace: work-phone", "work-phone: 555-555-1155"});
        writer.setExcludeAttribute(AttributeDescription.valueOf((String)"work-phone"));
        writer.writeChangeRecord(changeRequest);
        writer.close();
        Assertions.assertThat((int)actual.size()).isEqualTo(3);
        Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)"dn: cn=scarter,dc=example,dc=com");
        Assertions.assertThat((String)((String)actual.get(1))).isEqualTo((Object)"changetype: modify");
        Assertions.assertThat((String)((String)actual.get(2))).isEqualTo((Object)"");
    }

    @Test
    public void testWriteModifyRequestBranchExcludedNoMatch() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        ModifyRequest changeRequest = (ModifyRequest)Requests.newChangeRecord((String[])new String[]{"version: 1", "", "dn: cn=scarter,dc=example,dc=com", "changetype: modify", "replace: work-phone", "work-phone: 555-555-1155"});
        DN dn = DN.valueOf((String)"dc=example,dc=org");
        writer.setExcludeBranch(dn);
        writer.writeChangeRecord(changeRequest);
        writer.close();
        Assertions.assertThat((int)actual.size()).isEqualTo(6);
        Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)"dn: cn=scarter,dc=example,dc=com");
        Assertions.assertThat((String)((String)actual.get(1))).isEqualTo((Object)"changetype: modify");
        Assertions.assertThat((String)((String)actual.get(5))).isEqualTo((Object)"");
    }

    @Test
    public void testWriteModifyRequestBranchExcludedMatch() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        ModifyRequest changeRequest = (ModifyRequest)Requests.newChangeRecord((String[])new String[]{"version: 1", "", "dn: cn=scarter,dc=example,dc=com", "changetype: modify", "replace: work-phone", "work-phone: 555-555-1155"});
        DN dn = DN.valueOf((String)"dc=example,dc=com");
        writer.setExcludeBranch(dn);
        writer.writeChangeRecord(changeRequest);
        writer.close();
        Assertions.assertThat((int)actual.size()).isEqualTo(0);
    }

    @Test
    public void testWriteModifyDNRequestBranchExcludedNoMatch() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        ModifyDNRequest changeRequest = (ModifyDNRequest)Requests.newChangeRecord((String[])new String[]{"version: 1", "dn: cn=scarter,dc=example,dc=com", "changetype: modrdn", "newrdn: cn=Susan Jacobs", "deleteoldrdn: no"});
        DN dn = DN.valueOf((String)"dc=example,dc=org");
        writer.setExcludeBranch(dn);
        writer.writeChangeRecord(changeRequest);
        writer.close();
        Assertions.assertThat((int)actual.size()).isEqualTo(5);
        Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)"dn: cn=scarter,dc=example,dc=com");
        Assertions.assertThat((String)((String)actual.get(3))).isEqualTo((Object)"deleteoldrdn: 0");
    }

    @Test
    public void testWriteModifyDNRequestBranchExcludedMatch() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        ModifyDNRequest changeRequest = (ModifyDNRequest)Requests.newChangeRecord((String[])new String[]{"version: 1", "dn: cn=scarter,dc=example,dc=com", "changetype: modrdn", "newrdn: cn=Susan Jacobs", "deleteoldrdn: no"});
        DN dn = DN.valueOf((String)"dc=example,dc=com");
        writer.setExcludeBranch(dn);
        writer.writeChangeRecord(changeRequest);
        writer.close();
        Assertions.assertThat((int)actual.size()).isEqualTo(0);
    }

    @Test
    public void testWriteModifyDNRequest() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        ModifyDNRequest changeRequest = Requests.newModifyDNRequest((String)"cn=scarter,dc=example,dc=com", (String)"cn=Susan Jacobs").setDeleteOldRDN(true);
        writer.writeChangeRecord(changeRequest);
        writer.close();
        Assertions.assertThat((int)actual.size()).isEqualTo(5);
        Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)"dn: cn=scarter,dc=example,dc=com");
        Assertions.assertThat((String)((String)actual.get(1))).isEqualTo((Object)"changetype: modrdn");
        Assertions.assertThat((String)((String)actual.get(2))).isEqualTo((Object)"newrdn: cn=Susan Jacobs");
        Assertions.assertThat((String)((String)actual.get(3))).isEqualTo((Object)"deleteoldrdn: 1");
    }

    @Test
    public void testWriteMultipleChangeRecords() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        AddRequest changeRequest = Requests.newAddRequest((String[])this.getAddLDIFChangeRecord());
        ModifyDNRequest changeRequest2 = Requests.newModifyDNRequest((String)"cn=scarter,dc=example,dc=com", (String)"cn=Susan Jacobs").setDeleteOldRDN(false);
        ModifyRequest changeRequest3 = Requests.newModifyRequest((String[])new String[]{"version: 1", "", "dn: cn=scarter,dc=example,dc=com", "changetype: modify", "replace: work-phone", "work-phone: 555-555-1155"});
        AddRequest changeRequest4 = Requests.newAddRequest((String[])new String[]{"version: 1", "dn: uid=scarter,ou=People,dc=example,dc=com", "changetype: add", "sn: Carter"});
        File file = File.createTempFile("sdk", null);
        String url = file.toURI().toURL().toString();
        AddRequest changeRequest5 = Requests.newAddRequest((String[])new String[]{"version: 1", "# Add a new record", "dn: cn=Fiona Jensen, ou=Marketing, dc=airius, dc=com", "changetype: add", "objectclass: top", "objectclass: person", "objectclass: organizationalPerson", "cn: Fiona Jensen", "sn: Jensen", "uid: fiona", "telephonenumber: +1 408 555 1212", "jpegphoto:< " + url});
        writer.writeChangeRecord((ChangeRecord)changeRequest);
        writer.writeChangeRecord(changeRequest2);
        writer.writeChangeRecord(changeRequest3);
        writer.writeChangeRecord(changeRequest4);
        writer.writeComment((CharSequence)"A comment...");
        writer.writeChangeRecord(changeRequest5);
        writer.close();
        Assertions.assertThat((int)actual.size()).isGreaterThan(10);
        Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)"dn: uid=scarter,ou=People,dc=example,dc=com");
        Assertions.assertThat((String)((String)actual.get(actual.size() - 1))).isEqualTo((Object)"");
        file.delete();
    }

    @Test
    public void testWriteMultipleChangesRecord() throws Exception {
        ChangeRecord changeRequest = Requests.newChangeRecord((String[])new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "changetype: modify", "add: work-phone", "work-phone: 650/506-7000", "work-phone: 650/506-7001", "-", "delete: home-fax", "-", "replace: home-phone", "home-phone: 415/697-8899"});
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        writer.writeChangeRecord(changeRequest);
        writer.close();
        Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)"dn: uid=scarter,ou=People,dc=example,dc=com");
        Assertions.assertThat((int)actual.size()).isGreaterThan(10);
    }

    @Test
    public void testWriteComment() throws Exception {
        ArrayList actual = new ArrayList();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(actual);
        writer.writeComment((CharSequence)"TLDIFChangeRecordWriter, this is a comment.");
        writer.close();
        Assertions.assertThat((String)((String)actual.get(0))).isEqualTo((Object)"# TLDIFChangeRecordWriter, this is a comment.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteChangeRecordFlushClose() throws Exception {
        OutputStream mockOutput = (OutputStream)Mockito.mock(OutputStream.class);
        try (LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter(mockOutput);){
            writer.writeComment((CharSequence)"TLDIFChangeRecordWriter, this is a comment.");
            writer.flush();
            writer.flush();
            ((OutputStream)Mockito.verify((Object)mockOutput, (VerificationMode)Mockito.times((int)2))).flush();
        }
        finally {
            ((OutputStream)Mockito.verify((Object)mockOutput, (VerificationMode)Mockito.times((int)1))).close();
        }
    }

    @Test
    public void testWriteEntryOutputStreamUsingByteArrayOutputStream() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        LDIFChangeRecordWriter writer = new LDIFChangeRecordWriter((OutputStream)out);
        String[] lines = new String[]{"dn: cn=scarter,dc=example,dc=com", "changetype: add", "sn: Carter"};
        AddRequest changeRequest = Requests.newAddRequest((String[])lines);
        writer.writeChangeRecord(changeRequest);
        writer.close();
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(((Object)out).toString().getBytes())));
        Assertions.assertThat((String)reader.readLine()).isEqualTo((Object)lines[0]);
        Assertions.assertThat((String)reader.readLine()).isEqualTo((Object)lines[1]);
        Assertions.assertThat((String)reader.readLine()).isEqualTo((Object)lines[2]);
        Assertions.assertThat((String)reader.readLine()).isEqualTo((Object)"");
        Assertions.assertThat((String)reader.readLine()).isNull();
    }
}

