/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldif;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.fest.assertions.Assertions;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.LinkedAttribute;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.ldap.ModificationType;
import org.forgerock.opendj.ldap.RDN;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaValidationPolicy;
import org.forgerock.opendj.ldif.AbstractLDIFTestCase;
import org.forgerock.opendj.ldif.ChangeRecord;
import org.forgerock.opendj.ldif.LDIFChangeRecordReader;
import org.forgerock.opendj.ldif.RejectedLDIFListener;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.annotations.Test;

public final class LDIFChangeRecordReaderTestCase
extends AbstractLDIFTestCase {
    public final String[] getStandardLDIFChangeRecord() {
        return new String[]{"version: 1", "dn: uid=scarter,ou=People,dc=example,dc=com", "changetype: add", "sn: Carter", "cn: Samnatha Carter", "givenName: Sam", "objectClass: inetOrgPerson", "telephoneNumber: 555 555-5555", "mail: scarter@mail.org", "entryDN: uid=scarter,ou=people,dc=example,dc=org", "entryUUID: ad55a34a-763f-358f-93f9-da86f9ecd9e4", "modifyTimestamp: 20120903142126Z", "modifiersName: cn=Internal Client,cn=Root DNs,cn=config"};
    }

    @Test
    public void testSetExcludeAllOperationalAttributesFalse() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(this.getStandardLDIFChangeRecord());
        reader.setExcludeAllOperationalAttributes(false);
        ChangeRecord cr = reader.readChangeRecord();
        reader.close();
        Assertions.assertThat((String)cr.getName().toString()).isEqualTo((Object)"uid=scarter,ou=People,dc=example,dc=com");
        AddRequest addRequest = (AddRequest)cr;
        Assertions.assertThat((boolean)addRequest.containsAttribute("entryUUID", new Object[0])).isTrue();
        Assertions.assertThat((boolean)addRequest.containsAttribute("entryDN", new Object[0])).isTrue();
        Assertions.assertThat((boolean)addRequest.containsAttribute("modifyTimestamp", new Object[0])).isTrue();
        Assertions.assertThat((boolean)addRequest.containsAttribute("modifiersName", new Object[0])).isTrue();
        Assertions.assertThat((boolean)addRequest.containsAttribute("changetype", new Object[0])).isFalse();
        Assertions.assertThat((int)addRequest.getAttributeCount()).isEqualTo(10);
    }

    @Test
    public void testSetExcludeAllOperationalAttributesTrue() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(this.getStandardLDIFChangeRecord());
        reader.setExcludeAllOperationalAttributes(true);
        ChangeRecord cr = reader.readChangeRecord();
        reader.close();
        Assertions.assertThat((String)cr.getName().toString()).isEqualTo((Object)"uid=scarter,ou=People,dc=example,dc=com");
        AddRequest addRequest = (AddRequest)cr;
        Assertions.assertThat((boolean)addRequest.containsAttribute("entryUUID", new Object[0])).isFalse();
        Assertions.assertThat((boolean)addRequest.containsAttribute("entryDN", new Object[0])).isFalse();
        Assertions.assertThat((boolean)addRequest.containsAttribute("modifyTimestamp", new Object[0])).isFalse();
        Assertions.assertThat((boolean)addRequest.containsAttribute("modifiersName", new Object[0])).isFalse();
        Assertions.assertThat((boolean)addRequest.containsAttribute("changetype", new Object[0])).isFalse();
        Assertions.assertThat((int)addRequest.getAttributeCount()).isEqualTo(6);
    }

    @Test
    public void testSetExcludeAllUserAttributesFalse() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(this.getStandardLDIFChangeRecord());
        reader.setExcludeAllUserAttributes(false);
        ChangeRecord cr = reader.readChangeRecord();
        reader.close();
        Assertions.assertThat((String)cr.getName().toString()).isEqualTo((Object)"uid=scarter,ou=People,dc=example,dc=com");
        AddRequest addRequest = (AddRequest)cr;
        Assertions.assertThat((boolean)addRequest.containsAttribute("sn", new Object[0])).isTrue();
        Assertions.assertThat((boolean)addRequest.containsAttribute("givenName", new Object[0])).isTrue();
        Assertions.assertThat((boolean)addRequest.containsAttribute("mail", new Object[0])).isTrue();
        Assertions.assertThat((boolean)addRequest.containsAttribute("entryDN", new Object[0])).isTrue();
        Assertions.assertThat((boolean)addRequest.containsAttribute("changetype", new Object[0])).isFalse();
        Assertions.assertThat((int)addRequest.getAttributeCount()).isEqualTo(10);
    }

    @Test
    public void testSetExcludeAllUserAttributesTrue() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(this.getStandardLDIFChangeRecord());
        reader.setExcludeAllUserAttributes(true);
        ChangeRecord cr = reader.readChangeRecord();
        reader.close();
        Assertions.assertThat((String)cr.getName().toString()).isEqualTo((Object)"uid=scarter,ou=People,dc=example,dc=com");
        AddRequest addRequest = (AddRequest)cr;
        Assertions.assertThat((boolean)addRequest.containsAttribute("sn", new Object[0])).isFalse();
        Assertions.assertThat((boolean)addRequest.containsAttribute("givenName", new Object[0])).isFalse();
        Assertions.assertThat((boolean)addRequest.containsAttribute("mail", new Object[0])).isFalse();
        Assertions.assertThat((boolean)addRequest.containsAttribute("entryDN", new Object[0])).isTrue();
        Assertions.assertThat((boolean)addRequest.containsAttribute("changetype", new Object[0])).isFalse();
        Assertions.assertThat((int)addRequest.getAttributeCount()).isEqualTo(4);
    }

    @Test
    public void testSetExcludeAttributeWithMatch() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(this.getStandardLDIFChangeRecord());
        reader.setExcludeAttribute(AttributeDescription.valueOf((String)"cn"));
        reader.setExcludeAttribute(AttributeDescription.valueOf((String)"cn"));
        reader.setExcludeAttribute(AttributeDescription.valueOf((String)"sn"));
        reader.setExcludeAttribute(AttributeDescription.valueOf((String)"entryDN"));
        ChangeRecord cr = reader.readChangeRecord();
        reader.close();
        Assertions.assertThat((String)cr.getName().toString()).isEqualTo((Object)"uid=scarter,ou=People,dc=example,dc=com");
        AddRequest addRequest = (AddRequest)cr;
        Assertions.assertThat((boolean)addRequest.containsAttribute("entryDN", new Object[0])).isFalse();
        Assertions.assertThat((boolean)addRequest.containsAttribute("sn", new Object[0])).isFalse();
        Assertions.assertThat((boolean)addRequest.containsAttribute("cn", new Object[0])).isFalse();
        Assertions.assertThat((boolean)addRequest.containsAttribute("changetype", new Object[0])).isFalse();
        Assertions.assertThat((boolean)addRequest.containsAttribute("mail", new Object[0])).isTrue();
        Assertions.assertThat((int)addRequest.getAttributeCount()).isEqualTo(7);
    }

    @Test
    public void testSetExcludeAttributeWithNoMatch() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(this.getStandardLDIFChangeRecord());
        reader.setExcludeAttribute(AttributeDescription.valueOf((String)"vip"));
        ChangeRecord cr = reader.readChangeRecord();
        reader.close();
        Assertions.assertThat((String)cr.getName().toString()).isEqualTo((Object)"uid=scarter,ou=People,dc=example,dc=com");
        AddRequest addRequest = (AddRequest)cr;
        Assertions.assertThat((boolean)addRequest.containsAttribute("entryDN", new Object[0])).isTrue();
        Assertions.assertThat((boolean)addRequest.containsAttribute("sn", new Object[0])).isTrue();
        Assertions.assertThat((boolean)addRequest.containsAttribute("cn", new Object[0])).isTrue();
        Assertions.assertThat((boolean)addRequest.containsAttribute("mail", new Object[0])).isTrue();
        Assertions.assertThat((boolean)addRequest.containsAttribute("changetype", new Object[0])).isFalse();
        Assertions.assertThat((Collection)addRequest.getAttribute("vip")).isNull();
        Assertions.assertThat((int)addRequest.getAttributeCount()).isEqualTo(10);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testSetExcludeAttributeDoesntAllowNull() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(this.getStandardLDIFChangeRecord());
        reader.setExcludeAttribute(null);
        reader.close();
    }

    @Test
    public void testSetIncludeAttributeWithMatch() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(this.getStandardLDIFChangeRecord());
        reader.setIncludeAttribute(AttributeDescription.valueOf((String)"cn"));
        reader.setIncludeAttribute(AttributeDescription.valueOf((String)"cn"));
        reader.setIncludeAttribute(AttributeDescription.valueOf((String)"sn"));
        reader.setIncludeAttribute(AttributeDescription.valueOf((String)"entryDN"));
        ChangeRecord cr = reader.readChangeRecord();
        reader.close();
        Assertions.assertThat((String)cr.getName().toString()).isEqualTo((Object)"uid=scarter,ou=People,dc=example,dc=com");
        AddRequest addRequest = (AddRequest)cr;
        Assertions.assertThat((boolean)addRequest.containsAttribute("entryDN", new Object[0])).isTrue();
        Assertions.assertThat((boolean)addRequest.containsAttribute("sn", new Object[0])).isTrue();
        Assertions.assertThat((boolean)addRequest.containsAttribute("cn", new Object[0])).isTrue();
        Assertions.assertThat((boolean)addRequest.containsAttribute("changetype", new Object[0])).isFalse();
        Assertions.assertThat((boolean)addRequest.containsAttribute("mail", new Object[0])).isFalse();
        Assertions.assertThat((int)addRequest.getAttributeCount()).isEqualTo(3);
    }

    @Test
    public void testSetIncludeAttributeWithNoMatch() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(this.getStandardLDIFChangeRecord());
        reader.setIncludeAttribute(AttributeDescription.valueOf((String)"manager"));
        ChangeRecord cr = reader.readChangeRecord();
        reader.close();
        Assertions.assertThat((String)cr.getName().toString()).isEqualTo((Object)"uid=scarter,ou=People,dc=example,dc=com");
        AddRequest addRequest = (AddRequest)cr;
        Assertions.assertThat((boolean)addRequest.containsAttribute("entryDN", new Object[0])).isFalse();
        Assertions.assertThat((boolean)addRequest.containsAttribute("sn", new Object[0])).isFalse();
        Assertions.assertThat((boolean)addRequest.containsAttribute("cn", new Object[0])).isFalse();
        Assertions.assertThat((boolean)addRequest.containsAttribute("changetype", new Object[0])).isFalse();
        Assertions.assertThat((boolean)addRequest.containsAttribute("mail", new Object[0])).isFalse();
        Assertions.assertThat((int)addRequest.getAttributeCount()).isEqualTo(0);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testSetIncludeAttributeDoesntAllowNull() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"version: 1", "dn: uid=scarter,ou=People,dc=example,dc=com"});
        reader.setIncludeAttribute(null);
        reader.close();
    }

    @Test
    public void testSetIncludeBranchWithMatch() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(this.getStandardLDIFChangeRecord());
        reader.setIncludeBranch(DN.valueOf((String)"dc=example,dc=com"));
        ChangeRecord cr = reader.readChangeRecord();
        reader.close();
        Assertions.assertThat((String)cr.getName().toString()).isEqualTo((Object)"uid=scarter,ou=People,dc=example,dc=com");
        AddRequest addRequest = (AddRequest)cr;
        Assertions.assertThat((boolean)addRequest.containsAttribute("entryDN", new Object[0])).isTrue();
        Assertions.assertThat((boolean)addRequest.containsAttribute("sn", new Object[0])).isTrue();
        Assertions.assertThat((boolean)addRequest.containsAttribute("cn", new Object[0])).isTrue();
        Assertions.assertThat((boolean)addRequest.containsAttribute("changetype", new Object[0])).isFalse();
        Assertions.assertThat((boolean)addRequest.containsAttribute("mail", new Object[0])).isTrue();
        Assertions.assertThat((int)addRequest.getAttributeCount()).isEqualTo(10);
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testSetIncludeBranchWithNoMatch() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(this.getStandardLDIFChangeRecord());
        reader.setIncludeBranch(DN.valueOf((String)"dc=example,dc=org"));
        try {
            reader.readChangeRecord();
        }
        finally {
            reader.close();
        }
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testSetIncludeBranchDoesntAllowNull() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"version: 1", "dn: uid=scarter,ou=People,dc=example,dc=com"});
        reader.setIncludeBranch(null);
        reader.close();
    }

    @Test
    public void testSetExcludeBranchWithMatch() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(this.getStandardLDIFChangeRecord());
        reader.setExcludeBranch(DN.valueOf((String)"dc=example,dc=org"));
        ChangeRecord cr = null;
        cr = reader.readChangeRecord();
        AddRequest addRequest = (AddRequest)cr;
        Assertions.assertThat((boolean)addRequest.containsAttribute("entryDN", new Object[0])).isTrue();
        Assertions.assertThat((boolean)addRequest.containsAttribute("sn", new Object[0])).isTrue();
        Assertions.assertThat((boolean)addRequest.containsAttribute("cn", new Object[0])).isTrue();
        Assertions.assertThat((boolean)addRequest.containsAttribute("changetype", new Object[0])).isFalse();
        Assertions.assertThat((boolean)addRequest.containsAttribute("mail", new Object[0])).isTrue();
        Assertions.assertThat((int)addRequest.getAttributeCount()).isEqualTo(10);
        reader.close();
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testSetExcludeBranchWithNoMatch() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(this.getStandardLDIFChangeRecord());
        reader.setExcludeBranch(DN.valueOf((String)"dc=example,dc=com"));
        try {
            reader.readChangeRecord();
        }
        finally {
            reader.close();
        }
    }

    @Test(expectedExceptions={DecodeException.class})
    public void testSetSchemaValidationPolicyDefaultRejectsEntry() throws Exception {
        String[] strChangeRecord = new String[]{"dn: uid=user.0,ou=People,dc=example,dc=com", "changetype: add", "sn: Carter", "objectClass: person", "objectClass: top", "cn: Aaccf Amar", "sn: Amar", "uid: user.0"};
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(strChangeRecord);
        reader.setSchema(Schema.getDefaultSchema());
        reader.setSchemaValidationPolicy(SchemaValidationPolicy.defaultPolicy());
        try {
            reader.readChangeRecord();
        }
        finally {
            reader.close();
        }
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testSetExcludeBranchDoesntAllowNull() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"version: 1", "dn: uid=scarter,ou=People,dc=example,dc=com"});
        reader.setExcludeBranch(null);
        reader.close();
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testSetSchemaDoesntAllowNull() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"version: 1", "dn: uid=scarter,ou=People,dc=example,dc=com"});
        reader.setSchema(null);
        reader.close();
    }

    @Test
    public void testSetSchemaValidationPolicyDefaultAllowsEntry() throws Exception {
        String[] strChangeRecord = new String[]{"dn: uid=user.0,ou=People,dc=example,dc=com", "changetype: add", "sn: Carter", "objectClass: person", "objectClass: top", "cn: Aaccf Amar", "sn: Amar"};
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(strChangeRecord);
        reader.setSchema(Schema.getDefaultSchema());
        reader.setSchemaValidationPolicy(SchemaValidationPolicy.defaultPolicy());
        ChangeRecord cr = reader.readChangeRecord();
        AddRequest addRequest = (AddRequest)cr;
        Assertions.assertThat((String)cr.getName().toString()).isEqualTo((Object)"uid=user.0,ou=People,dc=example,dc=com");
        Assertions.assertThat((boolean)addRequest.containsAttribute("sn", new Object[0])).isTrue();
        Assertions.assertThat((boolean)addRequest.containsAttribute("cn", new Object[0])).isTrue();
        Assertions.assertThat((int)addRequest.getAttributeCount()).isEqualTo(3);
        reader.close();
    }

    @Test(expectedExceptions={DecodeException.class})
    public void testReadAddRecordWithEmptyPairKeyChangeType() throws Exception {
        try (LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"dn: dc=example,dc=com", ":add"});){
            reader.readChangeRecord();
        }
    }

    @Test(expectedExceptions={DecodeException.class})
    public void testReadAddRecordWithWrongChangeType() throws Exception {
        try (LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"dn: dc=example,dc=com", "changetype: oops", "objectClass: top", "objectClass: domainComponent", "dc: example"});){
            reader.readChangeRecord();
        }
    }

    @Test
    public void testReadAddRecordWithChangeType() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"dn: dc=example,dc=com", "changetype: add", "objectClass: top", "objectClass: domainComponent", "dc: example"});
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        ChangeRecord record = reader.readChangeRecord();
        Assertions.assertThat((Object)record).isInstanceOf(AddRequest.class);
        Assertions.assertThat((String)record.getName().toString()).isEqualTo((Object)"dc=example,dc=com");
        AddRequest addRequest = (AddRequest)record;
        Assertions.assertThat((boolean)addRequest.containsAttribute("objectClass", new Object[]{"top", "domainComponent"})).isTrue();
        Assertions.assertThat((boolean)addRequest.containsAttribute("dc", new Object[]{"example"})).isTrue();
        Assertions.assertThat((int)addRequest.getAttributeCount()).isEqualTo(2);
        Assertions.assertThat((boolean)reader.hasNext()).isFalse();
        reader.close();
    }

    @Test
    public void testReadAddRecordWithoutChangeType() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"dn: dc=example,dc=com", "objectClass: top", "objectClass: domainComponent", "dc: example"});
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        ChangeRecord record = reader.readChangeRecord();
        Assertions.assertThat((Object)record).isInstanceOf(AddRequest.class);
        Assertions.assertThat((String)record.getName().toString()).isEqualTo((Object)"dc=example,dc=com");
        AddRequest addRequest = (AddRequest)record;
        Assertions.assertThat((boolean)addRequest.containsAttribute("objectClass", new Object[]{"top", "domainComponent"})).isTrue();
        Assertions.assertThat((boolean)addRequest.containsAttribute("dc", new Object[]{"example"})).isTrue();
        Assertions.assertThat((int)addRequest.getAttributeCount()).isEqualTo(2);
        reader.close();
    }

    @Test
    public void testReadModifyRecord() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"dn: dc=example,dc=com", "changetype: modify", "add: description", "-", "add: description", "description: value1", "-", "add: description", "description: value1", "description: value2", "-", "delete: description", "-", "delete: description", "description: value1", "-", "delete: description", "description: value1", "description: value2", "-", "replace: description", "-", "replace: description", "description: value1", "-", "replace: description", "description: value1", "description: value2", "-", "increment: description", "description: 1"});
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        ChangeRecord record = reader.readChangeRecord();
        Assertions.assertThat((Object)record).isInstanceOf(ModifyRequest.class);
        Assertions.assertThat((String)record.getName().toString()).isEqualTo((Object)"dc=example,dc=com");
        ModifyRequest modifyRequest = (ModifyRequest)record;
        Iterator changes = modifyRequest.getModifications().iterator();
        Modification modification = (Modification)changes.next();
        Assertions.assertThat((Object)modification.getModificationType()).isEqualTo((Object)ModificationType.ADD);
        Assertions.assertThat((Collection)modification.getAttribute()).isEqualTo((Object)new LinkedAttribute("description"));
        modification = (Modification)changes.next();
        Assertions.assertThat((Object)modification.getModificationType()).isEqualTo((Object)ModificationType.ADD);
        Assertions.assertThat((Collection)modification.getAttribute()).isEqualTo((Object)new LinkedAttribute("description", (Object)"value1"));
        modification = (Modification)changes.next();
        Assertions.assertThat((Object)modification.getModificationType()).isEqualTo((Object)ModificationType.ADD);
        Assertions.assertThat((Collection)modification.getAttribute()).isEqualTo((Object)new LinkedAttribute("description", new Object[]{"value1", "value2"}));
        modification = (Modification)changes.next();
        Assertions.assertThat((Object)modification.getModificationType()).isEqualTo((Object)ModificationType.DELETE);
        Assertions.assertThat((Collection)modification.getAttribute()).isEqualTo((Object)new LinkedAttribute("description"));
        modification = (Modification)changes.next();
        Assertions.assertThat((Object)modification.getModificationType()).isEqualTo((Object)ModificationType.DELETE);
        Assertions.assertThat((Collection)modification.getAttribute()).isEqualTo((Object)new LinkedAttribute("description", (Object)"value1"));
        modification = (Modification)changes.next();
        Assertions.assertThat((Object)modification.getModificationType()).isEqualTo((Object)ModificationType.DELETE);
        Assertions.assertThat((Collection)modification.getAttribute()).isEqualTo((Object)new LinkedAttribute("description", new Object[]{"value1", "value2"}));
        modification = (Modification)changes.next();
        Assertions.assertThat((Object)modification.getModificationType()).isEqualTo((Object)ModificationType.REPLACE);
        Assertions.assertThat((Collection)modification.getAttribute()).isEqualTo((Object)new LinkedAttribute("description"));
        modification = (Modification)changes.next();
        Assertions.assertThat((Object)modification.getModificationType()).isEqualTo((Object)ModificationType.REPLACE);
        Assertions.assertThat((Collection)modification.getAttribute()).isEqualTo((Object)new LinkedAttribute("description", (Object)"value1"));
        modification = (Modification)changes.next();
        Assertions.assertThat((Object)modification.getModificationType()).isEqualTo((Object)ModificationType.REPLACE);
        Assertions.assertThat((Collection)modification.getAttribute()).isEqualTo((Object)new LinkedAttribute("description", new Object[]{"value1", "value2"}));
        modification = (Modification)changes.next();
        Assertions.assertThat((Object)modification.getModificationType()).isEqualTo((Object)ModificationType.INCREMENT);
        Assertions.assertThat((Collection)modification.getAttribute()).isEqualTo((Object)new LinkedAttribute("description", (Object)"1"));
        Assertions.assertThat((boolean)changes.hasNext()).isFalse();
        reader.close();
    }

    @Test
    public void testReadModdnRecordWithoutNewSuperior() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"dn: dc=example,dc=com", "changetype: moddn", "newrdn: dc=eggsample", "deleteoldrdn: true"});
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        ChangeRecord record = reader.readChangeRecord();
        Assertions.assertThat((Object)record).isInstanceOf(ModifyDNRequest.class);
        ModifyDNRequest modifyDNRequest = (ModifyDNRequest)record;
        Assertions.assertThat((Object)modifyDNRequest.getName()).isEqualTo((Object)DN.valueOf((String)"dc=example,dc=com"));
        Assertions.assertThat((Object)modifyDNRequest.getNewRDN()).isEqualTo((Object)RDN.valueOf((String)"dc=eggsample"));
        Assertions.assertThat((boolean)modifyDNRequest.isDeleteOldRDN()).isTrue();
        Assertions.assertThat((Iterable)modifyDNRequest.getNewSuperior()).isNull();
        reader.close();
    }

    @Test
    public void testReadModdnRecordWithNewSuperior() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"dn: dc=example,dc=com", "changetype: moddn", "newrdn: dc=eggsample", "deleteoldrdn: true", "newsuperior: dc=org"});
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        ChangeRecord record = reader.readChangeRecord();
        Assertions.assertThat((Object)record).isInstanceOf(ModifyDNRequest.class);
        ModifyDNRequest modifyDNRequest = (ModifyDNRequest)record;
        Assertions.assertThat((Object)modifyDNRequest.getName()).isEqualTo((Object)DN.valueOf((String)"dc=example,dc=com"));
        Assertions.assertThat((Object)modifyDNRequest.getNewRDN()).isEqualTo((Object)RDN.valueOf((String)"dc=eggsample"));
        Assertions.assertThat((boolean)modifyDNRequest.isDeleteOldRDN()).isTrue();
        Assertions.assertThat((Object)modifyDNRequest.getNewSuperior()).isEqualTo((Object)DN.valueOf((String)"dc=org"));
        reader.close();
    }

    @Test
    public void testRejectedRecordListenerMalformedFirstRecord() throws Exception {
        RejectedLDIFListener listener = (RejectedLDIFListener)Mockito.mock(RejectedLDIFListener.class);
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"dn: baddn", "changetype: add", "objectClass: top", "objectClass: domainComponent", "dc: example"});
        reader.setRejectedLDIFListener(listener);
        Assertions.assertThat((boolean)reader.hasNext()).isFalse();
        ((RejectedLDIFListener)Mockito.verify((Object)listener)).handleMalformedRecord(Mockito.eq((long)1L), (List)Mockito.eq(Arrays.asList("dn: baddn", "changetype: add", "objectClass: top", "objectClass: domainComponent", "dc: example")), (LocalizableMessage)Mockito.any(LocalizableMessage.class));
        reader.close();
    }

    @Test
    public void testRejectedRecordListenerMalformedSecondRecord() throws Exception {
        RejectedLDIFListener listener = (RejectedLDIFListener)Mockito.mock(RejectedLDIFListener.class);
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"dn: dc=example,dc=com", "changetype: add", "objectClass: top", "objectClass: domainComponent", "dc: example", "", "dn: baddn", "changetype: add", "objectClass: top", "objectClass: domainComponent", "dc: example"});
        reader.setRejectedLDIFListener(listener);
        reader.readChangeRecord();
        Assertions.assertThat((boolean)reader.hasNext()).isFalse();
        ((RejectedLDIFListener)Mockito.verify((Object)listener)).handleMalformedRecord(Mockito.eq((long)7L), (List)Mockito.eq(Arrays.asList("dn: baddn", "changetype: add", "objectClass: top", "objectClass: domainComponent", "dc: example")), (LocalizableMessage)Mockito.any(LocalizableMessage.class));
        reader.close();
    }

    @Test
    public void testRejectedRecordListenerSkipsRecord() throws Exception {
        RejectedLDIFListener listener = (RejectedLDIFListener)Mockito.mock(RejectedLDIFListener.class);
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"dn: dc=example,dc=com", "changetype: add", "objectClass: top", "objectClass: domainComponent", "dc: example"});
        reader.setRejectedLDIFListener(listener).setExcludeBranch(DN.valueOf((String)"dc=com"));
        Assertions.assertThat((boolean)reader.hasNext()).isFalse();
        ((RejectedLDIFListener)Mockito.verify((Object)listener)).handleSkippedRecord(Mockito.eq((long)1L), (List)Mockito.eq(Arrays.asList("dn: dc=example,dc=com", "changetype: add", "objectClass: top", "objectClass: domainComponent", "dc: example")), (LocalizableMessage)Mockito.any(LocalizableMessage.class));
        reader.close();
    }

    @Test
    public void testRejectedRecordListenerRejectsBadSchemaRecord() throws Exception {
        RejectedLDIFListener listener = (RejectedLDIFListener)Mockito.mock(RejectedLDIFListener.class);
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"dn: dc=example,dc=com", "changetype: add", "objectClass: top", "objectClass: domainComponent", "dc: example", "xxx: unknown attribute"});
        reader.setRejectedLDIFListener(listener).setSchemaValidationPolicy(SchemaValidationPolicy.ignoreAll().checkAttributesAndObjectClasses(SchemaValidationPolicy.Action.REJECT));
        Assertions.assertThat((boolean)reader.hasNext()).isFalse();
        ((RejectedLDIFListener)Mockito.verify((Object)listener)).handleSchemaValidationFailure(Mockito.eq((long)1L), (List)Mockito.eq(Arrays.asList("dn: dc=example,dc=com", "changetype: add", "objectClass: top", "objectClass: domainComponent", "dc: example", "xxx: unknown attribute")), Mockito.anyListOf(LocalizableMessage.class));
        reader.close();
    }

    @Test
    public void testRejectedRecordListenerWarnsBadSchemaRecord() throws Exception {
        RejectedLDIFListener listener = (RejectedLDIFListener)Mockito.mock(RejectedLDIFListener.class);
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"dn: dc=example,dc=com", "changetype: add", "objectClass: top", "objectClass: domainComponent", "dc: example", "xxx: unknown attribute"});
        reader.setRejectedLDIFListener(listener).setSchemaValidationPolicy(SchemaValidationPolicy.ignoreAll().checkAttributesAndObjectClasses(SchemaValidationPolicy.Action.WARN));
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        ChangeRecord record = reader.readChangeRecord();
        Assertions.assertThat((Object)record).isInstanceOf(AddRequest.class);
        AddRequest addRequest = (AddRequest)record;
        Assertions.assertThat((Object)addRequest.getName()).isEqualTo((Object)DN.valueOf((String)"dc=example,dc=com"));
        Assertions.assertThat((boolean)addRequest.containsAttribute("objectClass", new Object[]{"top", "domainComponent"})).isTrue();
        Assertions.assertThat((boolean)addRequest.containsAttribute("dc", new Object[]{"example"})).isTrue();
        Assertions.assertThat((int)addRequest.getAttributeCount()).isEqualTo(2);
        ((RejectedLDIFListener)Mockito.verify((Object)listener)).handleSchemaValidationWarning(Mockito.eq((long)1L), (List)Mockito.eq(Arrays.asList("dn: dc=example,dc=com", "changetype: add", "objectClass: top", "objectClass: domainComponent", "dc: example", "xxx: unknown attribute")), Mockito.anyListOf(LocalizableMessage.class));
        reader.close();
    }

    @Test(expectedExceptions={DecodeException.class})
    public void testReadFileContainingInvalidURLThrowsError() throws Exception {
        File file = File.createTempFile("sdk", null);
        String url = file.toURI().toURL().toString();
        file.delete();
        try (LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"version: 1", "# Add a new entry", "dn: cn=Fiona Jensen, ou=Marketing, dc=airius, dc=com", "changetype: add", "objectclass: top", "objectclass: person", "objectclass: organizationalPerson", "cn: Fiona Jensen", "sn: Jensen", "uid: fiona", "telephonenumber: +1 408 555 1212", "jpegphoto:< " + url});){
            reader.readChangeRecord();
        }
    }

    @Test
    public void testReadFileContainingSerieOfChanges() throws Exception {
        File file = File.createTempFile("sdk", ".png");
        String url = file.toURI().toURL().toString();
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"version: 1", "# Add a new entry", "dn: cn=Fiona Jensen,", " ou=Marketing, dc=airius, dc=com", "changetype: add", "objectclass: top", "objectclass: person", "objectclass: organizationalPerson", "cn: Fiona Jensen", "sn: Jensen", "uid: fiona", "telephonenumber: +1 408 555 1212", "jpegphoto:< " + url, "", "# Delete an existing entry", "dn: cn=Robert Jensen, ou=Marketing, dc=airius, dc=com", "changetype: delete", "", "# Modify an entry's relative distinguished name", "dn: cn=Paul Jensen, ou=Product Development, dc=airius, dc=com", "changetype: modrdn", "newrdn: cn=Paula Jensen", "deleteoldrdn: 1", "", "# Rename an entry and move all of its children to a new location in", "# the directory tree (only implemented by LDAPv3 servers).", "dn: ou=PD Accountants, ou=Product Development, dc=airius, dc=com", "changetype: modrdn", "newrdn: ou=Product Development Accountants", "deleteoldrdn: 0", "newsuperior: ou=Accounting, dc=airius, dc=com", ""});
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        ChangeRecord record = reader.readChangeRecord();
        Assertions.assertThat((Object)record).isInstanceOf(AddRequest.class);
        AddRequest addReq = (AddRequest)record;
        Assertions.assertThat((Object)addReq.getName()).isEqualTo((Object)DN.valueOf((String)"cn=Fiona Jensen, ou=Marketing, dc=airius, dc=com"));
        record = reader.readChangeRecord();
        Assertions.assertThat((Object)record).isInstanceOf(DeleteRequest.class);
        DeleteRequest delReq = (DeleteRequest)record;
        Assertions.assertThat((Object)delReq.getName()).isEqualTo((Object)DN.valueOf((String)"cn=Robert Jensen, ou=Marketing, dc=airius, dc=com"));
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        record = reader.readChangeRecord();
        Assertions.assertThat((Object)record).isInstanceOf(ModifyDNRequest.class);
        ModifyDNRequest modDNReq = (ModifyDNRequest)record;
        Assertions.assertThat((Object)modDNReq.getNewRDN()).isEqualTo((Object)RDN.valueOf((String)"cn=Paula Jensen"));
        Assertions.assertThat((Object)modDNReq.getName()).isEqualTo((Object)DN.valueOf((String)"cn=Paul Jensen, ou=Product Development, dc=airius, dc=com"));
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        record = reader.readChangeRecord();
        Assertions.assertThat((Object)record).isInstanceOf(ModifyDNRequest.class);
        modDNReq = (ModifyDNRequest)record;
        Assertions.assertThat((Object)modDNReq.getName()).isEqualTo((Object)DN.valueOf((String)"ou=PD Accountants, ou=Product Development, dc=airius, dc=com"));
        Assertions.assertThat((boolean)reader.hasNext()).isFalse();
        file.delete();
        reader.close();
    }

    @Test
    public void testParseChangeRecordEntryWithDeleteControl() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"# Delete an entry. The operation will attach the LDAPv3", "# Tree Delete Control defined in [9]. The criticality", "# field is \"true\" and the controlValue field is", "# absent, as required by [9].", "dn: ou=Product Development, dc=airius, dc=com", "control: 1.2.840.113556.1.4.805 true :cn", "changetype: delete"});
        reader.setSchema(Schema.getDefaultSchema());
        reader.setSchemaValidationPolicy(SchemaValidationPolicy.defaultPolicy());
        ChangeRecord record = reader.readChangeRecord();
        Assertions.assertThat((Object)record).isInstanceOf(DeleteRequest.class);
        Assertions.assertThat((String)record.getName().toString()).isEqualTo((Object)"ou=Product Development,dc=airius,dc=com");
        Assertions.assertThat((List)record.getControls()).isNotEmpty();
        Assertions.assertThat((String)((Control)record.getControls().get(0)).getOID()).isEqualTo((Object)"1.2.840.113556.1.4.805");
        Assertions.assertThat((String)((Control)record.getControls().get(0)).getValue().toString()).isEqualTo((Object)"cn");
        reader.close();
    }

    @Test
    public void testParseChangeRecordEntryWithAddControl() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"dn: ou=Product Development, dc=airius, dc=com", "control: 1.3.6.1.1.13.1 false :cn", "changetype: add", "objectClass: top", "objectClass: organization", "o: testing"});
        reader.setSchema(Schema.getDefaultSchema());
        reader.setSchemaValidationPolicy(SchemaValidationPolicy.defaultPolicy());
        ChangeRecord record = reader.readChangeRecord();
        Assertions.assertThat((Object)record).isInstanceOf(AddRequest.class);
        Assertions.assertThat((String)record.getName().toString()).isEqualTo((Object)"ou=Product Development,dc=airius,dc=com");
        Assertions.assertThat((List)record.getControls()).isNotEmpty();
        Assertions.assertThat((String)((Control)record.getControls().get(0)).getOID()).isEqualTo((Object)"1.3.6.1.1.13.1");
        Assertions.assertThat((String)((Control)record.getControls().get(0)).getValue().toString()).isEqualTo((Object)"cn");
        reader.close();
    }

    @Test(expectedExceptions={DecodeException.class})
    public void testParseChangeRecordEntryWithAnInvalidControl() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"dn: ou=Product Development, dc=airius, dc=com", "control: 1.2.3.4 0 value", "changetype: add", "objectClass: top", "objectClass: organization", "o: testing"});
        reader.setSchema(Schema.getDefaultSchema());
        reader.setSchemaValidationPolicy(SchemaValidationPolicy.defaultPolicy());
        reader.readChangeRecord();
        reader.close();
    }

    @Test
    public void testParseChangeRecordEntryWithAddControlWithoutSpacesBetweenCriticalityValue() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"dn: ou=Product Development, dc=airius, dc=com", "control: 1.3.6.1.1.13.1 false:cn", "changetype: add", "objectClass: top", "objectClass: organization", "o: testing"});
        reader.setSchema(Schema.getDefaultSchema());
        reader.setSchemaValidationPolicy(SchemaValidationPolicy.defaultPolicy());
        ChangeRecord record = reader.readChangeRecord();
        Assertions.assertThat((Object)record).isInstanceOf(AddRequest.class);
        Assertions.assertThat((String)record.getName().toString()).isEqualTo((Object)"ou=Product Development,dc=airius,dc=com");
        Assertions.assertThat((List)record.getControls()).isNotEmpty();
        Assertions.assertThat((String)((Control)record.getControls().get(0)).getOID()).isEqualTo((Object)"1.3.6.1.1.13.1");
        Assertions.assertThat((String)((Control)record.getControls().get(0)).getValue().toString()).isEqualTo((Object)"cn");
        reader.close();
    }

    @Test
    public void testParseChangeRecordEntryWithAddControlContainingWhiteSpaces() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"dn: ou=Product Development, dc=airius, dc=com", "control: 1.3.6.1.1.13.1 true : sn", "changetype: add", "objectClass: top", "objectClass: organization", "o: testing"});
        reader.setSchema(Schema.getDefaultSchema());
        reader.setSchemaValidationPolicy(SchemaValidationPolicy.defaultPolicy());
        ChangeRecord record = reader.readChangeRecord();
        Assertions.assertThat((Object)record).isInstanceOf(AddRequest.class);
        Assertions.assertThat((String)record.getName().toString()).isEqualTo((Object)"ou=Product Development,dc=airius,dc=com");
        Assertions.assertThat((List)record.getControls()).isNotEmpty();
        Assertions.assertThat((String)((Control)record.getControls().get(0)).getOID()).isEqualTo((Object)"1.3.6.1.1.13.1");
        Assertions.assertThat((String)((Control)record.getControls().get(0)).getValue().toString()).isEqualTo((Object)"sn");
        reader.close();
    }

    @Test
    public void testParseChangeRecordEntryWithAddControlContainingBase64Value() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"# This record contains a base64 value", "dn: uid=scarter,ou=People,dc=example,dc=com", "control: 2.16.840.1.113730.3.4.3 true::ZGVzY3JpcHRpb24=", "changetype: delete"});
        reader.setSchema(Schema.getDefaultSchema());
        reader.setSchemaValidationPolicy(SchemaValidationPolicy.defaultPolicy());
        ChangeRecord record = reader.readChangeRecord();
        Assertions.assertThat((Object)record).isInstanceOf(DeleteRequest.class);
        Assertions.assertThat((String)record.getName().toString()).isEqualTo((Object)"uid=scarter,ou=People,dc=example,dc=com");
        Assertions.assertThat((List)record.getControls()).isNotEmpty();
        Assertions.assertThat((String)((Control)record.getControls().get(0)).getOID()).isEqualTo((Object)"2.16.840.1.113730.3.4.3");
        Assertions.assertThat((String)((Control)record.getControls().get(0)).getValue().toString()).isEqualTo((Object)"description");
        reader.close();
    }

    @Test(expectedExceptions={DecodeException.class})
    public void testParseChangeRecordEntryWithAddControlMalformedBase64() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"# This record contains a control", "dn: uid=scarter,ou=People,dc=example,dc=com", "control: 2.16.840.1.113730.3.4.3 true:: malformedBase64", "changetype: delete"});
        reader.setSchema(Schema.getDefaultSchema());
        reader.setSchemaValidationPolicy(SchemaValidationPolicy.defaultPolicy());
        reader.readChangeRecord();
        reader.close();
    }

    @Test
    public void testParseChangeRecordEntryWithAddControlContainingURL() throws Exception {
        File file = File.createTempFile("sdk", ".png");
        String url = file.toURI().toURL().toString();
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"# This record contains a base64 value", "dn: uid=scarter,ou=People,dc=example,dc=com", "control: 2.16.840.1.113730.3.4.3 true:<" + url, "changetype: delete"});
        reader.setSchema(Schema.getDefaultSchema());
        reader.setSchemaValidationPolicy(SchemaValidationPolicy.defaultPolicy());
        ChangeRecord record = reader.readChangeRecord();
        Assertions.assertThat((Object)record).isInstanceOf(DeleteRequest.class);
        Assertions.assertThat((String)record.getName().toString()).isEqualTo((Object)"uid=scarter,ou=People,dc=example,dc=com");
        Assertions.assertThat((List)record.getControls()).isNotEmpty();
        Assertions.assertThat((String)((Control)record.getControls().get(0)).getOID()).isEqualTo((Object)"2.16.840.1.113730.3.4.3");
        Assertions.assertThat((String)((Control)record.getControls().get(0)).getValue().toString()).isEmpty();
        file.delete();
        reader.close();
    }

    @Test(expectedExceptions={DecodeException.class})
    public void testParseChangeRecordEntryWithAddControlMalformedURL() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"# This record contains a control", "dn: uid=scarter,ou=People,dc=example,dc=com", "control: 2.16.840.1.113730.3.4.3 true:<malformedURL", "changetype: delete"});
        reader.setSchema(Schema.getDefaultSchema());
        reader.setSchemaValidationPolicy(SchemaValidationPolicy.defaultPolicy());
        reader.readChangeRecord();
        reader.close();
    }

    @Test
    public void testParseChangeRecordEntryWithAddControlWithoutValue() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"dn: ou=Product Development, dc=airius, dc=com", "control: 1.3.6.1.1.13.1 false ", "changetype: add", "objectClass: top", "objectClass: organization", "o: testing"});
        reader.setSchema(Schema.getDefaultSchema());
        reader.setSchemaValidationPolicy(SchemaValidationPolicy.defaultPolicy());
        ChangeRecord record = reader.readChangeRecord();
        Assertions.assertThat((Object)record).isInstanceOf(AddRequest.class);
        Assertions.assertThat((String)record.getName().toString()).isEqualTo((Object)"ou=Product Development,dc=airius,dc=com");
        Assertions.assertThat((List)record.getControls()).isNotEmpty();
        Assertions.assertThat((String)((Control)record.getControls().get(0)).getOID()).isEqualTo((Object)"1.3.6.1.1.13.1");
        Assertions.assertThat((Object)((Control)record.getControls().get(0)).getValue()).isNull();
        reader.close();
    }

    @Test
    public void testParseChangeRecordEntryWithAddControlWithoutCriticality() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"dn: ou=Product Development, dc=airius, dc=com", "control:1.3.6.1.1.13.1 :description", "changetype: add", "objectClass: top", "objectClass: organization", "o: testing"});
        reader.setSchema(Schema.getDefaultSchema());
        reader.setSchemaValidationPolicy(SchemaValidationPolicy.defaultPolicy());
        ChangeRecord record = reader.readChangeRecord();
        Assertions.assertThat((Object)record).isInstanceOf(AddRequest.class);
        Assertions.assertThat((String)record.getName().toString()).isEqualTo((Object)"ou=Product Development,dc=airius,dc=com");
        Assertions.assertThat((List)record.getControls()).isNotEmpty();
        Assertions.assertThat((String)((Control)record.getControls().get(0)).getOID()).isEqualTo((Object)"1.3.6.1.1.13.1");
        Assertions.assertThat((String)((Control)record.getControls().get(0)).getValue().toString()).isEqualTo((Object)"description");
        reader.close();
    }

    @Test
    public void testParseChangeRecordEntryWithAddControlProvidedByChangeRecordWriter() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"# This record contains a control", "dn: uid=scarter,ou=People,dc=example,dc=com", "control: 2.16.840.1.113730.3.4.3 true:: MAkCAQ8BAf8BAf8=", "changetype: delete"});
        reader.setSchema(Schema.getDefaultSchema());
        reader.setSchemaValidationPolicy(SchemaValidationPolicy.defaultPolicy());
        ChangeRecord record = reader.readChangeRecord();
        Assertions.assertThat((Object)record).isInstanceOf(DeleteRequest.class);
        Assertions.assertThat((String)record.getName().toString()).isEqualTo((Object)"uid=scarter,ou=People,dc=example,dc=com");
        Assertions.assertThat((List)record.getControls()).isNotEmpty();
        Assertions.assertThat((String)((Control)record.getControls().get(0)).getOID()).isEqualTo((Object)"2.16.840.1.113730.3.4.3");
        Assertions.assertThat((String)((Control)record.getControls().get(0)).getValue().toBase64String()).isEqualTo((Object)"MAkCAQ8BAf8BAf8=");
        reader.close();
    }

    @Test
    public void testParseChangeRecordEntryWithMultipleControls() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"dn: ou=Product Development, dc=airius, dc=com", "control: 1.3.6.1.1.13.1 false", "changetype: add", "objectClass: top", "objectClass: organization", "o: testing", "", "# Modify an entry's relative distinguished name", "dn: cn=Paul Jensen, ou=Product Development, dc=airius, dc=com", "control: 1.3.6.1.1.13.13 false: cn", "changetype: add", "objectClass: top", "objectClass: organization", "o: testing", "", "# Modify an entry's relative distinguished name", "dn: cn=Paula Jensen, ou=Product Development, dc=airius, dc=com", "control:1.3.6.1.1.13.13.16 :sn", "changetype: add", "objectClass: top", "objectClass: organization", "o: testing"});
        reader.setSchema(Schema.getDefaultSchema());
        reader.setSchemaValidationPolicy(SchemaValidationPolicy.defaultPolicy());
        ChangeRecord record = reader.readChangeRecord();
        Assertions.assertThat((String)record.getName().toString()).isEqualTo((Object)"ou=Product Development,dc=airius,dc=com");
        Assertions.assertThat((List)record.getControls()).isNotEmpty();
        Assertions.assertThat((String)((Control)record.getControls().get(0)).getOID()).isEqualTo((Object)"1.3.6.1.1.13.1");
        Assertions.assertThat((Object)((Control)record.getControls().get(0)).getValue()).isNull();
        record = reader.readChangeRecord();
        Assertions.assertThat((Object)record).isInstanceOf(AddRequest.class);
        Assertions.assertThat((String)record.getName().toString()).isEqualTo((Object)"cn=Paul Jensen,ou=Product Development,dc=airius,dc=com");
        Assertions.assertThat((List)record.getControls()).isNotEmpty();
        Assertions.assertThat((String)((Control)record.getControls().get(0)).getOID()).isEqualTo((Object)"1.3.6.1.1.13.13");
        Assertions.assertThat((String)((Control)record.getControls().get(0)).getValue().toString()).isEqualTo((Object)"cn");
        record = reader.readChangeRecord();
        Assertions.assertThat((Object)record).isInstanceOf(AddRequest.class);
        Assertions.assertThat((String)record.getName().toString()).isEqualTo((Object)"cn=Paula Jensen,ou=Product Development,dc=airius,dc=com");
        Assertions.assertThat((List)record.getControls()).isNotEmpty();
        Assertions.assertThat((String)((Control)record.getControls().get(0)).getOID()).isEqualTo((Object)"1.3.6.1.1.13.13.16");
        Assertions.assertThat((String)((Control)record.getControls().get(0)).getValue().toString()).isEqualTo((Object)"sn");
        reader.close();
    }

    @Test(expectedExceptions={DecodeException.class})
    public void testParseChangeRecordEntryRejectedWhenControlIsEmpty() throws Exception {
        try (LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"dn: ou=Product Development, dc=airius, dc=com", "control:", "changetype: add", "objectClass: top", "objectClass: organization", "o: testing"});){
            reader.readChangeRecord();
        }
    }

    @Test(expectedExceptions={DecodeException.class})
    public void testParseAddChangeRecordEntryLastLDIFLineIsNull() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "wrongchangetype: add", "uid:Carter"});
        reader.setSchema(Schema.getDefaultSchema());
        reader.setSchemaValidationPolicy(SchemaValidationPolicy.defaultPolicy());
        try {
            reader.readChangeRecord();
        }
        finally {
            reader.close();
        }
    }

    @Test
    public void testParseDeleteChangeRecordEntry() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"dn: dc=example,dc=com", "changetype: delete"});
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        ChangeRecord record = reader.readChangeRecord();
        Assertions.assertThat((Object)record).isInstanceOf(DeleteRequest.class);
        DeleteRequest deleteRequest = (DeleteRequest)record;
        Assertions.assertThat((Object)deleteRequest.getName()).isEqualTo((Object)DN.valueOf((String)"dc=example,dc=com"));
        reader.close();
    }

    @Test(expectedExceptions={DecodeException.class})
    public void testParseDeleteChangeRecordEntryMalformedDelete() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"# Delete an existing entry", "dn: cn=Robert Jensen, ou=Marketing, dc=airius, dc=com", "changetype: delete", "-", "add: telephonenumber", "telephonenumber: 555-4321"});
        reader.readChangeRecord();
        reader.close();
    }

    @Test
    public void testParseModifyChangeRecordEntryDeleteMultipleValuableAttributes() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"# Add new entry containing multiple attributes", "dn: cn=Fiona Jensen, ou=Marketing, dc=airius, dc=com", "changetype: modify", "delete: telephonenumber", "telephonenumber: +1 408 555 1212", "telephonenumber: +1 408 555 1213", "telephonenumber: +1 408 555 1214"});
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        reader.setSchema(Schema.getDefaultSchema());
        reader.setSchemaValidationPolicy(SchemaValidationPolicy.defaultPolicy());
        ChangeRecord record = reader.readChangeRecord();
        Assertions.assertThat((Object)record).isInstanceOf(ModifyRequest.class);
        ModifyRequest req = (ModifyRequest)record;
        Assertions.assertThat((Object)req.getName()).isEqualTo((Object)DN.valueOf((String)"cn=Fiona Jensen, ou=Marketing, dc=airius, dc=com"));
        Assertions.assertThat((boolean)reader.hasNext()).isFalse();
        reader.close();
    }

    @Test(expectedExceptions={DecodeException.class})
    public void testParseModifyChangeRecordEntryDeleteMultipleValuableAttributesMalformedLDIF() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"# Add new entry containing multiple attributes", "dn: cn=Fiona Jensen, ou=Marketing, dc=airius, dc=com", "changetype: modify", "delete: telephonenumber", "telephonenumber: +1 408 555 1212", "telephonenumber:", "telephonenumber: +1 408 555 1214", "-"});
        reader.setSchema(Schema.getDefaultSchema());
        reader.setSchemaValidationPolicy(SchemaValidationPolicy.defaultPolicy());
        try {
            reader.readChangeRecord();
        }
        finally {
            reader.close();
        }
    }

    @Test
    public void testParseModifyChangeRecordBEREncodingRequired() throws Exception {
        String validcert1 = "MIICpTCCAg6gAwIBAgIJALeoA6I3ZC/cMA0GCSqGSIb3DQEBBQUAMFYxCzAJBgNVBAYTAlVTMRMwEQYDVQQHEwpDdXBlcnRpb25lMRwwGgYDVQQLExNQcm9kdWN0IERldmVsb3BtZW50MRQwEgYDVQQDEwtCYWJzIEplbnNlbjAeFw0xMjA1MDIxNjM0MzVaFw0xMjEyMjExNjM0MzVaMFYxCzAJBgNVBAYTAlVTMRMwEQYDVQQHEwpDdXBlcnRpb25lMRwwGgYDVQQLExNQcm9kdWN0IERldmVsb3BtZW50MRQwEgYDVQQDEwtCYWJzIEplbnNlbjCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEApysa0c9qc8FB8gIJ8zAb1pbJ4HzC7iRlVGhRJjFORkGhyvU4P5o2wL0iz/uko6rL9/pFhIlIMbwbV8smmKeNUPitwiKOjoFDmtimcZ4bx5UTAYLbbHMpEdwSpMC5iF2UioM7qdiwpAfZBd6Z69vqNxuUJ6tP+hxtr/aSgMH2i8ECAwEAAaN7MHkwCQYDVR0TBAIwADAsBglghkgBhvhCAQ0EHxYdT3BlblNTTCBHZW5lcmF0ZWQgQ2VydGlmaWNhdGUwHQYDVR0OBBYEFLlZD3aKDa8jdhzoByOFMAJDs2osMB8GA1UdIwQYMBaAFLlZD3aKDa8jdhzoByOFMAJDs2osMA0GCSqGSIb3DQEBBQUAA4GBAE5vccY8Ydd7by2bbwiDKgQqVyoKrkUg6CD0WRmc2pBeYX2z94/PWO5L3Fx+eIZh2wTxScF+FdRWJzLbUaBuClrxuy0Y5ifjaxuJ8LFNbZtsp1ldW3i84+F5+SYT+xI67ZcoAtwx/VFVI9s5I/Gkmu9f9nxjPpK71AIUXiE3Qcck";
        String[] strChangeRecord = new String[]{"version: 1", "dn:uid=scarter,ou=People,dc=example,dc=com", "changetype: modify", "add: userCertificate;binary", String.format("userCertificate;binary::%s", validcert1)};
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(strChangeRecord);
        Schema schema = Schema.getCoreSchema();
        reader.setSchema(schema);
        reader.setSchemaValidationPolicy(SchemaValidationPolicy.defaultPolicy());
        ModifyRequest modifyRequest = (ModifyRequest)reader.readChangeRecord();
        Assertions.assertThat((String)modifyRequest.getName().toString()).isEqualTo((Object)"uid=scarter,ou=People,dc=example,dc=com");
        Assertions.assertThat((String)((Modification)modifyRequest.getModifications().get(0)).getModificationType().toString()).isEqualTo((Object)"add");
        Assertions.assertThat((String)((Modification)modifyRequest.getModifications().get(0)).getAttribute().firstValueAsString()).contains("OpenSSL Generated Certificate");
        reader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={DecodeException.class})
    public void testParseModifyChangeRecordBEREncodingNotRequired() throws Exception {
        String[] strChangeRecord = new String[]{"version: 1", "dn:uid=scarter,ou=People,dc=example,dc=com", "changetype: modify", "add: sn;binary", "sn;binary:: 5bCP56yg5Y6f"};
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(strChangeRecord);
        Schema schema = Schema.getCoreSchema();
        reader.setSchema(schema);
        reader.setSchemaValidationPolicy(SchemaValidationPolicy.defaultPolicy());
        try {
            reader.readChangeRecord();
        }
        finally {
            reader.close();
        }
    }

    @Test
    public void testParseModifyChangeRecordEntryReplaceOk() throws Exception {
        String[] strChangeRecord = new String[]{"version: 1", "dn: uid=scarter,ou=People,dc=example,dc=com", "changetype: modify", "replace: uid", "uid: Samantha Carter"};
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(strChangeRecord);
        reader.setSchema(Schema.getDefaultSchema());
        reader.setSchemaValidationPolicy(SchemaValidationPolicy.defaultPolicy());
        ChangeRecord record = reader.readChangeRecord();
        Assertions.assertThat((Object)record).isInstanceOf(ModifyRequest.class);
        ModifyRequest modifyRequest = (ModifyRequest)record;
        Assertions.assertThat((String)modifyRequest.getName().toString()).isEqualTo((Object)"uid=scarter,ou=People,dc=example,dc=com");
        Assertions.assertThat((String)((Modification)modifyRequest.getModifications().get(0)).getModificationType().toString()).isEqualTo((Object)"replace");
        Assertions.assertThat((String)((Modification)modifyRequest.getModifications().get(0)).getAttribute().firstValueAsString()).isEqualTo((Object)"Samantha Carter");
        reader.close();
    }

    @Test(expectedExceptions={DecodeException.class})
    public void testParseModifyChangeRecordEntryReplaceKOPolicyReject() throws Exception {
        String[] strChangeRecord = new String[]{"version: 1", "dn: uid=scarter,ou=People,dc=example,dc=com", "changetype: modify", "replace: badAttribute", "badAttribute: scarter"};
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(strChangeRecord);
        reader.setSchema(Schema.getDefaultSchema());
        reader.setSchemaValidationPolicy(SchemaValidationPolicy.defaultPolicy());
        try {
            reader.readChangeRecord();
        }
        finally {
            reader.close();
        }
    }

    @Test(expectedExceptions={DecodeException.class})
    public void testParseModifyChangeRecordEntryReplaceKOPolicyWarn() throws Exception {
        String[] strChangeRecord = new String[]{"version: 1", "dn: uid=scarter,ou=People,dc=example,dc=com", "changetype: modify", "replace: badAttribute", "badAttribute: scarter"};
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(strChangeRecord);
        reader.setSchema(Schema.getDefaultSchema());
        reader.setSchemaValidationPolicy(SchemaValidationPolicy.defaultPolicy().checkAttributesAndObjectClasses(SchemaValidationPolicy.Action.WARN));
        try {
            reader.readChangeRecord();
        }
        finally {
            reader.close();
        }
    }

    @Test(expectedExceptions={DecodeException.class})
    public void testParseModifyChangeRecordEntryReplaceLocalizedIllegalArgumentException() throws Exception {
        String[] strChangeRecord = new String[]{"version: 1", "dn: uid=scarter,ou=People,dc=example,dc=com", "changetype: modify", "replace: uid", " uid:Samantha Carter"};
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(strChangeRecord);
        reader.setSchema(Schema.getDefaultSchema());
        reader.setSchemaValidationPolicy(SchemaValidationPolicy.defaultPolicy());
        try {
            reader.readChangeRecord();
        }
        finally {
            reader.close();
        }
    }

    @Test(expectedExceptions={LocalizedIllegalArgumentException.class})
    public void testParseModifyChangeRecordEntryWithWrongChangetype() {
        LDIFChangeRecordReader.valueOfLDIFChangeRecord((String[])new String[]{"version: 1", "dn: uid=scarter,ou=People,dc=example,dc=com", "changetype: modify", "oops:uidNumber"});
    }

    @Test(expectedExceptions={LocalizedIllegalArgumentException.class})
    public void testParseModifyChangeRecordEntryWithNullPairKey() {
        LDIFChangeRecordReader.valueOfLDIFChangeRecord((String[])new String[]{"version: 1", "dn: uid=scarter,ou=People,dc=example,dc=com", "changetype: modify", ":uidNumber"});
    }

    @Test
    public void testParseModifyChangeRecordEntryIncrement() throws Exception {
        ChangeRecord cr = LDIFChangeRecordReader.valueOfLDIFChangeRecord((String[])new String[]{"version: 1", "dn: uid=scarter,ou=People,dc=example,dc=com", "changetype: modify", "increment:uidNumber", "uidNumber: 1"});
        Assertions.assertThat((Object)cr).isInstanceOf(ModifyRequest.class);
        ModifyRequest modifyRequest = (ModifyRequest)cr;
        Assertions.assertThat((String)modifyRequest.getName().toString()).isEqualTo((Object)"uid=scarter,ou=People,dc=example,dc=com");
        Assertions.assertThat((String)((Modification)modifyRequest.getModifications().get(0)).getModificationType().toString()).isEqualTo((Object)"increment");
    }

    @Test
    public void testParseModifyDNChangeRecordEntryRecordBase64NewRDN() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"dn::ZGM9cGVvcGxlLGRjPWV4YW1wbGUsZGM9b3Jn", "changetype: modrdn", "newrdn::ZGM9cGVvcGxl", "deleteoldrdn: 1"});
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        ChangeRecord record = reader.readChangeRecord();
        Assertions.assertThat((Object)record).isInstanceOf(ModifyDNRequest.class);
        ModifyDNRequest modifyDNRequest = (ModifyDNRequest)record;
        Assertions.assertThat((Object)modifyDNRequest.getName()).isEqualTo((Object)DN.valueOf((String)"dc=people,dc=example,dc=org"));
        Assertions.assertThat((Object)modifyDNRequest.getNewRDN()).isEqualTo((Object)RDN.valueOf((String)"dc=people"));
        Assertions.assertThat((boolean)modifyDNRequest.isDeleteOldRDN()).isTrue();
        reader.close();
    }

    @Test
    public void testParseModifyDNChangeRecordEntry() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"version: 1", "dn: cn=scarter,dc=example,dc=com", "changetype: modrdn", "newrdn: cn=Susan Jacobs", "deleteoldrdn: 1"});
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        ChangeRecord record = reader.readChangeRecord();
        Assertions.assertThat((Object)record).isInstanceOf(ModifyDNRequest.class);
        ModifyDNRequest modifyDNRequest = (ModifyDNRequest)record;
        Assertions.assertThat((Object)modifyDNRequest.getName()).isEqualTo((Object)DN.valueOf((String)"cn=scarter,dc=example,dc=com"));
        Assertions.assertThat((Object)modifyDNRequest.getNewRDN()).isEqualTo((Object)RDN.valueOf((String)"cn=Susan Jacobs"));
        Assertions.assertThat((boolean)modifyDNRequest.isDeleteOldRDN()).isTrue();
        Assertions.assertThat((Object)modifyDNRequest.getNewSuperior()).isEqualTo(null);
        reader.close();
    }

    @Test(expectedExceptions={DecodeException.class})
    public void testParseModifyDNChangeRecordEntryMalformedMissedNewRDN() throws Exception {
        try (LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"version: 1", "dn: cn=scarter,dc=example,dc=com", "changetype: modrdn"});){
            reader.readChangeRecord();
        }
    }

    @Test(expectedExceptions={DecodeException.class})
    public void testParseModifyDNChangeRecordEntryKeyMalformedEmptyNewRDN() throws Exception {
        try (LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"version: 1", "dn: cn=scarter,dc=example,dc=com", "changetype: modrdn", "newrdn:", "deleteoldrdn: 1"});){
            reader.readChangeRecord();
        }
    }

    @Test(expectedExceptions={DecodeException.class})
    public void testParseModifyDNChangeRecordEntryKeyValueMalformedRDN() throws Exception {
        try (LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"version: 1", "dn: cn=scarter,dc=example,dc=com", "changetype: modrdn", "newrdn:oops", "deleteoldrdn: 1"});){
            reader.readChangeRecord();
        }
    }

    @Test(expectedExceptions={DecodeException.class})
    public void testParseModifyDNChangeRecordEntryKeyValueMalformedDeleteOldRDN() throws Exception {
        try (LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"version: 1", "dn: cn=scarter,dc=example,dc=com", "changetype: modrdn", "newrdn:cn=Susan Jacobs", "deleteoldrdn: cn=scarter,dc=example,dc=com"});){
            reader.readChangeRecord();
        }
    }

    @Test(expectedExceptions={DecodeException.class})
    public void testParseModifyDNChangeRecordEntryKeyValueMalformedDeleteOldRDN2() throws Exception {
        try (LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"version: 1", "dn: cn=scarter,dc=example,dc=com", "changetype: modrdn", "newrdn:cn=Susan Jacobs", "deleteold: 1"});){
            reader.readChangeRecord();
        }
    }

    @Test(expectedExceptions={DecodeException.class})
    public void testParseModifyDNChangeRecordEntryKeyValueMalformedDeleteOldRDN3() throws Exception {
        try (LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"version: 1", "dn: cn=scarter,dc=example,dc=com", "changetype: modrdn", "newrdn:cn=Susan Jacobs"});){
            reader.readChangeRecord();
        }
    }

    @Test
    public void testParseModifyRecordEntryDeleteOldRDNFalse() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"dn: cn=scarter,ou=People,dc=example,dc=com", "changeType: modrdn", "newrdn: cn=Susan Jacobs", "deleteOldRdn: 0", "newSuperior:ou=Manager,dc=example,dc=org"});
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        ChangeRecord record = reader.readChangeRecord();
        Assertions.assertThat((Object)record).isInstanceOf(ModifyDNRequest.class);
        ModifyDNRequest modifyDNRequest = (ModifyDNRequest)record;
        Assertions.assertThat((Object)modifyDNRequest.getName()).isEqualTo((Object)DN.valueOf((String)"cn=scarter,ou=People,dc=example,dc=com"));
        Assertions.assertThat((Object)modifyDNRequest.getNewRDN()).isEqualTo((Object)RDN.valueOf((String)"cn=Susan Jacobs"));
        Assertions.assertThat((boolean)modifyDNRequest.isDeleteOldRDN()).isFalse();
        Assertions.assertThat((Object)modifyDNRequest.getNewSuperior().toString()).isEqualTo((Object)"ou=Manager,dc=example,dc=org");
        reader.close();
    }

    @Test
    public void testParseModifyRecordEntryNewSuperior() throws Exception {
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"dn: cn=scarter,ou=People,dc=example,dc=com", "changeType: modrdn", "newrdn: cn=Susan Jacobs", "deleteOldRdn: 1", "newSuperior:ou=Manager,dc=example,dc=org"});
        Assertions.assertThat((boolean)reader.hasNext()).isTrue();
        ChangeRecord record = reader.readChangeRecord();
        Assertions.assertThat((Object)record).isInstanceOf(ModifyDNRequest.class);
        ModifyDNRequest modifyDNRequest = (ModifyDNRequest)record;
        Assertions.assertThat((Object)modifyDNRequest.getName()).isEqualTo((Object)DN.valueOf((String)"cn=scarter,ou=People,dc=example,dc=com"));
        Assertions.assertThat((Object)modifyDNRequest.getNewRDN()).isEqualTo((Object)RDN.valueOf((String)"cn=Susan Jacobs"));
        Assertions.assertThat((boolean)modifyDNRequest.isDeleteOldRDN()).isTrue();
        Assertions.assertThat((Object)modifyDNRequest.getNewSuperior().toString()).isEqualTo((Object)"ou=Manager,dc=example,dc=org");
        reader.close();
    }

    @Test(expectedExceptions={DecodeException.class})
    public void testParseModifyRecordEntryNewSuperiorMalformed() throws Exception {
        try (LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"dn: cn=scarter,ou=People,dc=example,dc=com", "changeType: modrdn", "newrdn: cn=Susan Jacobs", "deleteOldRdn: 1", "newSuperior:"});){
            reader.readChangeRecord();
        }
    }

    @Test(expectedExceptions={DecodeException.class})
    public void testParseModifyRecordEntryNewSuperiorMalformed2() throws Exception {
        try (LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{"dn: cn=scarter,ou=People,dc=example,dc=com", "changeType: modrdn", "newrdn: cn=Susan Jacobs", "deleteOldRdn: 1", "newSuperior: Susan Jacobs"});){
            reader.readChangeRecord();
        }
    }

    @Test(expectedExceptions={IOException.class})
    public void testChangeRecordReaderClosesAfterReading() throws Exception {
        FileInputStream mockIn = (FileInputStream)Mockito.mock(FileInputStream.class);
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader((InputStream)mockIn);
        ((FileInputStream)Mockito.doThrow((Throwable)new IOException()).when((Object)mockIn)).read();
        try {
            reader.readChangeRecord();
        }
        finally {
            reader.close();
            ((FileInputStream)Mockito.verify((Object)mockIn, (VerificationMode)Mockito.times((int)1))).close();
        }
    }

    @Test
    public void testChangeRecordReaderUseListConstructor() throws Exception {
        List<String> cr = Arrays.asList("dn: dc=example,dc=com", "changetype: add", "objectClass: top", "objectClass: domainComponent", "dc: example");
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(cr);
        ChangeRecord rc = reader.readChangeRecord();
        Assertions.assertThat((Object)rc).isNotNull();
        Assertions.assertThat((String)rc.getName().toString()).isEqualTo((Object)"dc=example,dc=com");
        reader.close();
    }

    @Test(expectedExceptions={LocalizedIllegalArgumentException.class})
    public void testChangeRecordReaderHasNoChange() throws Exception {
        LDIFChangeRecordReader.valueOfLDIFChangeRecord((String[])new String[]{"version: 1", "# Add a new entry without changes !", "dn: dc=example,dc=com"});
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testChangeRecordReaderDoesntAllowNull() throws Exception {
        List cr = Collections.emptyList();
        try (LDIFChangeRecordReader reader = new LDIFChangeRecordReader(cr);){
            reader.readChangeRecord();
        }
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testChangeRecordReaderLDIFLineDoesntAllowNull() throws Exception {
        try (LDIFChangeRecordReader reader = new LDIFChangeRecordReader(new String[]{new String()});){
            reader.readChangeRecord();
        }
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testChangeRecordReaderInpuStreamDoesntAllowNull() throws Exception {
        new LDIFChangeRecordReader((InputStream)null).close();
    }

    @Test(expectedExceptions={LocalizedIllegalArgumentException.class})
    public void testValueOfLDIFChangeRecordDoesntAllowNull() throws Exception {
        LDIFChangeRecordReader.valueOfLDIFChangeRecord((String[])new String[]{""});
    }

    @Test(expectedExceptions={LocalizedIllegalArgumentException.class})
    public void testValueOfLDIFChangeRecordDoesntAllowMultipleChangeRecords() throws Exception {
        File file = File.createTempFile("sdk", ".png");
        String url = file.toURI().toURL().toString();
        file.delete();
        LDIFChangeRecordReader.valueOfLDIFChangeRecord((String[])new String[]{"version: 1", "# Add a new entry", "dn: cn=Fiona Jensen, ou=Marketing, dc=airius, dc=com", "changetype: add", "objectclass: top", "objectclass: person", "objectclass: organizationalPerson", "cn: Fiona Jensen", "sn: Jensen", "uid: fiona", "telephonenumber: +1 408 555 1212", "jpegphotojpegphoto:< " + url, "", "# Delete an existing entry", "dn: cn=Robert Jensen, ou=Marketing, dc=airius, dc=com", "changetype: delete"});
    }

    @Test(expectedExceptions={LocalizedIllegalArgumentException.class})
    public void testValueOfLDIFChangeRecordMalformedLDIFDNIsMissing() throws Exception {
        LDIFChangeRecordReader.valueOfLDIFChangeRecord((String[])new String[]{"version: 1", "# Add a new entry", "changetype: add", "objectclass: top", "objectclass: person", "objectclass: organizationalPerson", "cn: Fiona Jensen", "sn: Jensen", "uid: fiona", "telephonenumber: +1 408 555 1212"});
    }

    @Test(expectedExceptions={LocalizedIllegalArgumentException.class})
    public void testValueOfLDIFChangeRecordMalformedLDIFContainingOnlyVersion() throws Exception {
        LDIFChangeRecordReader.valueOfLDIFChangeRecord((String[])new String[]{"version: 1"});
    }

    @Test(expectedExceptions={LocalizedIllegalArgumentException.class})
    public void testValueOfLDIFChangeRecordMalformedLDIFContainingVersionAndWrongLine() throws Exception {
        LDIFChangeRecordReader.valueOfLDIFChangeRecord((String[])new String[]{"version: 1", ":wrong"});
    }

    @Test
    public void testValueOfLDIFChangeRecordStandardLDIF() throws Exception {
        ChangeRecord cr = LDIFChangeRecordReader.valueOfLDIFChangeRecord((String[])this.getStandardLDIFChangeRecord());
        AddRequest addRequest = (AddRequest)cr;
        Assertions.assertThat((String)cr.getName().toString()).isEqualTo((Object)"uid=scarter,ou=People,dc=example,dc=com");
        Assertions.assertThat((boolean)addRequest.containsAttribute("sn", new Object[0])).isTrue();
        Assertions.assertThat((boolean)addRequest.containsAttribute("cn", new Object[0])).isTrue();
        Assertions.assertThat((int)addRequest.getAttributeCount()).isEqualTo(10);
    }

    @Test
    public void testValueOfLDIFRecordEmptyFirstAttrLDIF() {
        LDIFChangeRecordReader.valueOfLDIFChangeRecord((String[])new String[]{"version: 1", "# Add a new entry", "dn: cn=Fiona Jensen, ou=Marketing, dc=airius, dc=com", "description:", "objectclass: top", "objectclass: person", "objectclass: organizationalPerson", "cn: Fiona Jensen", "sn: Jensen", "uid: fiona", "telephonenumber: +1 408 555 1212"});
    }
}

