/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldif;

import com.forgerock.opendj.ldap.CoreMessages;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.fest.assertions.Assertions;
import org.fest.assertions.BooleanAssert;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.SdkTestCase;
import org.forgerock.opendj.ldap.TestCaseUtils;
import org.forgerock.opendj.ldap.schema.CoreSchema;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldif.EntryGenerator;
import org.forgerock.opendj.ldif.TemplateFile;
import org.forgerock.util.Utils;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class EntryGeneratorTestCase
extends SdkTestCase {
    private static final String BASIC_TEMPLATE_PATH = "org/forgerock/opendj/ldif/example.template";
    private static final String SUBTEMPLATES_TEMPLATE_PATH = "org/forgerock/opendj/ldif/people_and_groups.template";
    private String resourcePath;
    private Schema schema;

    @BeforeClass
    public void setUp() throws Exception {
        this.resourcePath = new File(TestCaseUtils.getTestFilePath(BASIC_TEMPLATE_PATH)).getParent();
        this.schema = Schema.getDefaultSchema();
    }

    @Test(enabled=false)
    public void printEntriesToStdOut() throws Exception {
        String path = SUBTEMPLATES_TEMPLATE_PATH;
        try (EntryGenerator generator = new EntryGenerator(TestCaseUtils.getTestFilePath(path)).setResourcePath(this.resourcePath);){
            while (generator.hasNext()) {
                System.out.println(generator.readEntry());
            }
        }
    }

    @Test
    public void testCreateWithDefaultTemplateFile() throws Exception {
        try (EntryGenerator generator = new EntryGenerator();){
            Assertions.assertThat((boolean)generator.hasNext()).isTrue();
        }
    }

    @Test(expectedExceptions={DecodeException.class}, expectedExceptionsMessageRegExp=".*Could not find template file unknown.*")
    public void testCreateWithMissingTemplateFile() throws Exception {
        try (EntryGenerator generator = new EntryGenerator("unknown/path");){
            generator.hasNext();
        }
    }

    @Test
    public void testCreateWithSetConstants() throws Exception {
        try (EntryGenerator generator = new EntryGenerator().setConstant("numusers", (Object)1);){
            generator.readEntry();
            generator.readEntry();
            Assertions.assertThat((String)generator.readEntry().getName().toString()).isEqualTo((Object)"uid=user.0,ou=People,dc=example,dc=com");
            ((BooleanAssert)Assertions.assertThat((boolean)generator.hasNext()).as("should have no more entries")).isFalse();
        }
    }

    @DataProvider(name="generators")
    public Object[][] createGenerators() throws Exception {
        Object[][] generators = new Object[3][2];
        String templatePath = TestCaseUtils.getTestFilePath(BASIC_TEMPLATE_PATH);
        generators[0][0] = new EntryGenerator(templatePath).setResourcePath(this.resourcePath);
        generators[0][1] = 10000;
        FileInputStream stream = new FileInputStream(new File(templatePath));
        generators[1][0] = new EntryGenerator((InputStream)stream).setResourcePath(this.resourcePath);
        generators[1][1] = 10000;
        generators[2][0] = new EntryGenerator(new String[]{"define suffix=dc=example,dc=com", "define maildomain=example.com", "define numusers=2", "", "branch: [suffix]", "objectClass: top", "objectClass: domain", "", "branch: ou=People,[suffix]", "objectClass: top", "objectClass: organizationalUnit", "subordinateTemplate: person:[numusers]", "", "template: person", "rdnAttr: uid", "objectClass: top", "objectClass: person", "objectClass: organizationalPerson", "objectClass: inetOrgPerson", "givenName: <first>", "sn: <last>", "cn: {givenName} {sn}", "initials: {givenName:1}<random:chars:ABCDEFGHIJKLMNOPQRSTUVWXYZ:1>{sn:1}", "employeeNumber: <sequential:0>", "uid: user.{employeeNumber}", "mail: {uid}@[maildomain]", "userPassword: password", "telephoneNumber: <random:telephone>", "homePhone: <random:telephone>", "pager: <random:telephone>", "mobile: <random:telephone>", "street: <random:numeric:5> <file:streets> Street", "l: <file:cities>", "st: <file:states>", "postalCode: <random:numeric:5>", "postalAddress: {cn}${street}${l}, {st}  {postalCode}", "description: This is the description for {cn}."}).setResourcePath(this.resourcePath);
        generators[2][1] = 2;
        return generators;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="generators")
    public void testGeneratedDNs(EntryGenerator generator, int numberOfUsers) throws Exception {
        try {
            Assertions.assertThat((boolean)generator.hasNext()).isTrue();
            Assertions.assertThat((String)generator.readEntry().getName().toString()).isEqualTo((Object)"dc=example,dc=com");
            Assertions.assertThat((boolean)generator.hasNext()).isTrue();
            Assertions.assertThat((String)generator.readEntry().getName().toString()).isEqualTo((Object)"ou=People,dc=example,dc=com");
            for (int i = 0; i < numberOfUsers; ++i) {
                Assertions.assertThat((boolean)generator.hasNext()).isTrue();
                Assertions.assertThat((String)generator.readEntry().getName().toString()).isEqualTo((Object)("uid=user." + i + ",ou=People,dc=example,dc=com"));
            }
            ((BooleanAssert)Assertions.assertThat((boolean)generator.hasNext()).as("should have no more entries")).isFalse();
        }
        catch (Throwable throwable) {
            Utils.closeSilently((Closeable[])new Closeable[]{generator});
            throw throwable;
        }
        Utils.closeSilently((Closeable[])new Closeable[]{generator});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="generators")
    public void testTopEntry(EntryGenerator generator, int numberOfUsers) throws Exception {
        try {
            Entry topEntry = generator.readEntry();
            Assertions.assertThat((String)topEntry.getName().toString()).isEqualTo((Object)"dc=example,dc=com");
            Attribute dcAttribute = topEntry.getAttribute(CoreSchema.getDCAttributeType().getNameOrOID());
            Assertions.assertThat((Collection)dcAttribute).isNotNull();
            Assertions.assertThat((String)dcAttribute.firstValueAsString()).isEqualTo((Object)"example");
            this.checkEntryObjectClasses(topEntry, "top", "domain");
        }
        catch (Throwable throwable) {
            Utils.closeSilently((Closeable[])new Closeable[]{generator});
            throw throwable;
        }
        Utils.closeSilently((Closeable[])new Closeable[]{generator});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="generators")
    public void testSecondEntry(EntryGenerator generator, int numberOfUsers) throws Exception {
        try {
            generator.readEntry();
            Entry entry = generator.readEntry();
            Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"ou=People,dc=example,dc=com");
            Attribute dcAttribute = entry.getAttribute(CoreSchema.getOUAttributeType().getNameOrOID());
            Assertions.assertThat((Collection)dcAttribute).isNotNull();
            Assertions.assertThat((String)dcAttribute.firstValueAsString()).isEqualTo((Object)"People");
            this.checkEntryObjectClasses(entry, "top", "organizationalUnit");
        }
        catch (Throwable throwable) {
            Utils.closeSilently((Closeable[])new Closeable[]{generator});
            throw throwable;
        }
        Utils.closeSilently((Closeable[])new Closeable[]{generator});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="generators")
    public void testFirstUserEntry(EntryGenerator generator, int numberOfUsers) throws Exception {
        try {
            generator.readEntry();
            generator.readEntry();
            Entry entry = generator.readEntry();
            Assertions.assertThat((String)entry.getName().toString()).isEqualTo((Object)"uid=user.0,ou=People,dc=example,dc=com");
            this.checkPresenceOfAttributes(entry, "givenName", "sn", "cn", "initials", "employeeNumber", "uid", "mail", "userPassword", "telephoneNumber", "homePhone", "pager", "mobile", "street", "l", "st", "postalCode", "postalAddress", "description");
            Assertions.assertThat((String)entry.getAttribute("cn").firstValueAsString()).isEqualTo((Object)(entry.getAttribute("givenName").firstValueAsString() + " " + entry.getAttribute("sn").firstValueAsString()));
            this.checkEntryObjectClasses(entry, "top", "person", "organizationalPerson", "inetOrgPerson");
        }
        catch (Throwable throwable) {
            Utils.closeSilently((Closeable[])new Closeable[]{generator});
            throw throwable;
        }
        Utils.closeSilently((Closeable[])new Closeable[]{generator});
    }

    private void checkEntryObjectClasses(Entry entry, String ... objectClasses) {
        Attribute ocAttribute = entry.getAttribute(CoreSchema.getObjectClassAttributeType().getNameOrOID());
        Assertions.assertThat((Collection)ocAttribute).isNotNull();
        Iterator it = ocAttribute.iterator();
        for (String objectClass : objectClasses) {
            Assertions.assertThat((String)((ByteString)it.next()).toString()).isEqualTo((Object)objectClass);
        }
        Assertions.assertThat((boolean)it.hasNext()).isFalse();
    }

    private void checkPresenceOfAttributes(Entry entry, String ... attributes) {
        for (String attribute : attributes) {
            Assertions.assertThat((Collection)entry.getAttribute(attribute)).isNotNull();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTemplateWithSubTemplates() throws Exception {
        int numberOfUsers = 10;
        int numberOfGroups = 5;
        int numberOfOUs = 10;
        EntryGenerator generator = new EntryGenerator(new String[]{"define suffix=dc=example,dc=com", "define maildomain=example.com", "define numusers=" + numberOfUsers, "define numous=" + numberOfOUs, "define numgroup=" + numberOfGroups, "", "branch: [suffix]", "subordinateTemplate: ous:[numous]", "", "template: ous", "subordinateTemplate: People:1", "subordinateTemplate: Groups:1", "rdnAttr: ou", "objectclass: top", "objectclass: organizationalUnit", "ou: Organization_<sequential:1>", "", "template: People", "rdnAttr: ou", "subordinateTemplate: person:[numusers]", "objectclass: top", "objectclass: organizationalUnit", "ou: People", "", "template: Groups", "subordinateTemplate: groupOfName:[numgroup]", "rdnAttr: ou", "objectclass: top", "objectclass: organizationalUnit", "ou: Groups", "", "template: person", "rdnAttr: uid", "objectClass: top", "objectClass: inetOrgPerson", "cn: <first> <last>", "employeeNumber: <sequential:0>", "uid: user.{employeeNumber}", "", "template: groupOfName", "rdnAttr: cn", "objectClass: top", "objectClass: groupOfNames", "cn: Group_<sequential:1>"}).setResourcePath(this.resourcePath);
        try {
            Assertions.assertThat((String)generator.readEntry().getName().toString()).isEqualTo((Object)"dc=example,dc=com");
            int countUsers = 0;
            int countGroups = 1;
            for (int i = 1; i <= numberOfOUs; ++i) {
                int j;
                String dnOU = "ou=Organization_" + i + ",dc=example,dc=com";
                Assertions.assertThat((String)generator.readEntry().getName().toString()).isEqualTo((Object)dnOU);
                Assertions.assertThat((String)generator.readEntry().getName().toString()).isEqualTo((Object)("ou=People," + dnOU));
                for (j = countUsers; j < countUsers + numberOfUsers; ++j) {
                    Assertions.assertThat((String)generator.readEntry().getName().toString()).isEqualTo((Object)("uid=user." + j + ",ou=People," + dnOU));
                }
                countUsers += numberOfUsers;
                Assertions.assertThat((String)generator.readEntry().getName().toString()).isEqualTo((Object)("ou=Groups," + dnOU));
                for (j = countGroups; j < countGroups + numberOfGroups; ++j) {
                    Assertions.assertThat((String)generator.readEntry().getName().toString()).isEqualTo((Object)("cn=Group_" + j + ",ou=Groups," + dnOU));
                }
                countGroups += numberOfGroups;
            }
            Assertions.assertThat((boolean)generator.hasNext()).isFalse();
        }
        catch (Throwable throwable) {
            Utils.closeSilently((Closeable[])new Closeable[]{generator});
            throw throwable;
        }
        Utils.closeSilently((Closeable[])new Closeable[]{generator});
    }

    @Test
    public void testMissingVariableErrorReport() throws Exception {
        String[] lines = new String[]{"template: template", "a: {missingVar}", "a: b", "a: c", "", "template: template2"};
        TemplateFile templateFile = new TemplateFile(this.schema, null, this.resourcePath);
        ArrayList warns = new ArrayList();
        try {
            templateFile.parse(lines, warns);
            TestCaseUtils.failWasExpected(DecodeException.class);
        }
        catch (DecodeException e) {
            LocalizableMessage expected = CoreMessages.ERR_ENTRY_GENERATOR_TAG_UNDEFINED_ATTRIBUTE.get((Object)"missingVar", (Object)1);
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)expected.toString());
        }
    }

    @DataProvider(name="validTemplates")
    public Object[][] createTestTemplates() {
        return new Object[][]{{"CurlyBracket", new String[]{"template: templateWithEscape", "rdnAttr: uid", "uid: testEntry", "cn: I\\{Foo\\}F"}}, {"AngleBracket", new String[]{"template: templateWithEscape", "rdnAttr: uid", "uid: testEntry", "sn: \\<Bar\\>"}}, {"SquareBracket", new String[]{"template: templateWithEscape", "rdnAttr: uid", "uid: testEntry", "description: \\[TEST\\]"}}, {"BackSlash", new String[]{"template: templateWithEscape", "rdnAttr: uid", "uid: testEntry", "description: Foo \\\\ Bar"}}, {"EscapedAlpha", new String[]{"template: templateWithEscape", "rdnAttr: uid", "uid: testEntry", "description: Foo \\\\Bar"}}, {"Normal Variable", new String[]{"template: templateNormal", "rdnAttr: uid", "uid: testEntry", "sn: {uid}"}}, {"Constant", new String[]{"define foo=Test123", "", "template: templateConstant", "rdnAttr: uid", "uid: testEntry", "sn: {uid}", "cn: [foo]"}}};
    }

    @Test(dataProvider="validTemplates")
    public void testParsingEscapeCharInTemplate(String testName, String[] lines) throws Exception {
        TemplateFile templateFile = new TemplateFile(this.schema, null, this.resourcePath);
        ArrayList warns = new ArrayList();
        templateFile.parse(lines, warns);
        Assertions.assertThat(warns).isEmpty();
    }

    @DataProvider(name="templatesToTestEscapeChars")
    public Object[][] createTemplatesToTestSpecialChars() {
        return new Object[][]{{"Curly", new String[]{"branch: dc=test", "subordinateTemplate: templateWithEscape:1", "", "template: templateWithEscape", "rdnAttr: uid", "objectclass: inetOrgPerson", "uid: testEntry", "cn: I\\{ Foo \\}F"}, "cn", "I{ Foo }F"}, {"Angle", new String[]{"branch: dc=test", "subordinateTemplate: templateWithEscape:1", "", "template: templateWithEscape", "rdnAttr: uid", "objectclass: inetOrgPerson", "uid: testEntry", "sn: \\< Bar \\>"}, "sn", "< Bar >"}, {"Square", new String[]{"branch: dc=test", "subordinateTemplate: templateWithEscape:1", "", "template: templateWithEscape", "rdnAttr: uid", "objectclass: inetOrgPerson", "uid: testEntry", "description: \\[TEST\\]"}, "description", "[TEST]"}, {"BackSlash", new String[]{"branch: dc=test", "subordinateTemplate: templateWithEscape:1", "", "template: templateWithEscape", "rdnAttr: uid", "objectclass: inetOrgPerson", "uid: testEntry", "displayName: Foo \\\\ Bar"}, "displayname", "Foo \\ Bar"}, {"MultipleSquare", new String[]{"define top=dc=com", "define container=ou=group", "", "branch: dc=test,[top]", "subordinateTemplate: templateWithEscape:1", "", "template: templateWithEscape", "rdnAttr: uid", "objectclass: inetOrgPerson", "uid: testEntry", "manager: cn=Bar,[container],dc=test,[top]", ""}, "manager", "cn=Bar,ou=group,dc=test,dc=com"}, {"MixedSquare", new String[]{"define top=dc=com", "define container=ou=group", "", "branch: dc=test,[top]", "subordinateTemplate: templateWithEscape:1", "", "template: templateWithEscape", "rdnAttr: uid", "objectclass: inetOrgPerson", "uid: testEntry", "description: test [container] \\[[top]\\]", ""}, "description", "test ou=group [dc=com]"}, {"NoConstantBecauseEscaped", new String[]{"define top=dc=com", "define container=ou=group", "", "branch: dc=test,[top]", "subordinateTemplate: templateWithEscape:1", "", "template: templateWithEscape", "rdnAttr: uid", "objectclass: inetOrgPerson", "uid: testEntry", "description: test \\[top]", ""}, "description", "test [top]"}, {"NoConstantBecauseStrangeChar", new String[]{"define top=dc=com", "define container=ou=group", "", "branch: dc=test,[top]", "subordinateTemplate: templateWithEscape:1", "", "template: templateWithEscape", "rdnAttr: uid", "objectclass: inetOrgPerson", "uid: testEntry", "description: test [group \\[top]", ""}, "description", "test [group [top]"}};
    }

    @Test(dataProvider="templatesToTestEscapeChars", dependsOnMethods={"testParsingEscapeCharInTemplate"})
    public void testEscapeCharsFromTemplate(String testName, String[] lines, String attrName, String expectedValue) throws Exception {
        try (EntryGenerator generator = new EntryGenerator(lines).setResourcePath(this.resourcePath);){
            Entry topEntry = generator.readEntry();
            Entry entry = generator.readEntry();
            Assertions.assertThat((Object)topEntry).isNotNull();
            Assertions.assertThat((Object)entry).isNotNull();
            Assertions.assertThat((String)entry.getAttribute(attrName).firstValueAsString()).isEqualTo((Object)expectedValue);
        }
    }

    @Test(dependsOnMethods={"testParsingEscapeCharInTemplate"})
    public void testCombineEscapeCharInTemplate() throws Exception {
        String[] lines = new String[]{"branch: dc=test", "subordinateTemplate: templateWithEscape:1", "", "template: templateWithEscape", "rdnAttr: uid", "objectclass: inetOrgPerson", "uid: testEntry", "sn: Bar", "cn: Foo \\<<random:chars:ABCDEFGHIJKLMNOPQRSTUVWXYZ:1>\\>\\{1\\}{sn}", ""};
        try (EntryGenerator generator = new EntryGenerator(lines).setResourcePath(this.resourcePath);){
            Entry topEntry = generator.readEntry();
            Entry entry = generator.readEntry();
            Assertions.assertThat((Object)topEntry).isNotNull();
            Assertions.assertThat((Object)entry).isNotNull();
            Assertions.assertThat((String)entry.getAttribute("cn").firstValueAsString()).matches("Foo <[A-Z]>\\{1\\}Bar");
        }
    }
}

