/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldif;

import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.LinkedHashMapEntry;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.responses.Responses;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldif.AbstractLDIFTestCase;
import org.forgerock.opendj.ldif.ConnectionEntryWriter;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ConnectionEntryWriterTestCase
extends AbstractLDIFTestCase {
    @Test
    public final void testConnectionEntryWriterWritesEntry() throws Exception {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Entry entry = new LinkedHashMapEntry("cn=scarter,dc=example,dc=com").addAttribute("objectclass", new Object[]{"top"}).addAttribute("objectclass", new Object[]{"person"}).addAttribute("objectclass", new Object[]{"organizationalPerson"}).addAttribute("objectclass", new Object[]{"inetOrgPerson"}).addAttribute("mail", new Object[]{"subgenius@example.com"}).addAttribute("sn", new Object[]{"carter"});
        Mockito.when((Object)connection.add((Entry)Mockito.any(Entry.class))).thenAnswer((Answer)new Answer<Result>(){

            public Result answer(InvocationOnMock invocation) throws Throwable {
                Entry handler = (Entry)invocation.getArguments()[0];
                if (handler != null) {
                    Assert.assertEquals((String)handler.getName().toString(), (String)"cn=scarter,dc=example,dc=com");
                    Assert.assertEquals((String)handler.getAttribute("sn").firstValueAsString(), (String)"carter");
                    Assert.assertEquals((int)handler.getAttributeCount(), (int)3);
                }
                return Responses.newResult((ResultCode)ResultCode.SUCCESS);
            }
        });
        try (ConnectionEntryWriter writer = new ConnectionEntryWriter(connection);){
            writer.writeComment((CharSequence)"This is a test for the ConnectionEntryWriter");
            writer.writeEntry(entry);
            ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).add((Entry)Mockito.any(Entry.class));
        }
    }

    @Test(expectedExceptions={NullPointerException.class})
    public final void testConnectionEntryWriterDoesntAllowNullComment() throws Exception {
        try (ConnectionEntryWriter writer = new ConnectionEntryWriter(null);){
            writer.writeComment(null);
        }
    }

    @Test(expectedExceptions={NullPointerException.class})
    public final void testConnectionEntryWriterDoesntAllowNull() throws Exception {
        new ConnectionEntryWriter(null);
    }

    @Test
    public final void testConnectionEntryWriterClose() throws Exception {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        new ConnectionEntryWriter(connection).close();
        ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).close();
    }
}

