/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldif;

import java.util.NoSuchElementException;
import org.fest.assertions.Assertions;
import org.fest.assertions.Fail;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SearchResultReferenceIOException;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.Responses;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.opendj.ldap.spi.LdapPromises;
import org.forgerock.opendj.ldif.AbstractLDIFTestCase;
import org.forgerock.opendj.ldif.ConnectionEntryReader;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.testng.annotations.Test;

public class ConnectionEntryReaderTestCase
extends AbstractLDIFTestCase {
    private static final SearchResultEntry ENTRY1 = Responses.newSearchResultEntry((String)"cn=entry1");
    private static final SearchResultEntry ENTRY2 = Responses.newSearchResultEntry((String)"cn=entry2");
    private static final SearchResultEntry ENTRY3 = Responses.newSearchResultEntry((String)"cn=entry3");
    private static final Result ERROR = Responses.newResult((ResultCode)ResultCode.BUSY);
    private static final SearchResultReference REF = Responses.newSearchResultReference((String)"http://www.forgerock.com/");
    private static final SearchRequest SEARCH = Requests.newSearchRequest((String)"", (SearchScope)SearchScope.WHOLE_SUBTREE, (String)"(objectClass=*)", (String[])new String[0]);
    private static final Result SUCCESS = Responses.newResult((ResultCode)ResultCode.SUCCESS);

    @Test
    public final void testHasNextWhenError() throws Exception {
        try (ConnectionEntryReader reader = this.newReader(ERROR);){
            reader.hasNext();
            Fail.fail();
        }
        catch (LdapException e) {
            Assertions.assertThat((Object)e.getResult()).isSameAs((Object)ERROR);
        }
    }

    @Test
    public final void testReadEntry() throws Exception {
        try (ConnectionEntryReader reader = this.newReader(ENTRY1, SUCCESS);){
            Assertions.assertThat((boolean)reader.hasNext()).isTrue();
            Assertions.assertThat((boolean)reader.isEntry()).isTrue();
            Assertions.assertThat((boolean)reader.isReference()).isFalse();
            Assertions.assertThat((Object)reader.readEntry()).isSameAs((Object)ENTRY1);
            Assertions.assertThat((boolean)reader.hasNext()).isFalse();
            Assertions.assertThat((Object)reader.readResult()).isSameAs((Object)SUCCESS);
        }
    }

    @Test
    public final void testReadEntryWhenError() throws Exception {
        try (ConnectionEntryReader reader = this.newReader(ERROR);){
            reader.readEntry();
            Fail.fail();
        }
        catch (LdapException e) {
            Assertions.assertThat((Object)e.getResult()).isSameAs((Object)ERROR);
        }
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public final void testReadEntryWhenNoMore() throws Exception {
        try (ConnectionEntryReader reader = this.newReader(SUCCESS);){
            Assertions.assertThat((boolean)reader.hasNext()).isFalse();
            reader.readEntry();
        }
    }

    @Test
    public final void testReadEntryWhenReference() throws Exception {
        try (ConnectionEntryReader reader = this.newReader(REF, SUCCESS);){
            Assertions.assertThat((boolean)reader.hasNext()).isTrue();
            try {
                reader.readEntry();
                Fail.fail();
            }
            catch (SearchResultReferenceIOException e) {
                Assertions.assertThat((Object)e.getReference()).isSameAs((Object)REF);
            }
            Assertions.assertThat((boolean)reader.hasNext()).isFalse();
            Assertions.assertThat((Object)reader.readResult()).isSameAs((Object)SUCCESS);
        }
    }

    @Test
    public final void testReadMultipleResults() throws Exception {
        try (ConnectionEntryReader reader = this.newReader(ENTRY1, ENTRY2, REF, ENTRY3, SUCCESS);){
            Assertions.assertThat((boolean)reader.hasNext()).isTrue();
            Assertions.assertThat((Object)reader.readEntry()).isSameAs((Object)ENTRY1);
            Assertions.assertThat((boolean)reader.hasNext()).isTrue();
            Assertions.assertThat((Object)reader.readEntry()).isSameAs((Object)ENTRY2);
            Assertions.assertThat((boolean)reader.hasNext()).isTrue();
            Assertions.assertThat((Object)reader.readReference()).isSameAs((Object)REF);
            Assertions.assertThat((boolean)reader.hasNext()).isTrue();
            Assertions.assertThat((Object)reader.readEntry()).isSameAs((Object)ENTRY3);
            Assertions.assertThat((boolean)reader.hasNext()).isFalse();
            Assertions.assertThat((Object)reader.readResult()).isSameAs((Object)SUCCESS);
        }
    }

    @Test
    public final void testReadReference() throws Exception {
        try (ConnectionEntryReader reader = this.newReader(REF, SUCCESS);){
            Assertions.assertThat((boolean)reader.hasNext()).isTrue();
            Assertions.assertThat((boolean)reader.isEntry()).isFalse();
            Assertions.assertThat((boolean)reader.isReference()).isTrue();
            Assertions.assertThat((Object)reader.readReference()).isSameAs((Object)REF);
            Assertions.assertThat((boolean)reader.hasNext()).isFalse();
            Assertions.assertThat((Object)reader.readResult()).isSameAs((Object)SUCCESS);
        }
    }

    @Test
    public final void testReadReferenceWhenEntry() throws Exception {
        try (ConnectionEntryReader reader = this.newReader(ENTRY1, SUCCESS);){
            Assertions.assertThat((boolean)reader.hasNext()).isTrue();
            Assertions.assertThat((Object)reader.readReference()).isNull();
            Assertions.assertThat((Object)reader.readEntry()).isSameAs((Object)ENTRY1);
            Assertions.assertThat((boolean)reader.hasNext()).isFalse();
            Assertions.assertThat((Object)reader.readResult()).isSameAs((Object)SUCCESS);
        }
    }

    @Test
    public final void testReadReferenceWhenError() throws Exception {
        try (ConnectionEntryReader reader = this.newReader(ERROR);){
            reader.readReference();
            Fail.fail();
        }
        catch (LdapException e) {
            Assertions.assertThat((Object)e.getResult()).isSameAs((Object)ERROR);
        }
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public final void testReadReferenceWhenNoMore() throws Exception {
        try (ConnectionEntryReader reader = this.newReader(SUCCESS);){
            Assertions.assertThat((boolean)reader.hasNext()).isFalse();
            reader.readReference();
        }
    }

    @Test
    public final void testReadResult() throws Exception {
        try (ConnectionEntryReader reader = this.newReader(SUCCESS);){
            Assertions.assertThat((Object)reader.readResult()).isSameAs((Object)SUCCESS);
        }
    }

    @Test
    public final void testReadResultWhenError() throws Exception {
        try (ConnectionEntryReader reader = this.newReader(ERROR);){
            reader.readResult();
            Fail.fail();
        }
        catch (LdapException e) {
            Assertions.assertThat((Object)e.getResult()).isSameAs((Object)ERROR);
        }
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public final void testReadResultWhenEntry() throws Exception {
        try (ConnectionEntryReader reader = this.newReader(ENTRY1, SUCCESS);){
            reader.readResult();
        }
    }

    private ConnectionEntryReader newReader(final Object ... responses) {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connection.searchAsync((SearchRequest)Mockito.same((Object)SEARCH), (SearchResultHandler)Mockito.any(SearchResultHandler.class))).thenAnswer((Answer)new Answer<LdapPromise<Result>>(){

            public LdapPromise<Result> answer(InvocationOnMock invocation) throws Throwable {
                Result result;
                SearchResultHandler handler = (SearchResultHandler)invocation.getArguments()[1];
                if (handler != null) {
                    for (Object response : responses) {
                        if (response instanceof SearchResultEntry) {
                            handler.handleEntry((SearchResultEntry)response);
                            continue;
                        }
                        if (!(response instanceof SearchResultReference)) continue;
                        handler.handleReference((SearchResultReference)response);
                    }
                }
                if ((result = (Result)responses[responses.length - 1]).isSuccess()) {
                    return LdapPromises.newSuccessfulLdapPromise((Object)result);
                }
                return LdapPromises.newFailedLdapPromise((LdapException)LdapException.newLdapException((Result)result));
            }
        });
        return new ConnectionEntryReader(connection, SEARCH);
    }
}

