/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldif;

import java.io.IOException;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldif.AbstractLDIFTestCase;
import org.forgerock.opendj.ldif.ChangeRecord;
import org.forgerock.opendj.ldif.ChangeRecordVisitor;
import org.forgerock.opendj.ldif.ConnectionChangeRecordWriter;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ConnectionChangeRecordWriterTestCase
extends AbstractLDIFTestCase {
    public final String[] getStandardLDIFChangeRecord() {
        return new String[]{"version: 1", "dn: uid=scarter,ou=People,dc=example,dc=com", "changetype: add", "sn: Carter", "cn: Samnatha Carter", "givenName: Sam", "objectClass: inetOrgPerson", "telephoneNumber: 555 555-5555", "mail: scarter@mail.org", "entryDN: uid=scarter,ou=people,dc=example,dc=org", "entryUUID: ad55a34a-763f-358f-93f9-da86f9ecd9e4", "modifyTimestamp: 20120903142126Z", "modifiersName: cn=Internal Client,cn=Root DNs,cn=config"};
    }

    @Test
    public final void testWriteChangeRecordAddRequest() throws Exception {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        try (ConnectionChangeRecordWriter writer = new ConnectionChangeRecordWriter(connection);){
            writer.writeChangeRecord(Requests.newAddRequest((String[])this.getStandardLDIFChangeRecord()));
            ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).add((AddRequest)Mockito.any(AddRequest.class));
        }
    }

    @Test(expectedExceptions={NullPointerException.class})
    public final void testWriteChangeRecordAddRequestDoesntAllowNull() throws Exception {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        try (ConnectionChangeRecordWriter writer = new ConnectionChangeRecordWriter(connection);){
            writer.writeChangeRecord((AddRequest)null);
        }
    }

    @Test
    public final void testWriteChangeRecordContainingAddRequest() throws Exception {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        try (ConnectionChangeRecordWriter writer = new ConnectionChangeRecordWriter(connection);){
            writer.writeChangeRecord(Requests.newChangeRecord((String[])this.getStandardLDIFChangeRecord()));
            Assert.assertTrue((boolean)(Requests.newChangeRecord((String[])this.getStandardLDIFChangeRecord()) instanceof AddRequest));
            ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).add((AddRequest)Mockito.any(AddRequest.class));
        }
    }

    @Test
    public final void testWriteChangeRecordContainingDeleteRequest() throws Exception {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        try (ConnectionChangeRecordWriter writer = new ConnectionChangeRecordWriter(connection);){
            ChangeRecord cr = Requests.newChangeRecord((String[])new String[]{"dn: dc=example,dc=com", "changetype: delete"});
            writer.writeChangeRecord(cr);
            Assert.assertTrue((boolean)(cr instanceof DeleteRequest));
            ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).delete((DeleteRequest)Mockito.any(DeleteRequest.class));
        }
    }

    @Test(expectedExceptions={LocalizedIllegalArgumentException.class})
    public final void testWriteChangeRecordDoesntAllowMultipleLDIF() throws Exception {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        try (ConnectionChangeRecordWriter writer = new ConnectionChangeRecordWriter(connection);){
            writer.writeChangeRecord(Requests.newChangeRecord((String[])new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "changetype: modify", "replace:sn", "sn: scarter", "", "dn: uid=user.0,ou=People,dc=example,dc=com", "changetype: modify", "replace:sn", "sn: Amarr"}));
        }
    }

    @Test(expectedExceptions={RuntimeException.class})
    public final void testWriteChangeRecordChangeAcceptSendIOException() throws Exception {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        ChangeRecord cr = (ChangeRecord)Mockito.mock(ChangeRecord.class);
        Mockito.when((Object)cr.accept((ChangeRecordVisitor)Mockito.any(ChangeRecordVisitor.class), Mockito.any(ConnectionChangeRecordWriter.class))).thenAnswer((Answer)new Answer<IOException>(){

            public IOException answer(InvocationOnMock invocation) throws Throwable {
                ChangeRecordVisitor handler = (ChangeRecordVisitor)invocation.getArguments()[0];
                if (handler != null) {
                    // empty if block
                }
                return new IOException("IOException_e_is_not_null");
            }
        });
        try (ConnectionChangeRecordWriter writer = new ConnectionChangeRecordWriter(connection);){
            writer.writeChangeRecord(cr);
        }
    }

    @Test(expectedExceptions={LdapException.class})
    public final void testWriteChangeRecordChangeAcceptSendLdapException() throws Exception {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        ChangeRecord cr = (ChangeRecord)Mockito.mock(ChangeRecord.class);
        Mockito.when((Object)cr.accept((ChangeRecordVisitor)Mockito.any(ChangeRecordVisitor.class), Mockito.any(ConnectionChangeRecordWriter.class))).thenAnswer((Answer)new Answer<LdapException>(){

            public LdapException answer(InvocationOnMock invocation) throws Throwable {
                ChangeRecordVisitor handler = (ChangeRecordVisitor)invocation.getArguments()[0];
                if (handler != null) {
                    // empty if block
                }
                return LdapException.newLdapException((ResultCode)ResultCode.UNAVAILABLE_CRITICAL_EXTENSION);
            }
        });
        try (ConnectionChangeRecordWriter writer = new ConnectionChangeRecordWriter(connection);){
            writer.writeChangeRecord(cr);
        }
    }

    @Test(expectedExceptions={NullPointerException.class})
    public final void testWriteChangeRecordChangeRecordDoesntAllowNull() throws Exception {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        try (ConnectionChangeRecordWriter writer = new ConnectionChangeRecordWriter(connection);){
            writer.writeChangeRecord((ChangeRecord)null);
        }
    }

    @Test
    public final void testWriteChangeRecordDeleteRequest() throws Exception {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        try (ConnectionChangeRecordWriter writer = new ConnectionChangeRecordWriter(connection);){
            DeleteRequest cr = Requests.newDeleteRequest((DN)DN.valueOf((String)"cn=scarter,dc=example,dc=com"));
            writer.writeChangeRecord((ChangeRecord)cr);
            ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).delete((DeleteRequest)Mockito.any(DeleteRequest.class));
        }
    }

    @Test(expectedExceptions={NullPointerException.class})
    public final void testWriteChangeRecordDeleteRequestDoesntAllowNull() throws Exception {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        try (ConnectionChangeRecordWriter writer = new ConnectionChangeRecordWriter(connection);){
            writer.writeChangeRecord((DeleteRequest)null);
        }
    }

    @Test
    public final void testWriteChangeRecordModifyDNRequest() throws Exception {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        try (ConnectionChangeRecordWriter writer = new ConnectionChangeRecordWriter(connection);){
            ModifyDNRequest cr = Requests.newModifyDNRequest((String)"cn=scarter,dc=example,dc=com", (String)"cn=Susan Jacobs");
            writer.writeChangeRecord((ChangeRecord)cr);
            ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).modifyDN((ModifyDNRequest)Mockito.any(ModifyDNRequest.class));
        }
    }

    @Test(expectedExceptions={NullPointerException.class})
    public final void testWriteChangeRecordModifyDNRequestDoesntAllowNull() throws Exception {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        try (ConnectionChangeRecordWriter writer = new ConnectionChangeRecordWriter(connection);){
            writer.writeChangeRecord((ModifyDNRequest)null);
        }
    }

    @Test
    public final void testWriteChangeRecordModifyRequest() throws Exception {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        try (ConnectionChangeRecordWriter writer = new ConnectionChangeRecordWriter(connection);){
            ModifyRequest cr = Requests.newModifyRequest((String[])new String[]{"dn: cn=Fiona Jensen, ou=Marketing, dc=airius, dc=com", "changetype: modify", "delete: telephonenumber", "telephonenumber: +1 408 555 1212"});
            writer.writeChangeRecord((ChangeRecord)cr);
            ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).modify((ModifyRequest)Mockito.any(ModifyRequest.class));
        }
    }

    @Test(expectedExceptions={NullPointerException.class})
    public final void testWriteChangeRecordModifyRequestDoesntAllowNull() throws Exception {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        try (ConnectionChangeRecordWriter writer = new ConnectionChangeRecordWriter(connection);){
            writer.writeChangeRecord((ModifyRequest)null);
        }
    }

    @Test
    public final void testWriteCommentDoNotSupportComment() throws Exception {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        try (ConnectionChangeRecordWriter writer = new ConnectionChangeRecordWriter(connection);){
            writer.writeComment((CharSequence)"# A new comment");
            ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.never())).add(new String[]{(String)Mockito.any(String.class)});
            ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.never())).delete((String)Mockito.any(String.class));
            ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.never())).modify(new String[]{(String)Mockito.any(String.class)});
            ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.never())).modifyDN((String)Mockito.any(String.class), (String)Mockito.any(String.class));
        }
    }

    @Test(expectedExceptions={NullPointerException.class})
    public final void testWriteCommentDoesntAllowNull() throws Exception {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        try (ConnectionChangeRecordWriter writer = new ConnectionChangeRecordWriter(connection);){
            writer.writeComment(null);
        }
    }

    @Test(expectedExceptions={NullPointerException.class})
    public final void testConnectionChangeRecordWriterDoesntAllowNull() throws Exception {
        new ConnectionChangeRecordWriter(null);
    }

    @Test
    public final void testConnectionChangeRecordWriterClose() throws Exception {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        new ConnectionChangeRecordWriter(connection).close();
        ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).close();
    }
}

