/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.spi;

import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.ConnectionEventListener;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.Responses;
import org.forgerock.opendj.ldap.spi.ConnectionState;
import org.forgerock.opendj.ldap.spi.LDAPTestCase;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.testng.annotations.Test;

public class ConnectionStateTest
extends LDAPTestCase {
    private static final LdapException ERROR = LdapException.newLdapException((ResultCode)ResultCode.OTHER);
    private static final LdapException LATE_ERROR = LdapException.newLdapException((ResultCode)ResultCode.BUSY);
    private static final ExtendedResult UNSOLICITED = Responses.newGenericExtendedResult((ResultCode)ResultCode.OPERATIONS_ERROR);

    @Test
    public void testCloseEventInClosedState() {
        ConnectionState state = new ConnectionState();
        ConnectionEventListener listener1 = (ConnectionEventListener)Mockito.mock(ConnectionEventListener.class);
        state.addConnectionEventListener(listener1);
        state.notifyConnectionClosed();
        state.notifyConnectionClosed();
        Assertions.assertThat((boolean)state.isValid()).isFalse();
        Assertions.assertThat((boolean)state.isClosed()).isTrue();
        Assertions.assertThat((Throwable)state.getConnectionError()).isNull();
        ((ConnectionEventListener)Mockito.verify((Object)listener1)).handleConnectionClosed();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener1});
        ConnectionEventListener listener2 = (ConnectionEventListener)Mockito.mock(ConnectionEventListener.class);
        state.addConnectionEventListener(listener2);
        ((ConnectionEventListener)Mockito.verify((Object)listener2)).handleConnectionClosed();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener2});
    }

    @Test
    public void testCloseEventInErrorState() {
        ConnectionState state = new ConnectionState();
        ConnectionEventListener listener1 = (ConnectionEventListener)Mockito.mock(ConnectionEventListener.class);
        state.addConnectionEventListener(listener1);
        state.notifyConnectionError(false, ERROR);
        state.notifyConnectionClosed();
        Assertions.assertThat((boolean)state.isValid()).isFalse();
        Assertions.assertThat((boolean)state.isClosed()).isTrue();
        Assertions.assertThat((Throwable)state.getConnectionError()).isSameAs((Object)ERROR);
        ((ConnectionEventListener)Mockito.verify((Object)listener1)).handleConnectionError(false, ERROR);
        ((ConnectionEventListener)Mockito.verify((Object)listener1)).handleConnectionClosed();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener1});
        ConnectionEventListener listener2 = (ConnectionEventListener)Mockito.mock(ConnectionEventListener.class);
        state.addConnectionEventListener(listener2);
        ((ConnectionEventListener)Mockito.verify((Object)listener2)).handleConnectionError(false, ERROR);
        ((ConnectionEventListener)Mockito.verify((Object)listener2)).handleConnectionClosed();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener2});
    }

    @Test
    public void testCloseEventInValidState() {
        ConnectionState state = new ConnectionState();
        ConnectionEventListener listener1 = (ConnectionEventListener)Mockito.mock(ConnectionEventListener.class);
        state.addConnectionEventListener(listener1);
        state.notifyConnectionClosed();
        Assertions.assertThat((boolean)state.isValid()).isFalse();
        Assertions.assertThat((boolean)state.isClosed()).isTrue();
        Assertions.assertThat((Throwable)state.getConnectionError()).isNull();
        ((ConnectionEventListener)Mockito.verify((Object)listener1)).handleConnectionClosed();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener1});
        ConnectionEventListener listener2 = (ConnectionEventListener)Mockito.mock(ConnectionEventListener.class);
        state.addConnectionEventListener(listener2);
        ((ConnectionEventListener)Mockito.verify((Object)listener2)).handleConnectionClosed();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener2});
    }

    @Test
    public void testErrorEventInClosedState() {
        ConnectionState state = new ConnectionState();
        ConnectionEventListener listener1 = (ConnectionEventListener)Mockito.mock(ConnectionEventListener.class);
        state.addConnectionEventListener(listener1);
        state.notifyConnectionClosed();
        state.notifyConnectionError(false, ERROR);
        Assertions.assertThat((boolean)state.isValid()).isFalse();
        Assertions.assertThat((boolean)state.isClosed()).isTrue();
        Assertions.assertThat((Throwable)state.getConnectionError()).isNull();
        ((ConnectionEventListener)Mockito.verify((Object)listener1)).handleConnectionClosed();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener1});
        ConnectionEventListener listener2 = (ConnectionEventListener)Mockito.mock(ConnectionEventListener.class);
        state.addConnectionEventListener(listener2);
        ((ConnectionEventListener)Mockito.verify((Object)listener2)).handleConnectionClosed();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener2});
    }

    @Test
    public void testErrorEventInErrorState() {
        ConnectionState state = new ConnectionState();
        ConnectionEventListener listener1 = (ConnectionEventListener)Mockito.mock(ConnectionEventListener.class);
        state.addConnectionEventListener(listener1);
        state.notifyConnectionError(false, ERROR);
        state.notifyConnectionError(false, LATE_ERROR);
        Assertions.assertThat((boolean)state.isValid()).isFalse();
        Assertions.assertThat((boolean)state.isClosed()).isFalse();
        Assertions.assertThat((Throwable)state.getConnectionError()).isSameAs((Object)ERROR);
        ((ConnectionEventListener)Mockito.verify((Object)listener1)).handleConnectionError(false, ERROR);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener1});
        ConnectionEventListener listener2 = (ConnectionEventListener)Mockito.mock(ConnectionEventListener.class);
        state.addConnectionEventListener(listener2);
        Assertions.assertThat((Throwable)state.getConnectionError()).isSameAs((Object)ERROR);
        ((ConnectionEventListener)Mockito.verify((Object)listener2)).handleConnectionError(false, ERROR);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener2});
    }

    @Test
    public void testErrorEventInValidState() {
        ConnectionState state = new ConnectionState();
        ConnectionEventListener listener1 = (ConnectionEventListener)Mockito.mock(ConnectionEventListener.class);
        state.addConnectionEventListener(listener1);
        state.notifyConnectionError(false, ERROR);
        Assertions.assertThat((boolean)state.isValid()).isFalse();
        Assertions.assertThat((boolean)state.isClosed()).isFalse();
        Assertions.assertThat((Throwable)state.getConnectionError()).isSameAs((Object)ERROR);
        ((ConnectionEventListener)Mockito.verify((Object)listener1)).handleConnectionError(false, ERROR);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener1});
        ConnectionEventListener listener2 = (ConnectionEventListener)Mockito.mock(ConnectionEventListener.class);
        state.addConnectionEventListener(listener2);
        ((ConnectionEventListener)Mockito.verify((Object)listener2)).handleConnectionError(false, ERROR);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener2});
    }

    @Test
    public void testRemoveEventListener() {
        ConnectionState state = new ConnectionState();
        ConnectionEventListener listener = (ConnectionEventListener)Mockito.mock(ConnectionEventListener.class);
        state.addConnectionEventListener(listener);
        state.notifyConnectionError(false, ERROR);
        ((ConnectionEventListener)Mockito.verify((Object)listener)).handleConnectionError(false, ERROR);
        state.removeConnectionEventListener(listener);
        state.notifyConnectionClosed();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
    }

    @Test
    public void testUnsolicitedNotificationEventInClosedState() {
        ConnectionState state = new ConnectionState();
        ConnectionEventListener listener1 = (ConnectionEventListener)Mockito.mock(ConnectionEventListener.class);
        state.addConnectionEventListener(listener1);
        state.notifyConnectionClosed();
        state.notifyUnsolicitedNotification(UNSOLICITED);
        Assertions.assertThat((boolean)state.isValid()).isFalse();
        Assertions.assertThat((boolean)state.isClosed()).isTrue();
        Assertions.assertThat((Throwable)state.getConnectionError()).isNull();
        ((ConnectionEventListener)Mockito.verify((Object)listener1)).handleConnectionClosed();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener1});
    }

    @Test
    public void testUnsolicitedNotificationEventInErrorState() {
        ConnectionState state = new ConnectionState();
        ConnectionEventListener listener1 = (ConnectionEventListener)Mockito.mock(ConnectionEventListener.class);
        state.addConnectionEventListener(listener1);
        state.notifyConnectionError(false, ERROR);
        state.notifyUnsolicitedNotification(UNSOLICITED);
        Assertions.assertThat((boolean)state.isValid()).isFalse();
        Assertions.assertThat((boolean)state.isClosed()).isFalse();
        Assertions.assertThat((Throwable)state.getConnectionError()).isSameAs((Object)ERROR);
        ((ConnectionEventListener)Mockito.verify((Object)listener1)).handleConnectionError(false, ERROR);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener1});
    }

    @Test
    public void testUnsolicitedNotificationEventInValidState() {
        ConnectionState state = new ConnectionState();
        ConnectionEventListener listener1 = (ConnectionEventListener)Mockito.mock(ConnectionEventListener.class);
        state.addConnectionEventListener(listener1);
        state.notifyUnsolicitedNotification(UNSOLICITED);
        Assertions.assertThat((boolean)state.isValid()).isTrue();
        Assertions.assertThat((boolean)state.isClosed()).isFalse();
        Assertions.assertThat((Throwable)state.getConnectionError()).isNull();
        ((ConnectionEventListener)Mockito.verify((Object)listener1)).handleUnsolicitedNotification((ExtendedResult)Matchers.same((Object)UNSOLICITED));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener1});
        ConnectionEventListener listener2 = (ConnectionEventListener)Mockito.mock(ConnectionEventListener.class);
        state.addConnectionEventListener(listener2);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener2});
    }

    @Test
    public void testValidState() {
        ConnectionState state = new ConnectionState();
        Assertions.assertThat((boolean)state.isValid()).isTrue();
        Assertions.assertThat((boolean)state.isClosed()).isFalse();
        Assertions.assertThat((Throwable)state.getConnectionError()).isNull();
    }

    @Test
    public void testReentrantClose() {
        final ConnectionState state = new ConnectionState();
        ConnectionEventListener listener1 = (ConnectionEventListener)Mockito.mock(ConnectionEventListener.class);
        ((ConnectionEventListener)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) {
                state.notifyConnectionClosed();
                return null;
            }
        }).when((Object)listener1)).handleConnectionError(false, ERROR);
        state.addConnectionEventListener(listener1);
        state.notifyConnectionError(false, ERROR);
        Assertions.assertThat((boolean)state.isValid()).isFalse();
        Assertions.assertThat((boolean)state.isClosed()).isTrue();
        Assertions.assertThat((Throwable)state.getConnectionError()).isSameAs((Object)ERROR);
        ((ConnectionEventListener)Mockito.verify((Object)listener1)).handleConnectionError(false, ERROR);
        ((ConnectionEventListener)Mockito.verify((Object)listener1)).handleConnectionClosed();
    }
}

