/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.spi;

import java.net.InetSocketAddress;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.spi.LDAPConnectionFactoryImpl;
import org.forgerock.opendj.ldap.spi.LDAPConnectionImpl;
import org.forgerock.util.Options;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;
import org.mockito.Mockito;

final class BasicLDAPConnectionFactory
implements LDAPConnectionFactoryImpl {
    private final String host;
    private final int port;

    BasicLDAPConnectionFactory(String host, int port, Options options) {
        this.host = host;
        this.port = port;
    }

    public void close() {
    }

    public Promise<LDAPConnectionImpl, LdapException> getConnectionAsync() {
        return Promises.newResultPromise((Object)Mockito.mock(LDAPConnectionImpl.class));
    }

    public InetSocketAddress getSocketAddress() {
        return new InetSocketAddress(this.host, this.port);
    }

    public String getHostName() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.host + ':' + this.port + ')';
    }
}

