/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.forgerock.opendj.ldap.schema.AbstractSyntaxTestCase;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.Syntax;
import org.forgerock.opendj.ldap.schema.UTCTimeSyntaxImpl;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class UTCTimeSyntaxTest
extends AbstractSyntaxTestCase {
    @Override
    @DataProvider(name="acceptableValues")
    public Object[][] createAcceptableValues() {
        return new Object[][]{{"060906135030+01", true}, {"0609061350Z", true}, {"060906135030Z", true}, {"061116135030Z", true}, {"061126135030Z", true}, {"061231235959Z", true}, {"060906135030+0101", true}, {"060906135030+2359", true}, {"060906135060+0101", true}, {"060906135061+0101", false}, {"060906135030+3359", false}, {"060906135030+2389", false}, {"062231235959Z", false}, {"061232235959Z", false}, {"06123123595aZ", false}, {"0a1231235959Z", false}, {"06j231235959Z", false}, {"0612-1235959Z", false}, {"061231#35959Z", false}, {"2006", false}, {"062106135030+0101", false}, {"060A06135030+0101", false}, {"061A06135030+0101", false}, {"060936135030+0101", false}, {"06090A135030+0101", false}, {"06091A135030+0101", false}, {"060900135030+0101", false}, {"060906335030+0101", false}, {"0609061A5030+0101", false}, {"0609062A5030+0101", false}, {"060906137030+0101", false}, {"060906135A30+0101", false}, {"060906135", false}, {"0609061350", false}, {"060906135070+0101", false}, {"06090613503A+0101", false}, {"06090613503", false}, {"0609061350Z0", false}, {"0609061350+0", false}, {"0609061350+000A", false}, {"0609061350+A00A", false}, {"060906135030Z0", false}, {"060906135030+010", false}, {"060906135030+010A", false}, {"060906135030+0A01", false}, {"060906135030+2501", false}, {"060906135030+0170", false}, {"060906135030+010A", false}, {"060906135030+A00A", false}, {"060906135030Q", false}, {"060906135030+", false}};
    }

    @Test
    public void testCreateAndDecodeUTCTimeValue() throws Exception {
        Date d = new Date();
        String timeValue = UTCTimeSyntaxImpl.createUTCTimeValue((Date)d);
        Date decodedDate = UTCTimeSyntaxImpl.decodeUTCTimeValue((String)timeValue);
        Assert.assertTrue((Math.abs(d.getTime() - decodedDate.getTime()) < 1000L ? 1 : 0) != 0);
    }

    @Test
    public void testDecode50to99() throws Exception {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        for (int yy = 50; yy <= 99; ++yy) {
            String utcString = String.format("%02d0819120000Z", yy);
            Date decodedDate = UTCTimeSyntaxImpl.decodeUTCTimeValue((String)utcString);
            cal.clear();
            cal.setTime(decodedDate);
            int year = cal.get(1);
            Assert.assertEquals((int)year, (int)(yy + 1900));
        }
    }

    @Test
    public void testDecode00to49() throws Exception {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        for (int yy = 0; yy <= 49; ++yy) {
            String utcString = String.format("%02d0819120000Z", yy);
            Date decodedDate = UTCTimeSyntaxImpl.decodeUTCTimeValue((String)utcString);
            cal.clear();
            cal.setTime(decodedDate);
            int year = cal.get(1);
            Assert.assertEquals((int)year, (int)(yy + 2000));
        }
    }

    @Test
    public void testCreate50to99() throws Exception {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        for (int yy = 50; yy <= 99; ++yy) {
            cal.clear();
            cal.set(1900 + yy, 7, 19, 12, 0, 0);
            Date date = cal.getTime();
            String createdString = UTCTimeSyntaxImpl.createUTCTimeValue((Date)date);
            String expectedString = String.format("%02d0819120000Z", yy);
            Assert.assertEquals((String)expectedString, (String)createdString);
        }
    }

    @Test
    public void testCreate00to49() throws Exception {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        for (int yy = 0; yy <= 49; ++yy) {
            cal.clear();
            cal.set(2000 + yy, 7, 19, 12, 0, 0);
            Date date = cal.getTime();
            String createdString = UTCTimeSyntaxImpl.createUTCTimeValue((Date)date);
            String expectedString = String.format("%02d0819120000Z", yy);
            Assert.assertEquals((String)expectedString, (String)createdString);
        }
    }

    @Override
    protected Syntax getRule() {
        return Schema.getCoreSchema().getSyntax("1.3.6.1.4.1.1466.115.121.1.53");
    }
}

