/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import java.util.Collection;
import java.util.List;
import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.schema.AbstractSchemaTestCase;
import org.forgerock.opendj.ldap.schema.DirectoryStringSyntaxImpl;
import org.forgerock.opendj.ldap.schema.OctetStringSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.forgerock.opendj.ldap.schema.SchemaOptions;
import org.forgerock.opendj.ldap.schema.Syntax;
import org.forgerock.opendj.ldap.schema.SyntaxImpl;
import org.testng.annotations.Test;

public class SyntaxTestCase
extends AbstractSchemaTestCase {
    @Test
    public final void testBuilderCreatesCustomSyntax() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildSyntax("1.9.1.2.3").description("Security Label").extraProperties("X-TEST", new String[]{"1", "2", "3"}).implementation((SyntaxImpl)new DirectoryStringSyntaxImpl()).addToSchema().toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        Syntax syntax = schema.getSyntax("1.9.1.2.3");
        Assertions.assertThat((Object)syntax).isNotNull();
        Assertions.assertThat((String)syntax.getDescription()).isEqualTo((Object)"Security Label");
        Assertions.assertThat((List)((List)syntax.getExtraProperties().get("X-TEST"))).hasSize(3);
        Assertions.assertThat((String)syntax.getApproximateMatchingRule().getNameOrOID()).isEqualTo((Object)"ds-mr-double-metaphone-approx");
        Assertions.assertThat((String)syntax.getEqualityMatchingRule().getNameOrOID()).isEqualTo((Object)"caseIgnoreMatch");
        Assertions.assertThat((String)syntax.getOrderingMatchingRule().getNameOrOID()).isEqualTo((Object)"caseIgnoreOrderingMatch");
        Assertions.assertThat((String)syntax.getSubstringMatchingRule().getNameOrOID()).isEqualTo((Object)"caseIgnoreSubstringsMatch");
        Assertions.assertThat((String)syntax.toString()).isEqualTo((Object)"( 1.9.1.2.3 DESC 'Security Label' X-TEST ( '1' '2' '3' ) )");
        Assertions.assertThat((boolean)syntax.isHumanReadable()).isTrue();
        Assertions.assertThat((boolean)syntax.isBEREncodingRequired()).isFalse();
    }

    @Test
    public final void testBuilderSubstitutesUnknownSyntaxWithDefaultSyntax() {
        SchemaBuilder sb = new SchemaBuilder(Schema.getCoreSchema());
        sb.buildSyntax("1.2.3.4.5").addToSchema();
        Schema schema = sb.toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).hasSize(1);
        Syntax syntax = schema.getSyntax("1.2.3.4.5");
        Assertions.assertThat((Object)syntax).isNotNull();
        Assertions.assertThat((String)syntax.getDescription()).isEmpty();
        Assertions.assertThat((Object)syntax.getApproximateMatchingRule()).isNull();
        Assertions.assertThat((String)syntax.getEqualityMatchingRule().getNameOrOID()).isEqualTo((Object)"octetStringMatch");
        Assertions.assertThat((String)syntax.getOrderingMatchingRule().getNameOrOID()).isEqualTo((Object)"octetStringOrderingMatch");
        Assertions.assertThat((Object)syntax.getSubstringMatchingRule()).isNull();
    }

    @Test
    public final void testDefaultSyntaxSubstitution() {
        Syntax syntax = Schema.getCoreSchema().getSyntax("1.2.3.4.5");
        Assertions.assertThat((Object)syntax).isNotNull();
        Assertions.assertThat((String)syntax.getDescription()).isEmpty();
        Assertions.assertThat((String)((String)((List)syntax.getExtraProperties().get("X-SUBST")).get(0))).isEqualTo((Object)"1.3.6.1.4.1.1466.115.121.1.40");
        Assertions.assertThat((Object)syntax.getApproximateMatchingRule()).isNull();
        Assertions.assertThat((String)syntax.getEqualityMatchingRule().getNameOrOID()).isEqualTo((Object)"octetStringMatch");
        Assertions.assertThat((String)syntax.getOrderingMatchingRule().getNameOrOID()).isEqualTo((Object)"octetStringOrderingMatch");
        Assertions.assertThat((Object)syntax.getSubstringMatchingRule()).isNull();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public final void testBuilderDoesNotAllowEmptyOid() {
        new SchemaBuilder(Schema.getCoreSchema()).buildSyntax("").addToSchema();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public final void testBuilderDoesNotAllowNullOid() {
        new SchemaBuilder(Schema.getCoreSchema()).buildSyntax((String)null).addToSchema();
    }

    @Test
    public final void testBuilderAllowsNullSyntax() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildSyntax("1.9.1.2.3").implementation(null).addToSchema().toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isNotEmpty();
        Assertions.assertThat((String)schema.getWarnings().toString()).contains("It will be substituted by the default syntax");
        Syntax syntax = schema.getSyntax("1.9.1.2.3");
        Assertions.assertThat((Object)syntax).isNotNull();
        Assertions.assertThat((Object)syntax.getApproximateMatchingRule()).isEqualTo(null);
        Assertions.assertThat((String)syntax.getEqualityMatchingRule().getNameOrOID()).isEqualTo((Object)"octetStringMatch");
        Assertions.assertThat((String)syntax.getOrderingMatchingRule().getNameOrOID()).isEqualTo((Object)"octetStringOrderingMatch");
        Assertions.assertThat((Object)syntax.getSubstringMatchingRule()).isEqualTo(null);
        Assertions.assertThat((String)syntax.toString()).isEqualTo((Object)"( 1.9.1.2.3 )");
    }

    @Test
    public final void testBuilderAllowsNoSyntax() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildSyntax("1.9.1.2.3").addToSchema().toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isNotEmpty();
        Assertions.assertThat((String)schema.getWarnings().toString()).contains("It will be substituted by the default syntax");
        Syntax syntax = schema.getSyntax("1.9.1.2.3");
        Assertions.assertThat((Object)syntax).isNotNull();
        Assertions.assertThat((Object)syntax.getApproximateMatchingRule()).isEqualTo(null);
        Assertions.assertThat((String)syntax.getEqualityMatchingRule().getNameOrOID()).isEqualTo((Object)"octetStringMatch");
        Assertions.assertThat((String)syntax.getOrderingMatchingRule().getNameOrOID()).isEqualTo((Object)"octetStringOrderingMatch");
        Assertions.assertThat((Object)syntax.getSubstringMatchingRule()).isEqualTo(null);
        Assertions.assertThat((String)syntax.toString()).isEqualTo((Object)"( 1.9.1.2.3 )");
    }

    @Test
    public final void testBuilderAllowsNoSyntaxCaseWhereDefaultSyntaxIsChanged() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).setOption(SchemaOptions.DEFAULT_SYNTAX_OID, (Object)"1.3.6.1.4.1.1466.115.121.1.15").buildSyntax("1.9.1.2.3").addToSchema().toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isNotEmpty();
        Assertions.assertThat((String)schema.getWarnings().toString()).contains("It will be substituted by the default syntax");
        Syntax syntax = schema.getSyntax("1.9.1.2.3");
        Assertions.assertThat((Object)syntax).isNotNull();
        Assertions.assertThat((String)syntax.getApproximateMatchingRule().getNameOrOID()).isEqualTo((Object)"ds-mr-double-metaphone-approx");
        Assertions.assertThat((String)syntax.getEqualityMatchingRule().getNameOrOID()).isEqualTo((Object)"caseIgnoreMatch");
        Assertions.assertThat((String)syntax.getOrderingMatchingRule().getNameOrOID()).isEqualTo((Object)"caseIgnoreOrderingMatch");
        Assertions.assertThat((String)syntax.getSubstringMatchingRule().getNameOrOID()).isEqualTo((Object)"caseIgnoreSubstringsMatch");
        Assertions.assertThat((String)syntax.toString()).isEqualTo((Object)"( 1.9.1.2.3 )");
    }

    @Test
    public final void testBuilderAllowsNoDescription() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildSyntax("1.9.1.2.3").addToSchema().toSchema();
        Syntax syntax = schema.getSyntax("1.9.1.2.3");
        Assertions.assertThat((Object)syntax).isNotNull();
        Assertions.assertThat((String)syntax.getDescription()).isEqualTo((Object)"");
    }

    @Test
    public final void testBuilderAllowsNullDescription() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildSyntax("1.9.1.2.3").description(null).addToSchema().toSchema();
        Syntax syntax = schema.getSyntax("1.9.1.2.3");
        Assertions.assertThat((Object)syntax).isNotNull();
        Assertions.assertThat((String)syntax.getDescription()).isEqualTo((Object)"");
    }

    @Test
    public final void testBuilderAllowsEmptyDescription() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildSyntax("1.9.1.2.3").description("").addToSchema().toSchema();
        Syntax syntax = schema.getSyntax("1.9.1.2.3");
        Assertions.assertThat((Object)syntax).isNotNull();
        Assertions.assertThat((String)syntax.getDescription()).isEqualTo((Object)"");
    }

    @Test
    public final void testBuilderAllowsNoExtraProperties() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildSyntax("1.9.1.2.3").addToSchema().toSchema();
        Syntax syntax = schema.getSyntax("1.9.1.2.3");
        Assertions.assertThat((Object)syntax).isNotNull();
        Assertions.assertThat((boolean)syntax.getExtraProperties().isEmpty()).isTrue();
    }

    @Test(expectedExceptions={NullPointerException.class})
    public final void testBuilderDoesNotAllowNullExtraProperties() {
        new SchemaBuilder(Schema.getCoreSchema()).buildSyntax("1.9.1.2.3").extraProperties(null);
    }

    @Test
    public final void testBuilderRemoveExtraProperties() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildSyntax("1.9.1.2.3").extraProperties("X-ENUM", new String[]{"1", "2", "3"}).removeAllExtraProperties().addToSchema().toSchema();
        Syntax syntax = schema.getSyntax("1.9.1.2.3");
        Assertions.assertThat((Object)syntax).isNotNull();
        Assertions.assertThat((boolean)syntax.getExtraProperties().isEmpty()).isTrue();
    }

    @Test
    public final void testBuilderRemoveSpecifiedExtraProperties() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildSyntax("1.9.1.2.3").extraProperties("X-ENUM", new String[]{"top-secret", "secret", "confidential"}).extraProperties("X-ORIGIN", new String[]{"Sam Carter"}).removeExtraProperty("X-ENUM", new String[]{"top-secret"}).addToSchema().toSchema();
        Syntax syntax = schema.getSyntax("1.9.1.2.3");
        Assertions.assertThat((Object)syntax).isNotNull();
        Assertions.assertThat((boolean)syntax.getExtraProperties().isEmpty()).isFalse();
        Assertions.assertThat((int)((List)syntax.getExtraProperties().get("X-ENUM")).size()).isEqualTo(2);
        Assertions.assertThat((int)((List)syntax.getExtraProperties().get("X-ORIGIN")).size()).isEqualTo(1);
    }

    @Test
    public final void testAddingBERSyntaxDefinition() {
        SchemaBuilder sb = new SchemaBuilder();
        sb.addSchema(Schema.getCoreSchema(), false);
        String definition = "( 1.3.6.1.4.1.1466.115.121.1.8 DESC 'X.509 Certificate' )";
        sb.addSyntax("( 1.3.6.1.4.1.1466.115.121.1.8 DESC 'X.509 Certificate' )", true);
        Schema schema = sb.toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        Syntax syntax = schema.getSyntax("1.3.6.1.4.1.1466.115.121.1.8");
        Assertions.assertThat((Object)syntax).isNotNull();
        Assertions.assertThat((String)syntax.getDescription()).isEqualTo((Object)"X.509 Certificate");
        Assertions.assertThat((boolean)syntax.getExtraProperties().isEmpty()).isTrue();
        Assertions.assertThat((Object)syntax.getApproximateMatchingRule()).isNull();
        Assertions.assertThat((String)syntax.getEqualityMatchingRule().getNameOrOID()).isEqualTo((Object)"certificateExactMatch");
        Assertions.assertThat((String)syntax.getOrderingMatchingRule().getNameOrOID()).isEqualTo((Object)"octetStringOrderingMatch");
        Assertions.assertThat((Object)syntax.getSubstringMatchingRule()).isNull();
        Assertions.assertThat((boolean)syntax.isBEREncodingRequired()).isTrue();
        Assertions.assertThat((boolean)syntax.isHumanReadable()).isFalse();
    }

    @Test
    public final void testAddingASyntaxDefinitionStringOverride() {
        SchemaBuilder sb = new SchemaBuilder();
        sb.addSchema(Schema.getCoreSchema(), false);
        String definition = "( 1.3.6.1.4.1.4203.1.1.2 DESC 'Authentication Password Syntaxe' X-ORIGIN 'RFC 4512' )";
        sb.addSyntax("( 1.3.6.1.4.1.4203.1.1.2 DESC 'Authentication Password Syntaxe' X-ORIGIN 'RFC 4512' )", true);
        Schema schema = sb.toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        Syntax syntax = schema.getSyntax("1.3.6.1.4.1.4203.1.1.2");
        Assertions.assertThat((Object)syntax).isNotNull();
        Assertions.assertThat((String)syntax.getDescription()).isEqualTo((Object)"Authentication Password Syntaxe");
        Assertions.assertThat((boolean)syntax.getExtraProperties().isEmpty()).isFalse();
        Assertions.assertThat((String)((String)((List)syntax.getExtraProperties().get("X-ORIGIN")).get(0))).isEqualTo((Object)"RFC 4512");
        Assertions.assertThat((Object)syntax.getApproximateMatchingRule()).isNull();
        Assertions.assertThat((String)syntax.getEqualityMatchingRule().getNameOrOID()).isEqualTo((Object)"authPasswordExactMatch");
        Assertions.assertThat((Object)syntax.getOrderingMatchingRule()).isNull();
        Assertions.assertThat((Object)syntax.getSubstringMatchingRule()).isNull();
    }

    @Test
    public final void testAddingUnknownSyntaxDefinitionString() {
        SchemaBuilder sb = new SchemaBuilder();
        sb.addSchema(Schema.getCoreSchema(), false);
        String definition = "( 1.3.6.1.4.1.4203.1.1.9999 DESC 'Custom Authentication Password' X-ORIGIN 'None' )";
        sb.addSyntax("( 1.3.6.1.4.1.4203.1.1.9999 DESC 'Custom Authentication Password' X-ORIGIN 'None' )", false);
        Schema schema = sb.toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isNotEmpty();
        Syntax syntax = schema.getSyntax("1.3.6.1.4.1.4203.1.1.9999");
        Assertions.assertThat((Object)syntax).isNotNull();
        Assertions.assertThat((String)syntax.getDescription()).isEqualTo((Object)"Custom Authentication Password");
        Assertions.assertThat((boolean)syntax.getExtraProperties().isEmpty()).isFalse();
        Assertions.assertThat((String)((String)((List)syntax.getExtraProperties().get("X-ORIGIN")).get(0))).isEqualTo((Object)"None");
        Assertions.assertThat((Object)syntax.getApproximateMatchingRule()).isNull();
        Assertions.assertThat((String)syntax.getEqualityMatchingRule().getNameOrOID()).isEqualTo((Object)"octetStringMatch");
        Assertions.assertThat((String)syntax.getOrderingMatchingRule().getNameOrOID()).isEqualTo((Object)"octetStringOrderingMatch");
        Assertions.assertThat((Object)syntax.getSubstringMatchingRule()).isNull();
    }

    @Test
    public final void testBuilderDuplicatesExistingSyntax() {
        Schema schema1 = new SchemaBuilder(Schema.getCoreSchema()).buildSyntax("1.2.3.4.5.6").description("v1").addToSchema().toSchema();
        Syntax syntax1 = schema1.getSyntax("1.2.3.4.5.6");
        Assertions.assertThat((String)syntax1.getDescription()).isEqualTo((Object)"v1");
        Schema schema2 = new SchemaBuilder(Schema.getCoreSchema()).buildSyntax(syntax1).description("v2").addToSchema().toSchema();
        Syntax syntax2 = schema2.getSyntax("1.2.3.4.5.6");
        Assertions.assertThat((String)syntax2.getDescription()).isEqualTo((Object)"v2");
        Assertions.assertThat((String)syntax2.toString()).isEqualTo((Object)"( 1.2.3.4.5.6 DESC 'v2' )");
    }

    @Test
    public final void testBuilderDuplicatesSyntax() {
        SchemaBuilder sb = new SchemaBuilder();
        sb.addSchema(Schema.getCoreSchema(), false);
        Syntax.Builder nfb = new Syntax.Builder("1.2.3.4.5.9999", sb);
        nfb.description("Description of the new syntax").extraProperties("X-ORIGIN", new String[]{"SyntaxCheckingTestCase"}).addToSchema();
        Schema schema = sb.toSchema();
        Assertions.assertThat((Collection)schema.getSyntaxes()).isNotEmpty();
        Syntax syntax = schema.getSyntax("1.2.3.4.5.9999");
        Assertions.assertThat((String)syntax.getDescription()).isEqualTo((Object)"Description of the new syntax");
        sb.buildSyntax(syntax).oid("1.2.3.4.5.99996").extraProperties("X-ORIGIN", new String[]{"Unknown"}).addToSchema();
        schema = sb.toSchema();
        Assertions.assertThat((Collection)schema.getSyntaxes()).isNotEmpty();
        Syntax dolly = schema.getSyntax("1.2.3.4.5.99996");
        Assertions.assertThat((String)dolly.getDescription()).isEqualTo((Object)"Description of the new syntax");
        Assertions.assertThat((int)dolly.getExtraProperties().size()).isEqualTo(1);
        Assertions.assertThat((String)((String)((List)dolly.getExtraProperties().get("X-ORIGIN")).get(0))).isEqualTo((Object)"SyntaxCheckingTestCase");
        Assertions.assertThat((String)((String)((List)dolly.getExtraProperties().get("X-ORIGIN")).get(1))).isEqualTo((Object)"Unknown");
        Assertions.assertThat((int)((List)dolly.getExtraProperties().get("X-ORIGIN")).size()).isEqualTo(2);
        Syntax originalSyntax = schema.getSyntax("1.2.3.4.5.9999");
        Assertions.assertThat((String)originalSyntax.getDescription()).isEqualTo((Object)"Description of the new syntax");
        Assertions.assertThat((int)((List)originalSyntax.getExtraProperties().get("X-ORIGIN")).size()).isEqualTo(1);
    }

    @Test
    public final void testBuilderSyntaxesEqualsTrue() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildSyntax("1.9.1.2.3").description("Security Label").extraProperties("X-ENUM", new String[]{"top-secret", "secret", "confidential"}).implementation((SyntaxImpl)new DirectoryStringSyntaxImpl()).addToSchema().toSchema();
        Syntax syntax1 = schema.getSyntax("1.9.1.2.3");
        Schema schema2 = new SchemaBuilder(Schema.getCoreSchema()).buildSyntax("1.9.1.2.3").description("Security Label").extraProperties("X-ENUM", new String[]{"top-secret", "secret", "confidential"}).implementation((SyntaxImpl)new DirectoryStringSyntaxImpl()).addToSchema().toSchema();
        Syntax syntax2 = schema2.getSyntax("1.9.1.2.3");
        Assertions.assertThat((Object)syntax1).isEqualTo((Object)syntax2);
    }

    @Test
    public final void testBuilderSyntaxesEqualsFalse() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildSyntax("1.9.1.2.3").description("Security Label").extraProperties("X-ENUM", new String[]{"top-secret", "secret", "confidential"}).implementation((SyntaxImpl)new DirectoryStringSyntaxImpl()).addToSchema().toSchema();
        Syntax syntax1 = schema.getSyntax("1.9.1.2.3");
        Schema schema2 = new SchemaBuilder(Schema.getCoreSchema()).buildSyntax("1.9.1.2.4").description("Security Label").extraProperties("X-ENUM", new String[]{"top-secret", "secret", "confidential"}).implementation((SyntaxImpl)new DirectoryStringSyntaxImpl()).addToSchema().toSchema();
        Syntax syntax2 = schema2.getSyntax("1.9.1.2.4");
        Assertions.assertThat((Object)syntax1).isNotEqualTo((Object)syntax2);
    }

    @Test
    public final void testBuilderEqualityReturnsTrueBetweenBuilderAndDefinition() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildSyntax("1.9.1.2.3").description("Security Label").extraProperties("X-ENUM", new String[]{"top-secret", "secret", "confidential"}).implementation((SyntaxImpl)new DirectoryStringSyntaxImpl()).addToSchema().toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        Syntax syntax1 = schema.getSyntax("1.9.1.2.3");
        SchemaBuilder sb2 = new SchemaBuilder();
        sb2.addSchema(Schema.getCoreSchema(), false);
        String definition = "( 1.9.1.2.3 DESC 'Security Label' X-ENUM ( 'top-secret' 'secret' 'confidential' ) )";
        sb2.addSyntax("( 1.9.1.2.3 DESC 'Security Label' X-ENUM ( 'top-secret' 'secret' 'confidential' ) )", false);
        Syntax syntax2 = sb2.toSchema().getSyntax("1.9.1.2.3");
        Assertions.assertThat((Object)syntax1).isEqualTo((Object)syntax2);
    }

    @Test
    public final void testBuilderEqualityReturnsFalseBetweenBuilderAndDefinition() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildSyntax("1.9.1.2.3").description("Security Label").extraProperties("X-ENUM", new String[]{"top-secret", "secret", "confidential"}).implementation((SyntaxImpl)new DirectoryStringSyntaxImpl()).addToSchema().toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        Syntax syntax1 = schema.getSyntax("1.9.1.2.3");
        SchemaBuilder sb2 = new SchemaBuilder();
        sb2.addSchema(Schema.getCoreSchema(), false);
        String definition = "( 1.9.1.2.4 DESC 'Security Label II' X-ENUM ( 'top-secret' 'secret' 'confidential' ) )";
        sb2.addSyntax("( 1.9.1.2.4 DESC 'Security Label II' X-ENUM ( 'top-secret' 'secret' 'confidential' ) )", false);
        Syntax syntax2 = sb2.toSchema().getSyntax("1.9.1.2.4");
        Assertions.assertThat((Object)syntax1).isNotEqualTo((Object)syntax2);
    }

    @Test
    public final void testBuilderCreatesSyntaxesUsingChainingMethods() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildSyntax("1.9.1.2.3").description("Security Label").extraProperties("X-TEST", new String[]{"1", "2", "3"}).implementation((SyntaxImpl)new DirectoryStringSyntaxImpl()).addToSchema().buildSyntax("1.9.1.2.4").description("Security Label II").extraProperties("X-TEST", new String[]{"private"}).addToSchema().buildSyntax("non-implemented-syntax-oid").description("Not Implemented in OpenDJ").extraProperties("X-SUBST", new String[]{"1.3.6.1.4.1.1466.115.121.1.15"}).implementation(null).addToSchema().buildSyntax("1.3.6.1.4.1.4203.1.1.2").description("Authentication Password Syntax").extraProperties("X-ORIGIN", new String[]{"RFC 4512"}).implementation((SyntaxImpl)new OctetStringSyntaxImpl()).addToSchemaOverwrite().toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isNotEmpty();
        Assertions.assertThat((String)schema.getDefaultSyntax().getOID()).isEqualTo((Object)"1.3.6.1.4.1.1466.115.121.1.40");
        Syntax s1 = schema.getSyntax("1.9.1.2.3");
        Assertions.assertThat((String)s1.getDescription()).isEqualTo((Object)"Security Label");
        Assertions.assertThat((String)s1.getApproximateMatchingRule().getNameOrOID()).isEqualTo((Object)"ds-mr-double-metaphone-approx");
        Assertions.assertThat((String)s1.getEqualityMatchingRule().getNameOrOID()).isEqualTo((Object)"caseIgnoreMatch");
        Assertions.assertThat((String)s1.getOrderingMatchingRule().getNameOrOID()).isEqualTo((Object)"caseIgnoreOrderingMatch");
        Assertions.assertThat((String)s1.getSubstringMatchingRule().getNameOrOID()).isEqualTo((Object)"caseIgnoreSubstringsMatch");
        Assertions.assertThat((List)((List)s1.getExtraProperties().get("X-TEST"))).hasSize(3);
        Syntax s2 = schema.getSyntax("1.9.1.2.4");
        Assertions.assertThat((String)s2.getDescription()).isEqualTo((Object)"Security Label II");
        Assertions.assertThat((List)((List)s2.getExtraProperties().get("X-TEST"))).hasSize(1);
        Assertions.assertThat((Object)s2.getApproximateMatchingRule()).isEqualTo(null);
        Assertions.assertThat((String)s2.getEqualityMatchingRule().getNameOrOID()).isEqualTo((Object)"octetStringMatch");
        Assertions.assertThat((String)s2.getOrderingMatchingRule().getNameOrOID()).isEqualTo((Object)"octetStringOrderingMatch");
        Assertions.assertThat((Object)s2.getSubstringMatchingRule()).isEqualTo(null);
        Syntax s3 = schema.getSyntax("non-implemented-syntax-oid");
        Assertions.assertThat((String)s3.getDescription()).isEqualTo((Object)"Not Implemented in OpenDJ");
        Assertions.assertThat((int)((List)s3.getExtraProperties().get("X-SUBST")).size()).isEqualTo(1);
        Assertions.assertThat((String)s1.getApproximateMatchingRule().getNameOrOID()).isEqualTo((Object)"ds-mr-double-metaphone-approx");
        Assertions.assertThat((String)s1.getEqualityMatchingRule().getNameOrOID()).isEqualTo((Object)"caseIgnoreMatch");
        Assertions.assertThat((String)s1.getOrderingMatchingRule().getNameOrOID()).isEqualTo((Object)"caseIgnoreOrderingMatch");
        Assertions.assertThat((String)s1.getSubstringMatchingRule().getNameOrOID()).isEqualTo((Object)"caseIgnoreSubstringsMatch");
        Syntax s4 = schema.getSyntax("1.3.6.1.4.1.4203.1.1.2");
        Assertions.assertThat((String)s4.getDescription()).isEqualTo((Object)"Authentication Password Syntax");
        Assertions.assertThat((Object)s4.getApproximateMatchingRule()).isEqualTo(null);
        Assertions.assertThat((String)s4.getEqualityMatchingRule().getNameOrOID()).isEqualTo((Object)"octetStringMatch");
        Assertions.assertThat((String)s4.getOrderingMatchingRule().getNameOrOID()).isEqualTo((Object)"octetStringOrderingMatch");
        Assertions.assertThat((Object)s4.getSubstringMatchingRule()).isEqualTo(null);
        Assertions.assertThat((int)((List)s4.getExtraProperties().get("X-ORIGIN")).size()).isEqualTo(1);
    }
}

