/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import java.util.ArrayList;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ConditionResult;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractSchemaTestCase;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public abstract class SubstringMatchingRuleTest
extends AbstractSchemaTestCase {
    @DataProvider(name="substringInvalidAssertionValues")
    public abstract Object[][] createMatchingRuleInvalidAssertionValues();

    @DataProvider(name="substringInvalidAttributeValues")
    public abstract Object[][] createMatchingRuleInvalidAttributeValues();

    @DataProvider(name="substringInitialMatchData")
    public abstract Object[][] createSubstringFinalMatchData();

    @DataProvider(name="substringInitialMatchData")
    public abstract Object[][] createSubstringInitialMatchData();

    @DataProvider(name="substringMiddleMatchData")
    public abstract Object[][] createSubstringMiddleMatchData();

    @Test(dataProvider="substringFinalMatchData")
    public void finalMatchingRules(String value, String finalValue, ConditionResult result) throws Exception {
        MatchingRule rule = this.getRule();
        ByteString normalizedValue = rule.normalizeAttributeValue((ByteSequence)ByteString.valueOfUtf8((CharSequence)value));
        ConditionResult substringAssertionMatches = rule.getSubstringAssertion(null, null, (ByteSequence)ByteString.valueOfUtf8((CharSequence)finalValue)).matches((ByteSequence)normalizedValue);
        ConditionResult assertionMatches = rule.getAssertion((ByteSequence)ByteString.valueOfUtf8((CharSequence)("*" + finalValue))).matches((ByteSequence)normalizedValue);
        String message = this.getMessage("final", rule, value, finalValue);
        Assert.assertEquals((Object)substringAssertionMatches, (Object)result, (String)message);
        Assert.assertEquals((Object)assertionMatches, (Object)result, (String)message);
    }

    @Test(dataProvider="substringInitialMatchData")
    public void initialMatchingRules(String value, String initial, ConditionResult result) throws Exception {
        MatchingRule rule = this.getRule();
        ByteString normalizedValue = rule.normalizeAttributeValue((ByteSequence)ByteString.valueOfUtf8((CharSequence)value));
        ConditionResult substringAssertionMatches = rule.getSubstringAssertion((ByteSequence)ByteString.valueOfUtf8((CharSequence)initial), null, null).matches((ByteSequence)normalizedValue);
        ConditionResult assertionMatches = rule.getAssertion((ByteSequence)ByteString.valueOfUtf8((CharSequence)(initial + "*"))).matches((ByteSequence)normalizedValue);
        String message = this.getMessage("initial", rule, value, initial);
        Assert.assertEquals((Object)substringAssertionMatches, (Object)result, (String)message);
        Assert.assertEquals((Object)assertionMatches, (Object)result, (String)message);
    }

    private String getMessage(String prefix, MatchingRule rule, String value, String assertionValue) {
        return prefix + " substring matching rule " + rule + " failed for values : \"" + value + "\" and \"" + assertionValue + "\".";
    }

    @Test(expectedExceptions={DecodeException.class}, dataProvider="substringInvalidAssertionValues")
    public void matchingRulesInvalidAssertionValues(String subInitial, String[] anys, String subFinal) throws Exception {
        MatchingRule rule = this.getRule();
        ArrayList<ByteString> anyList = new ArrayList<ByteString>(anys.length);
        for (String middleSub : anys) {
            anyList.add(ByteString.valueOfUtf8((CharSequence)middleSub));
        }
        rule.getSubstringAssertion((ByteSequence)(subInitial == null ? null : ByteString.valueOfUtf8((CharSequence)subInitial)), anyList, (ByteSequence)(subFinal == null ? null : ByteString.valueOfUtf8((CharSequence)subFinal)));
    }

    @Test(expectedExceptions={DecodeException.class}, dataProvider="substringInvalidAssertionValues")
    public void matchingRulesInvalidAssertionValuesString(String subInitial, String[] anys, String subFinal) throws Exception {
        MatchingRule rule = this.getRule();
        StringBuilder assertionString = new StringBuilder();
        if (subInitial != null) {
            assertionString.append(subInitial);
        }
        assertionString.append("*");
        for (String middleSub : anys) {
            assertionString.append(middleSub);
            assertionString.append("*");
        }
        if (subFinal != null) {
            assertionString.append(subFinal);
        }
        rule.getAssertion((ByteSequence)ByteString.valueOfUtf8((CharSequence)assertionString.toString()));
    }

    @Test(dataProvider="substringMiddleMatchData")
    public void middleMatchingRules(String value, String[] middleSubs, ConditionResult result) throws Exception {
        MatchingRule rule = this.getRule();
        ByteString normalizedValue = rule.normalizeAttributeValue((ByteSequence)ByteString.valueOfUtf8((CharSequence)value));
        StringBuilder printableMiddleSubs = new StringBuilder();
        ArrayList<ByteString> middleList = new ArrayList<ByteString>(middleSubs.length);
        printableMiddleSubs.append("*");
        for (String middleSub : middleSubs) {
            printableMiddleSubs.append(middleSub);
            printableMiddleSubs.append("*");
            middleList.add(ByteString.valueOfUtf8((CharSequence)middleSub));
        }
        ConditionResult substringAssertionMatches = rule.getSubstringAssertion(null, middleList, null).matches((ByteSequence)normalizedValue);
        ConditionResult assertionMatches = rule.getAssertion((ByteSequence)ByteString.valueOfUtf8((CharSequence)printableMiddleSubs)).matches((ByteSequence)normalizedValue);
        String message = this.getMessage("middle", rule, value, printableMiddleSubs.toString());
        Assert.assertEquals((Object)substringAssertionMatches, (Object)result, (String)message);
        Assert.assertEquals((Object)assertionMatches, (Object)result, (String)message);
    }

    @Test(expectedExceptions={DecodeException.class}, dataProvider="substringInvalidAttributeValues")
    public void substringInvalidAttributeValues(String value) throws Exception {
        MatchingRule rule = this.getRule();
        rule.normalizeAttributeValue((ByteSequence)ByteString.valueOfUtf8((CharSequence)value));
    }

    protected abstract MatchingRule getRule();

    protected String[] strings(String ... strings) {
        return strings;
    }
}

