/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import org.forgerock.opendj.ldap.schema.AbstractSyntaxTestCase;
import org.forgerock.opendj.ldap.schema.ConflictingSchemaElementException;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.forgerock.opendj.ldap.schema.Syntax;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class SubstitutionSyntaxTestCase
extends AbstractSyntaxTestCase {
    @Override
    @DataProvider(name="acceptableValues")
    public Object[][] createAcceptableValues() {
        return new Object[][]{{"12345678", true}, {"12345678\u2163", false}};
    }

    @Test
    public void testSelfSubstitute1() {
        SchemaBuilder builder = new SchemaBuilder(Schema.getCoreSchema());
        builder.addSyntax("( 1.3.6.1.4.1.1466.115.121.1.15  DESC 'Replacing DirectorySyntax'   X-SUBST '1.3.6.1.4.1.1466.115.121.1.15' )", true);
        Assert.assertFalse((boolean)builder.toSchema().getWarnings().isEmpty());
    }

    @Test
    public void testSelfSubstitute2() {
        SchemaBuilder builder = new SchemaBuilder(Schema.getCoreSchema());
        builder.addSubstitutionSyntax("1.3.6.1.4.1.1466.115.121.1.15", "Replacing DirectorySyntax", "1.3.6.1.4.1.1466.115.121.1.15", true);
        Assert.assertFalse((boolean)builder.toSchema().getWarnings().isEmpty());
    }

    @Test(expectedExceptions={ConflictingSchemaElementException.class})
    public void testSubstituteCore1() throws ConflictingSchemaElementException {
        SchemaBuilder builder = new SchemaBuilder(Schema.getCoreSchema());
        builder.addSyntax("( 1.3.6.1.4.1.1466.115.121.1.26  DESC 'Replacing DirectorySyntax'   X-SUBST '9.9.9' )", false);
    }

    @Test
    public void testSubstituteCore1Override() {
        SchemaBuilder builder = new SchemaBuilder(Schema.getCoreSchema());
        builder.addSyntax("( 1.3.6.1.4.1.1466.115.121.1.26  DESC 'Replacing DirectorySyntax'   X-SUBST '9.9.9' )", true);
    }

    @Test(expectedExceptions={ConflictingSchemaElementException.class})
    public void testSubstituteCore2() throws ConflictingSchemaElementException {
        SchemaBuilder builder = new SchemaBuilder(Schema.getCoreSchema());
        builder.addSubstitutionSyntax("1.3.6.1.4.1.1466.115.121.1.26", "Replacing DirectorySyntax", "9.9.9", false);
    }

    @Test
    public void testSubstituteCore2Override() {
        SchemaBuilder builder = new SchemaBuilder(Schema.getCoreSchema());
        builder.addSubstitutionSyntax("1.3.6.1.4.1.1466.115.121.1.26", "Replacing DirectorySyntax", "9.9.9", true);
    }

    @Test
    public void testUndefinedSubstitute1() {
        SchemaBuilder builder = new SchemaBuilder(Schema.getCoreSchema());
        builder.addSyntax("( 1.3.6.1.4.1.1466.115.121.1.15  DESC 'Replacing DirectorySyntax'   X-SUBST '1.1.1' )", true);
        Assert.assertFalse((boolean)builder.toSchema().getWarnings().isEmpty());
    }

    @Test
    public void testUndefinedSubstitute2() {
        SchemaBuilder builder = new SchemaBuilder(Schema.getCoreSchema());
        builder.addSubstitutionSyntax("1.3.6.1.4.1.1466.115.121.1.15", "Replacing DirectorySyntax", "1.1.1", true);
        Assert.assertFalse((boolean)builder.toSchema().getWarnings().isEmpty());
    }

    @Override
    protected Syntax getRule() {
        SchemaBuilder builder = new SchemaBuilder(Schema.getCoreSchema());
        builder.addSubstitutionSyntax("9.9.9", "Unimplemented Syntax", "1.3.6.1.4.1.1466.115.121.1.26", false);
        return builder.toSchema().getSyntax("9.9.9");
    }
}

