/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.util.SubstringReader;
import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractSchemaTestCase;
import org.forgerock.opendj.ldap.schema.SchemaUtils;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class SchemaUtilsTest
extends AbstractSchemaTestCase {
    @DataProvider(name="invalidOIDs")
    public Object[][] createInvalidOIDs() {
        return new Object[][]{{""}, {".0"}, {"0."}, {"100."}, {".999"}, {"1one"}, {"one+two+three"}, {"one.two.three"}, {"'0"}, {"'10"}, {"999'"}, {"0.0'"}};
    }

    @DataProvider(name="validOIDs")
    public Object[][] createValidOIDs() {
        return new Object[][]{{"0.0"}, {"1.0"}, {"2.0"}, {"3.0"}, {"4.0"}, {"5.0"}, {"6.0"}, {"7.0"}, {"8.0"}, {"9.0"}, {"0.1"}, {"0.2"}, {"0.3"}, {"0.4"}, {"0.5"}, {"0.6"}, {"0.7"}, {"0.8"}, {"0.9"}, {"10.0"}, {"100.0"}, {"999.0"}, {"0.100"}, {"0.999"}, {"100.100"}, {"999.999"}, {"111.22.333.44.55555.66.777.88.999"}, {"a"}, {"a2"}, {"a-"}, {"one"}, {"one1"}, {"one-two"}, {"one1-two2-three3"}, {"'0.0'"}, {"'10.0'"}, {"'999.0'"}, {"'111.22.333.44.55555.66.777.88.999'"}, {"'a'"}, {"'a2'"}, {"'a-'"}, {"'one'"}, {"'one1'"}, {"'one-two'"}, {"'one1-two2-three3'"}, {"0"}, {"1"}, {"2"}, {"3"}, {"4"}, {"5"}, {"6"}, {"7"}, {"8"}, {"9"}, {"00"}, {"01"}, {"01.0"}, {"0.01"}};
    }

    @Test(dataProvider="invalidOIDs", expectedExceptions={DecodeException.class})
    public void testReadOIDInvalid(String oid) throws DecodeException {
        SubstringReader reader = new SubstringReader(oid);
        SchemaUtils.readOID((SubstringReader)reader, (boolean)false);
    }

    @Test(dataProvider="validOIDs")
    public void testReadOIDValid(String oid) throws DecodeException {
        String expected = oid;
        if (oid.startsWith("'")) {
            expected = oid.substring(1, oid.length() - 1);
        }
        SubstringReader reader = new SubstringReader(oid);
        Assert.assertEquals((String)SchemaUtils.readOID((SubstringReader)reader, (boolean)false), (String)expected);
    }

    @DataProvider
    public Object[][] nonAsciiStringProvider() throws Exception {
        String nonAsciiChars = "\u00eb\u00e9\u00e8\u00ea\u0153";
        String singleNonAsciiChar = "\u00eb";
        String nonAsciiCharsReplacement = new String(new byte[]{this.b(101), this.b(204), this.b(136), this.b(101), this.b(204), this.b(129), this.b(101), this.b(204), this.b(128), this.b(101), this.b(204), this.b(130), this.b(197), this.b(147)}, "UTF8");
        String singleNonAsciiCharReplacement = new String(new byte[]{this.b(101), this.b(204), this.b(136)}, "UTF8");
        return new Object[][]{{"\u00eb\u00e9\u00e8\u00ea\u0153", false, false, nonAsciiCharsReplacement}, {"\u00eb\u00e9\u00e8\u00ea\u0153", false, true, nonAsciiCharsReplacement}, {"\u00eb\u00e9\u00e8\u00ea\u0153", true, false, nonAsciiCharsReplacement}, {"\u00eb\u00e9\u00e8\u00ea\u0153", true, true, nonAsciiCharsReplacement}, {"\u00eb", true, true, singleNonAsciiCharReplacement}};
    }

    @DataProvider
    public Object[][] stringProvider() throws Exception {
        String allSpaceChars = "\t\n\u000b\f\r\u000e";
        String mappedToNothingChars = "\u007f\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f";
        return new Object[][]{{"", false, false, ""}, {"", false, true, ""}, {"", true, false, ""}, {"", true, true, ""}, {"  ", false, false, " "}, {"  ", false, true, " "}, {"  ", true, false, " "}, {"  ", true, true, " "}, {"\t\n\u000b\f\r\u000e", false, false, " "}, {"\t\n\u000b\f\r\u000e", false, true, " "}, {"\t\n\u000b\f\r\u000e", true, false, " "}, {"\t\n\u000b\f\r\u000e", true, true, " "}, {"\u007f\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f", false, false, " "}, {"\u007f\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f", false, true, " "}, {"\u007f\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f", true, false, " "}, {"\u007f\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f", true, true, " "}};
    }

    @DataProvider
    public Object[][] stringWithSpacesProvider() {
        return new Object[][]{{" this is a string ", false, false, " this is a string "}, {" this is a string ", false, true, " this is a string "}, {" this is a string ", true, false, "this is a string"}, {" this is a string ", true, true, "this is a string"}, {"   this  is    a   string  ", false, false, " this is a string "}, {"   this  is    a   string  ", false, true, " this is a string "}, {"   this  is    a   string  ", true, false, "this is a string"}, {"   this  is    a   string  ", true, true, "this is a string"}, {" THIS IS A STRING ", false, false, " THIS IS A STRING "}, {" THIS IS A STRING ", false, true, " this is a string "}, {" THIS IS A STRING ", true, false, "THIS IS A STRING"}, {" THIS IS A STRING ", true, true, "this is a string"}};
    }

    private byte b(int i) {
        return (byte)i;
    }

    @Test(dataProvider="stringProvider")
    public void testNormalizeStringProvider(String value, boolean trim, boolean foldCase, String expected) throws Exception {
        ByteString val = ByteString.valueOfUtf8((CharSequence)value);
        ByteString normValue = SchemaUtils.normalizeStringAttributeValue((ByteSequence)val, (boolean)trim, (boolean)foldCase);
        Assertions.assertThat((String)normValue.toString()).isEqualTo((Object)expected);
    }

    @Test(dataProvider="nonAsciiStringProvider")
    public void testNormalizeStringWithNonAscii(String value, boolean trim, boolean foldCase, String expected) throws Exception {
        this.testNormalizeStringProvider(value, trim, foldCase, expected);
    }

    @Test(dataProvider="stringWithSpacesProvider")
    public void testNormalizeStringWithSpaces(String value, boolean trim, boolean foldCase, String expected) throws Exception {
        this.testNormalizeStringProvider(value, trim, foldCase, expected);
    }

    @Test(dataProvider="stringProvider")
    public void testNormalizeIA5String(String value, boolean trim, boolean foldCase, String expected) throws Exception {
        ByteString val = ByteString.valueOfUtf8((CharSequence)value);
        ByteString normValue = SchemaUtils.normalizeIA5StringAttributeValue((ByteSequence)val, (boolean)trim, (boolean)foldCase);
        Assertions.assertThat((String)normValue.toString()).isEqualTo((Object)expected);
    }

    @Test(dataProvider="nonAsciiStringProvider", expectedExceptions={DecodeException.class})
    public void testNormalizeIA5StringShouldThrowForNonAscii(String value, boolean trim, boolean foldCase, String expected) throws Exception {
        this.testNormalizeIA5String(value, trim, foldCase, expected);
    }

    @Test(dataProvider="stringWithSpacesProvider")
    public void testNormalizeIA5StringWithSpaces(String value, boolean trim, boolean foldCase, String expected) throws Exception {
        this.testNormalizeIA5String(value, trim, foldCase, expected);
    }

    @Test(dataProvider="stringProvider")
    public void testNormalizeStringList(String value, boolean trim, boolean foldCase, String expected) throws Exception {
        ByteString val = ByteString.valueOfUtf8((CharSequence)value);
        ByteString normValue = SchemaUtils.normalizeStringListAttributeValue((ByteSequence)val, (boolean)trim, (boolean)foldCase);
        Assertions.assertThat((String)normValue.toString()).isEqualTo((Object)expected);
    }

    @Test(dataProvider="nonAsciiStringProvider")
    public void testNormalizeStringListWithNonAscii(String value, boolean trim, boolean foldCase, String expected) throws Exception {
        this.testNormalizeStringList(value, trim, foldCase, expected);
    }

    @DataProvider
    public Object[][] stringListProvider() throws Exception {
        return new Object[][]{{"this$is$a$list", false, false, "this$is$a$list"}, {"this$is$a$list", false, true, "this$is$a$list"}, {"this$is$a$list", true, false, "this$is$a$list"}, {"this$is$a$list", true, true, "this$is$a$list"}, {"this $ is $ a $ list", false, false, "this$is$a$list"}, {"this $ is $ a $ list", false, true, "this$is$a$list"}, {"this $ is $ a $ list", true, false, "this$is$a$list"}, {"this $ is $ a $ list", true, true, "this$is$a$list"}, {"this $ is \\\\ $ a $ list", false, false, "this$is \\\\$a$list"}, {"this $ is \\\\ $ a $ list", false, true, "this$is \\\\$a$list"}, {"this $ is \\\\ $ a $ list", true, false, "this$is \\\\$a$list"}, {"this $ is \\\\ $ a $ list", true, true, "this$is \\\\$a$list"}, {"$ this $ is $ a $ list", false, false, "$this$is$a$list"}, {"$ this $ is $ a $ list", false, true, "$this$is$a$list"}, {"$ this $ is $ a $ list", true, false, "$this$is$a$list"}, {"$ this $ is $ a $ list", true, true, "$this$is$a$list"}};
    }

    @Test(dataProvider="stringListProvider")
    public void testNormalizeStringListWithList(String value, boolean trim, boolean foldCase, String expected) throws Exception {
        this.testNormalizeStringList(value, trim, foldCase, expected);
    }

    @DataProvider
    public Object[][] numericStringProvider() throws Exception {
        return new Object[][]{{"", ""}, {"   ", ""}, {" 123  ", "123"}, {" 123  456  ", "123456"}};
    }

    @Test(dataProvider="numericStringProvider")
    public void testNormalizeNumericString(String value, String expected) throws Exception {
        ByteString val = ByteString.valueOfUtf8((CharSequence)value);
        ByteString normValue = SchemaUtils.normalizeNumericStringAttributeValue((ByteSequence)val);
        Assertions.assertThat((String)normValue.toString()).isEqualTo((Object)expected);
    }
}

