/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import java.util.Collection;
import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.Responses;
import org.forgerock.opendj.ldap.schema.AbstractSchemaTestCase;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.CoreSchema;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.spi.LdapPromises;
import org.mockito.Mockito;
import org.testng.annotations.Test;

public class SchemaTestCase
extends AbstractSchemaTestCase {
    @Test(description="Unit test for OPENDJ-1477")
    public void asNonStrictSchemaAlwaysReturnsSameInstance() {
        Schema schema = Schema.getCoreSchema();
        Schema nonStrictSchema1 = schema.asNonStrictSchema();
        Schema nonStrictSchema2 = schema.asNonStrictSchema().asStrictSchema().asNonStrictSchema();
        Assertions.assertThat((Object)nonStrictSchema1).isSameAs((Object)nonStrictSchema2);
    }

    @Test(description="Unit test for OPENDJ-1477")
    public void asStrictSchemaAlwaysReturnsSameInstance() {
        Schema schema = Schema.getCoreSchema();
        Schema strictSchema1 = schema.asStrictSchema();
        Schema strictSchema2 = schema.asStrictSchema().asNonStrictSchema().asStrictSchema();
        Assertions.assertThat((Object)strictSchema1).isSameAs((Object)strictSchema2);
    }

    @Test
    public final void testReadSchemaAsyncMethodsMockConnection() throws Exception {
        Schema[] schemas;
        Connection connection = (Connection)Mockito.mock(Connection.class);
        String[] entry = new String[]{"# Search result entry: uid=bjensen,ou=People,dc=example,dc=com", "dn: uid=bjensen,ou=People,dc=example,dc=com", "subschemaSubentry: cn=schema", "entryDN: uid=bjensen,ou=people,dc=example,dc=com", "entryUUID: fc252fd9-b982-3ed6-b42a-c76d2546312c"};
        LdapPromise result = LdapPromises.newSuccessfulLdapPromise((Object)Responses.newSearchResultEntry((String[])entry));
        Mockito.when((Object)connection.searchSingleEntryAsync((SearchRequest)Mockito.any())).thenReturn((Object)result);
        DN testDN = DN.valueOf((String)"uid=bjensen,ou=People,dc=example,dc=com");
        for (Schema sc : schemas = new Schema[]{(Schema)Schema.readSchemaAsync((Connection)connection, (DN)testDN).getOrThrow(), (Schema)Schema.readSchemaForEntryAsync((Connection)connection, (DN)testDN).getOrThrow()}) {
            Assertions.assertThat((Collection)sc.getSyntaxes()).isNotNull();
            Assertions.assertThat((Collection)sc.getAttributeTypes()).isNotNull();
            Assertions.assertThat((Collection)sc.getObjectClasses()).isNotNull();
            Assertions.assertThat((Collection)sc.getMatchingRuleUses()).isNotNull();
            Assertions.assertThat((Collection)sc.getMatchingRuleUses()).isEmpty();
            Assertions.assertThat((Collection)sc.getMatchingRules()).isNotNull();
            Assertions.assertThat((Collection)sc.getDITContentRules()).isNotNull();
            Assertions.assertThat((Collection)sc.getDITContentRules()).isEmpty();
            Assertions.assertThat((Collection)sc.getDITStuctureRules()).isNotNull();
            Assertions.assertThat((Collection)sc.getDITStuctureRules()).isEmpty();
            Assertions.assertThat((Collection)sc.getNameForms()).isNotNull();
            Assertions.assertThat((Collection)sc.getNameForms()).isEmpty();
        }
        connection.close();
    }

    @Test
    public void getAttributeTypeWithDifferentNamesReturnSame() throws Exception {
        Schema schema = CoreSchema.getInstance();
        AttributeType cnAttrType = schema.getAttributeType("cn");
        Assertions.assertThat((Object)cnAttrType).isSameAs((Object)schema.getAttributeType("commonname"));
        Assertions.assertThat((Object)cnAttrType).isSameAs((Object)schema.getAttributeType("commonName"));
        Assertions.assertThat((Object)cnAttrType).isSameAs((Object)schema.getAttributeType("CN"));
    }

    @Test
    public void getAttributeTypeWithDifferentPlaceholderNames() throws Exception {
        Schema schema = CoreSchema.getInstance().asNonStrictSchema();
        AttributeType placeHolderAttrType = schema.getAttributeType("placeholder");
        Assertions.assertThat((Object)placeHolderAttrType).isEqualTo((Object)schema.getAttributeType("PLACEHOLDER"));
        Assertions.assertThat((Object)placeHolderAttrType).isNotEqualTo((Object)schema.getAttributeType("another_placeholder"));
    }
}

